/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.metrics.prometheus.core;

import com.codahale.metrics.Metric;
import com.google.common.base.Enums;
import org.apache.solr.metrics.prometheus.SolrMetric;
import org.apache.solr.metrics.prometheus.SolrNoOpMetric;
import org.apache.solr.metrics.prometheus.SolrPrometheusFormatter;
import org.apache.solr.metrics.prometheus.core.PrometheusCoreFormatterInfo;
import org.apache.solr.metrics.prometheus.core.SolrCoreCacheMetric;
import org.apache.solr.metrics.prometheus.core.SolrCoreHandlerMetric;
import org.apache.solr.metrics.prometheus.core.SolrCoreHighlighterMetric;
import org.apache.solr.metrics.prometheus.core.SolrCoreIndexMetric;
import org.apache.solr.metrics.prometheus.core.SolrCoreSearcherMetric;
import org.apache.solr.metrics.prometheus.core.SolrCoreTlogMetric;

public class SolrPrometheusCoreFormatter
extends SolrPrometheusFormatter
implements PrometheusCoreFormatterInfo {
    @Override
    public void exportDropwizardMetric(Metric dropwizardMetric, String metricName) {
        SolrMetric solrCoreMetric = this.categorizeMetric(dropwizardMetric, metricName);
        solrCoreMetric.parseLabels().toPrometheus(this);
    }

    @Override
    public SolrMetric categorizeMetric(Metric dropwizardMetric, String metricName) {
        String metricCategory = metricName.split("\\.", 3)[1];
        if (!Enums.getIfPresent(PrometheusCoreFormatterInfo.CoreCategory.class, (String)metricCategory).isPresent()) {
            return new SolrNoOpMetric();
        }
        switch (PrometheusCoreFormatterInfo.CoreCategory.valueOf(metricCategory)) {
            case ADMIN: 
            case QUERY: 
            case UPDATE: 
            case REPLICATION: {
                return new SolrCoreHandlerMetric(dropwizardMetric, metricName);
            }
            case TLOG: {
                return new SolrCoreTlogMetric(dropwizardMetric, metricName);
            }
            case CACHE: {
                return new SolrCoreCacheMetric(dropwizardMetric, metricName);
            }
            case SEARCHER: {
                return new SolrCoreSearcherMetric(dropwizardMetric, metricName);
            }
            case HIGHLIGHTER: {
                return new SolrCoreHighlighterMetric(dropwizardMetric, metricName);
            }
            case INDEX: {
                return new SolrCoreIndexMetric(dropwizardMetric, metricName);
            }
        }
        return new SolrNoOpMetric();
    }
}

