/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.base.Preconditions;
import io.grpc.Internal;
import io.grpc.NameResolver;
import io.grpc.NameResolverProvider;
import io.grpc.xds.XdsNameResolver;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;

@Internal
public final class XdsNameResolverProvider
extends NameResolverProvider {
    private static final String SCHEME = "xds";
    private final String scheme;
    private final Map<String, ?> bootstrapOverride;

    public XdsNameResolverProvider() {
        this(SCHEME, null);
    }

    private XdsNameResolverProvider(String scheme, @Nullable Map<String, ?> bootstrapOverride) {
        this.scheme = (String)Preconditions.checkNotNull((Object)scheme, (Object)"scheme");
        this.bootstrapOverride = bootstrapOverride;
    }

    public static XdsNameResolverProvider createForTest(String scheme, @Nullable Map<String, ?> bootstrapOverride) {
        return new XdsNameResolverProvider(scheme, bootstrapOverride);
    }

    public XdsNameResolver newNameResolver(URI targetUri, NameResolver.Args args) {
        if (this.scheme.equals(targetUri.getScheme())) {
            String targetPath = (String)Preconditions.checkNotNull((Object)targetUri.getPath(), (Object)"targetPath");
            Preconditions.checkArgument((boolean)targetPath.startsWith("/"), (String)"the path component (%s) of the target (%s) must start with '/'", (Object)targetPath, (Object)targetUri);
            String name = targetPath.substring(1);
            return new XdsNameResolver(targetUri.getAuthority(), name, args.getOverrideAuthority(), args.getServiceConfigParser(), args.getSynchronizationContext(), args.getScheduledExecutorService(), this.bootstrapOverride);
        }
        return null;
    }

    public String getDefaultScheme() {
        return this.scheme;
    }

    protected boolean isAvailable() {
        return true;
    }

    protected int priority() {
        return 4;
    }

    public Collection<Class<? extends SocketAddress>> getProducedSocketAddressTypes() {
        return Collections.singleton(InetSocketAddress.class);
    }

    static interface CallCounterProvider {
        public AtomicLong getOrCreate(String var1, @Nullable String var2);
    }
}

