/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p5edges.splines;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.elk.alg.layered.graph.LEdge;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.p5edges.splines.SplineEdgeRouter;
import org.eclipse.elk.core.math.ElkRectangle;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.util.Pair;

public final class SplineSegment
implements Comparable<SplineSegment> {
    public boolean handled = false;
    public final Set<LPort> leftPorts = Sets.newHashSet();
    public final Set<LPort> rightPorts = Sets.newHashSet();
    public final List<SplineEdgeRouter.Dependency> outgoing = Lists.newArrayList();
    public final List<SplineEdgeRouter.Dependency> incoming = Lists.newArrayList();
    public int mark;
    public int inweight;
    public int outweight;
    public int rank;
    public final Set<LEdge> edges = Sets.newHashSet();
    public final boolean isStraight;
    public ElkRectangle boundingBox = new ElkRectangle();
    public boolean isWestOfInitialLayer = false;
    public double xDelta;
    public LPort sourcePort;
    public LPort targetPort;
    public boolean initialSegment = false;
    public boolean lastSegment = false;
    public LNode sourceNode;
    public LNode targetNode;
    public boolean inverseOrder = false;
    public double hyperEdgeTopYPos;
    public double hyperEdgeBottomYPos;
    public double centerControlPointY;
    public Map<LEdge, EdgeInformation> edgeInformation = Maps.newHashMap();
    private static final double HYPEREDGE_POS_OUTER_RATE = 0.9;
    private static final double HYPEREDGE_POS_MID_RATE = 0.09999999999999998;
    private static final double ONE_HALF = 0.5;

    public SplineSegment(LPort singlePort, Set<Pair<SplineEdgeRouter.SideToProcess, LEdge>> edges, SplineEdgeRouter.SideToProcess sourceSide) {
        if (sourceSide == SplineEdgeRouter.SideToProcess.LEFT) {
            this.leftPorts.add(singlePort);
        } else {
            this.rightPorts.add(singlePort);
        }
        double yMinPosOfTarget = Double.POSITIVE_INFINITY;
        double yMaxPosOfTarget = Double.NEGATIVE_INFINITY;
        for (Pair<SplineEdgeRouter.SideToProcess, LEdge> pair : edges) {
            SplineEdgeRouter.SideToProcess side = pair.getFirst();
            LEdge edge = pair.getSecond();
            LPort tgtPort = edge.getSource();
            if (tgtPort.equals(singlePort)) {
                tgtPort = edge.getTarget();
            }
            if (side == SplineEdgeRouter.SideToProcess.LEFT) {
                this.leftPorts.add(tgtPort);
            } else {
                this.rightPorts.add(tgtPort);
            }
            double yPosOfTarget = this.anchorY(tgtPort);
            yMinPosOfTarget = Math.min(yMinPosOfTarget, yPosOfTarget);
            yMaxPosOfTarget = Math.max(yMaxPosOfTarget, yPosOfTarget);
        }
        double yPosOfSingleSide = this.anchorY(singlePort);
        this.setRelevantPositions(yPosOfSingleSide, yMinPosOfTarget, yMaxPosOfTarget);
        for (Pair<SplineEdgeRouter.SideToProcess, LEdge> pair : edges) {
            this.addEdge(pair.getSecond());
        }
        this.isStraight = false;
    }

    public SplineSegment(LEdge edge, SplineEdgeRouter.SideToProcess sourceSide, SplineEdgeRouter.SideToProcess targetSide) {
        if (sourceSide == SplineEdgeRouter.SideToProcess.LEFT) {
            this.leftPorts.add(edge.getSource());
        } else {
            this.rightPorts.add(edge.getSource());
        }
        if (targetSide == SplineEdgeRouter.SideToProcess.LEFT) {
            this.leftPorts.add(edge.getTarget());
        } else {
            this.rightPorts.add(edge.getTarget());
        }
        this.addEdge(edge);
        double sourceY = this.anchorY(edge.getSource());
        double targetY = this.anchorY(edge.getTarget());
        this.setRelevantPositions(sourceY, targetY, targetY);
        this.isStraight = SplineEdgeRouter.isStraight(sourceY, targetY);
    }

    private void addEdge(LEdge edge) {
        this.edges.add(edge);
        EdgeInformation ei = new EdgeInformation();
        this.edgeInformation.put(edge, ei);
        ei.startY = this.anchorY(edge.getSource());
        ei.endY = this.anchorY(edge.getTarget());
        ei.normalSourceNode = SplineEdgeRouter.isNormalNode(edge.getSource().getNode());
        ei.normalTargetNode = SplineEdgeRouter.isNormalNode(edge.getTarget().getNode());
        ei.invertedLeft = edge.getSource().getSide() == PortSide.WEST;
        ei.invertedRight = edge.getTarget().getSide() == PortSide.EAST;
    }

    private double anchorY(LPort p) {
        if (PortSide.SIDES_NORTH_SOUTH.contains((Object)p.getSide())) {
            return p.getProperty(InternalProperties.SPLINE_NS_PORT_Y_COORD);
        }
        return p.getAbsoluteAnchor().y;
    }

    public boolean isHyperEdge() {
        return this.edges.size() > 1;
    }

    @Override
    public int compareTo(SplineSegment other) {
        return this.mark - other.mark;
    }

    private void setRelevantPositions(double sourceY, double targetYMin, double targetYMax) {
        this.boundingBox.y = Math.min(sourceY, targetYMin);
        this.boundingBox.height = Math.max(sourceY, targetYMax) - this.boundingBox.y;
        if (sourceY < targetYMin) {
            this.centerControlPointY = 0.5 * (sourceY + targetYMin);
            this.hyperEdgeTopYPos = 0.09999999999999998 * this.centerControlPointY + 0.9 * sourceY;
            this.hyperEdgeBottomYPos = 0.09999999999999998 * this.centerControlPointY + 0.9 * targetYMin;
        } else {
            this.centerControlPointY = 0.5 * (sourceY + targetYMax);
            this.hyperEdgeTopYPos = 0.09999999999999998 * this.centerControlPointY + 0.9 * targetYMax;
            this.hyperEdgeBottomYPos = 0.09999999999999998 * this.centerControlPointY + 0.9 * sourceY;
        }
    }

    public class EdgeInformation {
        public double startY;
        public double endY;
        public boolean normalSourceNode;
        public boolean normalTargetNode;
        public boolean invertedLeft;
        public boolean invertedRight;
    }
}

