/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.microsoft.aad.msal4j.MsalClientException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;

final class StringHelper {
    static String EMPTY_STRING = "";

    StringHelper() {
    }

    static boolean isBlank(String str) {
        return str == null || str.trim().length() == 0;
    }

    static String createBase64EncodedSha256Hash(String stringToHash) {
        return StringHelper.createSha256Hash(stringToHash, true);
    }

    static String createSha256Hash(String stringToHash) {
        return StringHelper.createSha256Hash(stringToHash, false);
    }

    private static String createSha256Hash(String stringToHash, boolean base64Encode) {
        String res;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] hash = messageDigest.digest(stringToHash.getBytes(StandardCharsets.UTF_8));
            res = base64Encode ? Base64.getUrlEncoder().withoutPadding().encodeToString(hash) : new String(hash, StandardCharsets.UTF_8);
        }
        catch (NoSuchAlgorithmException e) {
            res = null;
        }
        return res;
    }

    static String createSha256HashHexString(String stringToHash) {
        if (stringToHash == null || stringToHash.isEmpty()) {
            throw new IllegalArgumentException("String to hash cannot be null or empty");
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] hash = messageDigest.digest(stringToHash.getBytes(StandardCharsets.UTF_8));
            StringBuilder hexString = new StringBuilder();
            for (byte b : hash) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new MsalClientException("Failed to create SHA-256 hash: " + e.getMessage(), "crypto_error");
        }
    }

    static boolean isNullOrBlank(String str) {
        return str == null || str.trim().length() == 0;
    }
}

