/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.internal.params;

import org.bouncycastle.crypto.IllegalKeyException;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.params.DhPrivateKeyParameters;
import org.bouncycastle.crypto.internal.params.DhPublicKeyParameters;

public class MqvPrivateParameters
implements CipherParameters {
    private DhPrivateKeyParameters staticPrivateKey;
    private DhPrivateKeyParameters ephemeralPrivateKey;
    private DhPublicKeyParameters ephemeralPublicKey;

    public MqvPrivateParameters(DhPrivateKeyParameters dhPrivateKeyParameters, DhPrivateKeyParameters dhPrivateKeyParameters2) {
        this(dhPrivateKeyParameters, dhPrivateKeyParameters2, new DhPublicKeyParameters(dhPrivateKeyParameters2.getParameters().getG().modPow(dhPrivateKeyParameters2.getX(), dhPrivateKeyParameters2.getParameters().getP()), dhPrivateKeyParameters2.getParameters()));
    }

    public MqvPrivateParameters(DhPrivateKeyParameters dhPrivateKeyParameters, DhPrivateKeyParameters dhPrivateKeyParameters2, DhPublicKeyParameters dhPublicKeyParameters) {
        this.staticPrivateKey = dhPrivateKeyParameters;
        this.ephemeralPrivateKey = dhPrivateKeyParameters2;
        this.ephemeralPublicKey = dhPublicKeyParameters;
        if (!dhPrivateKeyParameters.getParameters().equals(dhPrivateKeyParameters2.getParameters()) || !dhPrivateKeyParameters.getParameters().equals(dhPublicKeyParameters.getParameters())) {
            throw new IllegalKeyException("Static and ephemeral keys have different domain parameters");
        }
    }

    public DhPrivateKeyParameters getStaticPrivateKey() {
        return this.staticPrivateKey;
    }

    public DhPrivateKeyParameters getEphemeralPrivateKey() {
        return this.ephemeralPrivateKey;
    }

    public DhPublicKeyParameters getEphemeralPublicKey() {
        return this.ephemeralPublicKey;
    }
}

