/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.xcontent.support;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.apache.lucene.util.automaton.Operations;
import org.opensearch.OpenSearchParseException;
import org.opensearch.common.Booleans;
import org.opensearch.common.Numbers;
import org.opensearch.common.regex.Regex;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.Strings;

public class XContentMapValues {
    private static final String TRANSFORMER_TRIE_LEAF_KEY = "$transformer";

    public static List<Object> extractRawValues(String path, Map<String, Object> map) {
        ArrayList<Object> values = new ArrayList<Object>();
        String[] pathElements = path.split("\\.");
        if (pathElements.length == 0) {
            return values;
        }
        XContentMapValues.extractRawValues(values, map, pathElements, 0);
        return values;
    }

    private static void extractRawValues(List values, Map<String, Object> part, String[] pathElements, int index) {
        int nextIndex;
        if (index == pathElements.length) {
            return;
        }
        Object key = pathElements[index];
        Object currentValue = part.get(key);
        for (nextIndex = index + 1; currentValue == null && nextIndex != pathElements.length; ++nextIndex) {
            key = (String)key + "." + pathElements[nextIndex];
            currentValue = part.get(key);
        }
        if (currentValue == null) {
            return;
        }
        if (currentValue instanceof Map) {
            XContentMapValues.extractRawValues(values, (Map)currentValue, pathElements, nextIndex);
        } else if (currentValue instanceof List) {
            XContentMapValues.extractRawValues(values, (List)currentValue, pathElements, nextIndex);
        } else {
            values.add(currentValue);
        }
    }

    private static void extractRawValues(List values, List<Object> part, String[] pathElements, int index) {
        for (Object value : part) {
            if (value == null) continue;
            if (value instanceof Map) {
                XContentMapValues.extractRawValues(values, (Map)value, pathElements, index);
                continue;
            }
            if (value instanceof List) {
                XContentMapValues.extractRawValues(values, (List)value, pathElements, index);
                continue;
            }
            values.add(value);
        }
    }

    public static Object extractValue(String path, Map<?, ?> map) {
        return XContentMapValues.extractValue(map, path.split("\\."));
    }

    public static Object extractValue(Map<?, ?> map, String ... pathElements) {
        if (pathElements.length == 0) {
            return null;
        }
        return XContentMapValues.extractValue(pathElements, 0, map, null);
    }

    public static Object extractValue(String path, Map<?, ?> map, Object nullValue) {
        String[] pathElements = path.split("\\.");
        if (pathElements.length == 0) {
            return null;
        }
        return XContentMapValues.extractValue(pathElements, 0, map, nullValue);
    }

    private static Object extractValue(String[] pathElements, int index, Object currentValue, Object nullValue) {
        if (currentValue instanceof List) {
            List valueList = (List)currentValue;
            ArrayList<Object> newList = new ArrayList<Object>(valueList.size());
            for (Object o : valueList) {
                Object listValue = XContentMapValues.extractValue(pathElements, index, o, nullValue);
                if (listValue == null) continue;
                newList.add(listValue);
            }
            return newList;
        }
        if (index == pathElements.length) {
            return currentValue != null ? currentValue : nullValue;
        }
        if (currentValue instanceof Map) {
            int nextIndex;
            Map map = (Map)currentValue;
            Object key = pathElements[index];
            Object mapValue = map.get(key);
            for (nextIndex = index + 1; mapValue == null && nextIndex != pathElements.length; ++nextIndex) {
                key = (String)key + "." + pathElements[nextIndex];
                mapValue = map.get(key);
            }
            if (!map.containsKey(key)) {
                return null;
            }
            return XContentMapValues.extractValue(pathElements, nextIndex, mapValue, nullValue);
        }
        return null;
    }

    public static Map<String, Object> filter(Map<String, ?> map, String[] includes, String[] excludes) {
        return XContentMapValues.filter(includes, excludes).apply(map);
    }

    public static Function<Map<String, ?>, Map<String, Object>> filter(String[] includes, String[] excludes) {
        if (XContentMapValues.hasNoWildcardsOrDots(includes) && XContentMapValues.hasNoWildcardsOrDots(excludes)) {
            return XContentMapValues.createSetBasedFilter(includes, excludes);
        }
        return XContentMapValues.createAutomatonFilter(includes, excludes);
    }

    private static boolean hasNoWildcardsOrDots(String[] fields) {
        if (fields == null || fields.length == 0) {
            return true;
        }
        for (String field : fields) {
            if (field.indexOf(42) == -1 && field.indexOf(46) == -1) continue;
            return false;
        }
        return true;
    }

    private static Function<Map<String, ?>, Map<String, Object>> createSetBasedFilter(String[] includes, String[] excludes) {
        HashSet<String> includeSet = includes == null || includes.length == 0 ? null : new HashSet<String>(Arrays.asList(includes));
        HashSet<String> excludeSet = excludes == null || excludes.length == 0 ? Collections.emptySet() : new HashSet<String>(Arrays.asList(excludes));
        return map -> {
            HashMap filtered = new HashMap();
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                int dotPos = key.indexOf(46);
                if (dotPos > 0) {
                    key = key.substring(0, dotPos);
                }
                if (includeSet != null && !includeSet.contains(key) || excludeSet.contains(key)) continue;
                filtered.put((String)entry.getKey(), entry.getValue());
            }
            return filtered;
        };
    }

    public static Function<Map<String, ?>, Map<String, Object>> createAutomatonFilter(String[] includes, String[] excludes) {
        Automaton excludeA;
        CharacterRunAutomaton include;
        CharacterRunAutomaton matchAllAutomaton = new CharacterRunAutomaton(Automata.makeAnyString());
        if (includes == null || includes.length == 0) {
            include = matchAllAutomaton;
        } else {
            Automaton includeA = Regex.simpleMatchToAutomaton(includes);
            includeA = XContentMapValues.makeMatchDotsInFieldNames(includeA);
            include = new CharacterRunAutomaton(includeA);
        }
        if (excludes == null || excludes.length == 0) {
            excludeA = Automata.makeEmpty();
        } else {
            excludeA = Regex.simpleMatchToAutomaton(excludes);
            excludeA = XContentMapValues.makeMatchDotsInFieldNames(excludeA);
        }
        CharacterRunAutomaton exclude = new CharacterRunAutomaton(excludeA);
        return map -> XContentMapValues.filter(map, include, 0, exclude, 0, matchAllAutomaton);
    }

    private static Automaton makeMatchDotsInFieldNames(Automaton automaton) {
        Automaton automatonMatchingFields = Operations.concatenate(Arrays.asList(automaton, Automata.makeChar((int)46), Automata.makeAnyString()));
        return Operations.determinize((Automaton)Operations.union(Arrays.asList(automaton, automatonMatchingFields)), (int)10000);
    }

    private static int step(CharacterRunAutomaton automaton, String key, int state) {
        for (int i = 0; state != -1 && i < key.length(); ++i) {
            state = automaton.step(state, (int)key.charAt(i));
        }
        return state;
    }

    private static Map<String, Object> filter(Map<String, ?> map, CharacterRunAutomaton includeAutomaton, int initialIncludeState, CharacterRunAutomaton excludeAutomaton, int initialExcludeState, CharacterRunAutomaton matchAllAutomaton) {
        HashMap<String, Object> filtered = new HashMap<String, Object>();
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            int excludeState;
            String key = entry.getKey();
            int includeState = XContentMapValues.step(includeAutomaton, key, initialIncludeState);
            if (includeState == -1 || (excludeState = XContentMapValues.step(excludeAutomaton, key, initialExcludeState)) != -1 && excludeAutomaton.isAccept(excludeState)) continue;
            Object value = entry.getValue();
            CharacterRunAutomaton subIncludeAutomaton = includeAutomaton;
            int subIncludeState = includeState;
            if (includeAutomaton.isAccept(includeState)) {
                if (excludeState == -1 || excludeAutomaton.step(excludeState, 46) == -1) {
                    filtered.put(key, value);
                    continue;
                }
                subIncludeAutomaton = matchAllAutomaton;
                subIncludeState = 0;
            }
            if (value instanceof Map) {
                if ((subIncludeState = subIncludeAutomaton.step(subIncludeState, 46)) == -1) continue;
                if (excludeState != -1) {
                    excludeState = excludeAutomaton.step(excludeState, 46);
                }
                Map valueAsMap = (Map)value;
                Map<String, Object> filteredValue = XContentMapValues.filter(valueAsMap, subIncludeAutomaton, subIncludeState, excludeAutomaton, excludeState, matchAllAutomaton);
                if (!includeAutomaton.isAccept(includeState) && filteredValue.isEmpty()) continue;
                filtered.put(key, filteredValue);
                continue;
            }
            if (value instanceof Iterable) {
                List<Object> filteredValue = XContentMapValues.filter((Iterable)value, subIncludeAutomaton, subIncludeState, excludeAutomaton, excludeState, matchAllAutomaton);
                if (!includeAutomaton.isAccept(includeState) && filteredValue.isEmpty()) continue;
                filtered.put(key, filteredValue);
                continue;
            }
            if (!includeAutomaton.isAccept(includeState) || excludeState != -1 && excludeAutomaton.isAccept(excludeState)) continue;
            filtered.put(key, value);
        }
        return filtered;
    }

    private static List<Object> filter(Iterable<?> iterable, CharacterRunAutomaton includeAutomaton, int initialIncludeState, CharacterRunAutomaton excludeAutomaton, int initialExcludeState, CharacterRunAutomaton matchAllAutomaton) {
        ArrayList<Object> filtered = new ArrayList<Object>();
        boolean isInclude = includeAutomaton.isAccept(initialIncludeState);
        for (Object value : iterable) {
            if (value instanceof Map) {
                Map<String, Object> filteredValue;
                int includeState = includeAutomaton.step(initialIncludeState, 46);
                int excludeState = initialExcludeState;
                if (excludeState != -1) {
                    excludeState = excludeAutomaton.step(excludeState, 46);
                }
                if ((filteredValue = XContentMapValues.filter((Map)value, includeAutomaton, includeState, excludeAutomaton, excludeState, matchAllAutomaton)).isEmpty()) continue;
                filtered.add(filteredValue);
                continue;
            }
            if (value instanceof Iterable) {
                List<Object> filteredValue = XContentMapValues.filter((Iterable)value, includeAutomaton, initialIncludeState, excludeAutomaton, initialExcludeState, matchAllAutomaton);
                if (filteredValue.isEmpty()) continue;
                filtered.add(filteredValue);
                continue;
            }
            if (!isInclude) continue;
            filtered.add(value);
        }
        return filtered;
    }

    public static boolean isObject(Object node) {
        return node instanceof Map;
    }

    public static boolean isArray(Object node) {
        return node instanceof List;
    }

    public static String nodeStringValue(Object node, String defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return node.toString();
    }

    public static String nodeStringValue(Object node) {
        if (node == null) {
            return null;
        }
        return node.toString();
    }

    public static float nodeFloatValue(Object node, float defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return XContentMapValues.nodeFloatValue(node);
    }

    public static float nodeFloatValue(Object node) {
        if (node instanceof Number) {
            return ((Number)node).floatValue();
        }
        return Float.parseFloat(node.toString());
    }

    public static double nodeDoubleValue(Object node, double defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return XContentMapValues.nodeDoubleValue(node);
    }

    public static double nodeDoubleValue(Object node) {
        if (node instanceof Number) {
            return ((Number)node).doubleValue();
        }
        return Double.parseDouble(node.toString());
    }

    public static int nodeIntegerValue(Object node) {
        if (node instanceof Number) {
            return Numbers.toIntExact((Number)((Number)node));
        }
        return Integer.parseInt(node.toString());
    }

    public static int nodeIntegerValue(Object node, int defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return XContentMapValues.nodeIntegerValue(node);
    }

    public static short nodeShortValue(Object node, short defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return XContentMapValues.nodeShortValue(node);
    }

    public static short nodeShortValue(Object node) {
        if (node instanceof Number) {
            return Numbers.toShortExact((Number)((Number)node));
        }
        return Short.parseShort(node.toString());
    }

    public static byte nodeByteValue(Object node, byte defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return XContentMapValues.nodeByteValue(node);
    }

    public static byte nodeByteValue(Object node) {
        if (node instanceof Number) {
            return Numbers.toByteExact((Number)((Number)node));
        }
        return Byte.parseByte(node.toString());
    }

    public static long nodeLongValue(Object node, long defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return XContentMapValues.nodeLongValue(node);
    }

    public static long nodeLongValue(Object node) {
        if (node instanceof Number) {
            return Numbers.toLongExact((Number)((Number)node));
        }
        return Long.parseLong(node.toString());
    }

    public static boolean nodeBooleanValue(Object node, String name, boolean defaultValue) {
        try {
            return XContentMapValues.nodeBooleanValue(node, defaultValue);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Could not convert [" + name + "] to boolean", ex);
        }
    }

    public static boolean nodeBooleanValue(Object node, boolean defaultValue) {
        String nodeValue = node == null ? null : node.toString();
        return Booleans.parseBoolean((String)nodeValue, (boolean)defaultValue);
    }

    public static boolean nodeBooleanValue(Object node, String name) {
        try {
            return XContentMapValues.nodeBooleanValue(node);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Could not convert [" + name + "] to boolean", ex);
        }
    }

    public static boolean nodeBooleanValue(Object node) {
        return Booleans.parseBoolean((String)node.toString());
    }

    public static TimeValue nodeTimeValue(Object node, TimeValue defaultValue) {
        if (node == null) {
            return defaultValue;
        }
        return XContentMapValues.nodeTimeValue(node);
    }

    public static TimeValue nodeTimeValue(Object node) {
        if (node instanceof Number) {
            return TimeValue.timeValueMillis((long)((Number)node).longValue());
        }
        return TimeValue.parseTimeValue((String)node.toString(), null, (String)(XContentMapValues.class.getSimpleName() + ".nodeTimeValue"));
    }

    public static Map<String, Object> nodeMapValue(Object node, String desc) {
        if (node instanceof Map) {
            return (Map)node;
        }
        throw new OpenSearchParseException(desc + " should be a hash but was of type: " + String.valueOf(node.getClass()), new Object[0]);
    }

    public static String[] nodeStringArrayValue(Object node) {
        if (XContentMapValues.isArray(node)) {
            List list = (List)node;
            String[] arr = new String[list.size()];
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = XContentMapValues.nodeStringValue(list.get(i), null);
            }
            return arr;
        }
        return Strings.splitStringByCommaToArray((String)node.toString());
    }

    public static Map<String, Object> transform(Map<String, Object> source, Map<String, Function<Object, Object>> transformers, boolean inPlace) {
        return XContentMapValues.transform(transformers, inPlace).apply(source);
    }

    public static Function<Map<String, Object>, Map<String, Object>> transform(Map<String, Function<Object, Object>> transformers, boolean inPlace) {
        Map<String, Object> transformerTrie = XContentMapValues.buildTransformerTrie(transformers);
        return source -> {
            ArrayDeque<TransformContext> stack = new ArrayDeque<TransformContext>();
            Map result = inPlace ? source : new HashMap(source);
            stack.push(new TransformContext(result, transformerTrie));
            XContentMapValues.processStack(stack, inPlace);
            return result;
        };
    }

    private static Map<String, Object> buildTransformerTrie(Map<String, Function<Object, Object>> transformers) {
        HashMap<String, Object> trie = new HashMap<String, Object>();
        for (Map.Entry<String, Function<Object, Object>> entry : transformers.entrySet()) {
            String[] pathElements = entry.getKey().split("\\.");
            Map<String, Object> subTrie = trie;
            for (String pathElement : pathElements) {
                subTrie = (Map)subTrie.computeIfAbsent(pathElement, k -> new HashMap());
            }
            subTrie.put(TRANSFORMER_TRIE_LEAF_KEY, entry.getValue());
        }
        return trie;
    }

    private static void processStack(Deque<TransformContext> stack, boolean inPlace) {
        while (!stack.isEmpty()) {
            TransformContext ctx = stack.pop();
            XContentMapValues.processMap(ctx.map, ctx.trie, stack, inPlace);
        }
    }

    private static void processMap(Map<String, Object> currentMap, Map<String, Object> currentTrie, Deque<TransformContext> stack, boolean inPlace) {
        for (Map.Entry<String, Object> entry : currentMap.entrySet()) {
            XContentMapValues.processEntry(entry, currentTrie, stack, inPlace);
        }
    }

    private static void processEntry(Map.Entry<String, Object> entry, Map<String, Object> currentTrie, Deque<TransformContext> stack, boolean inPlace) {
        String key = entry.getKey();
        Object value = entry.getValue();
        Object subTrieObj = currentTrie.get(key);
        if (!(subTrieObj instanceof Map)) {
            return;
        }
        Map<String, Object> subTrie = XContentMapValues.nodeMapValue(subTrieObj, "transform");
        Function transformer = (Function)subTrie.get(TRANSFORMER_TRIE_LEAF_KEY);
        if (transformer != null) {
            entry.setValue(transformer.apply(value));
            return;
        }
        if (value instanceof Map) {
            Map<String, Object> subMap = XContentMapValues.nodeMapValue(value, "transform");
            if (!inPlace) {
                subMap = new HashMap<String, Object>(subMap);
                entry.setValue(subMap);
            }
            stack.push(new TransformContext(subMap, subTrie));
        } else if (value instanceof List) {
            ArrayList<Object> list;
            ArrayList<Object> subList = list = (ArrayList<Object>)value;
            if (!inPlace) {
                subList = new ArrayList<Object>(list);
                entry.setValue(subList);
            }
            XContentMapValues.processList(subList, subTrie, stack, inPlace);
        }
    }

    private static void processList(List<Object> list, Map<String, Object> transformerTrie, Deque<TransformContext> stack, boolean inPlace) {
        for (int i = list.size() - 1; i >= 0; --i) {
            Object value = list.get(i);
            if (!(value instanceof Map)) continue;
            Map<String, Object> subMap = XContentMapValues.nodeMapValue(value, "transform");
            if (!inPlace) {
                subMap = new HashMap<String, Object>(subMap);
                list.set(i, subMap);
            }
            stack.push(new TransformContext(subMap, transformerTrie));
        }
    }

    private static class TransformContext {
        Map<String, Object> map;
        Map<String, Object> trie;

        TransformContext(Map<String, Object> map, Map<String, Object> trie) {
            this.map = map;
            this.trie = trie;
        }
    }
}

