/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.tracing;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Scope;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.semconv.ExceptionAttributes;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jboss.logging.Logger;
import org.keycloak.tracing.TracingProvider;

public class OTelTracingProvider
implements TracingProvider {
    private static final Logger log = Logger.getLogger(OTelTracingProvider.class);
    private final OpenTelemetry openTelemetry;
    private final Deque<Scope> scopes;

    public OTelTracingProvider(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
        this.scopes = new ConcurrentLinkedDeque<Scope>();
    }

    OpenTelemetry getOpenTelemetry() {
        return this.openTelemetry;
    }

    public Span getCurrentSpan() {
        return Span.current();
    }

    public Span startSpan(String tracerName, String spanName) {
        Tracer tracer = this.getTracer(tracerName);
        return this.startSpan(tracer.spanBuilder(spanName));
    }

    public Span startSpan(SpanBuilder builder) {
        Span currentSpan = builder.startSpan();
        this.scopes.push(currentSpan.makeCurrent());
        if (log.isDebugEnabled()) {
            log.debugf("Start span '%s' (spanId: '%s')", (Object)OTelTracingProvider.getSpanName(currentSpan), (Object)currentSpan.getSpanContext().getSpanId());
        }
        return currentSpan;
    }

    public void endSpan() {
        Scope scope;
        if (this.scopes.isEmpty()) {
            log.info((Object)"All spans during tracing already ended. Verify that 'TracingProvider.endSpan()' method was not executed multiple times in the span hierarchy.");
            return;
        }
        Span span = this.getCurrentSpan();
        if (span != null) {
            if (log.isDebugEnabled()) {
                log.debugf("End span '%s' (spanId: '%s')", (Object)OTelTracingProvider.getSpanName(span), (Object)span.getSpanContext().getSpanId());
            }
            span.end();
        }
        if ((scope = this.scopes.pop()) != null) {
            scope.close();
        }
    }

    public void error(Throwable exception) {
        Span span = this.getCurrentSpan();
        Attributes exceptionAttributes = Attributes.builder().put(AttributeKey.booleanKey((String)"exception.escaped"), (Object)true).put(ExceptionAttributes.EXCEPTION_MESSAGE, (Object)exception.getMessage()).put(ExceptionAttributes.EXCEPTION_TYPE, (Object)exception.getClass().getCanonicalName()).put(ExceptionAttributes.EXCEPTION_STACKTRACE, (Object)ExceptionUtils.getStackTrace((Throwable)exception)).build();
        span.recordException(exception, exceptionAttributes);
        span.setStatus(StatusCode.ERROR, exception.getMessage());
    }

    public void trace(String tracerName, String spanName, Consumer<Span> execution) {
        this.startSpan(tracerName, spanName);
        try {
            execution.accept(this.getCurrentSpan());
        }
        catch (Throwable e) {
            this.error(e);
            throw e;
        }
        finally {
            this.endSpan();
        }
    }

    public <T> T trace(String tracerName, String spanName, Function<Span, T> execution) {
        this.startSpan(tracerName, spanName);
        try {
            T t = execution.apply(this.getCurrentSpan());
            return t;
        }
        catch (Throwable e) {
            this.error(e);
            throw e;
        }
        finally {
            this.endSpan();
        }
    }

    public Tracer getTracer(String name, String scopeVersion) {
        return this.openTelemetry.getTracer(name, scopeVersion);
    }

    public boolean validateAllSpansEnded() {
        boolean allEnded = this.scopes.isEmpty();
        if (!allEnded) {
            log.warn((Object)"Some spans during tracing were not ended. It may lead to memory leaks and incorrect scoping. Check the hierarchy of nested spans.");
        }
        return allEnded;
    }

    public void close() {
    }

    protected static String getSpanName(Span span) {
        String string;
        if (span instanceof ReadableSpan) {
            ReadableSpan rs = (ReadableSpan)span;
            string = rs.getName();
        } else {
            string = "unknown";
        }
        return string;
    }
}

