/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.representations.workflows;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.time.Duration;
import java.util.Arrays;
import java.util.Objects;
import org.keycloak.common.util.MultivaluedHashMap;
import org.keycloak.representations.workflows.AbstractWorkflowComponentRepresentation;
import org.keycloak.representations.workflows.MultivaluedHashMapValueDeserializer;
import org.keycloak.representations.workflows.MultivaluedHashMapValueSerializer;

@JsonPropertyOrder(value={"uses", "after", "priority", "with", "scheduled-at"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class WorkflowStepRepresentation
extends AbstractWorkflowComponentRepresentation {
    private final String uses;
    private Long scheduledAt;

    public static Builder create() {
        return new Builder();
    }

    public WorkflowStepRepresentation() {
        this(null, null, null);
    }

    public WorkflowStepRepresentation(String uses) {
        this(null, uses, null);
    }

    public WorkflowStepRepresentation(String id, String uses, MultivaluedHashMap<String, String> config) {
        this(id, uses, config, null);
    }

    public WorkflowStepRepresentation(String id, String uses, MultivaluedHashMap<String, String> config, Long scheduledAt) {
        super(id, config);
        this.uses = uses;
        this.scheduledAt = scheduledAt;
    }

    @Override
    @JsonIgnore
    public String getId() {
        return super.getId();
    }

    public String getUses() {
        return this.uses;
    }

    @Override
    @JsonSerialize(using=MultivaluedHashMapValueSerializer.class)
    @JsonDeserialize(using=MultivaluedHashMapValueDeserializer.class)
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY, content=JsonInclude.Include.NON_NULL)
    public MultivaluedHashMap<String, String> getConfig() {
        return super.getConfig();
    }

    public String getAfter() {
        return this.getConfigValue("after", String.class);
    }

    public void setAfter(String after) {
        this.setConfig("after", after);
    }

    @JsonIgnore
    public String getPriority() {
        return this.getConfigValue("priority", String.class);
    }

    public void setPriority(long ms) {
        this.setConfig("priority", String.valueOf(ms));
    }

    @JsonProperty(value="scheduled-at")
    public Long getScheduledAt() {
        return this.scheduledAt;
    }

    public void setScheduledAt(Long scheduledAt) {
        this.scheduledAt = scheduledAt;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof WorkflowStepRepresentation)) {
            return false;
        }
        WorkflowStepRepresentation that = (WorkflowStepRepresentation)obj;
        return Objects.equals(this.getUses(), that.getUses()) && Objects.equals(this.getConfig(), that.getConfig());
    }

    public static class Builder {
        private WorkflowStepRepresentation step;

        public Builder of(String providerId) {
            this.step = new WorkflowStepRepresentation(providerId);
            return this;
        }

        public Builder after(Duration duration) {
            return this.after(String.valueOf(duration.getSeconds()));
        }

        public Builder after(String after) {
            this.step.setAfter(after);
            return this;
        }

        public Builder withConfig(String key, String value) {
            this.step.setConfig(key, value);
            return this;
        }

        public Builder withConfig(String key, String ... value) {
            this.step.setConfig(key, Arrays.asList(value));
            return this;
        }

        public WorkflowStepRepresentation build() {
            return this.step;
        }
    }
}

