/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.k2.codeinsight.intentions;

import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfo;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallInfoKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallKt;
import org.jetbrains.kotlin.analysis.api.resolution.KaCallableMemberCall;
import org.jetbrains.kotlin.analysis.api.resolution.KaFunctionCall;
import org.jetbrains.kotlin.analysis.api.symbols.KaCallableSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaFunctionSymbol;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.idea.base.codeInsight.KotlinNameSuggester;
import org.jetbrains.kotlin.idea.base.codeInsight.KotlinNameSuggestionProvider;
import org.jetbrains.kotlin.idea.base.codeInsight.KotlinNameValidatorProvider;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.intentions.KotlinApplicableModCommandAction;
import org.jetbrains.kotlin.idea.k2.codeinsight.intentions.ConvertToIndexedFunctionCallIntentionKt;
import org.jetbrains.kotlin.idea.refactoring.KotlinCommonRefactoringUtilKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.BuilderByPattern;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementUtilsKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\"B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u000e\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\u0002H\u0002J\u0016\u0010\r\u001a\u0004\u0018\u00010\u0003*\u00020\u000e2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u0002H\u0014J(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J(\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0018\u0010 \u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J \u0010!\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/intentions/ConvertToIndexedFunctionCallIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/intentions/KotlinApplicableModCommandAction;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "Lorg/jetbrains/kotlin/idea/k2/codeinsight/intentions/ConvertToIndexedFunctionCallIntention$Context;", "<init>", "()V", "getFamilyName", "", "isApplicableByPsi", "", "element", "firstLambdaExpression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "prepareContext", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "getPresentation", "Lcom/intellij/modcommand/Presentation;", "context", "Lcom/intellij/modcommand/ActionContext;", "invoke", "", "actionContext", "elementContext", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "updateLabeledReturns", "functionLiteral", "Lorg/jetbrains/kotlin/psi/KtFunctionLiteral;", "oldFunctionName", "newFunctionName", "psiFactory", "Lorg/jetbrains/kotlin/psi/KtPsiFactory;", "addIndexParameter", "replaceCallWithIndexedVariant", "Context", "intellij.kotlin.codeInsight.intentions"})
@SourceDebugExtension(value={"SMAP\nConvertToIndexedFunctionCallIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConvertToIndexedFunctionCallIntention.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/intentions/ConvertToIndexedFunctionCallIntention\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,180:1\n1#2:181\n464#3,14:182\n383#3,2:196\n395#3:198\n482#3:199\n1869#4,2:200\n*S KotlinDebug\n*F\n+ 1 ConvertToIndexedFunctionCallIntention.kt\norg/jetbrains/kotlin/idea/k2/codeinsight/intentions/ConvertToIndexedFunctionCallIntention\n*L\n105#1:182,14\n105#1:196,2\n105#1:198\n105#1:199\n109#1:200,2\n*E\n"})
public final class ConvertToIndexedFunctionCallIntention
extends KotlinApplicableModCommandAction<KtCallExpression, Context> {
    public ConvertToIndexedFunctionCallIntention() {
        super(Reflection.getOrCreateKotlinClass(KtCallExpression.class));
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"convert.to.indexed.function.call", (Object[])new Object[0]);
    }

    @Override
    public boolean isApplicableByPsi(@NotNull KtCallExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Object object = element.getCalleeExpression();
        if (object == null || (object = object.getText()) == null) {
            return false;
        }
        Object calleeText = object;
        return ConvertToIndexedFunctionCallIntentionKt.access$getFunctions$p().containsKey(calleeText);
    }

    private final KtLambdaExpression firstLambdaExpression(KtCallExpression $this$firstLambdaExpression) {
        KtLambdaArgument ktLambdaArgument = (KtLambdaArgument)CollectionsKt.firstOrNull((List)$this$firstLambdaExpression.getLambdaArguments());
        if (ktLambdaArgument != null && (ktLambdaArgument = ktLambdaArgument.getLambdaExpression()) != null) {
            KtLambdaArgument it = ktLambdaArgument;
            boolean bl = false;
            return it;
        }
        return (KtLambdaExpression)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)$this$firstLambdaExpression.getValueArguments()), ConvertToIndexedFunctionCallIntention::firstLambdaExpression$lambda$1));
    }

    @Override
    @Nullable
    public Context prepareContext(@NotNull KaSession $this$prepareContext, @NotNull KtCallExpression element) {
        FqName fqName2;
        CallableId callableId;
        KaFunctionSymbol kaFunctionSymbol;
        KaFunctionCall<?> kaFunctionCall;
        Intrinsics.checkNotNullParameter((Object)$this$prepareContext, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtExpression ktExpression = element.getCalleeExpression();
        if (ktExpression == null) {
            return null;
        }
        KtExpression callee = ktExpression;
        Pair pair = (Pair)ConvertToIndexedFunctionCallIntentionKt.access$getFunctions$p().get(callee.getText());
        if (pair == null) {
            return null;
        }
        Pair pair2 = pair;
        FqName functionFqName = (FqName)pair2.component1();
        String newFunctionName = (String)pair2.component2();
        KaCallInfo kaCallInfo = $this$prepareContext.resolveToCall((KtElement)element);
        if (kaCallInfo == null || (kaFunctionCall = KaCallInfoKt.successfulFunctionCallOrNull(kaCallInfo)) == null || (kaFunctionSymbol = (KaFunctionSymbol)KaCallKt.getSymbol((KaCallableMemberCall)kaFunctionCall)) == null || (callableId = ((KaCallableSymbol)kaFunctionSymbol).getCallableId()) == null || (fqName2 = callableId.asSingleFqName()) == null) {
            return null;
        }
        FqName resolvedFqName = fqName2;
        if (!Intrinsics.areEqual((Object)resolvedFqName, (Object)functionFqName)) {
            return null;
        }
        KtLambdaExpression ktLambdaExpression = this.firstLambdaExpression(element);
        if (ktLambdaExpression == null || (ktLambdaExpression = ktLambdaExpression.getFunctionLiteral()) == null) {
            return null;
        }
        KtLambdaExpression functionLiteral = ktLambdaExpression;
        String string = callee.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return new Context(string, newFunctionName, (KtFunctionLiteral)functionLiteral);
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context2, @NotNull KtCallExpression element) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtExpression ktExpression = element.getCalleeExpression();
        if (ktExpression == null) {
            return null;
        }
        KtExpression callee = ktExpression;
        Pair pair = (Pair)ConvertToIndexedFunctionCallIntentionKt.access$getFunctions$p().get(callee.getText());
        if (pair == null) {
            return null;
        }
        String newFunctionName = (String)pair.component2();
        Object[] objectArray = new Object[]{"'" + newFunctionName + "'"};
        String text = KotlinBundle.message((String)"convert.to.0", (Object[])objectArray);
        return Presentation.of((String)text);
    }

    @Override
    public void invoke(@NotNull ActionContext actionContext, @NotNull KtCallExpression element, @NotNull Context elementContext, @NotNull ModPsiUpdater updater2) {
        Intrinsics.checkNotNullParameter((Object)actionContext, (String)"actionContext");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)elementContext, (String)"elementContext");
        Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
        String functionName = elementContext.component1();
        String newFunctionName = elementContext.component2();
        KtFunctionLiteral functionLiteral = elementContext.component3();
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        KtPsiFactory psiFactory = new KtPsiFactory(project, false, 2, null);
        this.updateLabeledReturns(functionLiteral, functionName, newFunctionName, psiFactory);
        this.addIndexParameter(functionLiteral, psiFactory);
        this.replaceCallWithIndexedVariant(element, newFunctionName, psiFactory);
    }

    /*
     * WARNING - void declaration
     */
    private final void updateLabeledReturns(KtFunctionLiteral functionLiteral, String oldFunctionName, String newFunctionName, KtPsiFactory psiFactory) {
        void $this$forEachDescendantOfType$iv$iv$iv$iv;
        void to$iv$iv$iv;
        void $this$collectDescendantsOfTypeTo$iv$iv$iv;
        void $this$collectDescendantsOfType$iv$iv;
        void $this$collectDescendantsOfType$iv;
        PsiElement psiElement = (PsiElement)functionLiteral;
        Function1 predicate$iv = arg_0 -> ConvertToIndexedFunctionCallIntention.updateLabeledReturns$lambda$0(oldFunctionName, arg_0);
        boolean $i$f$collectDescendantsOfType = false;
        void var9_10 = $this$collectDescendantsOfType$iv;
        Function1 predicate$iv$iv = predicate$iv;
        boolean $i$f$collectDescendantsOfType2 = false;
        void var12_13 = $this$collectDescendantsOfType$iv$iv;
        Object[] objectArray = (Object[])new ArrayList();
        Function1 predicate$iv$iv$iv = predicate$iv$iv;
        boolean $i$f$collectDescendantsOfTypeTo = false;
        void var16_17 = $this$collectDescendantsOfTypeTo$iv$iv$iv;
        Function1 action$iv$iv$iv$iv = (Function1)new Function1<KtReturnExpression, Unit>(predicate$iv$iv$iv, (Collection)to$iv$iv$iv){
            final /* synthetic */ Function1 $predicate;
            final /* synthetic */ Collection $to;
            {
                this.$predicate = $predicate;
                this.$to = $to;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final void invoke(PsiElement it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (((Boolean)this.$predicate.invoke((Object)it)).booleanValue()) {
                    this.$to.add(it);
                }
            }
        };
        boolean $i$f$forEachDescendantOfType = false;
        PsiUtilsKt.checkDecompiledText((PsiElement)$this$forEachDescendantOfType$iv$iv$iv$iv);
        $this$forEachDescendantOfType$iv$iv$iv$iv.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(action$iv$iv$iv$iv){
            final /* synthetic */ Function1 $action;
            {
                this.$action = $action;
            }

            public void visitElement(PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                PsiElement it = element;
                boolean bl = false;
                super.visitElement(element);
                if (element instanceof KtReturnExpression) {
                    this.$action.invoke((Object)element);
                }
            }
        });
        List labeledReturns = (List)to$iv$iv$iv;
        Iterable $this$forEach$iv = labeledReturns;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtExpression ktExpression;
            KtReturnExpression returnExpr = (KtReturnExpression)element$iv;
            boolean bl = false;
            KtExpression returnedExpression = returnExpr.getReturnedExpression();
            if (returnedExpression != null) {
                objectArray = new Object[]{returnedExpression};
                ktExpression = CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)psiFactory, (String)("return@" + newFunctionName + " $0"), (Object[])objectArray, (boolean)false, (int)4, null);
            } else {
                ktExpression = psiFactory.createExpression("return@" + newFunctionName);
            }
            KtExpression newLabeledReturn = ktExpression;
            returnExpr.replace((PsiElement)newLabeledReturn);
        }
    }

    private final void addIndexParameter(KtFunctionLiteral functionLiteral, KtPsiFactory psiFactory) {
        KtParameterList parameterList = KtPsiUtilKt.getOrCreateParameterList((KtFunctionLiteral)functionLiteral);
        List list2 = parameterList.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getParameters(...)");
        List parameters2 = list2;
        Function1 nameValidator = KotlinNameValidatorProvider.createNameValidator$default(KotlinNameValidatorProvider.Companion.getInstance(), (PsiElement)functionLiteral, KotlinNameSuggestionProvider.ValidatorTarget.VARIABLE, (PsiElement)functionLiteral, null, 8, null);
        String indexParameterName = KotlinNameSuggester.Companion.suggestNameByName("index", (Function1<? super String, Boolean>)nameValidator);
        KtParameter indexParameter = psiFactory.createParameter(indexParameterName);
        if (parameters2.isEmpty()) {
            parameterList.addParameter(indexParameter);
            String string = StandardNames.IMPLICIT_LAMBDA_PARAMETER_NAME.getIdentifier();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdentifier(...)");
            KtParameter implicitParam = psiFactory.createParameter(string);
            v2 = parameterList.addParameter(implicitParam);
        } else {
            v2 = parameterList.addParameterBefore(indexParameter, (KtParameter)CollectionsKt.first((List)parameters2));
        }
    }

    private final void replaceCallWithIndexedVariant(KtCallExpression element, String newFunctionName, KtPsiFactory psiFactory) {
        KtQualifiedExpression ktQualifiedExpression = KtPsiUtilKt.getQualifiedExpressionForSelector((KtElement)((KtElement)element));
        KtExpression callOrQualified = ktQualifiedExpression != null ? (KtExpression)ktQualifiedExpression : (KtExpression)element;
        PsiElement result2 = callOrQualified.replace((PsiElement)CreateByPatternKt.buildExpression$default((KtPsiFactory)psiFactory, (boolean)false, arg_0 -> ConvertToIndexedFunctionCallIntention.replaceCallWithIndexedVariant$lambda$0(element, newFunctionName, arg_0), (int)1, null));
        CodeStyleManager.getInstance((Project)element.getProject()).reformat(result2);
    }

    private static final KtLambdaExpression firstLambdaExpression$lambda$1(KtValueArgument it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        KtExpression ktExpression = it.getArgumentExpression();
        return ktExpression != null ? KtElementUtilsKt.unpackFunctionLiteral$default((KtExpression)ktExpression, (boolean)false, (int)1, null) : null;
    }

    private static final boolean updateLabeledReturns$lambda$0(String $oldFunctionName, KtReturnExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getLabelName(), (Object)$oldFunctionName);
    }

    private static final Unit replaceCallWithIndexedVariant$lambda$0(KtCallExpression $element, String $newFunctionName, BuilderByPattern $this$buildExpression) {
        Intrinsics.checkNotNullParameter((Object)$this$buildExpression, (String)"$this$buildExpression");
        KotlinCommonRefactoringUtilKt.appendCallOrQualifiedExpression((BuilderByPattern<KtExpression>)$this$buildExpression, $element, $newFunctionName);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/k2/codeinsight/intentions/ConvertToIndexedFunctionCallIntention$Context;", "", "functionName", "", "newFunctionName", "functionLiteral", "Lorg/jetbrains/kotlin/psi/KtFunctionLiteral;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/kotlin/psi/KtFunctionLiteral;)V", "getFunctionName", "()Ljava/lang/String;", "getNewFunctionName", "getFunctionLiteral", "()Lorg/jetbrains/kotlin/psi/KtFunctionLiteral;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.kotlin.codeInsight.intentions"})
    public static final class Context {
        @NotNull
        private final String functionName;
        @NotNull
        private final String newFunctionName;
        @NotNull
        private final KtFunctionLiteral functionLiteral;

        public Context(@NotNull String functionName, @NotNull String newFunctionName, @NotNull KtFunctionLiteral functionLiteral) {
            Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
            Intrinsics.checkNotNullParameter((Object)newFunctionName, (String)"newFunctionName");
            Intrinsics.checkNotNullParameter((Object)functionLiteral, (String)"functionLiteral");
            this.functionName = functionName;
            this.newFunctionName = newFunctionName;
            this.functionLiteral = functionLiteral;
        }

        @NotNull
        public final String getFunctionName() {
            return this.functionName;
        }

        @NotNull
        public final String getNewFunctionName() {
            return this.newFunctionName;
        }

        @NotNull
        public final KtFunctionLiteral getFunctionLiteral() {
            return this.functionLiteral;
        }

        @NotNull
        public final String component1() {
            return this.functionName;
        }

        @NotNull
        public final String component2() {
            return this.newFunctionName;
        }

        @NotNull
        public final KtFunctionLiteral component3() {
            return this.functionLiteral;
        }

        @NotNull
        public final Context copy(@NotNull String functionName, @NotNull String newFunctionName, @NotNull KtFunctionLiteral functionLiteral) {
            Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
            Intrinsics.checkNotNullParameter((Object)newFunctionName, (String)"newFunctionName");
            Intrinsics.checkNotNullParameter((Object)functionLiteral, (String)"functionLiteral");
            return new Context(functionName, newFunctionName, functionLiteral);
        }

        public static /* synthetic */ Context copy$default(Context context2, String string, String string2, KtFunctionLiteral ktFunctionLiteral, int n, Object object) {
            if ((n & 1) != 0) {
                string = context2.functionName;
            }
            if ((n & 2) != 0) {
                string2 = context2.newFunctionName;
            }
            if ((n & 4) != 0) {
                ktFunctionLiteral = context2.functionLiteral;
            }
            return context2.copy(string, string2, ktFunctionLiteral);
        }

        @NotNull
        public String toString() {
            return "Context(functionName=" + this.functionName + ", newFunctionName=" + this.newFunctionName + ", functionLiteral=" + this.functionLiteral + ")";
        }

        public int hashCode() {
            int result2 = this.functionName.hashCode();
            result2 = result2 * 31 + this.newFunctionName.hashCode();
            result2 = result2 * 31 + this.functionLiteral.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Context)) {
                return false;
            }
            Context context2 = (Context)other;
            if (!Intrinsics.areEqual((Object)this.functionName, (Object)context2.functionName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.newFunctionName, (Object)context2.newFunctionName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.functionLiteral, (Object)context2.functionLiteral);
        }
    }
}

