/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.languagemodel;

import java.util.List;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.ngrams.Probability;

public class MultiLanguageModel
implements LanguageModel {
    private final List<LanguageModel> lms;

    public MultiLanguageModel(List<LanguageModel> lms) {
        if (lms.isEmpty()) {
            throw new IllegalArgumentException("List of language models is empty");
        }
        this.lms = lms;
    }

    @Override
    public Probability getPseudoProbability(List<String> context) {
        double prob = 0.0;
        float coverage = 0.0f;
        long occurrences = 0L;
        for (LanguageModel lm : this.lms) {
            Probability pProb = lm.getPseudoProbability(context);
            prob += pProb.getProb();
            coverage += pProb.getCoverage();
            occurrences += pProb.getOccurrences();
        }
        return new Probability(prob, coverage / (float)this.lms.size(), occurrences);
    }

    @Override
    public void close() {
        this.lms.stream().forEach(LanguageModel::close);
    }

    public String toString() {
        return this.lms.toString();
    }
}

