/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.gamma.transactions;

import org.multiverse.stms.gamma.GammaConstants;
import org.multiverse.stms.gamma.transactions.GammaTxn;
import org.multiverse.stms.gamma.transactions.fat.FatFixedLengthGammaTxn;
import org.multiverse.stms.gamma.transactions.fat.FatMonoGammaTxn;
import org.multiverse.stms.gamma.transactions.fat.FatVariableLengthGammaTxn;
import org.multiverse.stms.gamma.transactions.lean.LeanFixedLengthGammaTxn;
import org.multiverse.stms.gamma.transactions.lean.LeanMonoGammaTxn;

public final class GammaTxnPool
implements GammaConstants {
    private static final boolean ENABLED = Boolean.parseBoolean(System.getProperty("org.multiverse.stm.gamma.transactions.GammaTxnPool.enabled", "true"));
    private final boolean enabled;
    private final FatMonoGammaTxn[] poolFatMono = new FatMonoGammaTxn[10];
    private int poolFatMonoIndex = -1;
    private final FatFixedLengthGammaTxn[] poolFatFixedLength = new FatFixedLengthGammaTxn[10];
    private int poolFatFixedLengthIndex = -1;
    private final LeanMonoGammaTxn[] poolLeanMono = new LeanMonoGammaTxn[10];
    private int poolLeanMonoIndex = -1;
    private final LeanFixedLengthGammaTxn[] poolLeanFixedLength = new LeanFixedLengthGammaTxn[10];
    private int poolLeanFixedLengthIndex = -1;
    private final FatVariableLengthGammaTxn[] poolFatVariableLength = new FatVariableLengthGammaTxn[10];
    private int poolFatVariableLengthIndex = -1;

    public GammaTxnPool() {
        this.enabled = ENABLED;
    }

    public FatMonoGammaTxn takeFatMono() {
        if (!this.enabled || this.poolFatMonoIndex == -1) {
            return null;
        }
        FatMonoGammaTxn tx = this.poolFatMono[this.poolFatMonoIndex];
        this.poolFatMono[this.poolFatMonoIndex] = null;
        --this.poolFatMonoIndex;
        return tx;
    }

    public FatFixedLengthGammaTxn takeFatFixedLength() {
        if (!this.enabled || this.poolFatFixedLengthIndex == -1) {
            return null;
        }
        FatFixedLengthGammaTxn tx = this.poolFatFixedLength[this.poolFatFixedLengthIndex];
        this.poolFatFixedLength[this.poolFatFixedLengthIndex] = null;
        --this.poolFatFixedLengthIndex;
        return tx;
    }

    public LeanMonoGammaTxn takeLeanMono() {
        if (!this.enabled || this.poolLeanMonoIndex == -1) {
            return null;
        }
        LeanMonoGammaTxn tx = this.poolLeanMono[this.poolLeanMonoIndex];
        this.poolLeanMono[this.poolLeanMonoIndex] = null;
        --this.poolLeanMonoIndex;
        return tx;
    }

    public LeanFixedLengthGammaTxn takeLeanFixedLength() {
        if (!this.enabled || this.poolLeanFixedLengthIndex == -1) {
            return null;
        }
        LeanFixedLengthGammaTxn tx = this.poolLeanFixedLength[this.poolLeanFixedLengthIndex];
        this.poolLeanFixedLength[this.poolLeanFixedLengthIndex] = null;
        --this.poolLeanFixedLengthIndex;
        return tx;
    }

    public FatVariableLengthGammaTxn takeMap() {
        if (!this.enabled || this.poolFatVariableLengthIndex == -1) {
            return null;
        }
        FatVariableLengthGammaTxn tx = this.poolFatVariableLength[this.poolFatVariableLengthIndex];
        this.poolFatVariableLength[this.poolFatVariableLengthIndex] = null;
        --this.poolFatVariableLengthIndex;
        return tx;
    }

    public void put(GammaTxn tx) {
        if (!this.enabled) {
            return;
        }
        int type = tx.transactionType;
        if (type == 3) {
            if (this.poolFatMonoIndex == this.poolFatMono.length - 1) {
                return;
            }
            ++this.poolFatMonoIndex;
            this.poolFatMono[this.poolFatMonoIndex] = (FatMonoGammaTxn)tx;
            return;
        }
        if (type == 4) {
            if (this.poolFatFixedLengthIndex == this.poolFatFixedLength.length - 1) {
                return;
            }
            ++this.poolFatFixedLengthIndex;
            this.poolFatFixedLength[this.poolFatFixedLengthIndex] = (FatFixedLengthGammaTxn)tx;
            return;
        }
        if (type == 1) {
            if (this.poolLeanMonoIndex == this.poolLeanMono.length - 1) {
                return;
            }
            ++this.poolLeanMonoIndex;
            this.poolLeanMono[this.poolLeanMonoIndex] = (LeanMonoGammaTxn)tx;
            return;
        }
        if (type == 2) {
            if (this.poolLeanFixedLengthIndex == this.poolLeanFixedLength.length - 1) {
                return;
            }
            ++this.poolLeanFixedLengthIndex;
            this.poolLeanFixedLength[this.poolLeanFixedLengthIndex] = (LeanFixedLengthGammaTxn)tx;
            return;
        }
        if (type == 5) {
            if (this.poolFatVariableLengthIndex == this.poolFatVariableLength.length - 1) {
                return;
            }
            ++this.poolFatVariableLengthIndex;
            this.poolFatVariableLength[this.poolFatVariableLengthIndex] = (FatVariableLengthGammaTxn)tx;
            return;
        }
        throw new IllegalArgumentException();
    }
}

