/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.internal.versionmapping;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserCodeException;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.Usage;
import org.gradle.api.internal.attributes.AttributeSchemaServices;
import org.gradle.api.internal.attributes.AttributesFactory;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.immutable.ImmutableAttributesSchema;
import org.gradle.api.internal.attributes.matching.AttributeMatcher;
import org.gradle.api.internal.attributes.matching.ImmutableAttributesBackedMatchingCandidate;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.publish.VariantVersionMappingStrategy;
import org.gradle.api.publish.internal.versionmapping.DefaultVariantVersionMappingStrategy;
import org.gradle.api.publish.internal.versionmapping.VariantVersionMappingStrategyInternal;
import org.gradle.api.publish.internal.versionmapping.VersionMappingStrategyInternal;

public class DefaultVersionMappingStrategy
implements VersionMappingStrategyInternal {
    private final ObjectFactory objectFactory;
    private final ConfigurationContainer configurations;
    private final AttributesSchemaInternal schema;
    private final AttributesFactory attributesFactory;
    private final AttributeSchemaServices attributeSchemaServices;
    private final List<Action<? super VariantVersionMappingStrategy>> mappingsForAllVariants = new ArrayList<Action<? super VariantVersionMappingStrategy>>(2);
    private final Map<ImmutableAttributesBackedMatchingCandidate, String> defaultConfigurations = new HashMap<ImmutableAttributesBackedMatchingCandidate, String>();
    private final Multimap<ImmutableAttributesBackedMatchingCandidate, Action<? super VariantVersionMappingStrategy>> attributeBasedMappings = ArrayListMultimap.create();
    private AttributeMatcher matcher;

    @Inject
    public DefaultVersionMappingStrategy(ObjectFactory objectFactory, ConfigurationContainer configurations, AttributesSchemaInternal schema, AttributesFactory attributesFactory, AttributeSchemaServices attributeSchemaServices) {
        this.objectFactory = objectFactory;
        this.configurations = configurations;
        this.schema = schema;
        this.attributesFactory = attributesFactory;
        this.attributeSchemaServices = attributeSchemaServices;
    }

    @Override
    public void allVariants(Action<? super VariantVersionMappingStrategy> action) {
        this.mappingsForAllVariants.add(action);
    }

    @Override
    public <T> void variant(Attribute<T> attribute, T attributeValue, Action<? super VariantVersionMappingStrategy> action) {
        ImmutableAttributes attributes = this.attributesFactory.of(attribute, attributeValue);
        this.attributeBasedMappings.put((Object)new ImmutableAttributesBackedMatchingCandidate(attributes), action);
    }

    @Override
    public void usage(String usage, Action<? super VariantVersionMappingStrategy> action) {
        this.variant(Usage.USAGE_ATTRIBUTE, (Usage)this.objectFactory.named(Usage.class, usage), action);
    }

    @Override
    public void defaultResolutionConfiguration(String usage, String defaultConfiguration) {
        ImmutableAttributes attributes = this.attributesFactory.of(Usage.USAGE_ATTRIBUTE, (Object)((Usage)this.objectFactory.named(Usage.class, usage)));
        this.defaultConfigurations.put(new ImmutableAttributesBackedMatchingCandidate(attributes), defaultConfiguration);
    }

    @Override
    public VariantVersionMappingStrategyInternal findStrategyForVariant(ImmutableAttributes variantAttributes) {
        DefaultVariantVersionMappingStrategy strategy = this.createDefaultMappingStrategy(variantAttributes);
        for (Action<? super VariantVersionMappingStrategy> action : this.mappingsForAllVariants) {
            action.execute((Object)strategy);
        }
        if (!this.attributeBasedMappings.isEmpty()) {
            ImmutableList candidates = ImmutableList.copyOf((Collection)this.attributeBasedMappings.keySet());
            List matches = this.getMatcher().matchMultipleCandidates((List)candidates, variantAttributes);
            if (matches.size() == 1) {
                Collection actions = this.attributeBasedMappings.get((Object)((ImmutableAttributesBackedMatchingCandidate)matches.get(0)));
                for (Action action : actions) {
                    action.execute((Object)strategy);
                }
            } else if (matches.size() > 1) {
                throw new InvalidUserCodeException("Unable to find a suitable version mapping strategy for " + variantAttributes);
            }
        }
        return strategy;
    }

    private DefaultVariantVersionMappingStrategy createDefaultMappingStrategy(ImmutableAttributes variantAttributes) {
        DefaultVariantVersionMappingStrategy strategy = new DefaultVariantVersionMappingStrategy(this.configurations);
        if (!this.defaultConfigurations.isEmpty()) {
            ImmutableList candidates = ImmutableList.copyOf(this.defaultConfigurations.keySet());
            List matches = this.getMatcher().matchMultipleCandidates((List)candidates, variantAttributes);
            for (ImmutableAttributesBackedMatchingCandidate match : matches) {
                strategy.setDefaultResolutionConfiguration(this.configurations.getByName(this.defaultConfigurations.get(match)));
            }
        }
        return strategy;
    }

    private AttributeMatcher getMatcher() {
        if (this.matcher == null) {
            ImmutableAttributesSchema immutableSchema = this.attributeSchemaServices.getSchemaFactory().create(this.schema);
            this.matcher = this.attributeSchemaServices.getMatcher(immutableSchema, ImmutableAttributesSchema.EMPTY);
        }
        return this.matcher;
    }
}

