############################################################################
##
#W  xmod-more.g            XMODALG example files             Zekeriya Arvasi
#W                                                            & Alper Odabas
#Y  Copyright (C) 2014-2024, Zekeriya Arvasi & Alper Odabas,  
##

LoadPackage( "xmodalg" );

Print("\nXModAlg test file xmod.g (version 16/06/24) :-");
Print("\ntesting constructions of crossed modules of algebras\n\n");

A := GroupRing( GF(5), DihedralGroup(4) );
SetName( A, "GF5[d4]" );
I := AugmentationIdeal( A );
SetName( I, "I(GF(5)[d4])" );
CM := XModAlgebraByIdeal( A, I );
Display( CM );
Print( "CM has size ", Size2d( CM ), "\n" );
Print( "CM has dimension ", Dimension( CM ), "\n" );
f := Boundary( CM );
Print( "CM has boundary ", f, "\n" );
Print( "CM has representations ", RepresentationsOfObject( CM ), "\n" ); 
props := [ "CanEasilyCompareElements", "CanEasilySortElements", 
"IsDuplicateFree", "IsLeftActedOnByDivisionRing", "IsAdditivelyCommutative", 
"IsPreXModAlgebra", "IsXModAlgebra" ];;
known := KnownPropertiesOfObject( CM );;
ForAll( props, p -> (p in known) );
Print( KnownAttributesOfObject( CM ), "\n" ); 

e4 := Elements(I)[4];
J := Ideal( I, [e4] );
SetName( J, "<e4>" ); 
Print( "PM is an XModAlgebraByIdeal with ideal generated by ", e4, "\n" );
PM := XModAlgebraByIdeal( A, J );
Display( PM );
ok := IsSubXModAlgebra( CM, PM );

G := SmallGroup( 4, 2 );
F := GaloisField( 4 );
R := GroupRing( F, G );
SetName( R, "GF(4)[k4]" );
Print( "R is the algebra ", R, "\n" );
e5 := Elements(R)[5]; 
S := Subalgebra( R, [e5] ); 
SetName( S, "<e5>" );
Print( "S is the subalgebra of R generated by ", e5, "\n" );
RS := Cartesian( R, S );; 
SetName( RS, "GF(2^2)[k4] x <e5>" );
## make the following available when AlgebraSAction2 has been fixed
## act := AlgebraAction( R, RS, S );;
## bdy := AlgebraHomomorphismByImages( S, R, [e5], [e5] );
## IsAlgebraAction( act ); 
## IsAlgebraHomomorphism( bdy );
## XM := PreXModAlgebraByBoundaryAndAction( bdy, act );
## IsXModAlgebra( XM );
## Display( XM );

A := GroupRing( GF(2), CyclicGroup(4) );
SetName( A, "GF(2)[c4]" );
B := AugmentationIdeal( A );
SetName( B, "I(GF(2)[c4])" );
X1 := XModAlgebra( A, B );
C := GroupRing( GF(2), SmallGroup(4,2) );
SetName( C, "GF(2)[k4]" );
D := AugmentationIdeal( C );
SetName( D, "I(GF(2)[k4])" );
X2 := XModAlgebra( C, D );
B = D;
all_f := AllAlgebraHomomorphisms(A,C);;
all_g := AllAlgebraHomomorphisms(B,D);;
mor := XModAlgebraMorphism( X1, X2, all_g[1], all_f[2] );
Display( mor );
X3 := Kernel( mor) ;
IsTotal( mor );
IsSingleValued( mor );
IsXModAlgebra( X3 );
Size2d( X3 );
IsSubXModAlgebra( X1, X3 );


#############################################################################
##
#E  xmod-more.g . . . . . . . . . . . . . . . . . . . . . . . . . . ends here
