/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.menubuilders.menu;

import java.awt.Dimension;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.core.ui.menubuilders.generic.Entry;
import org.freeplane.core.ui.menubuilders.generic.EntryAccessor;
import org.freeplane.core.ui.svgicons.FreeplaneIconFactory;
import org.freeplane.features.icon.factory.IconFactory;

class IconReplacer {
    IconReplacer() {
    }

    static void replaceByScaledImageIcon(AbstractButton actionComponent) {
        Icon icon = actionComponent.getIcon();
        IconFactory imageIconFactory = IconFactory.getInstance();
        if (icon != null && imageIconFactory.canScaleIcon(icon)) {
            if (actionComponent.getText() != null) {
                Icon scaledIcon = imageIconFactory.getScaledIcon(icon, actionComponent);
                actionComponent.setIcon(FreeplaneIconFactory.toImageIcon(scaledIcon));
            } else {
                Dimension preferredSize = actionComponent.getPreferredSize();
                int iconHeight = icon.getIconHeight();
                int iconWidth = icon.getIconWidth();
                if (iconWidth > 0 && iconHeight > 0) {
                    int preferredHeight = preferredSize.height;
                    int height = actionComponent.getHeight();
                    int preferredWidth = preferredSize.width;
                    int width = actionComponent.getWidth();
                    if (height > preferredHeight) {
                        int newIconHeight = Math.min(iconHeight + height - preferredHeight, (iconWidth + width - preferredWidth) * iconHeight / iconWidth);
                        Quantity iconHeightQuantity = new Quantity((double)newIconHeight, (Enum)LengthUnit.px);
                        actionComponent.setIcon(FreeplaneIconFactory.toImageIcon(imageIconFactory.getScaledIcon(icon, (Quantity<LengthUnit>)iconHeightQuantity)));
                    }
                }
            }
        }
    }

    static void replaceByImageIcon(Entry entry, AbstractButton actionComponent, EntryAccessor entryAccessor) {
        Icon icon = entryAccessor.getIcon(entry);
        if (icon == null) {
            icon = actionComponent.getIcon();
        }
        if (icon != null) {
            actionComponent.setIcon(FreeplaneIconFactory.toImageIcon(icon));
        }
    }
}

