/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.menubuilders.generic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.ListIterator;
import java.util.Map;
import org.freeplane.core.ui.menubuilders.generic.BuildPhaseListener;
import org.freeplane.core.ui.menubuilders.generic.Entry;
import org.freeplane.core.ui.menubuilders.generic.RecursiveMenuStructureProcessor;

public class PhaseProcessor {
    private final LinkedHashMap<Phase, RecursiveMenuStructureProcessor> processors = new LinkedHashMap();
    private final Collection<BuildPhaseListener> buildPhaseListeners;

    public PhaseProcessor(Collection<BuildPhaseListener> buildPhaseListeners) {
        this.buildPhaseListeners = buildPhaseListeners;
    }

    public PhaseProcessor() {
        this(Collections.emptyList());
    }

    public void build(Entry entry) {
        for (Map.Entry<Phase, RecursiveMenuStructureProcessor> processEntry : this.processors.entrySet()) {
            processEntry.getValue().build(entry);
            for (BuildPhaseListener listener : this.buildPhaseListeners) {
                listener.buildPhaseFinished(processEntry.getKey(), entry);
            }
        }
    }

    public PhaseProcessor forChildren(Entry root, Entry entry) {
        PhaseProcessor phaseProcessor = new PhaseProcessor(this.buildPhaseListeners);
        for (Map.Entry<Phase, RecursiveMenuStructureProcessor> processor : this.processors.entrySet()) {
            phaseProcessor.withPhase(processor.getKey(), processor.getValue().forChildren(root, entry));
        }
        return phaseProcessor;
    }

    public PhaseProcessor withPhase(Phase phaseName, RecursiveMenuStructureProcessor processor) {
        this.processors.put(phaseName, processor);
        return this;
    }

    public RecursiveMenuStructureProcessor phase(Phase name) {
        return this.processors.get((Object)name);
    }

    public void destroy(Entry entry) {
        ListIterator<RecursiveMenuStructureProcessor> processorIterator = new ArrayList<RecursiveMenuStructureProcessor>(this.processors.values()).listIterator(this.processors.size());
        while (processorIterator.hasPrevious()) {
            processorIterator.previous().destroy(entry);
        }
    }

    public void buildChildren(Entry entry) {
        for (Map.Entry<Phase, RecursiveMenuStructureProcessor> processEntry : this.processors.entrySet()) {
            for (Entry child : new ArrayList<Entry>(entry.children())) {
                processEntry.getValue().build(child);
            }
            for (BuildPhaseListener listener : this.buildPhaseListeners) {
                listener.buildPhaseFinished(processEntry.getKey(), entry);
            }
        }
    }

    public static enum Phase {
        ACTIONS,
        ACCELERATORS,
        UI;

    }
}

