/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.util.autodetect;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fontbox.util.autodetect.FontDirFinder;

public class WindowsFontDirFinder
implements FontDirFinder {
    private static final Log LOG = LogFactory.getLog(WindowsFontDirFinder.class);

    private String getWinDir(String osName) throws IOException {
        Runtime runtime = Runtime.getRuntime();
        String cmd = osName.startsWith("Windows 9") ? "command.com" : "cmd.exe";
        String[] cmdArray = new String[]{cmd, "/c", "echo", "%windir%"};
        Process process = runtime.exec(cmdArray);
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.ISO_8859_1));){
            String string = bufferedReader.readLine();
            return string;
        }
    }

    @Override
    public List<File> find() {
        ArrayList<File> fontDirList = new ArrayList<File>();
        String windir = null;
        try {
            windir = System.getProperty("env.windir");
        }
        catch (SecurityException e) {
            LOG.debug((Object)"Couldn't get Windows font directories - ignoring", (Throwable)e);
        }
        String osName = System.getProperty("os.name");
        if (windir == null) {
            try {
                windir = this.getWinDir(osName);
            }
            catch (IOException | SecurityException e) {
                LOG.debug((Object)"Couldn't get Windows font directories - ignoring", (Throwable)e);
            }
        }
        if (windir != null && windir.length() > 2) {
            File psFontsDir;
            File osFontsDir;
            if (windir.endsWith("/")) {
                windir = windir.substring(0, windir.length() - 1);
            }
            if ((osFontsDir = new File(windir + File.separator + "FONTS")).exists() && osFontsDir.canRead()) {
                fontDirList.add(osFontsDir);
            }
            if ((psFontsDir = new File(windir.substring(0, 2) + File.separator + "PSFONTS")).exists() && psFontsDir.canRead()) {
                fontDirList.add(psFontsDir);
            }
        } else {
            char driveLetter;
            String windowsDirName = osName.endsWith("NT") ? "WINNT" : "WINDOWS";
            for (driveLetter = 'C'; driveLetter <= 'E'; driveLetter = (char)(driveLetter + '\u0001')) {
                File osFontsDir = new File(driveLetter + ":" + File.separator + windowsDirName + File.separator + "FONTS");
                try {
                    if (!osFontsDir.exists() || !osFontsDir.canRead()) continue;
                    fontDirList.add(osFontsDir);
                    break;
                }
                catch (SecurityException e) {
                    LOG.debug((Object)"Couldn't get Windows font directories - ignoring", (Throwable)e);
                }
            }
            for (driveLetter = 'C'; driveLetter <= 'E'; driveLetter = (char)(driveLetter + '\u0001')) {
                File psFontsDir = new File(driveLetter + ":" + File.separator + "PSFONTS");
                try {
                    if (!psFontsDir.exists() || !psFontsDir.canRead()) continue;
                    fontDirList.add(psFontsDir);
                    break;
                }
                catch (SecurityException e) {
                    LOG.debug((Object)"Couldn't get Windows font directories - ignoring", (Throwable)e);
                }
            }
        }
        try {
            File localFontDir;
            String localAppData = System.getenv("LOCALAPPDATA");
            if (localAppData != null && !localAppData.isEmpty() && (localFontDir = new File(localAppData + File.separator + "Microsoft" + File.separator + "Windows" + File.separator + "Fonts")).exists() && localFontDir.canRead()) {
                fontDirList.add(localFontDir);
            }
        }
        catch (SecurityException e) {
            LOG.debug((Object)"Couldn't get LOCALAPPDATA directory - ignoring", (Throwable)e);
        }
        return fontDirList;
    }
}

