{% skip_file unless String::Formatter::HAS_RYU_PRINTF %}

module Float::Printer::RyuPrintf
  {% begin %}
    # A table of all two-digit numbers. This is used to speed up decimal digit
    # generation by copying pairs of digits into the final output.
    DIGIT_TABLE = "{% for i in 0..9 %}0{{ i }}{% end %}{% for i in 10..99 %}{{ i }}{% end %}".to_unsafe
  {% end %}

  # TODO: this is needed to avoid generating lots of allocas
  # in LLVM, which makes LLVM really slow. The compiler should
  # try to avoid/reuse temporary allocas.
  # Explanation: https://github.com/crystal-lang/crystal/issues/4516#issuecomment-306226171
  private def self.put(array : Array, values) : Nil
    array << values
  end

  private def self.put(array : Array, *values) : Nil
    array << values
  end

  # Special constants for `%g` formatting; for details refer to
  # https://github.com/ulfjack/ryu/pull/185/files or
  # https://github.com/microsoft/STL/blob/a8888806c6960f1687590ffd4244794c753aa819/stl/inc/xcharconv_tables.h

  private MAX_SPECIAL_P = 15_u32

  private SPECIAL_X = begin
    data = Array(UInt64).new(195)
    put(data, 0x3F18E757928E0C9Du64)
    put(data, 0x3F4F212D77318FC5u64)
    put(data, 0x3F8374BC6A7EF9DBu64)
    put(data, 0x3FB851EB851EB851u64)
    put(data, 0x3FEE666666666666u64)
    put(data, 0x4022FFFFFFFFFFFFu64)
    put(data, 0x3F1A1554FBDAD751u64)
    put(data, 0x3F504D551D68C692u64)
    put(data, 0x3F8460AA64C2F837u64)
    put(data, 0x3FB978D4FDF3B645u64)
    put(data, 0x3FEFD70A3D70A3D7u64)
    put(data, 0x4023E66666666666u64)
    put(data, 0x4058DFFFFFFFFFFFu64)
    put(data, 0x3F1A3387ECC8EB96u64)
    put(data, 0x3F506034F3FD933Eu64)
    put(data, 0x3F84784230FCF80Du64)
    put(data, 0x3FB99652BD3C3611u64)
    put(data, 0x3FEFFBE76C8B4395u64)
    put(data, 0x4023FD70A3D70A3Du64)
    put(data, 0x4058FCCCCCCCCCCCu64)
    put(data, 0x408F3BFFFFFFFFFFu64)
    put(data, 0x3F1A368D04E0BA6Au64)
    put(data, 0x3F506218230C7482u64)
    put(data, 0x3F847A9E2BCF91A3u64)
    put(data, 0x3FB99945B6C3760Bu64)
    put(data, 0x3FEFFF972474538Eu64)
    put(data, 0x4023FFBE76C8B439u64)
    put(data, 0x4058FFAE147AE147u64)
    put(data, 0x408F3F9999999999u64)
    put(data, 0x40C387BFFFFFFFFFu64)
    put(data, 0x3F1A36DA54164F19u64)
    put(data, 0x3F506248748DF16Fu64)
    put(data, 0x3F847ADA91B16DCBu64)
    put(data, 0x3FB99991361DC93Eu64)
    put(data, 0x3FEFFFF583A53B8Eu64)
    put(data, 0x4023FFF972474538u64)
    put(data, 0x4058FFF7CED91687u64)
    put(data, 0x408F3FF5C28F5C28u64)
    put(data, 0x40C387F999999999u64)
    put(data, 0x40F869F7FFFFFFFFu64)
    put(data, 0x3F1A36E20F35445Du64)
    put(data, 0x3F50624D49814ABAu64)
    put(data, 0x3F847AE09BE19D69u64)
    put(data, 0x3FB99998C2DA04C3u64)
    put(data, 0x3FEFFFFEF39085F4u64)
    put(data, 0x4023FFFF583A53B8u64)
    put(data, 0x4058FFFF2E48E8A7u64)
    put(data, 0x408F3FFEF9DB22D0u64)
    put(data, 0x40C387FF5C28F5C2u64)
    put(data, 0x40F869FF33333333u64)
    put(data, 0x412E847EFFFFFFFFu64)
    put(data, 0x3F1A36E2D51EC34Bu64)
    put(data, 0x3F50624DC5333A0Eu64)
    put(data, 0x3F847AE136800892u64)
    put(data, 0x3FB9999984200AB7u64)
    put(data, 0x3FEFFFFFE5280D65u64)
    put(data, 0x4023FFFFEF39085Fu64)
    put(data, 0x4058FFFFEB074A77u64)
    put(data, 0x408F3FFFE5C91D14u64)
    put(data, 0x40C387FFEF9DB22Du64)
    put(data, 0x40F869FFEB851EB8u64)
    put(data, 0x412E847FE6666666u64)
    put(data, 0x416312CFEFFFFFFFu64)
    put(data, 0x3F1A36E2E8E94FFCu64)
    put(data, 0x3F50624DD191D1FDu64)
    put(data, 0x3F847AE145F6467Du64)
    put(data, 0x3FB999999773D81Cu64)
    put(data, 0x3FEFFFFFFD50CE23u64)
    put(data, 0x4023FFFFFE5280D6u64)
    put(data, 0x4058FFFFFDE7210Bu64)
    put(data, 0x408F3FFFFD60E94Eu64)
    put(data, 0x40C387FFFE5C91D1u64)
    put(data, 0x40F869FFFDF3B645u64)
    put(data, 0x412E847FFD70A3D7u64)
    put(data, 0x416312CFFE666666u64)
    put(data, 0x4197D783FDFFFFFFu64)
    put(data, 0x3F1A36E2EAE3F7A7u64)
    put(data, 0x3F50624DD2CE7AC8u64)
    put(data, 0x3F847AE14782197Bu64)
    put(data, 0x3FB9999999629FD9u64)
    put(data, 0x3FEFFFFFFFBB47D0u64)
    put(data, 0x4023FFFFFFD50CE2u64)
    put(data, 0x4058FFFFFFCA501Au64)
    put(data, 0x408F3FFFFFBCE421u64)
    put(data, 0x40C387FFFFD60E94u64)
    put(data, 0x40F869FFFFCB923Au64)
    put(data, 0x412E847FFFBE76C8u64)
    put(data, 0x416312CFFFD70A3Du64)
    put(data, 0x4197D783FFCCCCCCu64)
    put(data, 0x41CDCD64FFBFFFFFu64)
    put(data, 0x3F1A36E2EB16A205u64)
    put(data, 0x3F50624DD2EE2543u64)
    put(data, 0x3F847AE147A9AE94u64)
    put(data, 0x3FB9999999941A39u64)
    put(data, 0x3FEFFFFFFFF920C8u64)
    put(data, 0x4023FFFFFFFBB47Du64)
    put(data, 0x4058FFFFFFFAA19Cu64)
    put(data, 0x408F3FFFFFF94A03u64)
    put(data, 0x40C387FFFFFBCE42u64)
    put(data, 0x40F869FFFFFAC1D2u64)
    put(data, 0x412E847FFFF97247u64)
    put(data, 0x416312CFFFFBE76Cu64)
    put(data, 0x4197D783FFFAE147u64)
    put(data, 0x41CDCD64FFF99999u64)
    put(data, 0x4202A05F1FFBFFFFu64)
    put(data, 0x3F1A36E2EB1BB30Fu64)
    put(data, 0x3F50624DD2F14FE9u64)
    put(data, 0x3F847AE147ADA3E3u64)
    put(data, 0x3FB9999999990CDCu64)
    put(data, 0x3FEFFFFFFFFF5014u64)
    put(data, 0x4023FFFFFFFF920Cu64)
    put(data, 0x4058FFFFFFFF768Fu64)
    put(data, 0x408F3FFFFFFF5433u64)
    put(data, 0x40C387FFFFFF94A0u64)
    put(data, 0x40F869FFFFFF79C8u64)
    put(data, 0x412E847FFFFF583Au64)
    put(data, 0x416312CFFFFF9724u64)
    put(data, 0x4197D783FFFF7CEDu64)
    put(data, 0x41CDCD64FFFF5C28u64)
    put(data, 0x4202A05F1FFF9999u64)
    put(data, 0x42374876E7FF7FFFu64)
    put(data, 0x3F1A36E2EB1C34C3u64)
    put(data, 0x3F50624DD2F1A0FAu64)
    put(data, 0x3F847AE147AE0938u64)
    put(data, 0x3FB9999999998B86u64)
    put(data, 0x3FEFFFFFFFFFEE68u64)
    put(data, 0x4023FFFFFFFFF501u64)
    put(data, 0x4058FFFFFFFFF241u64)
    put(data, 0x408F3FFFFFFFEED1u64)
    put(data, 0x40C387FFFFFFF543u64)
    put(data, 0x40F869FFFFFFF294u64)
    put(data, 0x412E847FFFFFEF39u64)
    put(data, 0x416312CFFFFFF583u64)
    put(data, 0x4197D783FFFFF2E4u64)
    put(data, 0x41CDCD64FFFFEF9Du64)
    put(data, 0x4202A05F1FFFF5C2u64)
    put(data, 0x42374876E7FFF333u64)
    put(data, 0x426D1A94A1FFEFFFu64)
    put(data, 0x3F1A36E2EB1C41BBu64)
    put(data, 0x3F50624DD2F1A915u64)
    put(data, 0x3F847AE147AE135Au64)
    put(data, 0x3FB9999999999831u64)
    put(data, 0x3FEFFFFFFFFFFE3Du64)
    put(data, 0x4023FFFFFFFFFEE6u64)
    put(data, 0x4058FFFFFFFFFEA0u64)
    put(data, 0x408F3FFFFFFFFE48u64)
    put(data, 0x40C387FFFFFFFEEDu64)
    put(data, 0x40F869FFFFFFFEA8u64)
    put(data, 0x412E847FFFFFFE52u64)
    put(data, 0x416312CFFFFFFEF3u64)
    put(data, 0x4197D783FFFFFEB0u64)
    put(data, 0x41CDCD64FFFFFE5Cu64)
    put(data, 0x4202A05F1FFFFEF9u64)
    put(data, 0x42374876E7FFFEB8u64)
    put(data, 0x426D1A94A1FFFE66u64)
    put(data, 0x42A2309CE53FFEFFu64)
    put(data, 0x3F1A36E2EB1C4307u64)
    put(data, 0x3F50624DD2F1A9E4u64)
    put(data, 0x3F847AE147AE145Eu64)
    put(data, 0x3FB9999999999975u64)
    put(data, 0x3FEFFFFFFFFFFFD2u64)
    put(data, 0x4023FFFFFFFFFFE3u64)
    put(data, 0x4058FFFFFFFFFFDCu64)
    put(data, 0x408F3FFFFFFFFFD4u64)
    put(data, 0x40C387FFFFFFFFE4u64)
    put(data, 0x40F869FFFFFFFFDDu64)
    put(data, 0x412E847FFFFFFFD5u64)
    put(data, 0x416312CFFFFFFFE5u64)
    put(data, 0x4197D783FFFFFFDEu64)
    put(data, 0x41CDCD64FFFFFFD6u64)
    put(data, 0x4202A05F1FFFFFE5u64)
    put(data, 0x42374876E7FFFFDFu64)
    put(data, 0x426D1A94A1FFFFD7u64)
    put(data, 0x42A2309CE53FFFE6u64)
    put(data, 0x42D6BCC41E8FFFDFu64)
    put(data, 0x3F1A36E2EB1C4328u64)
    put(data, 0x3F50624DD2F1A9F9u64)
    put(data, 0x3F847AE147AE1477u64)
    put(data, 0x3FB9999999999995u64)
    put(data, 0x3FEFFFFFFFFFFFFBu64)
    put(data, 0x4023FFFFFFFFFFFDu64)
    put(data, 0x4058FFFFFFFFFFFCu64)
    put(data, 0x408F3FFFFFFFFFFBu64)
    put(data, 0x40C387FFFFFFFFFDu64)
    put(data, 0x40F869FFFFFFFFFCu64)
    put(data, 0x412E847FFFFFFFFBu64)
    put(data, 0x416312CFFFFFFFFDu64)
    put(data, 0x4197D783FFFFFFFCu64)
    put(data, 0x41CDCD64FFFFFFFBu64)
    put(data, 0x4202A05F1FFFFFFDu64)
    put(data, 0x42374876E7FFFFFCu64)
    put(data, 0x426D1A94A1FFFFFBu64)
    put(data, 0x42A2309CE53FFFFDu64)
    put(data, 0x42D6BCC41E8FFFFCu64)
    put(data, 0x430C6BF52633FFFBu64)
    data
  end

  private MAX_ORDINARY_P = 309_u32

  private ORDINARY_X = begin
    data = Array(UInt64).new(314)
    put(data, 0x3F1A36E2EB1C432Cu64)
    put(data, 0x3F50624DD2F1A9FBu64)
    put(data, 0x3F847AE147AE147Au64)
    put(data, 0x3FB9999999999999u64)
    put(data, 0x3FEFFFFFFFFFFFFFu64)
    put(data, 0x4023FFFFFFFFFFFFu64)
    put(data, 0x4058FFFFFFFFFFFFu64)
    put(data, 0x408F3FFFFFFFFFFFu64)
    put(data, 0x40C387FFFFFFFFFFu64)
    put(data, 0x40F869FFFFFFFFFFu64)
    put(data, 0x412E847FFFFFFFFFu64)
    put(data, 0x416312CFFFFFFFFFu64)
    put(data, 0x4197D783FFFFFFFFu64)
    put(data, 0x41CDCD64FFFFFFFFu64)
    put(data, 0x4202A05F1FFFFFFFu64)
    put(data, 0x42374876E7FFFFFFu64)
    put(data, 0x426D1A94A1FFFFFFu64)
    put(data, 0x42A2309CE53FFFFFu64)
    put(data, 0x42D6BCC41E8FFFFFu64)
    put(data, 0x430C6BF52633FFFFu64)
    put(data, 0x4341C37937E07FFFu64)
    put(data, 0x4376345785D89FFFu64)
    put(data, 0x43ABC16D674EC7FFu64)
    put(data, 0x43E158E460913CFFu64)
    put(data, 0x4415AF1D78B58C3Fu64)
    put(data, 0x444B1AE4D6E2EF4Fu64)
    put(data, 0x4480F0CF064DD591u64)
    put(data, 0x44B52D02C7E14AF6u64)
    put(data, 0x44EA784379D99DB4u64)
    put(data, 0x45208B2A2C280290u64)
    put(data, 0x4554ADF4B7320334u64)
    put(data, 0x4589D971E4FE8401u64)
    put(data, 0x45C027E72F1F1281u64)
    put(data, 0x45F431E0FAE6D721u64)
    put(data, 0x46293E5939A08CE9u64)
    put(data, 0x465F8DEF8808B024u64)
    put(data, 0x4693B8B5B5056E16u64)
    put(data, 0x46C8A6E32246C99Cu64)
    put(data, 0x46FED09BEAD87C03u64)
    put(data, 0x4733426172C74D82u64)
    put(data, 0x476812F9CF7920E2u64)
    put(data, 0x479E17B84357691Bu64)
    put(data, 0x47D2CED32A16A1B1u64)
    put(data, 0x48078287F49C4A1Du64)
    put(data, 0x483D6329F1C35CA4u64)
    put(data, 0x48725DFA371A19E6u64)
    put(data, 0x48A6F578C4E0A060u64)
    put(data, 0x48DCB2D6F618C878u64)
    put(data, 0x4911EFC659CF7D4Bu64)
    put(data, 0x49466BB7F0435C9Eu64)
    put(data, 0x497C06A5EC5433C6u64)
    put(data, 0x49B18427B3B4A05Bu64)
    put(data, 0x49E5E531A0A1C872u64)
    put(data, 0x4A1B5E7E08CA3A8Fu64)
    put(data, 0x4A511B0EC57E6499u64)
    put(data, 0x4A8561D276DDFDC0u64)
    put(data, 0x4ABABA4714957D30u64)
    put(data, 0x4AF0B46C6CDD6E3Eu64)
    put(data, 0x4B24E1878814C9CDu64)
    put(data, 0x4B5A19E96A19FC40u64)
    put(data, 0x4B905031E2503DA8u64)
    put(data, 0x4BC4643E5AE44D12u64)
    put(data, 0x4BF97D4DF19D6057u64)
    put(data, 0x4C2FDCA16E04B86Du64)
    put(data, 0x4C63E9E4E4C2F344u64)
    put(data, 0x4C98E45E1DF3B015u64)
    put(data, 0x4CCF1D75A5709C1Au64)
    put(data, 0x4D03726987666190u64)
    put(data, 0x4D384F03E93FF9F4u64)
    put(data, 0x4D6E62C4E38FF872u64)
    put(data, 0x4DA2FDBB0E39FB47u64)
    put(data, 0x4DD7BD29D1C87A19u64)
    put(data, 0x4E0DAC74463A989Fu64)
    put(data, 0x4E428BC8ABE49F63u64)
    put(data, 0x4E772EBAD6DDC73Cu64)
    put(data, 0x4EACFA698C95390Bu64)
    put(data, 0x4EE21C81F7DD43A7u64)
    put(data, 0x4F16A3A275D49491u64)
    put(data, 0x4F4C4C8B1349B9B5u64)
    put(data, 0x4F81AFD6EC0E1411u64)
    put(data, 0x4FB61BCCA7119915u64)
    put(data, 0x4FEBA2BFD0D5FF5Bu64)
    put(data, 0x502145B7E285BF98u64)
    put(data, 0x50559725DB272F7Fu64)
    put(data, 0x508AFCEF51F0FB5Eu64)
    put(data, 0x50C0DE1593369D1Bu64)
    put(data, 0x50F5159AF8044462u64)
    put(data, 0x512A5B01B605557Au64)
    put(data, 0x516078E111C3556Cu64)
    put(data, 0x5194971956342AC7u64)
    put(data, 0x51C9BCDFABC13579u64)
    put(data, 0x5200160BCB58C16Cu64)
    put(data, 0x52341B8EBE2EF1C7u64)
    put(data, 0x526922726DBAAE39u64)
    put(data, 0x529F6B0F092959C7u64)
    put(data, 0x52D3A2E965B9D81Cu64)
    put(data, 0x53088BA3BF284E23u64)
    put(data, 0x533EAE8CAEF261ACu64)
    put(data, 0x53732D17ED577D0Bu64)
    put(data, 0x53A7F85DE8AD5C4Eu64)
    put(data, 0x53DDF67562D8B362u64)
    put(data, 0x5412BA095DC7701Du64)
    put(data, 0x5447688BB5394C25u64)
    put(data, 0x547D42AEA2879F2Eu64)
    put(data, 0x54B249AD2594C37Cu64)
    put(data, 0x54E6DC186EF9F45Cu64)
    put(data, 0x551C931E8AB87173u64)
    put(data, 0x5551DBF316B346E7u64)
    put(data, 0x558652EFDC6018A1u64)
    put(data, 0x55BBE7ABD3781ECAu64)
    put(data, 0x55F170CB642B133Eu64)
    put(data, 0x5625CCFE3D35D80Eu64)
    put(data, 0x565B403DCC834E11u64)
    put(data, 0x569108269FD210CBu64)
    put(data, 0x56C54A3047C694FDu64)
    put(data, 0x56FA9CBC59B83A3Du64)
    put(data, 0x5730A1F5B8132466u64)
    put(data, 0x5764CA732617ED7Fu64)
    put(data, 0x5799FD0FEF9DE8DFu64)
    put(data, 0x57D03E29F5C2B18Bu64)
    put(data, 0x58044DB473335DEEu64)
    put(data, 0x583961219000356Au64)
    put(data, 0x586FB969F40042C5u64)
    put(data, 0x58A3D3E2388029BBu64)
    put(data, 0x58D8C8DAC6A0342Au64)
    put(data, 0x590EFB1178484134u64)
    put(data, 0x59435CEAEB2D28C0u64)
    put(data, 0x59783425A5F872F1u64)
    put(data, 0x59AE412F0F768FADu64)
    put(data, 0x59E2E8BD69AA19CCu64)
    put(data, 0x5A17A2ECC414A03Fu64)
    put(data, 0x5A4D8BA7F519C84Fu64)
    put(data, 0x5A827748F9301D31u64)
    put(data, 0x5AB7151B377C247Eu64)
    put(data, 0x5AECDA62055B2D9Du64)
    put(data, 0x5B22087D4358FC82u64)
    put(data, 0x5B568A9C942F3BA3u64)
    put(data, 0x5B8C2D43B93B0A8Bu64)
    put(data, 0x5BC19C4A53C4E697u64)
    put(data, 0x5BF6035CE8B6203Du64)
    put(data, 0x5C2B843422E3A84Cu64)
    put(data, 0x5C6132A095CE492Fu64)
    put(data, 0x5C957F48BB41DB7Bu64)
    put(data, 0x5CCADF1AEA12525Au64)
    put(data, 0x5D00CB70D24B7378u64)
    put(data, 0x5D34FE4D06DE5056u64)
    put(data, 0x5D6A3DE04895E46Cu64)
    put(data, 0x5DA066AC2D5DAEC3u64)
    put(data, 0x5DD4805738B51A74u64)
    put(data, 0x5E09A06D06E26112u64)
    put(data, 0x5E400444244D7CABu64)
    put(data, 0x5E7405552D60DBD6u64)
    put(data, 0x5EA906AA78B912CBu64)
    put(data, 0x5EDF485516E7577Eu64)
    put(data, 0x5F138D352E5096AFu64)
    put(data, 0x5F48708279E4BC5Au64)
    put(data, 0x5F7E8CA3185DEB71u64)
    put(data, 0x5FB317E5EF3AB327u64)
    put(data, 0x5FE7DDDF6B095FF0u64)
    put(data, 0x601DD55745CBB7ECu64)
    put(data, 0x6052A5568B9F52F4u64)
    put(data, 0x60874EAC2E8727B1u64)
    put(data, 0x60BD22573A28F19Du64)
    put(data, 0x60F2357684599702u64)
    put(data, 0x6126C2D4256FFCC2u64)
    put(data, 0x615C73892ECBFBF3u64)
    put(data, 0x6191C835BD3F7D78u64)
    put(data, 0x61C63A432C8F5CD6u64)
    put(data, 0x61FBC8D3F7B3340Bu64)
    put(data, 0x62315D847AD00087u64)
    put(data, 0x6265B4E5998400A9u64)
    put(data, 0x629B221EFFE500D3u64)
    put(data, 0x62D0F5535FEF2084u64)
    put(data, 0x630532A837EAE8A5u64)
    put(data, 0x633A7F5245E5A2CEu64)
    put(data, 0x63708F936BAF85C1u64)
    put(data, 0x63A4B378469B6731u64)
    put(data, 0x63D9E056584240FDu64)
    put(data, 0x64102C35F729689Eu64)
    put(data, 0x6444374374F3C2C6u64)
    put(data, 0x647945145230B377u64)
    put(data, 0x64AF965966BCE055u64)
    put(data, 0x64E3BDF7E0360C35u64)
    put(data, 0x6518AD75D8438F43u64)
    put(data, 0x654ED8D34E547313u64)
    put(data, 0x6583478410F4C7ECu64)
    put(data, 0x65B819651531F9E7u64)
    put(data, 0x65EE1FBE5A7E7861u64)
    put(data, 0x6622D3D6F88F0B3Cu64)
    put(data, 0x665788CCB6B2CE0Cu64)
    put(data, 0x668D6AFFE45F818Fu64)
    put(data, 0x66C262DFEEBBB0F9u64)
    put(data, 0x66F6FB97EA6A9D37u64)
    put(data, 0x672CBA7DE5054485u64)
    put(data, 0x6761F48EAF234AD3u64)
    put(data, 0x679671B25AEC1D88u64)
    put(data, 0x67CC0E1EF1A724EAu64)
    put(data, 0x680188D357087712u64)
    put(data, 0x6835EB082CCA94D7u64)
    put(data, 0x686B65CA37FD3A0Du64)
    put(data, 0x68A11F9E62FE4448u64)
    put(data, 0x68D56785FBBDD55Au64)
    put(data, 0x690AC1677AAD4AB0u64)
    put(data, 0x6940B8E0ACAC4EAEu64)
    put(data, 0x6974E718D7D7625Au64)
    put(data, 0x69AA20DF0DCD3AF0u64)
    put(data, 0x69E0548B68A044D6u64)
    put(data, 0x6A1469AE42C8560Cu64)
    put(data, 0x6A498419D37A6B8Fu64)
    put(data, 0x6A7FE52048590672u64)
    put(data, 0x6AB3EF342D37A407u64)
    put(data, 0x6AE8EB0138858D09u64)
    put(data, 0x6B1F25C186A6F04Cu64)
    put(data, 0x6B537798F428562Fu64)
    put(data, 0x6B88557F31326BBBu64)
    put(data, 0x6BBE6ADEFD7F06AAu64)
    put(data, 0x6BF302CB5E6F642Au64)
    put(data, 0x6C27C37E360B3D35u64)
    put(data, 0x6C5DB45DC38E0C82u64)
    put(data, 0x6C9290BA9A38C7D1u64)
    put(data, 0x6CC734E940C6F9C5u64)
    put(data, 0x6CFD022390F8B837u64)
    put(data, 0x6D3221563A9B7322u64)
    put(data, 0x6D66A9ABC9424FEBu64)
    put(data, 0x6D9C5416BB92E3E6u64)
    put(data, 0x6DD1B48E353BCE6Fu64)
    put(data, 0x6E0621B1C28AC20Bu64)
    put(data, 0x6E3BAA1E332D728Eu64)
    put(data, 0x6E714A52DFFC6799u64)
    put(data, 0x6EA59CE797FB817Fu64)
    put(data, 0x6EDB04217DFA61DFu64)
    put(data, 0x6F10E294EEBC7D2Bu64)
    put(data, 0x6F451B3A2A6B9C76u64)
    put(data, 0x6F7A6208B5068394u64)
    put(data, 0x6FB07D457124123Cu64)
    put(data, 0x6FE49C96CD6D16CBu64)
    put(data, 0x7019C3BC80C85C7Eu64)
    put(data, 0x70501A55D07D39CFu64)
    put(data, 0x708420EB449C8842u64)
    put(data, 0x70B9292615C3AA53u64)
    put(data, 0x70EF736F9B3494E8u64)
    put(data, 0x7123A825C100DD11u64)
    put(data, 0x7158922F31411455u64)
    put(data, 0x718EB6BAFD91596Bu64)
    put(data, 0x71C33234DE7AD7E2u64)
    put(data, 0x71F7FEC216198DDBu64)
    put(data, 0x722DFE729B9FF152u64)
    put(data, 0x7262BF07A143F6D3u64)
    put(data, 0x72976EC98994F488u64)
    put(data, 0x72CD4A7BEBFA31AAu64)
    put(data, 0x73024E8D737C5F0Au64)
    put(data, 0x7336E230D05B76CDu64)
    put(data, 0x736C9ABD04725480u64)
    put(data, 0x73A1E0B622C774D0u64)
    put(data, 0x73D658E3AB795204u64)
    put(data, 0x740BEF1C9657A685u64)
    put(data, 0x74417571DDF6C813u64)
    put(data, 0x7475D2CE55747A18u64)
    put(data, 0x74AB4781EAD1989Eu64)
    put(data, 0x74E10CB132C2FF63u64)
    put(data, 0x75154FDD7F73BF3Bu64)
    put(data, 0x754AA3D4DF50AF0Au64)
    put(data, 0x7580A6650B926D66u64)
    put(data, 0x75B4CFFE4E7708C0u64)
    put(data, 0x75EA03FDE214CAF0u64)
    put(data, 0x7620427EAD4CFED6u64)
    put(data, 0x7654531E58A03E8Bu64)
    put(data, 0x768967E5EEC84E2Eu64)
    put(data, 0x76BFC1DF6A7A61BAu64)
    put(data, 0x76F3D92BA28C7D14u64)
    put(data, 0x7728CF768B2F9C59u64)
    put(data, 0x775F03542DFB8370u64)
    put(data, 0x779362149CBD3226u64)
    put(data, 0x77C83A99C3EC7EAFu64)
    put(data, 0x77FE494034E79E5Bu64)
    put(data, 0x7832EDC82110C2F9u64)
    put(data, 0x7867A93A2954F3B7u64)
    put(data, 0x789D9388B3AA30A5u64)
    put(data, 0x78D27C35704A5E67u64)
    put(data, 0x79071B42CC5CF601u64)
    put(data, 0x793CE2137F743381u64)
    put(data, 0x79720D4C2FA8A030u64)
    put(data, 0x79A6909F3B92C83Du64)
    put(data, 0x79DC34C70A777A4Cu64)
    put(data, 0x7A11A0FC668AAC6Fu64)
    put(data, 0x7A46093B802D578Bu64)
    put(data, 0x7A7B8B8A6038AD6Eu64)
    put(data, 0x7AB137367C236C65u64)
    put(data, 0x7AE585041B2C477Eu64)
    put(data, 0x7B1AE64521F7595Eu64)
    put(data, 0x7B50CFEB353A97DAu64)
    put(data, 0x7B8503E602893DD1u64)
    put(data, 0x7BBA44DF832B8D45u64)
    put(data, 0x7BF06B0BB1FB384Bu64)
    put(data, 0x7C2485CE9E7A065Eu64)
    put(data, 0x7C59A742461887F6u64)
    put(data, 0x7C9008896BCF54F9u64)
    put(data, 0x7CC40AABC6C32A38u64)
    put(data, 0x7CF90D56B873F4C6u64)
    put(data, 0x7D2F50AC6690F1F8u64)
    put(data, 0x7D63926BC01A973Bu64)
    put(data, 0x7D987706B0213D09u64)
    put(data, 0x7DCE94C85C298C4Cu64)
    put(data, 0x7E031CFD3999F7AFu64)
    put(data, 0x7E37E43C8800759Bu64)
    put(data, 0x7E6DDD4BAA009302u64)
    put(data, 0x7EA2AA4F4A405BE1u64)
    put(data, 0x7ED754E31CD072D9u64)
    put(data, 0x7F0D2A1BE4048F90u64)
    put(data, 0x7F423A516E82D9BAu64)
    put(data, 0x7F76C8E5CA239028u64)
    put(data, 0x7FAC7B1F3CAC7433u64)
    put(data, 0x7FE1CCF385EBC89Fu64)
    put(data, 0x7FEFFFFFFFFFFFFFu64)
    data
  end

  private POW10_OFFSET = [
    0, 2, 5, 8, 12, 16, 21, 26, 32, 39,
    46, 54, 62, 71, 80, 90, 100, 111, 122, 134,
    146, 159, 173, 187, 202, 217, 233, 249, 266, 283,
    301, 319, 338, 357, 377, 397, 418, 440, 462, 485,
    508, 532, 556, 581, 606, 632, 658, 685, 712, 740,
    769, 798, 828, 858, 889, 920, 952, 984, 1017, 1050,
    1084, 1118, 1153, 1188,
  ] of UInt16

  private POW10_SPLIT = begin
    data = Array({UInt64, UInt64, UInt64}).new(1224)
    put(data, 1u64, 72057594037927936u64, 0u64)
    put(data, 699646928636035157u64, 72057594u64, 0u64)
    put(data, 1u64, 0u64, 256u64)
    put(data, 11902091922964236229u64, 4722366482869u64, 0u64)
    put(data, 6760415703743915872u64, 4722u64, 0u64)
    put(data, 1u64, 0u64, 16777216u64)
    put(data, 13369850649504950658u64, 309485009821345068u64, 0u64)
    put(data, 15151142278969419334u64, 309485009u64, 0u64)
    put(data, 1u64, 0u64, 75511627776u64)
    put(data, 4635408826454083567u64, 9437866644873197963u64, 1099u64)
    put(data, 12367138975830625353u64, 20282409603651u64, 0u64)
    put(data, 7555853734021184432u64, 20282u64, 0u64)
    put(data, 1u64, 0u64, 250037927936u64)
    put(data, 5171444645924616995u64, 699646928636035156u64, 72057594u64)
    put(data, 16672297533003297786u64, 1329227995784915872u64, 0u64)
    put(data, 14479142226848862515u64, 1329227995u64, 0u64)
    put(data, 1u64, 0u64, 181645213696u64)
    put(data, 12214193123817091081u64, 11902091922964236228u64, 114366482869u64)
    put(data, 16592893013671929435u64, 6760415703743915871u64, 4722u64)
    put(data, 4549827147718617003u64, 87112285931760u64, 0u64)
    put(data, 5274510003815168971u64, 87112u64, 0u64)
    put(data, 1u64, 0u64, 44724781056u64)
    put(data, 9794971998307800535u64, 13369850649504950657u64, 209821345068u64)
    put(data, 14720142899209240169u64, 15151142278969419333u64, 309485009u64)
    put(data, 4300745446091561535u64, 5708990770823839524u64, 0u64)
    put(data, 15197156861335443364u64, 5708990770u64, 0u64)
    put(data, 1u64, 0u64, 139251286016u64)
    put(data, 13484604155038683037u64, 4635408826454083566u64, 67670423947u64)
    put(data, 8356963862052375699u64, 12367138975830625352u64, 58409603651u64)
    put(data, 5850852848337610021u64, 7555853734021184431u64, 20282u64)
    put(data, 2712780827214982050u64, 374144419156711u64, 0u64)
    put(data, 7732076577307618052u64, 374144u64, 0u64)
    put(data, 1u64, 0u64, 84280344576u64)
    put(data, 17296309485351745867u64, 5171444645924616994u64, 160903807060u64)
    put(data, 16598859101615853088u64, 16672297533003297785u64, 219784915872u64)
    put(data, 7469952526870444257u64, 14479142226848862514u64, 1329227995u64)
    put(data, 13531654022114669524u64, 6073184580144670117u64, 1u64)
    put(data, 15757609704383306943u64, 24519928653u64, 0u64)
    put(data, 9590990814237149590u64, 24u64, 0u64)
    put(data, 1u64, 0u64, 196662132736u64)
    put(data, 15408590707489433890u64, 12214193123817091080u64, 95899502532u64)
    put(data, 18332056844289122710u64, 16592893013671929434u64, 240246646623u64)
    put(data, 11114572877353986193u64, 4549827147718617002u64, 72285931760u64)
    put(data, 1703393793997526525u64, 5274510003815168970u64, 87112u64)
    put(data, 5082852056285196265u64, 1606938044258990u64, 0u64)
    put(data, 816434266573722365u64, 1606938u64, 0u64)
    put(data, 1u64, 0u64, 129530986496u64)
    put(data, 5736523019264798742u64, 9794971998307800534u64, 69797980545u64)
    put(data, 10129314776268243339u64, 14720142899209240168u64, 36233143877u64)
    put(data, 16511595775483995364u64, 4300745446091561534u64, 50823839524u64)
    put(data, 12367293405401453325u64, 15197156861335443363u64, 5708990770u64)
    put(data, 16934621733248854291u64, 13078571300009428617u64, 5u64)
    put(data, 10278280417769171336u64, 105312291668u64, 0u64)
    put(data, 5760764486226151240u64, 105u64, 0u64)
    put(data, 1u64, 0u64, 238731001856u64)
    put(data, 4128368337188369761u64, 13484604155038683036u64, 72453031918u64)
    put(data, 10240941003671005056u64, 8356963862052375698u64, 175317175368u64)
    put(data, 17933378316822368251u64, 5850852848337610020u64, 231147060143u64)
    put(data, 8346249813075698616u64, 2712780827214982049u64, 128419156711u64)
    put(data, 15906203609160902695u64, 7732076577307618051u64, 374144u64)
    put(data, 14525607416135386328u64, 6901746346790563u64, 0u64)
    put(data, 6397156777364256320u64, 6901746u64, 0u64)
    put(data, 1u64, 0u64, 34937634816u64)
    put(data, 16798760952716600048u64, 17296309485351745866u64, 249899825954u64)
    put(data, 2419982808370854967u64, 16598859101615853087u64, 50404946937u64)
    put(data, 2922947087773078956u64, 7469952526870444256u64, 165733552434u64)
    put(data, 15419220167069510190u64, 13531654022114669523u64, 77854221733u64)
    put(data, 3452124642157173416u64, 15757609704383306942u64, 24519928653u64)
    put(data, 5979700067267186899u64, 9590990814237149589u64, 24u64)
    put(data, 4913998146922579597u64, 452312848583u64, 0u64)
    put(data, 5771037749337678924u64, 452u64, 0u64)
    put(data, 1u64, 0u64, 8835301376u64)
    put(data, 3464734175350698519u64, 15408590707489433889u64, 90993782792u64)
    put(data, 9334527711335850125u64, 18332056844289122709u64, 170602522202u64)
    put(data, 7269882896518450106u64, 11114572877353986192u64, 202092341162u64)
    put(data, 1372511258182263196u64, 1703393793997526524u64, 174275541962u64)
    put(data, 7571228438575951046u64, 5082852056285196264u64, 26044258990u64)
    put(data, 2992506536646070406u64, 816434266573722364u64, 1606938u64)
    put(data, 524517896824344606u64, 29642774844752946u64, 0u64)
    put(data, 15582941400898702773u64, 29642774u64, 0u64)
    put(data, 1u64, 0u64, 214310977536u64)
    put(data, 3846112492507251066u64, 5736523019264798741u64, 104549111254u64)
    put(data, 16681117750123089487u64, 10129314776268243338u64, 62895095400u64)
    put(data, 14986314536556547267u64, 16511595775483995363u64, 163670432318u64)
    put(data, 2573712825027107389u64, 12367293405401453324u64, 137918027683u64)
    put(data, 7504855874008324928u64, 16934621733248854290u64, 84557186697u64)
    put(data, 9572138030626879787u64, 10278280417769171335u64, 105312291668u64)
    put(data, 8520676959353394843u64, 5760764486226151239u64, 105u64)
    put(data, 13448984662897903496u64, 1942668892225u64, 0u64)
    put(data, 12338883700918130648u64, 1942u64, 0u64)
    put(data, 1u64, 0u64, 156223799296u64)
    put(data, 2517285787892561600u64, 4128368337188369760u64, 146555162524u64)
    put(data, 4338831817635138103u64, 10240941003671005055u64, 36972170386u64)
    put(data, 1561495325934523196u64, 17933378316822368250u64, 161452451108u64)
    put(data, 12262635050079398786u64, 8346249813075698615u64, 3862277025u64)
    put(data, 11144065765517284188u64, 15906203609160902694u64, 163787434755u64)
    put(data, 1212260522471875711u64, 14525607416135386327u64, 242346790563u64)
    put(data, 9695352922247418869u64, 6397156777364256319u64, 6901746u64)
    put(data, 7227025834627242948u64, 127314748520905380u64, 0u64)
    put(data, 9609008238705447829u64, 127314748u64, 0u64)
    put(data, 1u64, 0u64, 74910662656u64)
    put(data, 3609144142396852269u64, 16798760952716600047u64, 31131187530u64)
    put(data, 11568848377382068865u64, 2419982808370854966u64, 224158453279u64)
    put(data, 10068303578029323957u64, 2922947087773078955u64, 211835877600u64)
    put(data, 11645070846862630231u64, 15419220167069510189u64, 190187140051u64)
    put(data, 12449386705878485055u64, 3452124642157173415u64, 149324160190u64)
    put(data, 15025619323517318418u64, 5979700067267186898u64, 199266388373u64)
    put(data, 14996237555047131272u64, 4913998146922579596u64, 196312848583u64)
    put(data, 10211005638256058413u64, 5771037749337678923u64, 452u64)
    put(data, 1014743503555840530u64, 8343699359066u64, 0u64)
    put(data, 12900897707145290678u64, 8343u64, 0u64)
    put(data, 1u64, 0u64, 33187823616u64)
    put(data, 4718003016239473662u64, 3464734175350698518u64, 149506025761u64)
    put(data, 14865830648693666725u64, 9334527711335850124u64, 144394101141u64)
    put(data, 14754517212823091778u64, 7269882896518450105u64, 252074403984u64)
    put(data, 11113946551474911901u64, 1372511258182263195u64, 232410437116u64)
    put(data, 1963520352638130630u64, 7571228438575951045u64, 252162224104u64)
    put(data, 13342587341404964200u64, 2992506536646070405u64, 50028434172u64)
    put(data, 6240392545013573291u64, 524517896824344605u64, 22844752946u64)
    put(data, 14377490861349714758u64, 15582941400898702772u64, 29642774u64)
    put(data, 1717863312631397839u64, 546812681195752981u64, 0u64)
    put(data, 3611005143890591770u64, 546812681u64, 0u64)
    put(data, 1u64, 0u64, 21208498176u64)
    put(data, 13168252824351245504u64, 3846112492507251065u64, 138904285205u64)
    put(data, 735883891883379688u64, 16681117750123089486u64, 227812409738u64)
    put(data, 10609203866866106404u64, 14986314536556547266u64, 12139521251u64)
    put(data, 12358191111890306470u64, 2573712825027107388u64, 18406839052u64)
    put(data, 15229916368406413528u64, 7504855874008324927u64, 135518906642u64)
    put(data, 7241424335568075942u64, 9572138030626879786u64, 71461906823u64)
    put(data, 6049715868779871913u64, 8520676959353394842u64, 65729070919u64)
    put(data, 2000548404719336762u64, 13448984662897903495u64, 150668892225u64)
    put(data, 1410974761895205301u64, 12338883700918130647u64, 1942u64)
    put(data, 16000132467694084868u64, 35835915874844u64, 0u64)
    put(data, 16894908866816792556u64, 35835u64, 0u64)
    put(data, 1u64, 0u64, 96136462336u64)
    put(data, 589096329272056762u64, 2517285787892561599u64, 127235208544u64)
    put(data, 7097729792403256904u64, 4338831817635138102u64, 250084648831u64)
    put(data, 8553736750439287020u64, 1561495325934523195u64, 183664758778u64)
    put(data, 2114152625261065696u64, 12262635050079398785u64, 38604121015u64)
    put(data, 9817523680007641224u64, 11144065765517284187u64, 215065716774u64)
    put(data, 13047215537500048015u64, 1212260522471875710u64, 63525586135u64)
    put(data, 16755544192002345880u64, 9695352922247418868u64, 164391777855u64)
    put(data, 6930119832670648356u64, 7227025834627242947u64, 60520905380u64)
    put(data, 14560698131901886167u64, 9609008238705447828u64, 127314748u64)
    put(data, 16408020927503338035u64, 2348542582773833227u64, 0u64)
    put(data, 14274703510609809116u64, 2348542582u64, 0u64)
    put(data, 1u64, 0u64, 239195652096u64)
    put(data, 16428432973129962470u64, 3609144142396852268u64, 54627148527u64)
    put(data, 3721112279790863774u64, 11568848377382068864u64, 171545803830u64)
    put(data, 18032764903259620753u64, 10068303578029323956u64, 45631280555u64)
    put(data, 18058455550468776079u64, 11645070846862630230u64, 167674882605u64)
    put(data, 15692090139033993190u64, 12449386705878485054u64, 210814540455u64)
    put(data, 389416944300619393u64, 15025619323517318417u64, 140812947666u64)
    put(data, 12009691357260487293u64, 14996237555047131271u64, 75553539724u64)
    put(data, 13494259174449809900u64, 10211005638256058412u64, 90055009355u64)
    put(data, 18288583400616279877u64, 1014743503555840529u64, 151699359066u64)
    put(data, 7216107869057472u64, 12900897707145290677u64, 8343u64)
    put(data, 17237061291959073878u64, 153914086704665u64, 0u64)
    put(data, 1599418782488783273u64, 153914u64, 0u64)
    put(data, 1u64, 0u64, 22255763456u64)
    put(data, 9565464987240335777u64, 4718003016239473661u64, 140805878294u64)
    put(data, 857713933775880687u64, 14865830648693666724u64, 185799843980u64)
    put(data, 4621617820081363356u64, 14754517212823091777u64, 155602488249u64)
    put(data, 9630162611715632528u64, 11113946551474911900u64, 197106442651u64)
    put(data, 9283986497984645815u64, 1963520352638130629u64, 133723303109u64)
    put(data, 8981807745082630996u64, 13342587341404964199u64, 29338292357u64)
    put(data, 18350140531565934622u64, 6240392545013573290u64, 180779405341u64)
    put(data, 4411619033127524143u64, 14377490861349714757u64, 21093125556u64)
    put(data, 1852297584111266889u64, 1717863312631397838u64, 9195752981u64)
    put(data, 11746243463811666096u64, 3611005143890591769u64, 546812681u64)
    put(data, 6335244004343789147u64, 10086913586276986678u64, 0u64)
    put(data, 5109502367228239844u64, 10086913586u64, 0u64)
    put(data, 1603272682579847821u64, 10u64, 0u64)
    put(data, 1u64, 0u64, 121713852416u64)
    put(data, 6609546910952910052u64, 13168252824351245503u64, 78039892345u64)
    put(data, 3911171343112928288u64, 735883891883379687u64, 194575126094u64)
    put(data, 5254510615100863555u64, 10609203866866106403u64, 60669938882u64)
    put(data, 3881927570803887650u64, 12358191111890306469u64, 63825615420u64)
    put(data, 6379348759607163190u64, 15229916368406413527u64, 42392558399u64)
    put(data, 14595733737222406466u64, 7241424335568075941u64, 154327955754u64)
    put(data, 14670223432002373542u64, 6049715868779871912u64, 135108449946u64)
    put(data, 4045087795619708513u64, 2000548404719336761u64, 215076489095u64)
    put(data, 12598467307137142718u64, 1410974761895205300u64, 28867368919u64)
    put(data, 734704388050777108u64, 16000132467694084867u64, 251915874844u64)
    put(data, 5682201693687285822u64, 16894908866816792555u64, 35835u64)
    put(data, 11048712694145438788u64, 661055968790248u64, 0u64)
    put(data, 17871025777010319485u64, 661055u64, 0u64)
    put(data, 1u64, 0u64, 191031934976u64)
    put(data, 15268761435931663695u64, 589096329272056761u64, 54384768703u64)
    put(data, 5016238054648555438u64, 7097729792403256903u64, 59463698998u64)
    put(data, 14236047313993899750u64, 8553736750439287019u64, 129114608443u64)
    put(data, 6957759675154690848u64, 2114152625261065695u64, 91532209025u64)
    put(data, 18439367135478514473u64, 9817523680007641223u64, 126707290971u64)
    put(data, 8539004472540641041u64, 13047215537500048014u64, 244908319870u64)
    put(data, 1908462039431738399u64, 16755544192002345879u64, 195375682548u64)
    put(data, 714690453250792146u64, 6930119832670648355u64, 148789337027u64)
    put(data, 13782189447673929633u64, 14560698131901886166u64, 11889480596u64)
    put(data, 3584742913798803164u64, 16408020927503338034u64, 118773833227u64)
    put(data, 4347581515245125291u64, 14274703510609809115u64, 2348542582u64)
    put(data, 16836742268156371392u64, 6429475823218628948u64, 2u64)
    put(data, 11764082328865615308u64, 43322963970u64, 0u64)
    put(data, 5957633711383291746u64, 43u64, 0u64)
    put(data, 1u64, 0u64, 44890587136u64)
    put(data, 9917186842884466953u64, 16428432973129962469u64, 128201721900u64)
    put(data, 4751011869809829335u64, 3721112279790863773u64, 180977558144u64)
    put(data, 11068497969931435029u64, 18032764903259620752u64, 86978950836u64)
    put(data, 17118056985122509954u64, 18058455550468776078u64, 62850669910u64)
    put(data, 14607066080907684459u64, 15692090139033993189u64, 17021110334u64)
    put(data, 11768892370493391107u64, 389416944300619392u64, 135651046673u64)
    put(data, 4043396447647747170u64, 12009691357260487292u64, 44731525255u64)
    put(data, 1670341095362518057u64, 13494259174449809899u64, 17991426092u64)
    put(data, 3190817644167043165u64, 18288583400616279876u64, 181000391185u64)
    put(data, 10425820027224322486u64, 7216107869057471u64, 25934422965u64)
    put(data, 13139964660506311565u64, 17237061291959073877u64, 58086704665u64)
    put(data, 2297772885416059937u64, 1599418782488783272u64, 153914u64)
    put(data, 7677687919964523763u64, 2839213766779714u64, 0u64)
    put(data, 14144589152747892828u64, 2839213u64, 0u64)
    put(data, 1u64, 0u64, 253518544896u64)
    put(data, 17069730341503660290u64, 9565464987240335776u64, 164046496765u64)
    put(data, 18167423787163077107u64, 857713933775880686u64, 65250538404u64)
    put(data, 3765746945827805904u64, 4621617820081363355u64, 156522052161u64)
    put(data, 10241734342430761691u64, 9630162611715632527u64, 197503285916u64)
    put(data, 13345717282537140784u64, 9283986497984645814u64, 103486904773u64)
    put(data, 9313926784816939953u64, 8981807745082630995u64, 170994763111u64)
    put(data, 550974205049535019u64, 18350140531565934621u64, 69239154346u64)
    put(data, 4494692285504086222u64, 4411619033127524142u64, 206100413253u64)
    put(data, 1134308559863725587u64, 1852297584111266888u64, 25636765134u64)
    put(data, 17587558045116130233u64, 11746243463811666095u64, 54343434265u64)
    put(data, 9817142032346161594u64, 6335244004343789146u64, 50276986678u64)
    put(data, 6071944935834172568u64, 5109502367228239843u64, 10086913586u64)
    put(data, 11564168293299416955u64, 1603272682579847820u64, 10u64)
    put(data, 12458266507226064437u64, 186070713419u64, 0u64)
    put(data, 1304432355328256915u64, 186u64, 0u64)
    put(data, 1u64, 0u64, 191358304256u64)
    put(data, 15946798815542087355u64, 6609546910952910051u64, 231212025023u64)
    put(data, 12082566083831286138u64, 3911171343112928287u64, 35284847591u64)
    put(data, 11449623684706196411u64, 5254510615100863554u64, 165210439715u64)
    put(data, 17518743620362604446u64, 3881927570803887649u64, 215345825189u64)
    put(data, 9451061563087633805u64, 6379348759607163189u64, 165791236311u64)
    put(data, 13191114787623314926u64, 14595733737222406465u64, 168795274405u64)
    put(data, 8367349876734474799u64, 14670223432002373541u64, 57219284648u64)
    put(data, 6544253801674393507u64, 4045087795619708512u64, 180682964281u64)
    put(data, 16113906253336597498u64, 12598467307137142717u64, 3039828404u64)
    put(data, 10294087136797312392u64, 734704388050777107u64, 235308032771u64)
    put(data, 9127173070014462803u64, 5682201693687285821u64, 232598951915u64)
    put(data, 16266900839595484952u64, 11048712694145438787u64, 63968790248u64)
    put(data, 3299745387370952632u64, 17871025777010319484u64, 661055u64)
    put(data, 12061115182604399189u64, 12194330274671844u64, 0u64)
    put(data, 5066801222582989646u64, 12194330u64, 0u64)
    put(data, 1u64, 0u64, 185827721216u64)
    put(data, 7568423425299591513u64, 15268761435931663694u64, 71271930809u64)
    put(data, 16561505984665207377u64, 5016238054648555437u64, 235771737671u64)
    put(data, 4329114621856906245u64, 14236047313993899749u64, 223377180907u64)
    put(data, 1477500474861899139u64, 6957759675154690847u64, 135999600095u64)
    put(data, 16891579639263969684u64, 18439367135478514472u64, 142462900359u64)
    put(data, 4684451357140027420u64, 8539004472540641040u64, 151103457934u64)
    put(data, 14727186580409080709u64, 1908462039431738398u64, 35038743447u64)
    put(data, 15864176859687308834u64, 714690453250792145u64, 214747133987u64)
    put(data, 1755486942842684438u64, 13782189447673929632u64, 50194329302u64)
    put(data, 17417077516652710041u64, 3584742913798803163u64, 219235682866u64)
    put(data, 4290982361913532783u64, 4347581515245125290u64, 84912721627u64)
    put(data, 11826659981004351409u64, 16836742268156371391u64, 2637732180u64)
    put(data, 932930645678090820u64, 11764082328865615307u64, 43322963970u64)
    put(data, 12707792781328052617u64, 5957633711383291745u64, 43u64)
    put(data, 16491596426880311906u64, 799167628880u64, 0u64)
    put(data, 3092207065214166010u64, 799u64, 0u64)
    put(data, 1u64, 0u64, 229537611776u64)
    put(data, 8142946531605512550u64, 9917186842884466952u64, 157257552869u64)
    put(data, 5328402096432654515u64, 4751011869809829334u64, 144600024477u64)
    put(data, 1932004361303814512u64, 11068497969931435028u64, 142927971728u64)
    put(data, 2511477647985517771u64, 17118056985122509953u64, 229791850638u64)
    put(data, 17451375493324716694u64, 14607066080907684458u64, 128637992933u64)
    put(data, 9489266854478998489u64, 11768892370493391106u64, 124219192960u64)
    put(data, 8803053132063235169u64, 4043396447647747169u64, 235090549372u64)
    put(data, 16198682197142616773u64, 1670341095362518056u64, 68172974571u64)
    put(data, 13696242485403414202u64, 3190817644167043164u64, 191565184836u64)
    put(data, 16409082426079859931u64, 10425820027224322485u64, 85712318911u64)
    put(data, 11653410736879597610u64, 13139964660506311564u64, 168124562517u64)
    put(data, 13589514120653213261u64, 2297772885416059936u64, 66416208296u64)
    put(data, 8032934885905905774u64, 7677687919964523762u64, 173766779714u64)
    put(data, 2753021350129449273u64, 14144589152747892827u64, 2839213u64)
    put(data, 16974897459201404133u64, 52374249726338269u64, 0u64)
    put(data, 13398576176159101589u64, 52374249u64, 0u64)
    put(data, 1u64, 0u64, 160925351936u64)
    put(data, 10284586955251725351u64, 17069730341503660289u64, 238984858016u64)
    put(data, 5294476488634150891u64, 18167423787163077106u64, 155204141550u64)
    put(data, 15833244538135063323u64, 3765746945827805903u64, 143555205531u64)
    put(data, 10348512742273116664u64, 10241734342430761690u64, 182723472783u64)
    put(data, 13658504610142595663u64, 13345717282537140783u64, 83504908982u64)
    put(data, 11956362239240850266u64, 9313926784816939952u64, 29029868371u64)
    put(data, 13415901703662731781u64, 550974205049535018u64, 46243657757u64)
    put(data, 5161774027546852762u64, 4494692285504086221u64, 72061490990u64)
    put(data, 15274384838790587711u64, 1134308559863725586u64, 175953423432u64)
    put(data, 14233354597679374929u64, 17587558045116130232u64, 90532188335u64)
    put(data, 4274656492162486921u64, 9817142032346161593u64, 227329160794u64)
    put(data, 12040276505541795046u64, 6071944935834172567u64, 140626894819u64)
    put(data, 13238307206256765457u64, 11564168293299416954u64, 75675363980u64)
    put(data, 12850161204172713271u64, 12458266507226064436u64, 186070713419u64)
    put(data, 17531777095001445154u64, 1304432355328256914u64, 186u64)
    put(data, 5623628114515245990u64, 3432398830065u64, 0u64)
    put(data, 7357116143579573377u64, 3432u64, 0u64)
    put(data, 1u64, 0u64, 227864477696u64)
    put(data, 3555734177475596582u64, 15946798815542087354u64, 31654997219u64)
    put(data, 14001876724756424382u64, 12082566083831286137u64, 66620685343u64)
    put(data, 18159905057231476140u64, 11449623684706196410u64, 33949692994u64)
    put(data, 5585207679308509467u64, 17518743620362604445u64, 53512343073u64)
    put(data, 13948697622866724672u64, 9451061563087633804u64, 65715091765u64)
    put(data, 9807691927739036432u64, 13191114787623314925u64, 165453594945u64)
    put(data, 15818010096140820918u64, 8367349876734474798u64, 96354764709u64)
    put(data, 5629845624785010943u64, 6544253801674393506u64, 189873536608u64)
    put(data, 9517635131137734707u64, 16113906253336597497u64, 19558043581u64)
    put(data, 619338244618780585u64, 10294087136797312391u64, 61494785043u64)
    put(data, 11632367007491958899u64, 9127173070014462802u64, 67881830461u64)
    put(data, 12083314261009739916u64, 16266900839595484951u64, 124178879555u64)
    put(data, 16880538609458881650u64, 3299745387370952631u64, 228653834364u64)
    put(data, 17404223674486504228u64, 12061115182604399188u64, 26274671844u64)
    put(data, 7089067015287185433u64, 5066801222582989645u64, 12194330u64)
    put(data, 2592264228029443648u64, 224945689727159819u64, 0u64)
    put(data, 13413731084370224440u64, 224945689u64, 0u64)
    put(data, 1u64, 0u64, 78410285056u64)
    put(data, 9323915941641553425u64, 7568423425299591512u64, 173897801038u64)
    put(data, 12155831029092699564u64, 16561505984665207376u64, 229234681773u64)
    put(data, 17397171276588232676u64, 4329114621856906244u64, 31080095461u64)
    put(data, 11874560617553253769u64, 1477500474861899138u64, 40915694367u64)
    put(data, 13444839516837727954u64, 16891579639263969683u64, 16253944616u64)
    put(data, 16994416043584590671u64, 4684451357140027419u64, 30798362384u64)
    put(data, 15879694502877015730u64, 14727186580409080708u64, 209859998750u64)
    put(data, 4234647645735263359u64, 15864176859687308833u64, 160095165137u64)
    put(data, 7978589901512919496u64, 1755486942842684437u64, 219944181664u64)
    put(data, 6114237175390859894u64, 17417077516652710040u64, 170232614619u64)
    put(data, 8658612872088282708u64, 4290982361913532782u64, 191641124522u64)
    put(data, 10253813330683324853u64, 11826659981004351408u64, 203050574271u64)
    put(data, 13289465061747830991u64, 932930645678090819u64, 97688890827u64)
    put(data, 4123165538545565412u64, 12707792781328052616u64, 80894011233u64)
    put(data, 7846417485927038481u64, 16491596426880311905u64, 31167628880u64)
    put(data, 10562273346358018864u64, 3092207065214166009u64, 799u64)
    put(data, 2691512658346619120u64, 14742040721959u64, 0u64)
    put(data, 751187558544605998u64, 14742u64, 0u64)
    put(data, 1u64, 0u64, 8441430016u64)
    put(data, 3757709791947931308u64, 8142946531605512549u64, 214288853256u64)
    put(data, 3452755398462519465u64, 5328402096432654514u64, 20104734166u64)
    put(data, 3105818720159874523u64, 1932004361303814511u64, 129136147476u64)
    put(data, 16859138458894499364u64, 2511477647985517770u64, 106946040961u64)
    put(data, 12271894740606233755u64, 17451375493324716693u64, 2514414186u64)
    put(data, 5429638071845793701u64, 9489266854478998488u64, 97477214466u64)
    put(data, 145278150038876889u64, 8803053132063235168u64, 40878132321u64)
    put(data, 9050266019724932450u64, 16198682197142616772u64, 92742474792u64)
    put(data, 11907016253451490866u64, 13696242485403414201u64, 181889538140u64)
    put(data, 2472757296513770735u64, 16409082426079859930u64, 140631732661u64)
    put(data, 10558733798178239360u64, 11653410736879597609u64, 32736689036u64)
    put(data, 15917322570831255850u64, 13589514120653213260u64, 242435466272u64)
    put(data, 12254334656791355238u64, 8032934885905905773u64, 91149241586u64)
    put(data, 7869542424662730262u64, 2753021350129449272u64, 221920211035u64)
    put(data, 1378558986933000253u64, 16974897459201404132u64, 233726338269u64)
    put(data, 13521405041909411105u64, 13398576176159101588u64, 52374249u64)
    put(data, 3206744593298092012u64, 966134380754314586u64, 0u64)
    put(data, 13914648122214918505u64, 966134380u64, 0u64)
    put(data, 1u64, 0u64, 1557528576u64)
    put(data, 1235541077112082496u64, 10284586955251725350u64, 242287014145u64)
    put(data, 12014985518315533846u64, 5294476488634150890u64, 207858321906u64)
    put(data, 1561535086344155741u64, 15833244538135063322u64, 218560993999u64)
    put(data, 12761747276316224577u64, 10348512742273116663u64, 47740429018u64)
    put(data, 9745594781103966137u64, 13658504610142595662u64, 176648155695u64)
    put(data, 17514238702394846785u64, 11956362239240850265u64, 42727277488u64)
    put(data, 2428898913707151713u64, 13415901703662731780u64, 205279820330u64)
    put(data, 71666709959904945u64, 5161774027546852761u64, 18828026061u64)
    put(data, 4049380135452919193u64, 15274384838790587710u64, 184771591698u64)
    put(data, 18422240861777453733u64, 14233354597679374928u64, 185231729592u64)
    put(data, 2914504416394425696u64, 4274656492162486920u64, 151652704697u64)
    put(data, 12721377795748989418u64, 12040276505541795045u64, 122717650071u64)
    put(data, 2626074459217717422u64, 13238307206256765456u64, 52696608634u64)
    put(data, 4261529925046307655u64, 12850161204172713270u64, 146950399540u64)
    put(data, 11536038685430305586u64, 17531777095001445153u64, 241304857490u64)
    put(data, 12555757789435162768u64, 5623628114515245989u64, 104398830065u64)
    put(data, 11905178684546080059u64, 7357116143579573376u64, 3432u64)
    put(data, 14032797718924543051u64, 63316582777114u64, 0u64)
    put(data, 10750340288005853484u64, 63316u64, 0u64)
    put(data, 1u64, 0u64, 186192756736u64)
    put(data, 9660290106216358253u64, 3555734177475596581u64, 121759043258u64)
    put(data, 14820142034615351103u64, 14001876724756424381u64, 186984450425u64)
    put(data, 12674041783707777619u64, 18159905057231476139u64, 157302774714u64)
    put(data, 15386686816442679994u64, 5585207679308509466u64, 140756160413u64)
    put(data, 5679510383719146248u64, 13948697622866724671u64, 237531676044u64)
    put(data, 1391101719248678506u64, 9807691927739036431u64, 46857496045u64)
    put(data, 3364596672173710517u64, 15818010096140820917u64, 162305194542u64)
    put(data, 11276509210104319732u64, 5629845624785010942u64, 249515952034u64)
    put(data, 5316312656902630164u64, 9517635131137734706u64, 135033574393u64)
    put(data, 17470981304473644647u64, 619338244618780584u64, 82630591879u64)
    put(data, 7373293636384920591u64, 11632367007491958898u64, 23655037778u64)
    put(data, 7616810902585191937u64, 12083314261009739915u64, 183915095831u64)
    put(data, 12740295655921903924u64, 16880538609458881649u64, 84943484855u64)
    put(data, 18366635945916526940u64, 17404223674486504227u64, 77384299092u64)
    put(data, 4472171448243407067u64, 7089067015287185432u64, 11140526925u64)
    put(data, 229592460858185629u64, 2592264228029443647u64, 25727159819u64)
    put(data, 12749672866417114996u64, 13413731084370224439u64, 224945689u64)
    put(data, 9452256722867098693u64, 4149515568880992958u64, 0u64)
    put(data, 16251451636418604634u64, 4149515568u64, 0u64)
    put(data, 1u64, 0u64, 88505450496u64)
    put(data, 4515791283442995454u64, 9323915941641553424u64, 80658968920u64)
    put(data, 13306155670047701346u64, 12155831029092699563u64, 4943102544u64)
    put(data, 4456930152933417601u64, 17397171276588232675u64, 130643721220u64)
    put(data, 9089157128546489637u64, 11874560617553253768u64, 147728846210u64)
    put(data, 12437332180345515840u64, 13444839516837727953u64, 27921269139u64)
    put(data, 3433060408790452524u64, 16994416043584590670u64, 132860839963u64)
    put(data, 8275594526021936172u64, 15879694502877015729u64, 33229560708u64)
    put(data, 3846512444641107689u64, 4234647645735263358u64, 21432520225u64)
    put(data, 6210962618469046250u64, 7978589901512919495u64, 152331453461u64)
    put(data, 7272858906616296575u64, 6114237175390859893u64, 110469384344u64)
    put(data, 3710743300451225347u64, 8658612872088282707u64, 176555860334u64)
    put(data, 6424677242672030600u64, 10253813330683324852u64, 67720423344u64)
    put(data, 11485842256170301862u64, 13289465061747830990u64, 136223517251u64)
    put(data, 7355797963557024308u64, 4123165538545565411u64, 97425355144u64)
    put(data, 6358188982569427273u64, 7846417485927038480u64, 249572581985u64)
    put(data, 12475094728768767402u64, 10562273346358018863u64, 39145907193u64)
    put(data, 17288154837907896183u64, 2691512658346619119u64, 150040721959u64)
    put(data, 2983850577727105262u64, 751187558544605997u64, 14742u64)
    put(data, 13918604635001185935u64, 271942652322184u64, 0u64)
    put(data, 12033220395769876327u64, 271942u64, 0u64)
    put(data, 1u64, 0u64, 101203705856u64)
    put(data, 5782377197813462997u64, 3757709791947931307u64, 178187174245u64)
    put(data, 17732139848231399226u64, 3452755398462519464u64, 111168366770u64)
    put(data, 3628839527415562921u64, 3105818720159874522u64, 202913935727u64)
    put(data, 3188692267613601004u64, 16859138458894499363u64, 149665260746u64)
    put(data, 5168130193478377352u64, 12271894740606233754u64, 216294341269u64)
    put(data, 12556227529405091290u64, 5429638071845793700u64, 96007875544u64)
    put(data, 15087090312791441192u64, 145278150038876888u64, 196490615904u64)
    put(data, 10281804758610642494u64, 9050266019724932449u64, 185645480644u64)
    put(data, 14238177586158586580u64, 11907016253451490865u64, 218134048441u64)
    put(data, 7107927498217678128u64, 2472757296513770734u64, 41572390106u64)
    put(data, 3845814658485364450u64, 10558733798178239359u64, 76862879785u64)
    put(data, 714293333681725946u64, 15917322570831255849u64, 109664308812u64)
    put(data, 16766172658649116982u64, 12254334656791355237u64, 56426608749u64)
    put(data, 812461421432632215u64, 7869542424662730261u64, 228074731832u64)
    put(data, 15218024718633799196u64, 1378558986933000252u64, 148732996836u64)
    put(data, 8110797782612805146u64, 13521405041909411104u64, 90173837972u64)
    put(data, 15941193964933529227u64, 3206744593298092011u64, 108754314586u64)
    put(data, 14144280602323277933u64, 13914648122214918504u64, 966134380u64)
    put(data, 15072402647813125245u64, 17822033662586700072u64, 0u64)
    put(data, 10822706091283369889u64, 17822033662u64, 0u64)
    put(data, 15163844593710966731u64, 17u64, 0u64)
    put(data, 1u64, 0u64, 38066978816u64)
    put(data, 2408529687792073670u64, 1235541077112082495u64, 234651333670u64)
    put(data, 3980682212356510808u64, 12014985518315533845u64, 26084650986u64)
    put(data, 4202670442792148519u64, 1561535086344155740u64, 247691815706u64)
    put(data, 9419583343154651922u64, 12761747276316224576u64, 78528309751u64)
    put(data, 16359166491570434575u64, 9745594781103966136u64, 89949448782u64)
    put(data, 12567727056384237385u64, 17514238702394846784u64, 4131670873u64)
    put(data, 2068388267923286639u64, 2428898913707151712u64, 153003885060u64)
    put(data, 5689135844565021196u64, 71666709959904944u64, 62219517337u64)
    put(data, 3104061965171139313u64, 4049380135452919192u64, 80998671678u64)
    put(data, 7955173880156328016u64, 18422240861777453732u64, 136157995600u64)
    put(data, 1445179403240833754u64, 2914504416394425695u64, 229689627272u64)
    put(data, 12538201164459126715u64, 12721377795748989417u64, 16142359781u64)
    put(data, 7580606719088482667u64, 2626074459217717421u64, 54231018000u64)
    put(data, 8168318283218819755u64, 4261529925046307654u64, 33625369910u64)
    put(data, 5249615277755961676u64, 11536038685430305585u64, 165680648993u64)
    put(data, 6312997372068219831u64, 12555757789435162767u64, 128645381029u64)
    put(data, 9183815417025176703u64, 11905178684546080058u64, 26760719488u64)
    put(data, 10683849953373876937u64, 14032797718924543050u64, 84582777114u64)
    put(data, 17175012155615667568u64, 10750340288005853483u64, 63316u64)
    put(data, 18003508288378896912u64, 1167984798111281u64, 0u64)
    put(data, 14722554560950996951u64, 1167984u64, 0u64)
    put(data, 1u64, 0u64, 37523685376u64)
    put(data, 15059324482416394930u64, 9660290106216358252u64, 189803401509u64)
    put(data, 4134778595813308312u64, 14820142034615351102u64, 171687061181u64)
    put(data, 16321118342639660948u64, 12674041783707777618u64, 26834113963u64)
    put(data, 1523550293123468805u64, 15386686816442679993u64, 63307886874u64)
    put(data, 8016371634569878509u64, 5679510383719146247u64, 15075411775u64)
    put(data, 9884220139611134110u64, 1391101719248678505u64, 181182395151u64)
    put(data, 7218073002727840414u64, 3364596672173710516u64, 254611300789u64)
    put(data, 16062235669481359233u64, 11276509210104319731u64, 50288197886u64)
    put(data, 15558048660560338002u64, 5316312656902630163u64, 168947103794u64)
    put(data, 8394398745765058609u64, 17470981304473644646u64, 114399707048u64)
    put(data, 5693296366442904274u64, 7373293636384920590u64, 139412908146u64)
    put(data, 11783494675061161358u64, 7616810902585191936u64, 113690652811u64)
    put(data, 13377293110865447894u64, 12740295655921903923u64, 35995657329u64)
    put(data, 12840734051093062130u64, 18366635945916526939u64, 24242436899u64)
    put(data, 7009868331566697505u64, 4472171448243407066u64, 63012446232u64)
    put(data, 5019690705031194477u64, 229592460858185628u64, 55691161151u64)
    put(data, 8608277240439804984u64, 12749672866417114995u64, 190512407863u64)
    put(data, 12172482590657749222u64, 9452256722867098692u64, 48880992958u64)
    put(data, 16613484892678771990u64, 16251451636418604633u64, 4149515568u64)
    put(data, 5721488662757049244u64, 2758075434182769113u64, 4u64)
    put(data, 386931106438877039u64, 76545051729u64, 0u64)
    put(data, 10054429752182825659u64, 76u64, 0u64)
    put(data, 1u64, 0u64, 16244801536u64)
    put(data, 8634592106137071313u64, 4515791283442995453u64, 171721328144u64)
    put(data, 12626356501369830731u64, 13306155670047701345u64, 227241610667u64)
    put(data, 4803333258178976933u64, 4456930152933417600u64, 136492724195u64)
    put(data, 13613083223558209297u64, 9089157128546489636u64, 209674229128u64)
    put(data, 16106967997237446989u64, 12437332180345515839u64, 78186106577u64)
    put(data, 14832921244380020170u64, 3433060408790452523u64, 177448620878u64)
    put(data, 13774024637717231397u64, 8275594526021936171u64, 126208519857u64)
    put(data, 9673012968505228885u64, 3846512444641107688u64, 199336696958u64)
    put(data, 5391832334264815667u64, 6210962618469046249u64, 117394262471u64)
    put(data, 16514436292632703088u64, 7272858906616296574u64, 83201159797u64)
    put(data, 12025036352783454153u64, 3710743300451225346u64, 180348282451u64)
    put(data, 7059867105311401050u64, 6424677242672030599u64, 206622648756u64)
    put(data, 12769210631552594670u64, 11485842256170301861u64, 227398758606u64)
    put(data, 8328873878884556145u64, 7355797963557024307u64, 16344678115u64)
    put(data, 1016565892414238685u64, 6358188982569427272u64, 47676276240u64)
    put(data, 9662978461927250281u64, 12475094728768767401u64, 239937192751u64)
    put(data, 13729967277551868112u64, 17288154837907896182u64, 45161754863u64)
    put(data, 6371593776693359475u64, 2983850577727105261u64, 136754529069u64)
    put(data, 17617208110845643245u64, 13918604635001185934u64, 70652322184u64)
    put(data, 14960960225633086797u64, 12033220395769876326u64, 271942u64)
    put(data, 12090634301321662558u64, 5016456510113118u64, 0u64)
    put(data, 9409926148478635503u64, 5016456u64, 0u64)
    put(data, 1u64, 0u64, 171313463296u64)
    put(data, 4307062684900157136u64, 5782377197813462996u64, 168961261227u64)
    put(data, 15300759383869911853u64, 17732139848231399225u64, 218196719784u64)
    put(data, 16007534237643445447u64, 3628839527415562920u64, 35172859354u64)
    put(data, 7138502295759677634u64, 3188692267613601003u64, 154280164899u64)
    put(data, 8218537071653683708u64, 5168130193478377351u64, 164680674458u64)
    put(data, 2254219416760329296u64, 12556227529405091289u64, 216817872804u64)
    put(data, 3057410459568460683u64, 15087090312791441191u64, 97557377752u64)
    put(data, 8217810929938874370u64, 10281804758610642493u64, 49771853153u64)
    put(data, 11741126472498340929u64, 14238177586158586579u64, 238385321521u64)
    put(data, 1175325363726654805u64, 7107927498217678127u64, 127208482030u64)
    put(data, 9428843070696730900u64, 3845814658485364449u64, 41038721919u64)
    put(data, 12662500978715131896u64, 714293333681725945u64, 101908896041u64)
    put(data, 6443045597035184564u64, 16766172658649116981u64, 21044043621u64)
    put(data, 1921385512639171183u64, 812461421432632214u64, 60824970773u64)
    put(data, 10469475094355551399u64, 15218024718633799195u64, 32439687228u64)
    put(data, 14679174489076953574u64, 8110797782612805145u64, 235864173856u64)
    put(data, 11853074234719825644u64, 15941193964933529226u64, 104766762987u64)
    put(data, 8270896886596139124u64, 14144280602323277932u64, 40817076584u64)
    put(data, 16532667046659118126u64, 15072402647813125244u64, 254586700072u64)
    put(data, 148341279888833483u64, 10822706091283369888u64, 17822033662u64)
    put(data, 10364629296397276041u64, 15163844593710966730u64, 17u64)
    put(data, 14265682585545771671u64, 328758493846u64, 0u64)
    put(data, 13991741872911347878u64, 328u64, 0u64)
    put(data, 1u64, 0u64, 63130566656u64)
    put(data, 14029045786848724433u64, 2408529687792073669u64, 21215793215u64)
    put(data, 4005878521026842341u64, 3980682212356510807u64, 92227827221u64)
    put(data, 3428326338640386488u64, 4202670442792148518u64, 64510636636u64)
    put(data, 1010001558294829380u64, 9419583343154651921u64, 184886832192u64)
    put(data, 2012063724327403418u64, 16359166491570434574u64, 64681297848u64)
    put(data, 10997154538851372612u64, 12567727056384237384u64, 96112127552u64)
    put(data, 1917749645489607898u64, 2068388267923286638u64, 176308408672u64)
    put(data, 9763872523711218805u64, 5689135844565021195u64, 152168271536u64)
    put(data, 15875699078454059311u64, 3104061965171139312u64, 164431250840u64)
    put(data, 10966529452671276106u64, 7955173880156328015u64, 95078343332u64)
    put(data, 18073244132105736913u64, 1445179403240833753u64, 233679697247u64)
    put(data, 4435241176994913173u64, 12538201164459126714u64, 173410945513u64)
    put(data, 5464400086219074323u64, 7580606719088482666u64, 70442805421u64)
    put(data, 2445909179323258812u64, 8168318283218819754u64, 49284582214u64)
    put(data, 873962058644121211u64, 5249615277755961675u64, 143342228273u64)
    put(data, 16675872194112650857u64, 6312997372068219830u64, 58497855631u64)
    put(data, 10680102689274800355u64, 9183815417025176702u64, 74579172666u64)
    put(data, 2370498083108897524u64, 10683849953373876936u64, 43931059274u64)
    put(data, 15354400521451334666u64, 17175012155615667567u64, 49975972139u64)
    put(data, 259991949657381021u64, 18003508288378896911u64, 112798111281u64)
    put(data, 10335286558772966917u64, 14722554560950996950u64, 1167984u64)
    put(data, 16337526653906757263u64, 21545516652742137u64, 0u64)
    put(data, 12040967163702784894u64, 21545516u64, 0u64)
    put(data, 1u64, 0u64, 108816367616u64)
    put(data, 3373309160242342187u64, 15059324482416394929u64, 62224146796u64)
    put(data, 13639841054510584221u64, 4134778595813308311u64, 82884769598u64)
    put(data, 15898855427739708031u64, 16321118342639660947u64, 185082591826u64)
    put(data, 4544387940067005419u64, 1523550293123468804u64, 7434568377u64)
    put(data, 5281598644835398575u64, 8016371634569878508u64, 105535824647u64)
    put(data, 13675642405083408835u64, 9884220139611134109u64, 180391292521u64)
    put(data, 3973392623768015721u64, 7218073002727840413u64, 243870735540u64)
    put(data, 4491285101509114191u64, 16062235669481359232u64, 19843403507u64)
    put(data, 15002304272810270500u64, 15558048660560338001u64, 102455061267u64)
    put(data, 17325098540619893468u64, 8394398745765058608u64, 14308634214u64)
    put(data, 1137212864974584822u64, 5693296366442904273u64, 638784526u64)
    put(data, 2619406097224859078u64, 11783494675061161357u64, 51725184512u64)
    put(data, 8281347529729293732u64, 13377293110865447893u64, 91696097587u64)
    put(data, 11344719666795450104u64, 12840734051093062129u64, 218380005723u64)
    put(data, 17283870506679425783u64, 7009868331566697504u64, 156272117978u64)
    put(data, 11054210518010603775u64, 5019690705031194476u64, 115466655644u64)
    put(data, 6399455551799092885u64, 8608277240439804983u64, 68659871603u64)
    put(data, 12930529916573967170u64, 12172482590657749221u64, 89900618820u64)
    put(data, 14550097052337552404u64, 16613484892678771989u64, 217310162521u64)
    put(data, 12487632712206414748u64, 5721488662757049243u64, 81020975577u64)
    put(data, 5791017277843595715u64, 386931106438877038u64, 76545051729u64)
    put(data, 10227264183449036113u64, 10054429752182825658u64, 76u64)
    put(data, 2006055278511721441u64, 1412006979354u64, 0u64)
    put(data, 128746359043876333u64, 1412u64, 0u64)
    put(data, 1u64, 0u64, 253468082176u64)
    put(data, 7408146306870995754u64, 8634592106137071312u64, 97684476157u64)
    put(data, 8299024588195267962u64, 12626356501369830730u64, 128260389217u64)
    put(data, 1497052939192040881u64, 4803333258178976932u64, 36737966720u64)
    put(data, 16771714264265803747u64, 13613083223558209296u64, 63873160484u64)
    put(data, 142988846654429432u64, 16106967997237446988u64, 43804094271u64)
    put(data, 11839838367716104145u64, 14832921244380020169u64, 43746691371u64)
    put(data, 6019646776647679765u64, 13774024637717231396u64, 232524375083u64)
    put(data, 4611972391702034948u64, 9673012968505228884u64, 233292291816u64)
    put(data, 16447182322205429545u64, 5391832334264815666u64, 126895249385u64)
    put(data, 2113477168726764245u64, 16514436292632703087u64, 2651878526u64)
    put(data, 3536261187802311516u64, 12025036352783454152u64, 135382716162u64)
    put(data, 18444381860986709854u64, 7059867105311401049u64, 165692220295u64)
    put(data, 4734315730275909838u64, 12769210631552594669u64, 51451509157u64)
    put(data, 9974936316849658174u64, 8328873878884556144u64, 72055108147u64)
    put(data, 11864423681540657642u64, 1016565892414238684u64, 169523831112u64)
    put(data, 8207245621417902667u64, 9662978461927250280u64, 118744303017u64)
    put(data, 7992526918695295028u64, 13729967277551868111u64, 237345404790u64)
    put(data, 8679354522130259987u64, 6371593776693359474u64, 142955030765u64)
    put(data, 6065763799692166461u64, 17617208110845643244u64, 102811035278u64)
    put(data, 18143341109049024976u64, 14960960225633086796u64, 94655434598u64)
    put(data, 15242492331283350570u64, 12090634301321662557u64, 136510113118u64)
    put(data, 9986352353182266963u64, 9409926148478635502u64, 5016456u64)
    put(data, 17340463289911536077u64, 92537289398950870u64, 0u64)
    put(data, 7359344614214233035u64, 92537289u64, 0u64)
    put(data, 1u64, 0u64, 212233486336u64)
    put(data, 419091135888749535u64, 4307062684900157135u64, 57829455828u64)
    put(data, 1073142712661309790u64, 15300759383869911852u64, 168867770169u64)
    put(data, 11076438902195672286u64, 16007534237643445446u64, 235386978984u64)
    put(data, 1820390940081322073u64, 7138502295759677633u64, 135445527787u64)
    put(data, 18417808973944523597u64, 8218537071653683707u64, 217122201479u64)
    put(data, 10251294197731582957u64, 2254219416760329295u64, 39165742553u64)
    put(data, 1502394029870156428u64, 3057410459568460682u64, 61445488423u64)
    put(data, 321014853559106075u64, 8217810929938874369u64, 211636487741u64)
    put(data, 2390953058510591778u64, 11741126472498340928u64, 47063714515u64)
    put(data, 10685224265907994087u64, 1175325363726654804u64, 225511138607u64)
    put(data, 5967405799190505023u64, 9428843070696730899u64, 249686435553u64)
    put(data, 11210723659228214761u64, 12662500978715131895u64, 53349278201u64)
    put(data, 12327123641078462773u64, 6443045597035184563u64, 150104158517u64)
    put(data, 1709976940107894237u64, 1921385512639171182u64, 27567551382u64)
    put(data, 16607686590938553511u64, 10469475094355551398u64, 25795759643u64)
    put(data, 18332088094272679457u64, 14679174489076953573u64, 138642556441u64)
    put(data, 2946170632136780882u64, 11853074234719825643u64, 108448366218u64)
    put(data, 4824449494694383419u64, 8270896886596139123u64, 124896237676u64)
    put(data, 17008332258693407134u64, 16532667046659118125u64, 160008041596u64)
    put(data, 1773419466622750661u64, 148341279888833482u64, 202561867680u64)
    put(data, 3892343466023784379u64, 10364629296397276040u64, 150773344202u64)
    put(data, 12001571085575422796u64, 14265682585545771670u64, 72758493846u64)
    put(data, 12933506765500977582u64, 13991741872911347877u64, 328u64)
    put(data, 11884830007749143734u64, 6064523798049u64, 0u64)
    put(data, 9662368568096205337u64, 6064u64, 0u64)
    put(data, 1u64, 0u64, 197760516096u64)
    put(data, 16801499925276664442u64, 14029045786848724432u64, 87217159109u64)
    put(data, 10492407990787637084u64, 4005878521026842340u64, 38185849943u64)
    put(data, 7673849751013230269u64, 3428326338640386487u64, 17054752294u64)
    put(data, 6046724489853072367u64, 1010001558294829379u64, 14109074193u64)
    put(data, 3723941391207507903u64, 2012063724327403417u64, 72596156942u64)
    put(data, 16844122108860347659u64, 10997154538851372611u64, 110103961416u64)
    put(data, 10622020182694668027u64, 1917749645489607897u64, 11529300590u64)
    put(data, 8741198820686854862u64, 9763872523711218804u64, 240860623371u64)
    put(data, 6855480461211306807u64, 15875699078454059310u64, 79594496752u64)
    put(data, 10005708458011566304u64, 10966529452671276105u64, 217979752527u64)
    put(data, 8932093106442919061u64, 18073244132105736912u64, 186240434905u64)
    put(data, 9062763476260756743u64, 4435241176994913172u64, 106296225722u64)
    put(data, 13664977682032775521u64, 5464400086219074322u64, 170132593002u64)
    put(data, 1078499125430623453u64, 2445909179323258811u64, 75047377578u64)
    put(data, 6554586738078431161u64, 873962058644121210u64, 182904000843u64)
    put(data, 12177313698643242883u64, 16675872194112650856u64, 126578969526u64)
    put(data, 16615072271904633953u64, 10680102689274800354u64, 200128504958u64)
    put(data, 16375404983106569285u64, 2370498083108897523u64, 111832363720u64)
    put(data, 13552251831473522729u64, 15354400521451334665u64, 15014094191u64)
    put(data, 8330500218412111874u64, 259991949657381020u64, 214560277007u64)
    put(data, 7044338079053294004u64, 10335286558772966916u64, 249885659094u64)
    put(data, 2688849443046530184u64, 16337526653906757262u64, 44652742137u64)
    put(data, 855940991879596845u64, 12040967163702784893u64, 21545516u64)
    put(data, 7344363609485825662u64, 397444631628981487u64, 0u64)
    put(data, 11602660525134634992u64, 397444631u64, 0u64)
    put(data, 1u64, 0u64, 177182867456u64)
    put(data, 16945343208344873835u64, 3373309160242342186u64, 151739417265u64)
    put(data, 9617992661337889145u64, 13639841054510584220u64, 147861878679u64)
    put(data, 18280344933262742088u64, 15898855427739708030u64, 4246351763u64)
    put(data, 5179975582362777795u64, 4544387940067005418u64, 236286316036u64)
    put(data, 1798918997870037130u64, 5281598644835398574u64, 157741358060u64)
    put(data, 6327667344756325883u64, 13675642405083408834u64, 157215398045u64)
    put(data, 18380327574124007701u64, 3973392623768015720u64, 128243473053u64)
    put(data, 18015447557304295289u64, 4491285101509114190u64, 81813276544u64)
    put(data, 10315590748073249878u64, 15002304272810270499u64, 48939195473u64)
    put(data, 7697916092577993382u64, 17325098540619893467u64, 209061648432u64)
    put(data, 3124132817942110723u64, 1137212864974584821u64, 141141998289u64)
    put(data, 7448238998520507049u64, 2619406097224859077u64, 213448932749u64)
    put(data, 13892823322374205297u64, 8281347529729293731u64, 241614998485u64)
    put(data, 11042137840046332564u64, 11344719666795450103u64, 32936960497u64)
    put(data, 10513966307445593804u64, 17283870506679425782u64, 108599249952u64)
    put(data, 9388437460943526958u64, 11054210518010603774u64, 55346915180u64)
    put(data, 10967228614677896228u64, 6399455551799092884u64, 229700965431u64)
    put(data, 2310996671540235542u64, 12930529916573967169u64, 21788762341u64)
    put(data, 4989110555003898587u64, 14550097052337552403u64, 155676955925u64)
    put(data, 16271452421983657679u64, 12487632712206414747u64, 110313931675u64)
    put(data, 9523160181437090473u64, 5791017277843595714u64, 186554421102u64)
    put(data, 13137707423765072250u64, 10227264183449036112u64, 26108748474u64)
    put(data, 16846859744221860705u64, 2006055278511721440u64, 132006979354u64)
    put(data, 7767140033449795569u64, 128746359043876332u64, 1412u64)
    put(data, 17169456915721160017u64, 26046931378436u64, 0u64)
    put(data, 17180899661833327819u64, 26046u64, 0u64)
    put(data, 1u64, 0u64, 208401596416u64)
    put(data, 17572520700934791416u64, 7408146306870995753u64, 74449891024u64)
    put(data, 17968798858233825417u64, 8299024588195267961u64, 164081155402u64)
    put(data, 15338423313945305609u64, 1497052939192040880u64, 16909196452u64)
    put(data, 17895321323836726301u64, 16771714264265803746u64, 76007751440u64)
    put(data, 814069333008965773u64, 142988846654429431u64, 201641838924u64)
    put(data, 7200328959852723947u64, 11839838367716104144u64, 36326325705u64)
    put(data, 759884557248133773u64, 6019646776647679764u64, 84250015524u64)
    put(data, 13410165861863974851u64, 4611972391702034947u64, 50891603540u64)
    put(data, 6278452420856351570u64, 16447182322205429544u64, 111114571826u64)
    put(data, 9072115382556676442u64, 2113477168726764244u64, 200191701103u64)
    put(data, 2755882551854926563u64, 3536261187802311515u64, 89999871944u64)
    put(data, 8496072611504649269u64, 18444381860986709853u64, 237256647769u64)
    put(data, 4122009033579215815u64, 4734315730275909837u64, 112540742381u64)
    put(data, 10222217724450527221u64, 9974936316849658173u64, 220643171696u64)
    put(data, 2064539481554006325u64, 11864423681540657641u64, 104444915676u64)
    put(data, 7935605886598063693u64, 8207245621417902666u64, 207433275752u64)
    put(data, 7805147585347548429u64, 7992526918695295027u64, 114470508751u64)
    put(data, 5709020905457661273u64, 8679354522130259986u64, 236328825714u64)
    put(data, 16257370307404906674u64, 6065763799692166460u64, 76983552492u64)
    put(data, 14971258192939373646u64, 18143341109049024975u64, 93826297164u64)
    put(data, 1133404845901376390u64, 15242492331283350569u64, 238541361245u64)
    put(data, 9460827548162822047u64, 9986352353182266962u64, 214940028398u64)
    put(data, 1273897659779791346u64, 17340463289911536076u64, 201398950870u64)
    put(data, 7833262224435092783u64, 7359344614214233034u64, 92537289u64)
    put(data, 3033420566713364587u64, 1707011694817242694u64, 0u64)
    put(data, 15075466825360349103u64, 1707011694u64, 0u64)
    put(data, 1u64, 0u64, 207022718976u64)
    put(data, 2484134775182816690u64, 419091135888749534u64, 44058175183u64)
    put(data, 18400539815335991277u64, 1073142712661309789u64, 198600454956u64)
    put(data, 485494064952118286u64, 11076438902195672285u64, 193098683590u64)
    put(data, 17577048805241314891u64, 1820390940081322072u64, 251998431425u64)
    put(data, 2863946907557583807u64, 18417808973944523596u64, 79555723771u64)
    put(data, 13045307417786230800u64, 10251294197731582956u64, 138081444943u64)
    put(data, 12032088871615097766u64, 1502394029870156427u64, 1017402250u64)
    put(data, 8848763446997690580u64, 321014853559106074u64, 64129613825u64)
    put(data, 10031289150307672684u64, 2390953058510591777u64, 84579247168u64)
    put(data, 11592215575498656563u64, 10685224265907994086u64, 19323493716u64)
    put(data, 15894436747956898388u64, 5967405799190505022u64, 247607734547u64)
    put(data, 2091546719588500923u64, 11210723659228214760u64, 179668254711u64)
    put(data, 5863809244813756109u64, 12327123641078462772u64, 110092698035u64)
    put(data, 11303008753675411245u64, 1709976940107894236u64, 166900304494u64)
    put(data, 13238426537506910532u64, 16607686590938553510u64, 229993784486u64)
    put(data, 17258458071023005565u64, 18332088094272679456u64, 235159712229u64)
    put(data, 8385733444777075179u64, 2946170632136780881u64, 115261533931u64)
    put(data, 9530757096163247300u64, 4824449494694383418u64, 45922023539u64)
    put(data, 14423000845391072217u64, 17008332258693407133u64, 202096137261u64)
    put(data, 10953140011159884311u64, 1773419466622750660u64, 136211004362u64)
    put(data, 12228340237948264127u64, 3892343466023784378u64, 150650606472u64)
    put(data, 11279134946966259189u64, 12001571085575422795u64, 165701126806u64)
    put(data, 14640097792684582651u64, 12933506765500977581u64, 33644277925u64)
    put(data, 6232313315128656728u64, 11884830007749143733u64, 176523798049u64)
    put(data, 16136121832933322088u64, 9662368568096205336u64, 6064u64)
    put(data, 15074767079673358271u64, 111870718431542u64, 0u64)
    put(data, 13252722804829281908u64, 111870u64, 0u64)
    put(data, 1u64, 0u64, 208910811136u64)
    put(data, 7740175894281560509u64, 16801499925276664441u64, 228568794576u64)
    put(data, 15670495392425593226u64, 10492407990787637083u64, 183416000228u64)
    put(data, 15152257626756992778u64, 7673849751013230268u64, 67327793591u64)
    put(data, 4090073428152440422u64, 6046724489853072366u64, 153201875267u64)
    put(data, 14450327772834205584u64, 3723941391207507902u64, 67913121689u64)
    put(data, 4466091895542494216u64, 16844122108860347658u64, 217575820867u64)
    put(data, 10454115378553795377u64, 10622020182694668026u64, 116473861337u64)
    put(data, 2267817233475657788u64, 8741198820686854861u64, 46371636340u64)
    put(data, 5500455702636497521u64, 6855480461211306806u64, 73542410542u64)
    put(data, 15178768299492252549u64, 10005708458011566303u64, 208484209737u64)
    put(data, 7062359872332045590u64, 8932093106442919060u64, 148491293392u64)
    put(data, 12297347290027942576u64, 9062763476260756742u64, 18740779924u64)
    put(data, 8030124596941085588u64, 13664977682032775520u64, 187058465554u64)
    put(data, 6526656990996654843u64, 1078499125430623452u64, 122355324859u64)
    put(data, 6254287345256979850u64, 6554586738078431160u64, 104660133498u64)
    put(data, 6642007136244870032u64, 12177313698643242882u64, 226900704872u64)
    put(data, 2027592955437164718u64, 16615072271904633952u64, 243887712482u64)
    put(data, 942718349157325567u64, 16375404983106569284u64, 9734669043u64)
    put(data, 14617066671884002278u64, 13552251831473522728u64, 156451597321u64)
    put(data, 6831631114396133348u64, 8330500218412111873u64, 4381874332u64)
    put(data, 14603040013386939258u64, 7044338079053294003u64, 142145762820u64)
    put(data, 9906106765319401103u64, 2688849443046530183u64, 125046400654u64)
    put(data, 1396179595609933063u64, 855940991879596844u64, 239398138749u64)
    put(data, 11524884268464976417u64, 7344363609485825661u64, 23628981487u64)
    put(data, 382929570730827274u64, 11602660525134634991u64, 397444631u64)
    put(data, 6109721884461301381u64, 7331559403129590068u64, 0u64)
    put(data, 2390514825000339691u64, 7331559403u64, 0u64)
    put(data, 6116191454763441755u64, 7u64, 0u64)
    put(data, 1u64, 0u64, 42918608896u64)
    put(data, 11598868771099176310u64, 16945343208344873834u64, 156521392426u64)
    put(data, 14449966445520085105u64, 9617992661337889144u64, 126990979484u64)
    put(data, 11675595287405614726u64, 18280344933262742087u64, 234280807038u64)
    put(data, 15860796398550489897u64, 5179975582362777794u64, 174097519594u64)
    put(data, 16180408435245829662u64, 1798918997870037129u64, 194343023534u64)
    put(data, 13756992797154950706u64, 6327667344756325882u64, 104996399554u64)
    put(data, 8830551328786758466u64, 18380327574124007700u64, 78976619368u64)
    put(data, 16699955256560951264u64, 18015447557304295288u64, 35559209294u64)
    put(data, 10038983627153402074u64, 10315590748073249877u64, 219417304867u64)
    put(data, 15085100736692127346u64, 7697916092577993381u64, 245169359579u64)
    put(data, 10007783780289711125u64, 3124132817942110722u64, 197403769845u64)
    put(data, 17596907048353602192u64, 7448238998520507048u64, 163753131461u64)
    put(data, 13530650344896573509u64, 13892823322374205296u64, 247598595491u64)
    put(data, 6337724853398437005u64, 11042137840046332563u64, 246569963255u64)
    put(data, 12768885008904063297u64, 10513966307445593803u64, 254508948214u64)
    put(data, 2759773619512884114u64, 9388437460943526957u64, 148594534654u64)
    put(data, 8434364600126655292u64, 10967228614677896227u64, 65125279380u64)
    put(data, 3843827521199949338u64, 2310996671540235541u64, 19270460225u64)
    put(data, 4661660852957808994u64, 4989110555003898586u64, 155882077203u64)
    put(data, 15298044134177324417u64, 16271452421983657678u64, 194516251547u64)
    put(data, 7747773274913338217u64, 9523160181437090472u64, 80712196546u64)
    put(data, 10348785912020632966u64, 13137707423765072249u64, 224913270096u64)
    put(data, 4175372293197190170u64, 16846859744221860704u64, 236421057504u64)
    put(data, 11326064156813083145u64, 7767140033449795568u64, 4930758124u64)
    put(data, 8100407170505981763u64, 17169456915721160016u64, 190931378436u64)
    put(data, 1706556116319916846u64, 17180899661833327818u64, 26046u64)
    put(data, 15028897280749641942u64, 480481077043500u64, 0u64)
    put(data, 1421201742071739121u64, 480481u64, 0u64)
    put(data, 1u64, 0u64, 41952608256u64)
    put(data, 8480737406125178272u64, 17572520700934791415u64, 121974090537u64)
    put(data, 10947205650755620361u64, 17968798858233825416u64, 176831497593u64)
    put(data, 868577942165647781u64, 15338423313945305608u64, 226970107312u64)
    put(data, 16017710019091388479u64, 17895321323836726300u64, 247044130786u64)
    put(data, 6610879150827623375u64, 814069333008965772u64, 208390330615u64)
    put(data, 12110095866223762092u64, 7200328959852723946u64, 20041193424u64)
    put(data, 7756802952949470775u64, 759884557248133772u64, 3726966548u64)
    put(data, 2941800790804618759u64, 13410165861863974850u64, 40340355587u64)
    put(data, 11703600274199927522u64, 6278452420856351569u64, 212491800360u64)
    put(data, 806737539257940346u64, 9072115382556676441u64, 91149396692u64)
    put(data, 14579028397110132023u64, 2755882551854926562u64, 93460573019u64)
    put(data, 14247808875344366934u64, 8496072611504649268u64, 205223454557u64)
    put(data, 9713379923695279513u64, 4122009033579215814u64, 61554147533u64)
    put(data, 2246428675703313877u64, 10222217724450527220u64, 233111918909u64)
    put(data, 3549783776592680620u64, 2064539481554006324u64, 74430190057u64)
    put(data, 12645029747929213033u64, 7935605886598063692u64, 51423117898u64)
    put(data, 16279009267476580506u64, 7805147585347548428u64, 18309486643u64)
    put(data, 343358782242907186u64, 5709020905457661272u64, 60881313810u64)
    put(data, 10077054739085890321u64, 16257370307404906673u64, 207811593532u64)
    put(data, 10526715404712173586u64, 14971258192939373645u64, 41061441999u64)
    put(data, 11438715865125144243u64, 1133404845901376389u64, 82512872489u64)
    put(data, 5040916178827294801u64, 9460827548162822046u64, 204069058130u64)
    put(data, 16643761637275849508u64, 1273897659779791345u64, 202424641996u64)
    put(data, 4852542977279030386u64, 7833262224435092782u64, 70164442058u64)
    put(data, 7883373066544387129u64, 3033420566713364586u64, 110817242694u64)
    put(data, 16699064314768500978u64, 15075466825360349102u64, 1707011694u64)
    put(data, 6805863634444817214u64, 13042063791413317777u64, 1u64)
    put(data, 2266540253968903500u64, 31488807865u64, 0u64)
    put(data, 9016913589137908810u64, 31u64, 0u64)
    put(data, 1u64, 0u64, 222134665216u64)
    put(data, 11654451024602552034u64, 2484134775182816689u64, 93997495262u64)
    put(data, 5299013208454526793u64, 18400539815335991276u64, 221026318685u64)
    put(data, 14918550373926182540u64, 485494064952118285u64, 88952853725u64)
    put(data, 6225552657491071054u64, 17577048805241314890u64, 76155254872u64)
    put(data, 10344713496596235785u64, 2863946907557583806u64, 236707187532u64)
    put(data, 12972405634433280209u64, 13045307417786230799u64, 139652260844u64)
    put(data, 12911885282402784945u64, 12032088871615097765u64, 26479692427u64)
    put(data, 6934311832970995868u64, 8848763446997690579u64, 33543797274u64)
    put(data, 9975729197003430461u64, 10031289150307672683u64, 230628415265u64)
    put(data, 1982857556803548935u64, 11592215575498656562u64, 62861639142u64)
    put(data, 2095735223386298223u64, 15894436747956898387u64, 232113382974u64)
    put(data, 7110931538347639365u64, 2091546719588500922u64, 52317877736u64)
    put(data, 15822183724630969535u64, 5863809244813756108u64, 220612737332u64)
    put(data, 16931982690156327501u64, 11303008753675411244u64, 166717656540u64)
    put(data, 6740069226761666110u64, 13238426537506910531u64, 32935582886u64)
    put(data, 3138792961008474902u64, 17258458071023005564u64, 81454591520u64)
    put(data, 12154594426971851390u64, 8385733444777075178u64, 58516663377u64)
    put(data, 15780127219221910902u64, 9530757096163247299u64, 157781872442u64)
    put(data, 16421541930960194381u64, 14423000845391072216u64, 196593770909u64)
    put(data, 7485894627196740576u64, 10953140011159884310u64, 186662899652u64)
    put(data, 8897269432694476707u64, 12228340237948264126u64, 75611443130u64)
    put(data, 17189823634941678805u64, 11279134946966259188u64, 173793641291u64)
    put(data, 9585582064286255216u64, 14640097792684582650u64, 181337854381u64)
    put(data, 12835472279575022097u64, 6232313315128656727u64, 24874740917u64)
    put(data, 6776016669542754608u64, 16136121832933322087u64, 54817204760u64)
    put(data, 18340015775620871027u64, 15074767079673358270u64, 254718431542u64)
    put(data, 5254188752292365830u64, 13252722804829281907u64, 111870u64)
    put(data, 6798802596750151183u64, 2063650512248692u64, 0u64)
    put(data, 9449320530215272000u64, 2063650u64, 0u64)
    put(data, 1u64, 0u64, 121419595776u64)
    put(data, 17110720482574968811u64, 7740175894281560508u64, 91849499257u64)
    put(data, 16172441693558688213u64, 15670495392425593225u64, 188821405531u64)
    put(data, 6234654946353717320u64, 15152257626756992777u64, 238221723324u64)
    put(data, 11180283100679445438u64, 4090073428152440421u64, 190783353838u64)
    put(data, 14852260031176961272u64, 14450327772834205583u64, 10242107326u64)
    put(data, 4481533167346438750u64, 4466091895542494215u64, 250566718730u64)
    put(data, 4269718344362365664u64, 10454115378553795376u64, 205122938618u64)
    put(data, 11520029752381101466u64, 2267817233475657787u64, 54298180301u64)
    put(data, 16778682550309368417u64, 5500455702636497520u64, 223822842678u64)
    put(data, 9687587467301363608u64, 15178768299492252548u64, 148382851295u64)
    put(data, 10093971076828497318u64, 7062359872332045589u64, 6666640532u64)
    put(data, 1913763026490934696u64, 12297347290027942575u64, 96435313926u64)
    put(data, 12701450127613557000u64, 8030124596941085587u64, 220353810784u64)
    put(data, 8974572160711134644u64, 6526656990996654842u64, 184339045596u64)
    put(data, 9890000077336694124u64, 6254287345256979849u64, 130360063928u64)
    put(data, 4292326716201059148u64, 6642007136244870031u64, 96109916034u64)
    put(data, 14644519175104337420u64, 2027592955437164717u64, 68051104864u64)
    put(data, 5051178622270136798u64, 942718349157325566u64, 40792392772u64)
    put(data, 675983118348065839u64, 14617066671884002277u64, 1370343464u64)
    put(data, 4431647660065117244u64, 6831631114396133347u64, 179791632385u64)
    put(data, 8316115180008411962u64, 14603040013386939257u64, 135537011123u64)
    put(data, 9621158095544965602u64, 9906106765319401102u64, 44075687047u64)
    put(data, 15283478958951102072u64, 1396179595609933062u64, 125624765228u64)
    put(data, 13981553073094447813u64, 11524884268464976416u64, 239020758653u64)
    put(data, 4558368743929911607u64, 382929570730827273u64, 52331208687u64)
    put(data, 15217004469858477791u64, 6109721884461301380u64, 235129590068u64)
    put(data, 11589190369996515737u64, 2390514825000339690u64, 7331559403u64)
    put(data, 3670624237398152929u64, 6116191454763441754u64, 7u64)
    put(data, 13471713758418039777u64, 135243399970u64, 0u64)
    put(data, 4489936967610296411u64, 135u64, 0u64)
    put(data, 1u64, 0u64, 106628775936u64)
    put(data, 9052049303222747950u64, 11598868771099176309u64, 120783334250u64)
    put(data, 1011330006193020538u64, 14449966445520085104u64, 71632935288u64)
    put(data, 17412075644359478612u64, 11675595287405614725u64, 194859815495u64)
    put(data, 6358678384745980468u64, 15860796398550489896u64, 137877141698u64)
    put(data, 15262353928842850919u64, 16180408435245829661u64, 250745768073u64)
    put(data, 11145257686438581736u64, 13756992797154950705u64, 20478705146u64)
    put(data, 1600562031807691890u64, 8830551328786758465u64, 120905306388u64)
    put(data, 6775147337046626724u64, 16699955256560951263u64, 85544214392u64)
    put(data, 15772127322106297822u64, 10038983627153402073u64, 165817764949u64)
    put(data, 4141472200527441474u64, 15085100736692127345u64, 2542523045u64)
    put(data, 18246007807879281267u64, 10007783780289711124u64, 168953930242u64)
    put(data, 960746958654787123u64, 17596907048353602191u64, 112733498024u64)
    put(data, 11355981212264408477u64, 13530650344896573508u64, 147343568752u64)
    put(data, 1573078209576251481u64, 6337724853398437004u64, 203692202643u64)
    put(data, 6245294478780491367u64, 12768885008904063296u64, 45149607627u64)
    put(data, 7523292955659721510u64, 2759773619512884113u64, 35457227821u64)
    put(data, 14454736751015226505u64, 8434364600126655291u64, 21208374307u64)
    put(data, 7219786377781411316u64, 3843827521199949337u64, 218252709141u64)
    put(data, 10597123082209392431u64, 4661660852957808993u64, 206829308634u64)
    put(data, 6922353544343010714u64, 15298044134177324416u64, 168420007630u64)
    put(data, 14317523356293377430u64, 7747773274913338216u64, 121561008808u64)
    put(data, 4057766168681892717u64, 10348785912020632965u64, 96226347385u64)
    put(data, 15214083611901244045u64, 4175372293197190169u64, 240613987168u64)
    put(data, 8390569016883950721u64, 11326064156813083144u64, 80439123952u64)
    put(data, 10680472538208175055u64, 8100407170505981762u64, 202092512592u64)
    put(data, 12173567833130544927u64, 1706556116319916845u64, 44814718154u64)
    put(data, 1386341248286610026u64, 15028897280749641941u64, 225077043500u64)
    put(data, 12487300952797237352u64, 1421201742071739120u64, 480481u64)
    put(data, 2614759871804869720u64, 8863311460481781u64, 0u64)
    put(data, 8494389567327729477u64, 8863311u64, 0u64)
    put(data, 1u64, 0u64, 247459741696u64)
    put(data, 6260469580539185878u64, 8480737406125178271u64, 136593449207u64)
    put(data, 17818573101084525841u64, 10947205650755620360u64, 8047085704u64)
    put(data, 2201029069927307150u64, 868577942165647780u64, 28868321800u64)
    put(data, 10397997613804897039u64, 16017710019091388478u64, 140358376476u64)
    put(data, 14269915965770103741u64, 6610879150827623374u64, 234656489612u64)
    put(data, 16776139909196366727u64, 12110095866223762091u64, 140420497130u64)
    put(data, 6246513436385199720u64, 7756802952949470774u64, 194159475340u64)
    put(data, 2926026498821554288u64, 2941800790804618758u64, 81634453442u64)
    put(data, 15725499391028340982u64, 11703600274199927521u64, 89043733329u64)
    put(data, 8576577277771450827u64, 806737539257940345u64, 226790330713u64)
    put(data, 15523351176022259335u64, 14579028397110132022u64, 52772375266u64)
    put(data, 4775158829429176134u64, 14247808875344366933u64, 198526563380u64)
    put(data, 10141817222123532462u64, 9713379923695279512u64, 244121779142u64)
    put(data, 12847658900242624586u64, 2246428675703313876u64, 52192434164u64)
    put(data, 13708197964460514655u64, 3549783776592680619u64, 76685488436u64)
    put(data, 1951540006613246932u64, 12645029747929213032u64, 12882486860u64)
    put(data, 9979297327280092199u64, 16279009267476580505u64, 88018613516u64)
    put(data, 15381307706282553684u64, 343358782242907185u64, 177546278232u64)
    put(data, 10037428657543061177u64, 10077054739085890320u64, 77570654385u64)
    put(data, 2584877324547208668u64, 10526715404712173585u64, 133620094029u64)
    put(data, 1126624732730703576u64, 11438715865125144242u64, 158273268613u64)
    put(data, 1501064139624981020u64, 5040916178827294800u64, 241902260126u64)
    put(data, 5219661484955306109u64, 16643761637275849507u64, 46263056881u64)
    put(data, 5336997298570282212u64, 4852542977279030385u64, 106427358510u64)
    put(data, 12191131175733833362u64, 7883373066544387128u64, 174905258090u64)
    put(data, 3707068178994436536u64, 16699064314768500977u64, 145368946606u64)
    put(data, 5045484691732942022u64, 6805863634444817213u64, 185122869393u64)
    put(data, 14847900542908711232u64, 2266540253968903499u64, 31488807865u64)
    put(data, 9097257915916965135u64, 9016913589137908809u64, 31u64)
    put(data, 2472027983230314217u64, 580865979874u64, 0u64)
    put(data, 15974509111133272205u64, 580u64, 0u64)
    put(data, 1u64, 0u64, 177631789056u64)
    put(data, 12099486841948187399u64, 11654451024602552033u64, 236287260081u64)
    put(data, 5319910566029976328u64, 5299013208454526792u64, 13808736236u64)
    put(data, 11549214421017285864u64, 14918550373926182539u64, 74337487885u64)
    put(data, 1998791413186046700u64, 6225552657491071053u64, 190560788042u64)
    put(data, 17075171930090011210u64, 10344713496596235784u64, 15703235518u64)
    put(data, 15158296003813501474u64, 12972405634433280208u64, 165699954703u64)
    put(data, 1360083178079384115u64, 12911885282402784944u64, 211375909797u64)
    put(data, 6167980558592741158u64, 6934311832970995867u64, 107540785363u64)
    put(data, 3630180428124865653u64, 9975729197003430460u64, 50107490923u64)
    put(data, 2276550099763657677u64, 1982857556803548934u64, 83113610034u64)
    put(data, 407006713016100655u64, 2095735223386298222u64, 186385484371u64)
    put(data, 14242579061653496002u64, 7110931538347639364u64, 204857722298u64)
    put(data, 17944493332678643704u64, 15822183724630969534u64, 44917884620u64)
    put(data, 987185901870869452u64, 16931982690156327500u64, 67365379884u64)
    put(data, 5578665155415167745u64, 6740069226761666109u64, 124170154307u64)
    put(data, 4849210377429577536u64, 3138792961008474901u64, 234658901884u64)
    put(data, 10811995403388891862u64, 12154594426971851389u64, 195855442410u64)
    put(data, 7051931074990177294u64, 15780127219221910901u64, 216890213571u64)
    put(data, 2030832259446664275u64, 16421541930960194380u64, 22405811160u64)
    put(data, 6069512651054767896u64, 7485894627196740575u64, 190482321942u64)
    put(data, 10608701253763958799u64, 8897269432694476706u64, 244931862206u64)
    put(data, 15700053443426906717u64, 17189823634941678804u64, 250519635444u64)
    put(data, 17759719234725541222u64, 9585582064286255215u64, 87695812346u64)
    put(data, 15187321568916405210u64, 12835472279575022096u64, 103367328599u64)
    put(data, 11040156458113129594u64, 6776016669542754607u64, 190994214247u64)
    put(data, 2800727824598008497u64, 18340015775620871026u64, 115284830142u64)
    put(data, 2997236166375604479u64, 5254188752292365829u64, 116368563827u64)
    put(data, 6260091886451512841u64, 6798802596750151182u64, 34512248692u64)
    put(data, 17573059315228347474u64, 9449320530215271999u64, 2063650u64)
    put(data, 7519453664590169251u64, 38067632857031246u64, 0u64)
    put(data, 15809436065653866529u64, 38067632u64, 0u64)
    put(data, 1u64, 0u64, 188927574016u64)
    put(data, 228921437623588922u64, 17110720482574968810u64, 137876709820u64)
    put(data, 2195862230003073884u64, 16172441693558688212u64, 9337981321u64)
    put(data, 960207412233973688u64, 6234654946353717319u64, 101606084361u64)
    put(data, 2464387149230492479u64, 11180283100679445437u64, 143805142629u64)
    put(data, 3631866936444955213u64, 14852260031176961271u64, 7242944399u64)
    put(data, 1578304441149380227u64, 4481533167346438749u64, 48231461895u64)
    put(data, 18190538519673445181u64, 4269718344362365663u64, 59624502064u64)
    put(data, 1271000736479934749u64, 11520029752381101465u64, 112909574203u64)
    put(data, 18292963032817745634u64, 16778682550309368416u64, 132525165168u64)
    put(data, 17168014021925537455u64, 9687587467301363607u64, 21547195268u64)
    put(data, 18046757712870378949u64, 10093971076828497317u64, 175103745301u64)
    put(data, 14857998893911743220u64, 1913763026490934695u64, 147688546991u64)
    put(data, 11933607369968684575u64, 12701450127613556999u64, 250486512531u64)
    put(data, 3483798509902859162u64, 8974572160711134643u64, 137536137978u64)
    put(data, 7378828438829845831u64, 9890000077336694123u64, 143232687497u64)
    put(data, 15791137430347699565u64, 4292326716201059147u64, 173793880975u64)
    put(data, 17044141236829932641u64, 14644519175104337419u64, 254273824941u64)
    put(data, 9075651910862456484u64, 5051178622270136797u64, 229036645118u64)
    put(data, 17811207355884564095u64, 675983118348065838u64, 227240240101u64)
    put(data, 4438638126207305937u64, 4431647660065117243u64, 121450817507u64)
    put(data, 12507972635512950185u64, 8316115180008411961u64, 142521564025u64)
    put(data, 14658269128098109408u64, 9621158095544965601u64, 6828519054u64)
    put(data, 3642436268910286111u64, 15283478958951102071u64, 32757941510u64)
    put(data, 3783099432964819561u64, 13981553073094447812u64, 9247109664u64)
    put(data, 9497579866027539638u64, 4558368743929911606u64, 132824915465u64)
    put(data, 3395179445046271361u64, 15217004469858477790u64, 234628251268u64)
    put(data, 5938502732309497276u64, 11589190369996515736u64, 90198984938u64)
    put(data, 5793671185917606255u64, 3670624237398152928u64, 34730303066u64)
    put(data, 889272970253526588u64, 13471713758418039776u64, 135243399970u64)
    put(data, 8594177504370135501u64, 4489936967610296410u64, 135u64)
    put(data, 7374354721120724712u64, 2494800386918u64, 0u64)
    put(data, 14764532643665507567u64, 2494u64, 0u64)
    put(data, 1u64, 0u64, 117490712576u64)
    put(data, 5392404173658087695u64, 9052049303222747949u64, 112054824309u64)
    put(data, 4976586473237854316u64, 1011330006193020537u64, 133943910512u64)
    put(data, 6308932742419013569u64, 17412075644359478611u64, 40344704645u64)
    put(data, 4831846642430703059u64, 6358678384745980467u64, 29827373864u64)
    put(data, 18139507855949846901u64, 15262353928842850918u64, 49604185629u64)
    put(data, 4865833876326628410u64, 11145257686438581735u64, 65086766641u64)
    put(data, 14296661839130179261u64, 1600562031807691889u64, 223367281473u64)
    put(data, 9254773150378118248u64, 6775147337046626723u64, 217855008735u64)
    put(data, 12174712433727875143u64, 15772127322106297821u64, 113224509657u64)
    put(data, 705653145340915199u64, 4141472200527441473u64, 20989118065u64)
    put(data, 17763928858962481812u64, 18246007807879281266u64, 143052082196u64)
    put(data, 3982836567612046296u64, 960746958654787122u64, 68615608975u64)
    put(data, 12730849277561967739u64, 11355981212264408476u64, 140085276740u64)
    put(data, 17314488764367235908u64, 1573078209576251480u64, 64338558092u64)
    put(data, 15951418930590301119u64, 6245294478780491366u64, 145407838528u64)
    put(data, 7193356087283467261u64, 7523292955659721509u64, 59783592849u64)
    put(data, 17592945625696089446u64, 14454736751015226504u64, 25391385403u64)
    put(data, 3554461664875361428u64, 7219786377781411315u64, 97574471193u64)
    put(data, 2213779057785318208u64, 10597123082209392430u64, 128375261537u64)
    put(data, 3880940796082421148u64, 6922353544343010713u64, 104776154496u64)
    put(data, 4528237545358141043u64, 14317523356293377429u64, 133219971944u64)
    put(data, 11681196539088147363u64, 4057766168681892716u64, 25824757125u64)
    put(data, 9835005502912643017u64, 15214083611901244044u64, 8454853657u64)
    put(data, 4964088126040986696u64, 8390569016883950720u64, 66578989576u64)
    put(data, 3355564873147047622u64, 10680472538208175054u64, 45659930434u64)
    put(data, 1853093467828272927u64, 12173567833130544926u64, 213075153709u64)
    put(data, 14755341584803008677u64, 1386341248286610025u64, 240676937941u64)
    put(data, 4701571132542556621u64, 12487300952797237351u64, 245141746416u64)
    put(data, 6128849686644853851u64, 2614759871804869719u64, 79460481781u64)
    put(data, 12026867901170202094u64, 8494389567327729476u64, 8863311u64)
    put(data, 17909760324981426303u64, 163499238157084246u64, 0u64)
    put(data, 2897692901883393664u64, 163499238u64, 0u64)
    put(data, 1u64, 0u64, 159339380736u64)
    put(data, 12323704802554838154u64, 6260469580539185877u64, 8965946783u64)
    put(data, 7135886931147821732u64, 17818573101084525840u64, 164119318024u64)
    put(data, 15341283120292884947u64, 2201029069927307149u64, 62563676580u64)
    put(data, 3092789040392634166u64, 10397997613804897038u64, 206773573694u64)
    put(data, 8811761390822097865u64, 14269915965770103740u64, 171909436366u64)
    put(data, 16870860798610218169u64, 16776139909196366726u64, 54338624171u64)
    put(data, 17452041453591904833u64, 6246513436385199719u64, 6158620214u64)
    put(data, 10314783684009874908u64, 2926026498821554287u64, 225852481030u64)
    put(data, 4932636630789274903u64, 15725499391028340981u64, 121464937185u64)
    put(data, 18143884346082124480u64, 8576577277771450826u64, 54841522553u64)
    put(data, 2823209155405527322u64, 15523351176022259334u64, 85258861878u64)
    put(data, 16195396106620226251u64, 4775158829429176133u64, 152549789013u64)
    put(data, 1150544491807648944u64, 10141817222123532461u64, 212696472984u64)
    put(data, 7767455475523884824u64, 12847658900242624585u64, 171743122900u64)
    put(data, 15204378045683991808u64, 13708197964460514654u64, 104105793195u64)
    put(data, 17239732561718805622u64, 1951540006613246931u64, 153540978792u64)
    put(data, 12886430624522800062u64, 9979297327280092198u64, 49833822361u64)
    put(data, 18162250541178258136u64, 15381307706282553683u64, 16544130097u64)
    put(data, 17028935366700158084u64, 10037428657543061176u64, 17140126480u64)
    put(data, 16075467823964198637u64, 2584877324547208667u64, 178061074449u64)
    put(data, 9803858825574498304u64, 1126624732730703575u64, 80081372850u64)
    put(data, 17464070808143041817u64, 1501064139624981019u64, 35282958416u64)
    put(data, 17682703471239266776u64, 5219661484955306108u64, 113289319203u64)
    put(data, 18147688354161351336u64, 5336997298570282211u64, 56660882545u64)
    put(data, 6663423873348080051u64, 12191131175733833361u64, 241200960568u64)
    put(data, 9417270363716235133u64, 3707068178994436535u64, 61273516273u64)
    put(data, 9295013721571344179u64, 5045484691732942021u64, 75804906301u64)
    put(data, 6199479138350037783u64, 14847900542908711231u64, 73493163339u64)
    put(data, 887603005365085688u64, 9097257915916965134u64, 226134008905u64)
    put(data, 333989628642975696u64, 2472027983230314216u64, 68865979874u64)
    put(data, 4620735991403939439u64, 15974509111133272204u64, 580u64)
    put(data, 12418523063962801201u64, 10715086071862u64, 0u64)
    put(data, 1587745622680169419u64, 10715u64, 0u64)
    put(data, 1u64, 0u64, 225655914496u64)
    put(data, 10968905082284365638u64, 12099486841948187398u64, 72288392929u64)
    put(data, 14076907092801977812u64, 5319910566029976327u64, 139626084168u64)
    put(data, 3438322122816124202u64, 11549214421017285863u64, 77108354699u64)
    put(data, 14645413324829073676u64, 1998791413186046699u64, 8925646925u64)
    put(data, 12271281439492289999u64, 17075171930090011209u64, 208821732872u64)
    put(data, 6233751789862708246u64, 15158296003813501473u64, 176073730256u64)
    put(data, 1962644459455827991u64, 1360083178079384114u64, 155334366896u64)
    put(data, 8726934184642952500u64, 6167980558592741157u64, 60196792475u64)
    put(data, 4531087719737475147u64, 3630180428124865652u64, 6123412028u64)
    put(data, 481513520412720775u64, 2276550099763657676u64, 110022063878u64)
    put(data, 992149349835802669u64, 407006713016100654u64, 68772091758u64)
    put(data, 11165474436676191361u64, 14242579061653496001u64, 190972772932u64)
    put(data, 10240785855143707184u64, 17944493332678643703u64, 76053515454u64)
    put(data, 10059329918238932466u64, 987185901870869451u64, 61302420044u64)
    put(data, 14791716450947031886u64, 5578665155415167744u64, 21262876221u64)
    put(data, 15378882314737417403u64, 4849210377429577535u64, 125586119445u64)
    put(data, 14726970229242271128u64, 10811995403388891861u64, 117382285949u64)
    put(data, 5090110549507128156u64, 7051931074990177293u64, 76110091637u64)
    put(data, 17185220781106503841u64, 2030832259446664274u64, 223329028940u64)
    put(data, 9858517691519529306u64, 6069512651054767895u64, 162575098847u64)
    put(data, 5595905546638020703u64, 10608701253763958798u64, 212851101602u64)
    put(data, 15555173226968030256u64, 15700053443426906716u64, 111962756308u64)
    put(data, 10745236628845355771u64, 17759719234725541221u64, 16823306351u64)
    put(data, 9973314042399760760u64, 15187321568916405209u64, 47598488080u64)
    put(data, 4374506813558796576u64, 11040156458113129593u64, 114151827759u64)
    put(data, 15960826480426749933u64, 2800727824598008496u64, 5162480498u64)
    put(data, 9636454862798615738u64, 2997236166375604478u64, 14339360261u64)
    put(data, 17973331528911319269u64, 6260091886451512840u64, 63952637454u64)
    put(data, 7366495200039369602u64, 17573059315228347473u64, 78407630399u64)
    put(data, 10505831326526933399u64, 7519453664590169250u64, 176857031246u64)
    put(data, 2803218632575724145u64, 15809436065653866528u64, 38067632u64)
    put(data, 8425731874431741636u64, 702223880805592151u64, 0u64)
    put(data, 14860552245711912111u64, 702223880u64, 0u64)
    put(data, 1u64, 0u64, 234012409856u64)
    put(data, 6993664200669526994u64, 228921437623588921u64, 212119037930u64)
    put(data, 4065363582031999356u64, 2195862230003073883u64, 71052052948u64)
    put(data, 6899780515342669867u64, 960207412233973687u64, 189133594695u64)
    put(data, 17713500890201844939u64, 2464387149230492478u64, 247196883901u64)
    put(data, 6445781125105107086u64, 3631866936444955212u64, 93085560055u64)
    put(data, 13563044070717478571u64, 1578304441149380226u64, 223986111069u64)
    put(data, 13167612994149348885u64, 18190538519673445180u64, 153068901087u64)
    put(data, 5505463469596727288u64, 1271000736479934748u64, 96991663513u64)
    put(data, 12125446212518819372u64, 18292963032817745633u64, 151930679904u64)
    put(data, 12537707724735421794u64, 17168014021925537454u64, 165978316695u64)
    put(data, 15173675086703777069u64, 18046757712870378948u64, 167805453733u64)
    put(data, 13535510174093048476u64, 14857998893911743219u64, 7646922151u64)
    put(data, 10698912997087096629u64, 11933607369968684574u64, 179188857095u64)
    put(data, 16952559548431933861u64, 3483798509902859161u64, 107400007091u64)
    put(data, 13528255827744249993u64, 7378828438829845830u64, 75856039275u64)
    put(data, 14122167436324771955u64, 15791137430347699564u64, 11923964747u64)
    put(data, 13071007137740038297u64, 17044141236829932640u64, 221491992075u64)
    put(data, 13011887609328904025u64, 9075651910862456483u64, 46965547485u64)
    put(data, 3116434332871336590u64, 17811207355884564094u64, 59240619054u64)
    put(data, 9050993820536772770u64, 4438638126207305936u64, 57678058555u64)
    put(data, 11993719123438634238u64, 12507972635512950184u64, 225794626361u64)
    put(data, 1414857165879849301u64, 14658269128098109407u64, 119197456865u64)
    put(data, 13819438220812375094u64, 3642436268910286110u64, 196205082231u64)
    put(data, 6073063033888264440u64, 3783099432964819560u64, 54514864836u64)
    put(data, 6828883869150720294u64, 9497579866027539637u64, 222184053046u64)
    put(data, 4548265621068768345u64, 3395179445046271360u64, 152321926878u64)
    put(data, 10422524923581371874u64, 5938502732309497275u64, 224314075544u64)
    put(data, 1858996082510682634u64, 5793671185917606254u64, 224048207584u64)
    put(data, 890276727450878316u64, 889272970253526587u64, 90465891296u64)
    put(data, 3886008133802710905u64, 8594177504370135500u64, 102399764570u64)
    put(data, 612074409233016757u64, 7374354721120724711u64, 190800386918u64)
    put(data, 3927020336901729264u64, 14764532643665507566u64, 2494u64)
    put(data, 5298603480094474942u64, 46020944252475u64, 0u64)
    put(data, 17418383752590430025u64, 46020u64, 0u64)
    put(data, 1u64, 0u64, 45292322816u64)
    put(data, 8973799690601597929u64, 5392404173658087694u64, 121269781293u64)
    put(data, 1343055462055792431u64, 4976586473237854315u64, 83342007929u64)
    put(data, 17425118728683169659u64, 6308932742419013568u64, 51261934931u64)
    put(data, 18389781726026675967u64, 4831846642430703058u64, 102983344691u64)
    put(data, 272526939565961561u64, 18139507855949846900u64, 231263777382u64)
    put(data, 11293026845930963228u64, 4865833876326628409u64, 113775023591u64)
    put(data, 13997416438903902597u64, 14296661839130179260u64, 163501702257u64)
    put(data, 6186605805999441184u64, 9254773150378118247u64, 221659992483u64)
    put(data, 4401776373281836138u64, 12174712433727875142u64, 65038253533u64)
    put(data, 16338917089754547008u64, 705653145340915198u64, 114962984513u64)
    put(data, 13337700757935003056u64, 17763928858962481811u64, 50215910002u64)
    put(data, 14612496890816348693u64, 3982836567612046295u64, 156690140722u64)
    put(data, 3219935399907691719u64, 12730849277561967738u64, 88938620316u64)
    put(data, 10887238730052330387u64, 17314488764367235907u64, 102864728152u64)
    put(data, 360256418697768294u64, 15951418930590301118u64, 37389952614u64)
    put(data, 321440824631118565u64, 7193356087283467260u64, 136953715493u64)
    put(data, 10069228080701402580u64, 17592945625696089445u64, 243192687752u64)
    put(data, 9428069607611622975u64, 3554461664875361427u64, 46120009203u64)
    put(data, 14736799017468812344u64, 2213779057785318207u64, 153210386222u64)
    put(data, 10875332567307979280u64, 3880940796082421147u64, 149245476249u64)
    put(data, 4611492910339012807u64, 4528237545358141042u64, 108633238933u64)
    put(data, 10743508637597314786u64, 11681196539088147362u64, 140533156716u64)
    put(data, 9356196315668016028u64, 9835005502912643016u64, 128269103756u64)
    put(data, 15755598617722189347u64, 4964088126040986695u64, 206181905536u64)
    put(data, 1275276394173375542u64, 3355564873147047621u64, 30100456398u64)
    put(data, 12644999363867216251u64, 1853093467828272926u64, 105799888670u64)
    put(data, 4553830511509832021u64, 14755341584803008676u64, 103254872681u64)
    put(data, 8869400642218174412u64, 4701571132542556620u64, 87332245607u64)
    put(data, 16570849151159054040u64, 6128849686644853850u64, 68651977815u64)
    put(data, 16127119334101797673u64, 12026867901170202093u64, 86970890052u64)
    put(data, 9686867250420930550u64, 17909760324981426302u64, 230157084246u64)
    put(data, 10678226869774428035u64, 2897692901883393663u64, 163499238u64)
    put(data, 7767227962910162068u64, 3016028602530220424u64, 0u64)
    put(data, 9780840471948993674u64, 3016028602u64, 0u64)
    put(data, 1u64, 0u64, 213668069376u64)
    put(data, 6288709332106746357u64, 12323704802554838153u64, 16386837205u64)
    put(data, 9066785620141948673u64, 7135886931147821731u64, 141831652624u64)
    put(data, 8442375916704414909u64, 15341283120292884946u64, 14167660429u64)
    put(data, 11604629218100425803u64, 3092789040392634165u64, 188477686542u64)
    put(data, 3877248044010875762u64, 8811761390822097864u64, 134914571196u64)
    put(data, 16435137704395217283u64, 16870860798610218168u64, 103946077062u64)
    put(data, 14994442577577813271u64, 17452041453591904832u64, 111559165543u64)
    put(data, 4410105917142436089u64, 10314783684009874907u64, 245267398767u64)
    put(data, 4632574728444936970u64, 4932636630789274902u64, 202983581941u64)
    put(data, 9117147535650050359u64, 18143884346082124479u64, 134153046474u64)
    put(data, 588939301256904809u64, 2823209155405527321u64, 69877954182u64)
    put(data, 324393982565305683u64, 16195396106620226250u64, 173062371141u64)
    put(data, 9380909186923521175u64, 1150544491807648943u64, 73421074605u64)
    put(data, 4463385697777230217u64, 7767455475523884823u64, 94824230985u64)
    put(data, 16378985502426333808u64, 15204378045683991807u64, 211934567774u64)
    put(data, 18210894922387834354u64, 17239732561718805621u64, 38698574803u64)
    put(data, 1555748035329493205u64, 12886430624522800061u64, 83984577574u64)
    put(data, 4277055533891898507u64, 18162250541178258135u64, 184923140435u64)
    put(data, 11574429772510874408u64, 17028935366700158083u64, 219871452856u64)
    put(data, 17391099253493808815u64, 16075467823964198636u64, 215531468251u64)
    put(data, 5791212393959129882u64, 9803858825574498303u64, 27946729175u64)
    put(data, 11254268231455680880u64, 17464070808143041816u64, 124958581275u64)
    put(data, 16355477587312235322u64, 17682703471239266775u64, 227983788156u64)
    put(data, 2411485149249320633u64, 18147688354161351335u64, 145361224931u64)
    put(data, 12763114642070638360u64, 6663423873348080050u64, 183510511249u64)
    put(data, 1147543073987366419u64, 9417270363716235132u64, 197503883703u64)
    put(data, 8410777835225272692u64, 9295013721571344178u64, 63336074437u64)
    put(data, 8134725822306818018u64, 6199479138350037782u64, 14048117055u64)
    put(data, 8899607004752328377u64, 887603005365085687u64, 232018105614u64)
    put(data, 690976506652396830u64, 333989628642975695u64, 140250490600u64)
    put(data, 12281570945595192074u64, 4620735991403939438u64, 54673209484u64)
    put(data, 12592957291365552899u64, 12418523063962801200u64, 219086071862u64)
    put(data, 13595807339013970272u64, 1587745622680169418u64, 10715u64)
    put(data, 9698096389749839992u64, 197658450495420u64, 0u64)
    put(data, 8310173728816391804u64, 197658u64, 0u64)
    data
  end

  private POW10_OFFSET_2 = [
    0, 2, 6, 12, 20, 29, 40, 52, 66, 80,
    95, 112, 130, 150, 170, 192, 215, 240, 265, 292,
    320, 350, 381, 413, 446, 480, 516, 552, 590, 629,
    670, 712, 755, 799, 845, 892, 940, 989, 1040, 1092,
    1145, 1199, 1254, 1311, 1369, 1428, 1488, 1550, 1613, 1678,
    1743, 1810, 1878, 1947, 2017, 2088, 2161, 2235, 2311, 2387,
    2465, 2544, 2625, 2706, 2789, 2873, 2959, 3046, 3133,
  ] of UInt16

  private MIN_BLOCK_2 = [
    0, 0, 0, 0, 0, 0, 1, 1, 2, 3,
    3, 4, 4, 5, 5, 6, 6, 7, 7, 8,
    8, 9, 9, 10, 11, 11, 12, 12, 13, 13,
    14, 14, 15, 15, 16, 16, 17, 17, 18, 19,
    19, 20, 20, 21, 21, 22, 22, 23, 23, 24,
    24, 25, 26, 26, 27, 27, 28, 28, 29, 29,
    30, 30, 31, 31, 32, 32, 33, 34, 0,
  ] of UInt8

  private POW10_SPLIT_2 = begin
    data = Array({UInt64, UInt64, UInt64}).new(3133)
    put(data, 0u64, 0u64, 3906250u64)
    put(data, 0u64, 0u64, 202000000000u64)
    put(data, 0u64, 11153727427136454656u64, 59u64)
    put(data, 0u64, 7205759403792793600u64, 59604644775u64)
    put(data, 0u64, 0u64, 167390625000u64)
    put(data, 0u64, 0u64, 232000000000u64)
    put(data, 0u64, 16777216000000000u64, 0u64)
    put(data, 0u64, 12945425605062557696u64, 909494u64)
    put(data, 0u64, 4388757836872548352u64, 182701772928u64)
    put(data, 0u64, 1152921504606846976u64, 128237915039u64)
    put(data, 0u64, 0u64, 159062500000u64)
    put(data, 0u64, 0u64, 160000000000u64)
    put(data, 0u64, 256000000000u64, 0u64)
    put(data, 0u64, 16192327041775828992u64, 13u64)
    put(data, 0u64, 15024075324038053888u64, 13877787807u64)
    put(data, 0u64, 5449091666327633920u64, 159814456755u64)
    put(data, 0u64, 2494994193563254784u64, 179295395851u64)
    put(data, 0u64, 4611686018427387904u64, 11135253906u64)
    put(data, 0u64, 0u64, 146250000000u64)
    put(data, 0u64, 0u64, 128000000000u64)
    put(data, 0u64, 3906250u64, 0u64)
    put(data, 0u64, 3906250000000000u64, 0u64)
    put(data, 0u64, 4368439412768899072u64, 211758u64)
    put(data, 0u64, 1563676642168012800u64, 46236813575u64)
    put(data, 0u64, 11532349341402398720u64, 7084767080u64)
    put(data, 0u64, 9048364970084925440u64, 104625169910u64)
    put(data, 0u64, 16609275425742389248u64, 246490512847u64)
    put(data, 0u64, 0u64, 207900390625u64)
    put(data, 0u64, 0u64, 225000000000u64)
    put(data, 11153727427136454656u64, 59u64, 0u64)
    put(data, 7205759403792793600u64, 59604644775u64, 0u64)
    put(data, 0u64, 4264412554261970152u64, 3u64)
    put(data, 0u64, 14485570586272534528u64, 3231174267u64)
    put(data, 0u64, 17827675094632103936u64, 123785264354u64)
    put(data, 0u64, 7347197909193981952u64, 226966440203u64)
    put(data, 0u64, 13677404030777688064u64, 11398292396u64)
    put(data, 0u64, 3810326759732150272u64, 172741453558u64)
    put(data, 0u64, 9943947977234055168u64, 246206558227u64)
    put(data, 0u64, 0u64, 19539062500u64)
    put(data, 0u64, 0u64, 228000000000u64)
    put(data, 12945425605062557696u64, 909494u64, 0u64)
    put(data, 4388757836872548352u64, 909494701772928u64, 0u64)
    put(data, 1152921504606846976u64, 14878706826214591391u64, 49303u64)
    put(data, 0u64, 4387341015746028192u64, 151806576313u64)
    put(data, 0u64, 651726680428265472u64, 185237838233u64)
    put(data, 0u64, 2570638187944738816u64, 153035330174u64)
    put(data, 0u64, 7419175577111756800u64, 126139354575u64)
    put(data, 0u64, 17299322326264840192u64, 207402194313u64)
    put(data, 0u64, 7990511638862102528u64, 137937798142u64)
    put(data, 0u64, 16717361816799281152u64, 254433166503u64)
    put(data, 0u64, 0u64, 167906250000u64)
    put(data, 0u64, 0u64, 16000000000u64)
    put(data, 16192327041775828992u64, 13u64, 0u64)
    put(data, 15024075324038053888u64, 13877787807u64, 0u64)
    put(data, 5449091666327633920u64, 13877787807814456755u64, 0u64)
    put(data, 2494994193563254784u64, 9707857417284919307u64, 752316384u64)
    put(data, 4611686018427387904u64, 1844515466944871826u64, 224526264005u64)
    put(data, 0u64, 15167599819856275072u64, 197099991383u64)
    put(data, 0u64, 14830185305589481472u64, 87822237233u64)
    put(data, 0u64, 6163721531743535104u64, 49803945956u64)
    put(data, 0u64, 14122847407012052992u64, 228334136013u64)
    put(data, 0u64, 335491783960035328u64, 205765601092u64)
    put(data, 0u64, 941252322120433664u64, 68018187046u64)
    put(data, 0u64, 11529215046068469760u64, 38051025390u64)
    put(data, 0u64, 0u64, 238625000000u64)
    put(data, 0u64, 0u64, 64000000000u64)
    put(data, 4368439412768899072u64, 211758u64, 0u64)
    put(data, 1563676642168012800u64, 211758236813575u64, 0u64)
    put(data, 11532349341402398720u64, 8061591463141767016u64, 11479u64)
    put(data, 9048364970084925440u64, 16628725344207857142u64, 215437019748u64)
    put(data, 16609275425742389248u64, 3555541870038531535u64, 100901445007u64)
    put(data, 0u64, 18316647450161853665u64, 143192746310u64)
    put(data, 0u64, 16709574568378075648u64, 70992947447u64)
    put(data, 0u64, 7696022835795591168u64, 247905827852u64)
    put(data, 0u64, 16664449640376041472u64, 12417202233u64)
    put(data, 0u64, 3109186955116544000u64, 57903381625u64)
    put(data, 0u64, 10515518101817131008u64, 121168549362u64)
    put(data, 0u64, 9961962375743537152u64, 242570047378u64)
    put(data, 0u64, 9223372036854775808u64, 146540039062u64)
    put(data, 0u64, 0u64, 150500000000u64)
    put(data, 14485570586272534528u64, 3231174267u64, 0u64)
    put(data, 17827675094632103936u64, 3231174267785264354u64, 0u64)
    put(data, 7347197909193981952u64, 748977172262750475u64, 175162308u64)
    put(data, 13677404030777688064u64, 15965033457315095468u64, 196040602133u64)
    put(data, 3810326759732150272u64, 16809402149066729206u64, 21865466197u64)
    put(data, 9943947977234055168u64, 7563769067065700371u64, 85911239516u64)
    put(data, 0u64, 13550322810840051428u64, 92410032742u64)
    put(data, 0u64, 8663209637545764864u64, 102734564471u64)
    put(data, 0u64, 8969247575312957440u64, 119469633535u64)
    put(data, 0u64, 6193172891660451840u64, 255486223885u64)
    put(data, 0u64, 3427954273864908800u64, 13335732575u64)
    put(data, 0u64, 10058367555266936832u64, 95185829773u64)
    put(data, 0u64, 13907115649320091648u64, 141545265197u64)
    put(data, 0u64, 0u64, 45753906250u64)
    put(data, 0u64, 0u64, 74000000000u64)
    put(data, 14878706826214591391u64, 49303u64, 0u64)
    put(data, 4387341015746028192u64, 49303806576313u64, 0u64)
    put(data, 651726680428265472u64, 14106411361315920281u64, 2672u64)
    put(data, 2570638187944738816u64, 3609034283485221502u64, 112764710092u64)
    put(data, 7419175577111756800u64, 9896072247338192335u64, 204195646140u64)
    put(data, 17299322326264840192u64, 8889095178479228297u64, 188536467151u64)
    put(data, 7990511638862102528u64, 3631796911038383102u64, 207481878815u64)
    put(data, 16717361816799281152u64, 898318840772166823u64, 31196880105u64)
    put(data, 0u64, 17293677953982795024u64, 233048697961u64)
    put(data, 0u64, 7353628266884669440u64, 105937492160u64)
    put(data, 0u64, 2404693032470315008u64, 192398640987u64)
    put(data, 0u64, 9191155893041889280u64, 91130358670u64)
    put(data, 0u64, 6353946855033798656u64, 142498253559u64)
    put(data, 0u64, 3767824038248841216u64, 247344448149u64)
    put(data, 0u64, 7205759403792793600u64, 149204254150u64)
    put(data, 0u64, 0u64, 198390625000u64)
    put(data, 0u64, 0u64, 232000000000u64)
    put(data, 9707857417284919307u64, 752316384u64, 0u64)
    put(data, 1844515466944871826u64, 752316384526264005u64, 0u64)
    put(data, 15167599819856275072u64, 17063068157692817751u64, 40783152u64)
    put(data, 14830185305589481472u64, 5385330256507239985u64, 48924990778u64)
    put(data, 6163721531743535104u64, 3373050282752075748u64, 58291939338u64)
    put(data, 14122847407012052992u64, 4116064001262906061u64, 10182853422u64)
    put(data, 335491783960035328u64, 11306582046748043076u64, 46223132276u64)
    put(data, 941252322120433664u64, 17035410946089626406u64, 116612931040u64)
    put(data, 11529215046068469760u64, 15618595715183448558u64, 224923491477u64)
    put(data, 0u64, 5141740092277295680u64, 149846685770u64)
    put(data, 0u64, 16973644291514990592u64, 74278734288u64)
    put(data, 0u64, 14625255268443750400u64, 208920143100u64)
    put(data, 0u64, 14021170507320131584u64, 252792836676u64)
    put(data, 0u64, 4451355232865091584u64, 68760089176u64)
    put(data, 0u64, 12891553933348044800u64, 88241308450u64)
    put(data, 0u64, 1152921504606846976u64, 34698852539u64)
    put(data, 0u64, 0u64, 187062500000u64)
    put(data, 0u64, 0u64, 160000000000u64)
    put(data, 8061591463141767016u64, 11479u64, 0u64)
    put(data, 16628725344207857142u64, 11479437019748u64, 0u64)
    put(data, 3555541870038531535u64, 5562205901560339855u64, 622u64)
    put(data, 18316647450161853665u64, 2106077949367544134u64, 110301527786u64)
    put(data, 16709574568378075648u64, 7496855998374373623u64, 234114170714u64)
    put(data, 7696022835795591168u64, 229183437194837004u64, 90406405378u64)
    put(data, 16664449640376041472u64, 465169186276472889u64, 2012424059u64)
    put(data, 3109186955116544000u64, 2152980561625316473u64, 123025216872u64)
    put(data, 10515518101817131008u64, 2059790725449340402u64, 104116713310u64)
    put(data, 9961962375743537152u64, 17891190926410198930u64, 94111661478u64)
    put(data, 9223372036854775808u64, 9930696175609809814u64, 166969883403u64)
    put(data, 0u64, 7276914261609005312u64, 11538344118u64)
    put(data, 0u64, 10539762974036983808u64, 182394482312u64)
    put(data, 0u64, 12851089458992250880u64, 136571361695u64)
    put(data, 0u64, 9449311677678878720u64, 159696658955u64)
    put(data, 0u64, 8699564697382289408u64, 11512248212u64)
    put(data, 0u64, 4224376450473525248u64, 148471604347u64)
    put(data, 0u64, 4611686018427387904u64, 123229003906u64)
    put(data, 0u64, 0u64, 130250000000u64)
    put(data, 0u64, 0u64, 128000000000u64)
    put(data, 748977172262750475u64, 175162308u64, 0u64)
    put(data, 15965033457315095468u64, 175162308040602133u64, 0u64)
    put(data, 16809402149066729206u64, 13756840147955779925u64, 9495567u64)
    put(data, 7563769067065700371u64, 13788447602092505948u64, 15745759798u64)
    put(data, 13550322810840051428u64, 4972540435632173670u64, 54747473242u64)
    put(data, 8663209637545764864u64, 2844874687533091959u64, 90269561957u64)
    put(data, 8969247575312957440u64, 15377573779532804095u64, 101154220965u64)
    put(data, 6193172891660451840u64, 17824715805091194381u64, 165833619944u64)
    put(data, 3427954273864908800u64, 18277569135638159711u64, 232966279779u64)
    put(data, 10058367555266936832u64, 4254645803379752845u64, 99990829008u64)
    put(data, 13907115649320091648u64, 2933643244178200621u64, 208230644811u64)
    put(data, 0u64, 17188148801879487562u64, 75159033118u64)
    put(data, 0u64, 11069762501163246592u64, 30931771413u64)
    put(data, 0u64, 11676570643941818368u64, 21600093027u64)
    put(data, 0u64, 17840016768744030208u64, 99632988162u64)
    put(data, 0u64, 16463817321652158464u64, 2967109246u64)
    put(data, 0u64, 6954191143357644800u64, 126892505325u64)
    put(data, 0u64, 5080060379673919488u64, 237376987457u64)
    put(data, 0u64, 0u64, 65275390625u64)
    put(data, 0u64, 0u64, 161000000000u64)
    put(data, 14106411361315920281u64, 2672u64, 0u64)
    put(data, 3609034283485221502u64, 2672764710092u64, 0u64)
    put(data, 9896072247338192335u64, 16433563478020213436u64, 144u64)
    put(data, 8889095178479228297u64, 4194750497955655375u64, 144890865261u64)
    put(data, 3631796911038383102u64, 2691539602252904735u64, 109227397880u64)
    put(data, 898318840772166823u64, 3775467271962795241u64, 248145908654u64)
    put(data, 17293677953982795024u64, 16980212613224918121u64, 174204668490u64)
    put(data, 7353628266884669440u64, 4172857038337333440u64, 74920499170u64)
    put(data, 2404693032470315008u64, 5936867627376461659u64, 226226211033u64)
    put(data, 9191155893041889280u64, 17856837443266866062u64, 217321838238u64)
    put(data, 6353946855033798656u64, 8956297047799810807u64, 158968021097u64)
    put(data, 3767824038248841216u64, 15356974049716912789u64, 105485521835u64)
    put(data, 7205759403792793600u64, 6923608913322982854u64, 171832503231u64)
    put(data, 0u64, 4855902993563955944u64, 191375329591u64)
    put(data, 0u64, 13835893222288330752u64, 55263239028u64)
    put(data, 0u64, 9114973913760137216u64, 116750045274u64)
    put(data, 0u64, 17937099003422310400u64, 90494123725u64)
    put(data, 0u64, 7007960010734960640u64, 205972372085u64)
    put(data, 0u64, 7683422439270776832u64, 117379902273u64)
    put(data, 0u64, 720575940379279360u64, 65416519165u64)
    put(data, 0u64, 0u64, 253039062500u64)
    put(data, 0u64, 0u64, 228000000000u64)
    put(data, 17063068157692817751u64, 40783152u64, 0u64)
    put(data, 5385330256507239985u64, 40783152924990778u64, 0u64)
    put(data, 3373050282752075748u64, 2768933352715741194u64, 2210859u64)
    put(data, 4116064001262906061u64, 15201941611824153390u64, 43150104177u64)
    put(data, 11306582046748043076u64, 1418128541727000180u64, 113824098906u64)
    put(data, 17035410946089626406u64, 5353350204565757408u64, 90076876902u64)
    put(data, 15618595715183448558u64, 1721001680354286741u64, 102290205696u64)
    put(data, 5141740092277295680u64, 637631411660453962u64, 93295688u64)
    put(data, 16973644291514990592u64, 1630012588870568400u64, 72034566068u64)
    put(data, 14625255268443750400u64, 9253063571656828156u64, 180088363159u64)
    put(data, 14021170507320131584u64, 6029146854993203780u64, 151501609581u64)
    put(data, 4451355232865091584u64, 16987401965352759896u64, 109326840705u64)
    put(data, 12891553933348044800u64, 14499131620542087970u64, 129920888905u64)
    put(data, 1152921504606846976u64, 1978417255298660539u64, 73785999500u64)
    put(data, 0u64, 5790079354402454176u64, 140107250214u64)
    put(data, 0u64, 13748918935842078720u64, 38313880830u64)
    put(data, 0u64, 18047438014740692992u64, 254745330388u64)
    put(data, 0u64, 3116889656839372800u64, 212978353575u64)
    put(data, 0u64, 15995952446606147584u64, 167168966926u64)
    put(data, 0u64, 12530140063251562496u64, 14867142319u64)
    put(data, 0u64, 16717361816799281152u64, 175679260253u64)
    put(data, 0u64, 0u64, 93906250000u64)
    put(data, 0u64, 0u64, 16000000000u64)
    put(data, 5562205901560339855u64, 622u64, 0u64)
    put(data, 2106077949367544134u64, 622301527786u64, 0u64)
    put(data, 7496855998374373623u64, 13558973353698967386u64, 33u64)
    put(data, 229183437194837004u64, 6228991722850501890u64, 33735033418u64)
    put(data, 465169186276472889u64, 16886831391703377787u64, 74337674317u64)
    put(data, 2152980561625316473u64, 1181713637872883048u64, 77915436964u64)
    put(data, 2059790725449340402u64, 12393932434925221726u64, 164064060824u64)
    put(data, 17891190926410198930u64, 10684799845419711910u64, 152671876423u64)
    put(data, 9930696175609809814u64, 4590318792215640843u64, 71579224160u64)
    put(data, 7276914261609005312u64, 6383712187366189238u64, 96248841680u64)
    put(data, 10539762974036983808u64, 1904270214927675016u64, 208346061731u64)
    put(data, 12851089458992250880u64, 3711506775113308575u64, 163103230695u64)
    put(data, 9449311677678878720u64, 8091219444738793995u64, 231201201185u64)
    put(data, 8699564697382289408u64, 39436684991068052u64, 33438625885u64)
    put(data, 4224376450473525248u64, 18025182908196512891u64, 93002137866u64)
    put(data, 4611686018427387904u64, 7853924592034603138u64, 10977147123u64)
    put(data, 0u64, 4815749283615688320u64, 243425762105u64)
    put(data, 0u64, 14242399906544287744u64, 57261062291u64)
    put(data, 0u64, 76242322576113664u64, 147772082046u64)
    put(data, 0u64, 10858088421377703936u64, 126004133104u64)
    put(data, 0u64, 14293835879041466368u64, 240588618152u64)
    put(data, 0u64, 12182236992037191680u64, 168774870395u64)
    put(data, 0u64, 11529215046068469760u64, 123660400390u64)
    put(data, 0u64, 0u64, 6625000000u64)
    put(data, 0u64, 0u64, 64000000000u64)
    put(data, 13756840147955779925u64, 9495567u64, 0u64)
    put(data, 13788447602092505948u64, 9495567745759798u64, 0u64)
    put(data, 4972540435632173670u64, 14000097438505379162u64, 514755u64)
    put(data, 2844874687533091959u64, 16451062686452429925u64, 195758946802u64)
    put(data, 15377573779532804095u64, 4009347599785716645u64, 242891813895u64)
    put(data, 17824715805091194381u64, 16544162347546196456u64, 7217347168u64)
    put(data, 18277569135638159711u64, 17674258299745817187u64, 96896860837u64)
    put(data, 4254645803379752845u64, 5215238411201214416u64, 165958123462u64)
    put(data, 2933643244178200621u64, 14253990228345322571u64, 198282718640u64)
    put(data, 17188148801879487562u64, 11214836553940194590u64, 176772710358u64)
    put(data, 11069762501163246592u64, 14620711348380590101u64, 214607957507u64)
    put(data, 11676570643941818368u64, 6638710787931587427u64, 3792590350u64)
    put(data, 17840016768744030208u64, 17320000343692853250u64, 14359885232u64)
    put(data, 16463817321652158464u64, 75147386268843646u64, 176938919100u64)
    put(data, 6954191143357644800u64, 17938801582125480173u64, 188004073747u64)
    put(data, 5080060379673919488u64, 6573358613626446145u64, 19972464382u64)
    put(data, 0u64, 8688505427903736481u64, 254356342484u64)
    put(data, 0u64, 539870168696556032u64, 212471004823u64)
    put(data, 0u64, 9002861336394465280u64, 151029266420u64)
    put(data, 0u64, 17989846818158018560u64, 244488046090u64)
    put(data, 0u64, 2700938287723315200u64, 10975231550u64)
    put(data, 0u64, 17800090499088908288u64, 62146418157u64)
    put(data, 0u64, 8809040871136690176u64, 237964944839u64)
    put(data, 0u64, 9223372036854775808u64, 199477539062u64)
    put(data, 0u64, 0u64, 246500000000u64)
    put(data, 16433563478020213436u64, 144u64, 0u64)
    put(data, 4194750497955655375u64, 144890865261u64, 0u64)
    put(data, 2691539602252904735u64, 15763656745260536568u64, 7u64)
    put(data, 3775467271962795241u64, 8787336846248645550u64, 7854549544u64)
    put(data, 16980212613224918121u64, 17584084447880694346u64, 40476362484u64)
    put(data, 4172857038337333440u64, 18041672551129683938u64, 244953235127u64)
    put(data, 5936867627376461659u64, 14025886302294509785u64, 183978041028u64)
    put(data, 17856837443266866062u64, 18430498103283160734u64, 196760344819u64)
    put(data, 8956297047799810807u64, 3292348826238025833u64, 243999119304u64)
    put(data, 15356974049716912789u64, 9211721212658275243u64, 200178478587u64)
    put(data, 6923608913322982854u64, 10233245872666307519u64, 251499368407u64)
    put(data, 4855902993563955944u64, 6200995035623311671u64, 215554745370u64)
    put(data, 13835893222288330752u64, 8480542380570450804u64, 26336156614u64)
    put(data, 9114973913760137216u64, 11870363864499900506u64, 198459731123u64)
    put(data, 17937099003422310400u64, 9301051379839581901u64, 179643493714u64)
    put(data, 7007960010734960640u64, 11456694803569638005u64, 82504211005u64)
    put(data, 7683422439270776832u64, 14327208890643983169u64, 61621068669u64)
    put(data, 720575940379279360u64, 4510081789599866365u64, 125776679550u64)
    put(data, 0u64, 13255356976020303332u64, 126244492023u64)
    put(data, 0u64, 9658806854127314944u64, 247718574341u64)
    put(data, 0u64, 13708435528809971712u64, 5523604968u64)
    put(data, 0u64, 1580190652103131136u64, 232743135779u64)
    put(data, 0u64, 16557336970347413504u64, 35085662306u64)
    put(data, 0u64, 12751520132434493440u64, 98897575035u64)
    put(data, 0u64, 9295429630892703744u64, 123691261291u64)
    put(data, 0u64, 0u64, 107503906250u64)
    put(data, 0u64, 0u64, 202000000000u64)
    put(data, 2768933352715741194u64, 2210859u64, 0u64)
    put(data, 15201941611824153390u64, 2210859150104177u64, 0u64)
    put(data, 1418128541727000180u64, 16872870088062921306u64, 119850u64)
    put(data, 5353350204565757408u64, 5112979788807802982u64, 42914680120u64)
    put(data, 1721001680354286741u64, 13742728082020150272u64, 56277175189u64)
    put(data, 637631411660453962u64, 2217110934613627976u64, 149744994782u64)
    put(data, 1630012588870568400u64, 11021433940188610484u64, 222120189824u64)
    put(data, 9253063571656828156u64, 1713669895470733463u64, 128597473131u64)
    put(data, 6029146854993203780u64, 3313382510572018285u64, 107092898231u64)
    put(data, 16987401965352759896u64, 14976595232784069505u64, 183179618825u64)
    put(data, 14499131620542087970u64, 7213172372862496841u64, 9811882854u64)
    put(data, 1978417255298660539u64, 15836474542502248588u64, 102391026857u64)
    put(data, 5790079354402454176u64, 3221099285878340134u64, 169858497005u64)
    put(data, 13748918935842078720u64, 3265814602578095358u64, 237174616142u64)
    put(data, 18047438014740692992u64, 6502528252282225364u64, 78177040164u64)
    put(data, 3116889656839372800u64, 16392476834556790183u64, 36352502762u64)
    put(data, 15995952446606147584u64, 15167629413417091342u64, 234888637949u64)
    put(data, 12530140063251562496u64, 1366763272626280111u64, 253822238838u64)
    put(data, 16717361816799281152u64, 8720523635169216093u64, 118074092385u64)
    put(data, 0u64, 9649171375767398672u64, 97472740533u64)
    put(data, 0u64, 7647980704001073152u64, 181523082628u64)
    put(data, 0u64, 13286434495608651776u64, 132414597864u64)
    put(data, 0u64, 4358271637167013888u64, 232720259057u64)
    put(data, 0u64, 15954987941890097152u64, 241236262378u64)
    put(data, 0u64, 7911135695429697536u64, 234864921629u64)
    put(data, 0u64, 7205759403792793600u64, 29428863525u64)
    put(data, 0u64, 0u64, 37390625000u64)
    put(data, 0u64, 0u64, 232000000000u64)
    put(data, 13558973353698967386u64, 33u64, 0u64)
    put(data, 6228991722850501890u64, 33735033418u64, 0u64)
    put(data, 16886831391703377787u64, 15288289344628122701u64, 1u64)
    put(data, 1181713637872883048u64, 952589339068938148u64, 1828779826u64)
    put(data, 12393932434925221726u64, 10058155040190817688u64, 50051639971u64)
    put(data, 10684799845419711910u64, 5322725640026584391u64, 163545253677u64)
    put(data, 4590318792215640843u64, 2269982385930389600u64, 45288545535u64)
    put(data, 6383712187366189238u64, 13216683679976310224u64, 255123055991u64)
    put(data, 1904270214927675016u64, 17417440642083494819u64, 119716477857u64)
    put(data, 3711506775113308575u64, 3029180749090900711u64, 161944201349u64)
    put(data, 8091219444738793995u64, 8315443826261908513u64, 133164212217u64)
    put(data, 39436684991068052u64, 1488962797247197277u64, 249450781113u64)
    put(data, 18025182908196512891u64, 18009099634999034122u64, 185080716834u64)
    put(data, 7853924592034603138u64, 8092455412807497971u64, 34976275247u64)
    put(data, 4815749283615688320u64, 17808458047236758329u64, 47438692886u64)
    put(data, 14242399906544287744u64, 3164591817527425171u64, 22965398445u64)
    put(data, 76242322576113664u64, 3314036340472350590u64, 173171552866u64)
    put(data, 10858088421377703936u64, 33234902404332784u64, 98179654270u64)
    put(data, 14293835879041466368u64, 12349284717857274280u64, 126001801667u64)
    put(data, 12182236992037191680u64, 18209607903013119355u64, 195669456065u64)
    put(data, 11529215046068469760u64, 7891549145984268038u64, 193987144822u64)
    put(data, 0u64, 7703609897518594624u64, 118427801736u64)
    put(data, 0u64, 6336912652634587136u64, 136417613529u64)
    put(data, 0u64, 4461621834659397632u64, 217343524723u64)
    put(data, 0u64, 5484660635557953536u64, 115241865004u64)
    put(data, 0u64, 15142619273265938432u64, 44297324048u64)
    put(data, 0u64, 12170977992968765440u64, 16820883035u64)
    put(data, 0u64, 1152921504606846976u64, 91659790039u64)
    put(data, 0u64, 0u64, 215062500000u64)
    put(data, 0u64, 0u64, 160000000000u64)
    put(data, 14000097438505379162u64, 514755u64, 0u64)
    put(data, 16451062686452429925u64, 514755758946802u64, 0u64)
    put(data, 4009347599785716645u64, 17812314011563521031u64, 27904u64)
    put(data, 16544162347546196456u64, 7684138864490314336u64, 965607477u64)
    put(data, 17674258299745817187u64, 9740522787420029605u64, 53416558002u64)
    put(data, 5215238411201214416u64, 6701109407732989894u64, 178528034798u64)
    put(data, 14253990228345322571u64, 16534886227502443952u64, 238363267868u64)
    put(data, 11214836553940194590u64, 8908667306968317910u64, 28896357978u64)
    put(data, 14620711348380590101u64, 7531472173477105155u64, 90482939822u64)
    put(data, 6638710787931587427u64, 11527371604834801166u64, 174408281924u64)
    put(data, 17320000343692853250u64, 15688593496691078576u64, 68624900066u64)
    put(data, 75147386268843646u64, 11394944804253312188u64, 226850480357u64)
    put(data, 17938801582125480173u64, 11182279880854372627u64, 229617721195u64)
    put(data, 6573358613626446145u64, 150579373068361470u64, 107606192607u64)
    put(data, 8688505427903736481u64, 3147220002440857300u64, 223008162924u64)
    put(data, 539870168696556032u64, 3630514817795505815u64, 108170611138u64)
    put(data, 9002861336394465280u64, 11708796588334233588u64, 194196810602u64)
    put(data, 17989846818158018560u64, 16844495466426369546u64, 106634735134u64)
    put(data, 2700938287723315200u64, 17636655472325475902u64, 30913141928u64)
    put(data, 17800090499088908288u64, 17038926655686645229u64, 168956085008u64)
    put(data, 8809040871136690176u64, 15602838456783529415u64, 16923682064u64)
    put(data, 9223372036854775808u64, 10869815869248876790u64, 16845831567u64)
    put(data, 0u64, 18407124180939800832u64, 143589253898u64)
    put(data, 0u64, 5705018517251293184u64, 10997852201u64)
    put(data, 0u64, 9660452258743058432u64, 41309269673u64)
    put(data, 0u64, 5646292272224927744u64, 169523694166u64)
    put(data, 0u64, 7410409304047484928u64, 86306086117u64)
    put(data, 0u64, 5953758707383795712u64, 229401719093u64)
    put(data, 0u64, 4611686018427387904u64, 53322753906u64)
    put(data, 0u64, 0u64, 114250000000u64)
    put(data, 0u64, 0u64, 128000000000u64)
    put(data, 15763656745260536568u64, 7u64, 0u64)
    put(data, 8787336846248645550u64, 7854549544u64, 0u64)
    put(data, 17584084447880694346u64, 7854549544476362484u64, 0u64)
    put(data, 18041672551129683938u64, 15035424419724983u64, 425795984u64)
    put(data, 14025886302294509785u64, 18280822466032836292u64, 144000815071u64)
    put(data, 18430498103283160734u64, 11524250747302615283u64, 223991005371u64)
    put(data, 3292348826238025833u64, 15212285943691810760u64, 187624730884u64)
    put(data, 9211721212658275243u64, 7951804027551297019u64, 4824659673u64)
    put(data, 10233245872666307519u64, 1706416229965221847u64, 217431068160u64)
    put(data, 6200995035623311671u64, 3406023111930700826u64, 92505009u64)
    put(data, 8480542380570450804u64, 16132696204133391302u64, 177184640882u64)
    put(data, 11870363864499900506u64, 11593846688794356915u64, 114874555213u64)
    put(data, 9301051379839581901u64, 6875759884161133906u64, 77628503688u64)
    put(data, 11456694803569638005u64, 3593593325323835965u64, 136372735690u64)
    put(data, 14327208890643983169u64, 9542049733257388925u64, 202194809084u64)
    put(data, 4510081789599866365u64, 9926551925937787518u64, 252517275552u64)
    put(data, 13255356976020303332u64, 3128491553219547895u64, 160538119458u64)
    put(data, 9658806854127314944u64, 17158408656931354885u64, 34169595866u64)
    put(data, 13708435528809971712u64, 2065169543154992616u64, 218930159197u64)
    put(data, 1580190652103131136u64, 4832622393556232739u64, 93111953065u64)
    put(data, 16557336970347413504u64, 16505930714733656162u64, 169261976984u64)
    put(data, 12751520132434493440u64, 18270988073492888699u64, 152894788296u64)
    put(data, 9295429630892703744u64, 2525111411519708523u64, 200990472248u64)
    put(data, 0u64, 16728989342518570442u64, 56136886563u64)
    put(data, 0u64, 7974052022039438336u64, 35906880329u64)
    put(data, 0u64, 5356554962386550784u64, 73432274226u64)
    put(data, 0u64, 6693869495028547584u64, 50290379426u64)
    put(data, 0u64, 8157517147199766528u64, 162362875392u64)
    put(data, 0u64, 12065776720423157760u64, 442219890u64)
    put(data, 0u64, 11997589407315001344u64, 114654087066u64)
    put(data, 0u64, 0u64, 154650390625u64)
    put(data, 0u64, 0u64, 97000000000u64)
    put(data, 16872870088062921306u64, 119850u64, 0u64)
    put(data, 5112979788807802982u64, 119850914680120u64, 0u64)
    put(data, 13742728082020150272u64, 2418433229320326037u64, 6497u64)
    put(data, 2217110934613627976u64, 1143911773589293534u64, 97131103528u64)
    put(data, 11021433940188610484u64, 9276183703610924928u64, 40062011581u64)
    put(data, 1713669895470733463u64, 3532180128827684715u64, 189502862926u64)
    put(data, 3313382510572018285u64, 8563997501322031543u64, 78191479868u64)
    put(data, 14976595232784069505u64, 14843890409658460681u64, 60464255234u64)
    put(data, 7213172372862496841u64, 9489417861634552678u64, 2804688911u64)
    put(data, 15836474542502248588u64, 1113198223322322089u64, 15514422373u64)
    put(data, 3221099285878340134u64, 11190777557146597869u64, 101060346596u64)
    put(data, 3265814602578095358u64, 17764553645932638286u64, 228606653266u64)
    put(data, 6502528252282225364u64, 14900777150991234852u64, 82963018382u64)
    put(data, 16392476834556790183u64, 17364899863357893610u64, 142807772747u64)
    put(data, 15167629413417091342u64, 15537570181590167037u64, 75941353107u64)
    put(data, 1366763272626280111u64, 5558052627121307766u64, 147842293367u64)
    put(data, 8720523635169216093u64, 12095241565795232609u64, 119301302636u64)
    put(data, 9649171375767398672u64, 2187936505958366389u64, 108655684359u64)
    put(data, 7647980704001073152u64, 12009203621325860228u64, 7118608275u64)
    put(data, 13286434495608651776u64, 14814842834750302952u64, 147651020232u64)
    put(data, 4358271637167013888u64, 5965296499605198833u64, 200803114239u64)
    put(data, 15954987941890097152u64, 4051026394962148842u64, 255323379371u64)
    put(data, 7911135695429697536u64, 16799526299141688349u64, 171219606580u64)
    put(data, 7205759403792793600u64, 9460214166646215205u64, 52910704145u64)
    put(data, 0u64, 10750736995029068008u64, 17512839237u64)
    put(data, 0u64, 5377963045376430080u64, 69582798620u64)
    put(data, 0u64, 15996910350253424640u64, 28291539960u64)
    put(data, 0u64, 13651157529655246848u64, 248867194247u64)
    put(data, 0u64, 9771305410219737088u64, 135740030732u64)
    put(data, 0u64, 12709439623416250368u64, 12529703527u64)
    put(data, 0u64, 9943947977234055168u64, 103688980102u64)
    put(data, 0u64, 0u64, 134539062500u64)
    put(data, 0u64, 0u64, 228000000000u64)
    put(data, 952589339068938148u64, 1828779826u64, 0u64)
    put(data, 10058155040190817688u64, 1828779826051639971u64, 0u64)
    put(data, 5322725640026584391u64, 371564423966525229u64, 99138353u64)
    put(data, 2269982385930389600u64, 14464859121514339583u64, 49020142547u64)
    put(data, 13216683679976310224u64, 3913119023023056247u64, 211784141584u64)
    put(data, 17417440642083494819u64, 5493396321716566945u64, 16212130607u64)
    put(data, 3029180749090900711u64, 5837454566818211973u64, 47297797611u64)
    put(data, 8315443826261908513u64, 2886670683193253881u64, 235316449046u64)
    put(data, 1488962797247197277u64, 5504823105587173817u64, 22156486731u64)
    put(data, 18009099634999034122u64, 9431834277334851106u64, 75298417058u64)
    put(data, 8092455412807497971u64, 12921661346456247087u64, 162511300760u64)
    put(data, 17808458047236758329u64, 3643076516404724246u64, 152700484665u64)
    put(data, 3164591817527425171u64, 12559396953196866477u64, 57197491573u64)
    put(data, 3314036340472350590u64, 1626880974916825698u64, 117680846273u64)
    put(data, 33234902404332784u64, 6806994170946429566u64, 193088193394u64)
    put(data, 12349284717857274280u64, 7596631230206896579u64, 114369007893u64)
    put(data, 18209607903013119355u64, 3100480253729502401u64, 21411814204u64)
    put(data, 7891549145984268038u64, 6310570748781063286u64, 60168077371u64)
    put(data, 7703609897518594624u64, 14251867077375744136u64, 59342096725u64)
    put(data, 6336912652634587136u64, 6701165793751570137u64, 85772595262u64)
    put(data, 4461621834659397632u64, 10856833140463959923u64, 62363270925u64)
    put(data, 5484660635557953536u64, 15867563727561248556u64, 13588550103u64)
    put(data, 15142619273265938432u64, 5048961008671491600u64, 215860182353u64)
    put(data, 12170977992968765440u64, 13278183119599849051u64, 81273704724u64)
    put(data, 1152921504606846976u64, 4547591784941053655u64, 20719811749u64)
    put(data, 0u64, 11815437715887182496u64, 165246525444u64)
    put(data, 0u64, 398495392178782208u64, 4640516162u64)
    put(data, 0u64, 9154841240825495552u64, 66021602478u64)
    put(data, 0u64, 1902683298245640192u64, 174496284938u64)
    put(data, 0u64, 5081900962138816512u64, 10103144668u64)
    put(data, 0u64, 3234710432358858752u64, 220275490403u64)
    put(data, 0u64, 16717361816799281152u64, 99175354003u64)
    put(data, 0u64, 0u64, 147906250000u64)
    put(data, 0u64, 0u64, 16000000000u64)
    put(data, 17812314011563521031u64, 27904u64, 0u64)
    put(data, 7684138864490314336u64, 27904965607477u64, 0u64)
    put(data, 9740522787420029605u64, 13488568028574514610u64, 1512u64)
    put(data, 6701109407732989894u64, 275784718433886190u64, 232731216738u64)
    put(data, 16534886227502443952u64, 10020568880357102364u64, 98014950319u64)
    put(data, 8908667306968317910u64, 8876397213146246746u64, 175543216127u64)
    put(data, 7531472173477105155u64, 2155905919114811310u64, 255481190457u64)
    put(data, 11527371604834801166u64, 1087100407155601220u64, 57116871894u64)
    put(data, 15688593496691078576u64, 2903498381705011170u64, 214058931831u64)
    put(data, 11394944804253312188u64, 12223476257006657765u64, 119157398962u64)
    put(data, 11182279880854372627u64, 12148657163736735595u64, 178662635975u64)
    put(data, 150579373068361470u64, 8951241323311673823u64, 199658580024u64)
    put(data, 3147220002440857300u64, 8463862715901576300u64, 56485247764u64)
    put(data, 3630514817795505815u64, 3873401978748963266u64, 20458826917u64)
    put(data, 11708796588334233588u64, 248364795947002730u64, 165209977542u64)
    put(data, 16844495466426369546u64, 10454378025404001822u64, 198013463882u64)
    put(data, 17636655472325475902u64, 6574176865628265640u64, 74566732968u64)
    put(data, 17038926655686645229u64, 16703315293848336u64, 168356386842u64)
    put(data, 15602838456783529415u64, 9896033222450013456u64, 26000905488u64)
    put(data, 10869815869248876790u64, 17311376269334085007u64, 16536465035u64)
    put(data, 18407124180939800832u64, 18378511316495639306u64, 139938451587u64)
    put(data, 5705018517251293184u64, 15120796393727584297u64, 131996301094u64)
    put(data, 9660452258743058432u64, 18253447805740347049u64, 38819700014u64)
    put(data, 5646292272224927744u64, 5842497225601731158u64, 46989521388u64)
    put(data, 7410409304047484928u64, 4369968404176723173u64, 236316722409u64)
    put(data, 5953758707383795712u64, 16142207253674488117u64, 233236896461u64)
    put(data, 4611686018427387904u64, 12124259227391928178u64, 205875070808u64)
    put(data, 0u64, 13019483264566077056u64, 88657257409u64)
    put(data, 0u64, 74901376448135168u64, 193705787602u64)
    put(data, 0u64, 13897060093813325824u64, 210004060411u64)
    put(data, 0u64, 4495486210810052608u64, 251753361137u64)
    put(data, 0u64, 14885496280087265280u64, 241243700795u64)
    put(data, 0u64, 4976477588244398080u64, 59806944370u64)
    put(data, 0u64, 11529215046068469760u64, 114269775390u64)
    put(data, 0u64, 0u64, 30625000000u64)
    put(data, 0u64, 0u64, 64000000000u64)
    put(data, 15035424419724983u64, 425795984u64, 0u64)
    put(data, 18280822466032836292u64, 425795984000815071u64, 0u64)
    put(data, 11524250747302615283u64, 10043594327130472635u64, 23082446u64)
    put(data, 15212285943691810760u64, 8336034337032909060u64, 206544464339u64)
    put(data, 7951804027551297019u64, 16717215784895280857u64, 211451897326u64)
    put(data, 1706416229965221847u64, 10968831263951212032u64, 238906242083u64)
    put(data, 3406023111930700826u64, 5536629379734406065u64, 35594621534u64)
    put(data, 16132696204133391302u64, 1618806894932332402u64, 94300141280u64)
    put(data, 11593846688794356915u64, 11363331325254998861u64, 224087755697u64)
    put(data, 6875759884161133906u64, 8775167772751754888u64, 177616007425u64)
    put(data, 3593593325323835965u64, 2898202945316114122u64, 1475702798u64)
    put(data, 9542049733257388925u64, 8868842714495185148u64, 14157111896u64)
    put(data, 9926551925937787518u64, 17052094667531999136u64, 88480780926u64)
    put(data, 3128491553219547895u64, 3658615537031138594u64, 126924395904u64)
    put(data, 17158408656931354885u64, 12486952437987190746u64, 128198333945u64)
    put(data, 2065169543154992616u64, 912079238520577629u64, 249676919048u64)
    put(data, 4832622393556232739u64, 10960072898031888041u64, 8049443914u64)
    put(data, 16505930714733656162u64, 6129550094334741912u64, 74594146742u64)
    put(data, 18270988073492888699u64, 7965724516573729480u64, 182332283576u64)
    put(data, 2525111411519708523u64, 5801761178810791992u64, 184431822791u64)
    put(data, 16728989342518570442u64, 13197466483098446115u64, 199314514103u64)
    put(data, 7974052022039438336u64, 11326268638393107273u64, 183715436091u64)
    put(data, 5356554962386550784u64, 3597339351794947378u64, 59613998253u64)
    put(data, 6693869495028547584u64, 353880726151383714u64, 173195012157u64)
    put(data, 8157517147199766528u64, 11154818162602073600u64, 61019183912u64)
    put(data, 12065776720423157760u64, 5141043976157511026u64, 40604703904u64)
    put(data, 11997589407315001344u64, 7188225141808859034u64, 160278696552u64)
    put(data, 0u64, 13894168943295705185u64, 104389674465u64)
    put(data, 0u64, 12176538069834828288u64, 225753204407u64)
    put(data, 0u64, 7994239409235165184u64, 183660091451u64)
    put(data, 0u64, 13707777025480065024u64, 59433368586u64)
    put(data, 0u64, 10120227247676719104u64, 10743100081u64)
    put(data, 0u64, 7358494763030413312u64, 177548618618u64)
    put(data, 0u64, 7656119366529843200u64, 122398904800u64)
    put(data, 0u64, 9223372036854775808u64, 224415039062u64)
    put(data, 0u64, 0u64, 86500000000u64)
    put(data, 2418433229320326037u64, 6497u64, 0u64)
    put(data, 1143911773589293534u64, 6497131103528u64, 0u64)
    put(data, 9276183703610924928u64, 3877189582299842749u64, 352u64)
    put(data, 3532180128827684715u64, 7625565791857948238u64, 96210182868u64)
    put(data, 8563997501322031543u64, 16568435163612007484u64, 212413382749u64)
    put(data, 14843890409658460681u64, 17592071940521808130u64, 93898176669u64)
    put(data, 9489417861634552678u64, 15158637878035490831u64, 157953668130u64)
    put(data, 1113198223322322089u64, 17789243229146401893u64, 34821751405u64)
    put(data, 11190777557146597869u64, 14677686051252896484u64, 109964356807u64)
    put(data, 17764553645932638286u64, 3531237481269211986u64, 199795678955u64)
    put(data, 14900777150991234852u64, 8074435404989280910u64, 235191428767u64)
    put(data, 17364899863357893610u64, 7086549341467684427u64, 159437716020u64)
    put(data, 15537570181590167037u64, 10556134770918626963u64, 52384162609u64)
    put(data, 5558052627121307766u64, 10772666134712966775u64, 49572249212u64)
    put(data, 12095241565795232609u64, 6195173298198112620u64, 124583987401u64)
    put(data, 2187936505958366389u64, 8144773843324250887u64, 201335841017u64)
    put(data, 12009203621325860228u64, 14144284817150924691u64, 249441529074u64)
    put(data, 14814842834750302952u64, 6464447844648863176u64, 242766763216u64)
    put(data, 5965296499605198833u64, 15760468443293179135u64, 208350438419u64)
    put(data, 4051026394962148842u64, 5172191224908322475u64, 19854376706u64)
    put(data, 16799526299141688349u64, 2357554307308969012u64, 2280385048u64)
    put(data, 9460214166646215205u64, 1602046917604361745u64, 24127803275u64)
    put(data, 10750736995029068008u64, 7830970218109515845u64, 139086847137u64)
    put(data, 5377963045376430080u64, 2899479134887821084u64, 161424517746u64)
    put(data, 15996910350253424640u64, 15792042302392017912u64, 114157181078u64)
    put(data, 13651157529655246848u64, 11286099112296056199u64, 150856088328u64)
    put(data, 9771305410219737088u64, 15161477829153947404u64, 8611820658u64)
    put(data, 12709439623416250368u64, 423831848142641767u64, 114821905360u64)
    put(data, 9943947977234055168u64, 9707413321046312582u64, 208022975970u64)
    put(data, 0u64, 10969483299803835620u64, 226526239930u64)
    put(data, 0u64, 4326479556120930304u64, 186594656881u64)
    put(data, 0u64, 12876227232041795584u64, 113234538926u64)
    put(data, 0u64, 16967986827791171584u64, 174698021676u64)
    put(data, 0u64, 1288146316538413056u64, 44919836409u64)
    put(data, 0u64, 13715290452691779584u64, 249069830551u64)
    put(data, 0u64, 4683743612465315840u64, 151743507385u64)
    put(data, 0u64, 0u64, 185253906250u64)
    put(data, 0u64, 0u64, 74000000000u64)
    put(data, 371564423966525229u64, 99138353u64, 0u64)
    put(data, 14464859121514339583u64, 99138353020142547u64, 0u64)
    put(data, 3913119023023056247u64, 16344805304534272784u64, 5374300u64)
    put(data, 5493396321716566945u64, 26429987091348271u64, 92886053671u64)
    put(data, 5837454566818211973u64, 8691371289609838059u64, 39001432772u64)
    put(data, 2886670683193253881u64, 12980168378493046550u64, 196471160181u64)
    put(data, 5504823105587173817u64, 14010125458129496139u64, 117703656337u64)
    put(data, 9431834277334851106u64, 17061829677031795106u64, 145759490422u64)
    put(data, 12921661346456247087u64, 2227928323072698520u64, 118924923640u64)
    put(data, 3643076516404724246u64, 7394752319272287289u64, 248120776236u64)
    put(data, 12559396953196866477u64, 8805771303577744757u64, 44400870326u64)
    put(data, 1626880974916825698u64, 16371027194302248385u64, 182477361818u64)
    put(data, 6806994170946429566u64, 9114324123731231602u64, 154887475162u64)
    put(data, 7596631230206896579u64, 14468189808746991893u64, 218494088500u64)
    put(data, 3100480253729502401u64, 2376054557800684348u64, 52784322141u64)
    put(data, 6310570748781063286u64, 12462238943546048571u64, 93128806175u64)
    put(data, 14251867077375744136u64, 15334855370842605909u64, 31675579326u64)
    put(data, 6701165793751570137u64, 7211347914013798462u64, 190831304175u64)
    put(data, 10856833140463959923u64, 13763642332572548877u64, 239390927953u64)
    put(data, 15867563727561248556u64, 16868268377740071383u64, 81746128545u64)
    put(data, 5048961008671491600u64, 1120013377627684177u64, 161914430661u64)
    put(data, 13278183119599849051u64, 15898107650717274388u64, 197060716046u64)
    put(data, 4547591784941053655u64, 12281923376333274277u64, 14861838142u64)
    put(data, 11815437715887182496u64, 6383530489286615044u64, 62665804400u64)
    put(data, 398495392178782208u64, 4253822060257126466u64, 112346051881u64)
    put(data, 9154841240825495552u64, 17614372438391501998u64, 41230600155u64)
    put(data, 1902683298245640192u64, 4309951310554333450u64, 219954877043u64)
    put(data, 5081900962138816512u64, 13106185988973773020u64, 115233642928u64)
    put(data, 3234710432358858752u64, 2070134359761960547u64, 176710487766u64)
    put(data, 16717361816799281152u64, 9399359914137865875u64, 214112222208u64)
    put(data, 0u64, 17415053284723541264u64, 509540321u64)
    put(data, 0u64, 4840502610448261120u64, 225944071930u64)
    put(data, 0u64, 5690599259712258048u64, 250262404172u64)
    put(data, 0u64, 114769594245185536u64, 76308488004u64)
    put(data, 0u64, 3150620882578178048u64, 68006221672u64)
    put(data, 0u64, 5136918324969472000u64, 104170795500u64)
    put(data, 0u64, 7205759403792793600u64, 236278472900u64)
    put(data, 0u64, 0u64, 196390625000u64)
    put(data, 0u64, 0u64, 232000000000u64)
    put(data, 13488568028574514610u64, 1512u64, 0u64)
    put(data, 275784718433886190u64, 1512731216738u64, 0u64)
    put(data, 10020568880357102364u64, 98202693831717807u64, 82u64)
    put(data, 8876397213146246746u64, 12909287260170414079u64, 82005323578u64)
    put(data, 2155905919114811310u64, 11728631949380786233u64, 58699813864u64)
    put(data, 1087100407155601220u64, 18263701925522197718u64, 232635810411u64)
    put(data, 2903498381705011170u64, 4868886449713321591u64, 107990077265u64)
    put(data, 12223476257006657765u64, 5870139507184082354u64, 81263942863u64)
    put(data, 12148657163736735595u64, 5978562500822661575u64, 207318220900u64)
    put(data, 8951241323311673823u64, 10821136839630268472u64, 100324098522u64)
    put(data, 8463862715901576300u64, 9490907630136752916u64, 218586615003u64)
    put(data, 3873401978748963266u64, 10564005678001613989u64, 219514503133u64)
    put(data, 248364795947002730u64, 5754050547468481222u64, 221572675895u64)
    put(data, 10454378025404001822u64, 3833909949855542602u64, 55311927705u64)
    put(data, 6574176865628265640u64, 15446538552665967784u64, 153207836674u64)
    put(data, 16703315293848336u64, 14924837848804399130u64, 2837358532u64)
    put(data, 9896033222450013456u64, 18140170340418344208u64, 196809077080u64)
    put(data, 17311376269334085007u64, 11380424819825208971u64, 88983380604u64)
    put(data, 18378511316495639306u64, 12416915664152252547u64, 124616934065u64)
    put(data, 15120796393727584297u64, 17195282241626289958u64, 177673122346u64)
    put(data, 18253447805740347049u64, 2649541045825281326u64, 42932158118u64)
    put(data, 5842497225601731158u64, 16577429864268509676u64, 166143631907u64)
    put(data, 4369968404176723173u64, 12051257060168107241u64, 35898664273u64)
    put(data, 16142207253674488117u64, 5363884561143470797u64, 81653299954u64)
    put(data, 12124259227391928178u64, 13054029903083620184u64, 242290776764u64)
    put(data, 13019483264566077056u64, 566314952158634945u64, 188707660379u64)
    put(data, 74901376448135168u64, 1329472079642345682u64, 91030699995u64)
    put(data, 13897060093813325824u64, 15686237486658857211u64, 219072070825u64)
    put(data, 4495486210810052608u64, 1069073549290598129u64, 169850352638u64)
    put(data, 14885496280087265280u64, 4323599065125928507u64, 254057954593u64)
    put(data, 4976477588244398080u64, 17861823329752681586u64, 33234382774u64)
    put(data, 11529215046068469760u64, 17220149985412802078u64, 182968291382u64)
    put(data, 0u64, 4344934572159429184u64, 54933506201u64)
    put(data, 0u64, 2252927464837120000u64, 153235539375u64)
    put(data, 0u64, 10910018171964489728u64, 175122131442u64)
    put(data, 0u64, 3597328585515335680u64, 242591433270u64)
    put(data, 0u64, 6972808074239148032u64, 54195011573u64)
    put(data, 0u64, 2227030015734710272u64, 245377996683u64)
    put(data, 0u64, 1152921504606846976u64, 139120727539u64)
    put(data, 0u64, 0u64, 243062500000u64)
    put(data, 0u64, 0u64, 160000000000u64)
    put(data, 10043594327130472635u64, 23082446u64, 0u64)
    put(data, 8336034337032909060u64, 23082446544464339u64, 0u64)
    put(data, 16717215784895280857u64, 17238287503805244910u64, 1251301u64)
    put(data, 10968831263951212032u64, 1434575446038410275u64, 229934489438u64)
    put(data, 5536629379734406065u64, 14009569747841241694u64, 94077768490u64)
    put(data, 1618806894932332402u64, 14938795732275951328u64, 42759460297u64)
    put(data, 11363331325254998861u64, 6687653542888983473u64, 201809833739u64)
    put(data, 8775167772751754888u64, 28238723295162625u64, 11362538425u64)
    put(data, 2898202945316114122u64, 4745270274832691214u64, 185001530824u64)
    put(data, 8868842714495185148u64, 926478968112308824u64, 200257241617u64)
    put(data, 17052094667531999136u64, 9213681606604198526u64, 17050224525u64)
    put(data, 3658615537031138594u64, 13346223820579313024u64, 141499474680u64)
    put(data, 12486952437987190746u64, 691642518601291257u64, 248723500243u64)
    put(data, 912079238520577629u64, 1153720150033789192u64, 211037494016u64)
    put(data, 10960072898031888041u64, 12089015034721780810u64, 62543294u64)
    put(data, 6129550094334741912u64, 3555868702841788854u64, 190655346818u64)
    put(data, 7965724516573729480u64, 11708406782758214328u64, 130192764028u64)
    put(data, 5801761178810791992u64, 9417497762905343943u64, 124634714003u64)
    put(data, 13197466483098446115u64, 12838336066957615287u64, 147510523576u64)
    put(data, 11326268638393107273u64, 13737708142128207419u64, 184695967592u64)
    put(data, 3597339351794947378u64, 11683434809834695853u64, 104744722650u64)
    put(data, 353880726151383714u64, 2689114340106315837u64, 218633360270u64)
    put(data, 11154818162602073600u64, 8859225263374261032u64, 142145777180u64)
    put(data, 5141043976157511026u64, 15761671984578600096u64, 28480259563u64)
    put(data, 7188225141808859034u64, 7087267079878005352u64, 235854441950u64)
    put(data, 13894168943295705185u64, 4601291730423121377u64, 222384201518u64)
    put(data, 12176538069834828288u64, 9559411037059581623u64, 46249436524u64)
    put(data, 7994239409235165184u64, 12969820289641388091u64, 108518216710u64)
    put(data, 13707777025480065024u64, 13628239920285957130u64, 6703095366u64)
    put(data, 10120227247676719104u64, 8049893933765800625u64, 70738788366u64)
    put(data, 7358494763030413312u64, 10391755948840250234u64, 14436385624u64)
    put(data, 7656119366529843200u64, 14454650777462444512u64, 88563338218u64)
    put(data, 9223372036854775808u64, 14244638523341127254u64, 234783588188u64)
    put(data, 0u64, 12246016810439753984u64, 92772203401u64)
    put(data, 0u64, 9382741764551081984u64, 137663857901u64)
    put(data, 0u64, 4608696190291148800u64, 237508639450u64)
    put(data, 0u64, 1696483666416369664u64, 218249837921u64)
    put(data, 0u64, 15416683541605384192u64, 97091966563u64)
    put(data, 0u64, 7683140964294066176u64, 99835740089u64)
    put(data, 0u64, 4611686018427387904u64, 185416503906u64)
    put(data, 0u64, 0u64, 98250000000u64)
    put(data, 0u64, 0u64, 128000000000u64)
    put(data, 3877189582299842749u64, 352u64, 0u64)
    put(data, 7625565791857948238u64, 352210182868u64, 0u64)
    put(data, 16568435163612007484u64, 1722045467931902045u64, 19u64)
    put(data, 17592071940521808130u64, 16095324008152856733u64, 19093352271u64)
    put(data, 15158637878035490831u64, 15216188060094280738u64, 79872529262u64)
    put(data, 17789243229146401893u64, 10793385929903030893u64, 110824871207u64)
    put(data, 14677686051252896484u64, 12613277226875940039u64, 39585110623u64)
    put(data, 3531237481269211986u64, 10644539625155600107u64, 95683767128u64)
    put(data, 8074435404989280910u64, 6181262895644173983u64, 88577041649u64)
    put(data, 7086549341467684427u64, 148914399627082292u64, 241335086933u64)
    put(data, 10556134770918626963u64, 14379289774887985969u64, 85008072665u64)
    put(data, 10772666134712966775u64, 11743339675582627452u64, 217779502860u64)
    put(data, 6195173298198112620u64, 7841621929809463497u64, 12636607719u64)
    put(data, 8144773843324250887u64, 11168944680251236601u64, 231425095176u64)
    put(data, 14144284817150924691u64, 6178560202529287410u64, 8605469704u64)
    put(data, 6464447844648863176u64, 13295243308201596112u64, 8334940419u64)
    put(data, 15760468443293179135u64, 17040673746172470291u64, 3720736583u64)
    put(data, 5172191224908322475u64, 14957442487039409922u64, 71923776774u64)
    put(data, 2357554307308969012u64, 17778155426506992152u64, 6810844581u64)
    put(data, 1602046917604361745u64, 14945404984219733899u64, 165963755736u64)
    put(data, 7830970218109515845u64, 11590754866058681505u64, 216810192027u64)
    put(data, 2899479134887821084u64, 6020790784469412466u64, 155628336080u64)
    put(data, 15792042302392017912u64, 7934351824569522326u64, 208326387722u64)
    put(data, 11286099112296056199u64, 5038361112172116744u64, 10430122074u64)
    put(data, 15161477829153947404u64, 3305187319649924210u64, 90273130103u64)
    put(data, 423831848142641767u64, 11470175511099161552u64, 119179174563u64)
    put(data, 9707413321046312582u64, 7308362160352048610u64, 163621799460u64)
    put(data, 10969483299803835620u64, 10666410671225576634u64, 36396187106u64)
    put(data, 4326479556120930304u64, 2181639019945820785u64, 226578227281u64)
    put(data, 12876227232041795584u64, 4615749499734847918u64, 81118266888u64)
    put(data, 16967986827791171584u64, 14076159200958497580u64, 8250220281u64)
    put(data, 1288146316538413056u64, 5470405257862074105u64, 249763070119u64)
    put(data, 13715290452691779584u64, 4565741478181339543u64, 167296551263u64)
    put(data, 4683743612465315840u64, 8901832997861862329u64, 95247509341u64)
    put(data, 0u64, 14190141170191714122u64, 93482569333u64)
    put(data, 0u64, 4240772322245764096u64, 117769249094u64)
    put(data, 0u64, 4422842195340951552u64, 70229892728u64)
    put(data, 0u64, 15448426386733137920u64, 120239762755u64)
    put(data, 0u64, 9203504548935630848u64, 67837460872u64)
    put(data, 0u64, 5936377627571912704u64, 136498922981u64)
    put(data, 0u64, 468374361246531584u64, 229321811676u64)
    put(data, 0u64, 0u64, 220025390625u64)
    put(data, 0u64, 0u64, 33000000000u64)
    put(data, 16344805304534272784u64, 5374300u64, 0u64)
    put(data, 26429987091348271u64, 5374300886053671u64, 0u64)
    put(data, 8691371289609838059u64, 8020875056524075716u64, 291341u64)
    put(data, 12980168378493046550u64, 1400288714762747253u64, 13434812508u64)
    put(data, 14010125458129496139u64, 6136037711314764689u64, 92075909803u64)
    put(data, 17061829677031795106u64, 15735488086392394102u64, 171332635270u64)
    put(data, 2227928323072698520u64, 7735094782793634552u64, 134853022518u64)
    put(data, 7394752319272287289u64, 7273689191766726188u64, 54419320328u64)
    put(data, 8805771303577744757u64, 3410634565056431030u64, 8394307481u64)
    put(data, 16371027194302248385u64, 4600927904885215898u64, 153184890870u64)
    put(data, 9114324123731231602u64, 9154871331680374746u64, 246249416801u64)
    put(data, 14468189808746991893u64, 6117978272461042996u64, 97496286569u64)
    put(data, 2376054557800684348u64, 13116904339287496285u64, 105331656266u64)
    put(data, 12462238943546048571u64, 867037205615660831u64, 74711068809u64)
    put(data, 15334855370842605909u64, 1802487145191504830u64, 137047002181u64)
    put(data, 7211347914013798462u64, 17242009718457409007u64, 69097713023u64)
    put(data, 13763642332572548877u64, 13620802355488468049u64, 127934691219u64)
    put(data, 16868268377740071383u64, 4442227880594435745u64, 147738385175u64)
    put(data, 1120013377627684177u64, 17354849212854314181u64, 23240813655u64)
    put(data, 15898107650717274388u64, 18202319179831567886u64, 87940808260u64)
    put(data, 12281923376333274277u64, 17568634016348874558u64, 68986749699u64)
    put(data, 6383530489286615044u64, 7496925598312450672u64, 3952397558u64)
    put(data, 4253822060257126466u64, 601870379496813865u64, 246406409151u64)
    put(data, 17614372438391501998u64, 11995106565680728027u64, 191032627458u64)
    put(data, 4309951310554333450u64, 16331071694764184179u64, 2650256029u64)
    put(data, 13106185988973773020u64, 9665962217000524208u64, 157885309170u64)
    put(data, 2070134359761960547u64, 13682661374415474390u64, 242523992861u64)
    put(data, 9399359914137865875u64, 6940361789924260864u64, 29741738559u64)
    put(data, 17415053284723541264u64, 9658039831644010465u64, 63376237766u64)
    put(data, 4840502610448261120u64, 6843715893910236922u64, 198523563388u64)
    put(data, 5690599259712258048u64, 47089792870595660u64, 124370998582u64)
    put(data, 114769594245185536u64, 14510386192097156932u64, 54002552742u64)
    put(data, 3150620882578178048u64, 12059931208360040296u64, 166786609611u64)
    put(data, 5136918324969472000u64, 14877013468459184620u64, 203653770180u64)
    put(data, 7205759403792793600u64, 2397668560671695044u64, 196806484516u64)
    put(data, 0u64, 2195572305559232232u64, 36129977873u64)
    put(data, 0u64, 3261686279425953792u64, 17119022213u64)
    put(data, 0u64, 9333850662059900928u64, 133176816367u64)
    put(data, 0u64, 5036522340217782272u64, 239505989058u64)
    put(data, 0u64, 2800120215143186432u64, 194273030423u64)
    put(data, 0u64, 441634238459019264u64, 23151794821u64)
    put(data, 0u64, 720575940379279360u64, 133023941040u64)
    put(data, 0u64, 0u64, 176039062500u64)
    put(data, 0u64, 0u64, 228000000000u64)
    put(data, 98202693831717807u64, 82u64, 0u64)
    put(data, 12909287260170414079u64, 82005323578u64, 0u64)
    put(data, 11728631949380786233u64, 8218347283861607400u64, 4u64)
    put(data, 18263701925522197718u64, 17896200385973633643u64, 4445517498u64)
    put(data, 4868886449713321591u64, 16333242102094352209u64, 186970154966u64)
    put(data, 5870139507184082354u64, 9981905728606788815u64, 214885426828u64)
    put(data, 5978562500822661575u64, 15219470018924839012u64, 140541120193u64)
    put(data, 10821136839630268472u64, 17152070168529617370u64, 193825049122u64)
    put(data, 9490907630136752916u64, 17841343440958328027u64, 34929815586u64)
    put(data, 10564005678001613989u64, 17291078023923990493u64, 34967181165u64)
    put(data, 5754050547468481222u64, 16744804581790759223u64, 109937351217u64)
    put(data, 3833909949855542602u64, 5001622214111594905u64, 49907737675u64)
    put(data, 15446538552665967784u64, 9676746897435398146u64, 75271138483u64)
    put(data, 14924837848804399130u64, 8109025833995118532u64, 179524577500u64)
    put(data, 18140170340418344208u64, 5495826424046694744u64, 220439591171u64)
    put(data, 11380424819825208971u64, 7890288164365705852u64, 3297929347u64)
    put(data, 12416915664152252547u64, 8616438349039895217u64, 131427733378u64)
    put(data, 17195282241626289958u64, 15787154801788760618u64, 130467098058u64)
    put(data, 2649541045825281326u64, 12418659311480782502u64, 202855823376u64)
    put(data, 16577429864268509676u64, 4486988874116669987u64, 16673216870u64)
    put(data, 12051257060168107241u64, 4828971301551875409u64, 102243240154u64)
    put(data, 5363884561143470797u64, 14769106422014442226u64, 218261779058u64)
    put(data, 13054029903083620184u64, 7763933466423188156u64, 114800634863u64)
    put(data, 566314952158634945u64, 10449097116253839963u64, 239420883676u64)
    put(data, 1329472079642345682u64, 12870692502472900571u64, 220566446689u64)
    put(data, 15686237486658857211u64, 11597479481311003817u64, 97697721638u64)
    put(data, 1069073549290598129u64, 8294994869530047486u64, 38628700622u64)
    put(data, 4323599065125928507u64, 16879315829924478241u64, 206449672572u64)
    put(data, 17861823329752681586u64, 11873324837601439670u64, 124915029544u64)
    put(data, 17220149985412802078u64, 3277599055636107318u64, 40643654229u64)
    put(data, 4344934572159429184u64, 15363467897354242201u64, 85177679000u64)
    put(data, 2252927464837120000u64, 10351182204479784367u64, 152832855263u64)
    put(data, 10910018171964489728u64, 12811517584931924466u64, 223561138711u64)
    put(data, 3597328585515335680u64, 16988930699558748726u64, 23694513759u64)
    put(data, 6972808074239148032u64, 11683499918824718325u64, 95920971778u64)
    put(data, 2227030015734710272u64, 13119300691281647499u64, 2633363799u64)
    put(data, 1152921504606846976u64, 10125549106595354099u64, 87711198715u64)
    put(data, 0u64, 17505352699870800544u64, 251548907116u64)
    put(data, 0u64, 6756039242241163264u64, 108948967071u64)
    put(data, 0u64, 3537338758766526464u64, 159366245621u64)
    put(data, 0u64, 6522626374119718912u64, 245191759518u64)
    put(data, 0u64, 4733294203482669056u64, 158353592284u64)
    put(data, 0u64, 16997710893603094528u64, 220256592392u64)
    put(data, 0u64, 16717361816799281152u64, 8921447753u64)
    put(data, 0u64, 0u64, 73906250000u64)
    put(data, 0u64, 0u64, 16000000000u64)
    put(data, 17238287503805244910u64, 1251301u64, 0u64)
    put(data, 1434575446038410275u64, 1251301934489438u64, 0u64)
    put(data, 14009569747841241694u64, 3943737498063000362u64, 67833u64)
    put(data, 14938795732275951328u64, 2870731037991212489u64, 249213790438u64)
    put(data, 6687653542888983473u64, 7389433400402095883u64, 230155622641u64)
    put(data, 28238723295162625u64, 5675049236146197433u64, 241400581987u64)
    put(data, 4745270274832691214u64, 9953779846262904264u64, 99307645035u64)
    put(data, 926478968112308824u64, 12691978937179636241u64, 107539595486u64)
    put(data, 9213681606604198526u64, 15523327331528198029u64, 222688033556u64)
    put(data, 13346223820579313024u64, 15722603279568118520u64, 20841521260u64)
    put(data, 691642518601291257u64, 11838632364171816147u64, 108852324031u64)
    put(data, 1153720150033789192u64, 7832751832367143680u64, 191641773546u64)
    put(data, 12089015034721780810u64, 12167724027162940862u64, 234424614327u64)
    put(data, 3555868702841788854u64, 4108211144748152962u64, 183659613641u64)
    put(data, 11708406782758214328u64, 7530983398136343676u64, 201222706572u64)
    put(data, 9417497762905343943u64, 1117587133956542355u64, 140408255428u64)
    put(data, 12838336066957615287u64, 17134748625149490872u64, 196060584519u64)
    put(data, 13737708142128207419u64, 4039918359454207848u64, 71928876584u64)
    put(data, 11683434809834695853u64, 1830218764589441242u64, 40219004413u64)
    put(data, 2689114340106315837u64, 637895981480825742u64, 253099216358u64)
    put(data, 8859225263374261032u64, 8246879226348334620u64, 230034580410u64)
    put(data, 15761671984578600096u64, 12389239568142583275u64, 186447064218u64)
    put(data, 7087267079878005352u64, 14041257178803154398u64, 154671622022u64)
    put(data, 4601291730423121377u64, 16312515716494630702u64, 134761178076u64)
    put(data, 9559411037059581623u64, 17088522799596987756u64, 220884303248u64)
    put(data, 12969820289641388091u64, 3588932524637852678u64, 144926370677u64)
    put(data, 13628239920285957130u64, 107218049069817414u64, 117194556422u64)
    put(data, 8049893933765800625u64, 1596707240462008334u64, 6005812302u64)
    put(data, 10391755948840250234u64, 17461913142391587672u64, 78086557672u64)
    put(data, 14454650777462444512u64, 4366474266651610090u64, 232946612208u64)
    put(data, 14244638523341127254u64, 5539304013194805084u64, 240236707044u64)
    put(data, 12246016810439753984u64, 4762470619211987849u64, 228300286272u64)
    put(data, 9382741764551081984u64, 10835638458986644717u64, 64258174049u64)
    put(data, 4608696190291148800u64, 16141642290510052058u64, 97587401137u64)
    put(data, 1696483666416369664u64, 17390568670756355425u64, 177875040181u64)
    put(data, 15416683541605384192u64, 12536768491333867107u64, 181942744616u64)
    put(data, 7683140964294066176u64, 13145148522871947193u64, 40679619581u64)
    put(data, 4611686018427387904u64, 5665349945233068642u64, 253712599929u64)
    put(data, 0u64, 17074607537751066240u64, 121307119235u64)
    put(data, 0u64, 6241525660962062336u64, 131925616329u64)
    put(data, 0u64, 1142860629783085056u64, 201338353784u64)
    put(data, 0u64, 16287527416870469632u64, 120061954598u64)
    put(data, 0u64, 9028002014738513920u64, 38882948630u64)
    put(data, 0u64, 16217462258161156096u64, 22489408969u64)
    put(data, 0u64, 11529215046068469760u64, 201879150390u64)
    put(data, 0u64, 0u64, 54625000000u64)
    put(data, 0u64, 0u64, 64000000000u64)
    put(data, 1722045467931902045u64, 19u64, 0u64)
    put(data, 16095324008152856733u64, 19093352271u64, 0u64)
    put(data, 15216188060094280738u64, 646608198162977646u64, 1u64)
    put(data, 10793385929903030893u64, 12170458846894708007u64, 1035052700u64)
    put(data, 12613277226875940039u64, 1797330480103086687u64, 156659761896u64)
    put(data, 10644539625155600107u64, 10332188564497263448u64, 232097433480u64)
    put(data, 6181262895644173983u64, 7524259485079594225u64, 136560109064u64)
    put(data, 148914399627082292u64, 62681109059153749u64, 8407890924u64)
    put(data, 14379289774887985969u64, 13480636451804037081u64, 236003397949u64)
    put(data, 11743339675582627452u64, 6948168233012789004u64, 61730786766u64)
    put(data, 7841621929809463497u64, 12015502974041806055u64, 206376660954u64)
    put(data, 11168944680251236601u64, 7343801660689004040u64, 218651361721u64)
    put(data, 6178560202529287410u64, 13670580858640731144u64, 185398108285u64)
    put(data, 13295243308201596112u64, 5605073897566574851u64, 125741083673u64)
    put(data, 17040673746172470291u64, 15387788940505247559u64, 25303851664u64)
    put(data, 14957442487039409922u64, 17565181499678113030u64, 144834173709u64)
    put(data, 17778155426506992152u64, 1893743623847493029u64, 13952210397u64)
    put(data, 14945404984219733899u64, 10243498996716269784u64, 221102660047u64)
    put(data, 11590754866058681505u64, 5619675836950314139u64, 207555301193u64)
    put(data, 6020790784469412466u64, 10224869737511515088u64, 73304643237u64)
    put(data, 7934351824569522326u64, 2574495974386198538u64, 165554291299u64)
    put(data, 5038361112172116744u64, 7825756347302873178u64, 99139563706u64)
    put(data, 3305187319649924210u64, 12071550103794656887u64, 186424235101u64)
    put(data, 11470175511099161552u64, 7195875213867606691u64, 93654400042u64)
    put(data, 7308362160352048610u64, 18271364438406891044u64, 42390089176u64)
    put(data, 10666410671225576634u64, 16966521933952564706u64, 216990492650u64)
    put(data, 2181639019945820785u64, 289920862029570129u64, 234919756997u64)
    put(data, 4615749499734847918u64, 7804199568098625032u64, 197015716641u64)
    put(data, 14076159200958497580u64, 5758118571242446585u64, 33423066506u64)
    put(data, 5470405257862074105u64, 4030788293606375591u64, 138312148233u64)
    put(data, 4565741478181339543u64, 4387716460037196127u64, 9218509471u64)
    put(data, 8901832997861862329u64, 16807506478881285981u64, 159237858585u64)
    put(data, 14190141170191714122u64, 17033060604413529717u64, 25911136751u64)
    put(data, 4240772322245764096u64, 10498418508292170054u64, 239923364065u64)
    put(data, 4422842195340951552u64, 13237752038744465016u64, 225569120407u64)
    put(data, 15448426386733137920u64, 17737618428304633155u64, 151717619975u64)
    put(data, 9203504548935630848u64, 13546183833248825736u64, 7961558221u64)
    put(data, 5936377627571912704u64, 826778452978976229u64, 205734340097u64)
    put(data, 468374361246531584u64, 13728076626990147292u64, 1044819749u64)
    put(data, 0u64, 2794860281883592225u64, 37744200525u64)
    put(data, 0u64, 8680705720425908736u64, 77151509679u64)
    put(data, 0u64, 731520517439488000u64, 175470582000u64)
    put(data, 0u64, 13120812320768917504u64, 240039655806u64)
    put(data, 0u64, 2722954908557901824u64, 126711280661u64)
    put(data, 0u64, 6860847004205973504u64, 21147611681u64)
    put(data, 0u64, 6503197861922996224u64, 33371927261u64)
    put(data, 0u64, 9223372036854775808u64, 221352539062u64)
    put(data, 0u64, 0u64, 182500000000u64)
    put(data, 8020875056524075716u64, 291341u64, 0u64)
    put(data, 1400288714762747253u64, 291341434812508u64, 0u64)
    put(data, 6136037711314764689u64, 12005656413127238315u64, 15793u64)
    put(data, 15735488086392394102u64, 4821130826186787462u64, 177650827938u64)
    put(data, 7735094782793634552u64, 14377899467066168118u64, 162261354025u64)
    put(data, 7273689191766726188u64, 16575613239625444872u64, 41779427491u64)
    put(data, 3410634565056431030u64, 4317827099179284377u64, 163898565794u64)
    put(data, 4600927904885215898u64, 1242354770412171254u64, 162234069876u64)
    put(data, 9154871331680374746u64, 994838588328896609u64, 116067348187u64)
    put(data, 6117978272461042996u64, 17283309862013060457u64, 219053930307u64)
    put(data, 13116904339287496285u64, 124242522249856586u64, 67936930105u64)
    put(data, 867037205615660831u64, 11564608014666985609u64, 57006735200u64)
    put(data, 1802487145191504830u64, 12401028575581654085u64, 96626918656u64)
    put(data, 17242009718457409007u64, 2490725392961465727u64, 672261106u64)
    put(data, 13620802355488468049u64, 1949482237120640915u64, 242135022494u64)
    put(data, 4442227880594435745u64, 15410502396166200087u64, 158105681643u64)
    put(data, 17354849212854314181u64, 15694919529799920727u64, 235835405008u64)
    put(data, 18202319179831567886u64, 10324869370171768388u64, 208850823292u64)
    put(data, 17568634016348874558u64, 1631866459122189059u64, 124559712290u64)
    put(data, 7496925598312450672u64, 172020494461226230u64, 34088463658u64)
    put(data, 601870379496813865u64, 12734610307908856767u64, 42009325249u64)
    put(data, 11995106565680728027u64, 1467513250829340930u64, 193690344608u64)
    put(data, 16331071694764184179u64, 13558759428494307997u64, 160079554052u64)
    put(data, 9665962217000524208u64, 7915355143999496434u64, 4735021821u64)
    put(data, 13682661374415474390u64, 2876370200608797469u64, 253429092262u64)
    put(data, 6940361789924260864u64, 343685370404989503u64, 166155928341u64)
    put(data, 9658039831644010465u64, 4837266557407634630u64, 21018631221u64)
    put(data, 6843715893910236922u64, 9622591415747161468u64, 53262228745u64)
    put(data, 47089792870595660u64, 16503783814424220982u64, 9521641725u64)
    put(data, 14510386192097156932u64, 5377083431343591334u64, 253894671913u64)
    put(data, 12059931208360040296u64, 16508482371299291595u64, 41291492276u64)
    put(data, 14877013468459184620u64, 10515883558812249028u64, 180894926622u64)
    put(data, 2397668560671695044u64, 63492062913405476u64, 30570067190u64)
    put(data, 2195572305559232232u64, 11571919759617799697u64, 246003441911u64)
    put(data, 3261686279425953792u64, 2956602334970088581u64, 247627315027u64)
    put(data, 9333850662059900928u64, 13604736747717849839u64, 83160277733u64)
    put(data, 5036522340217782272u64, 16573540719338151362u64, 229737514256u64)
    put(data, 2800120215143186432u64, 12620703004601168151u64, 16898453442u64)
    put(data, 441634238459019264u64, 14649407809089591941u64, 194684169680u64)
    put(data, 720575940379279360u64, 11290375247898624432u64, 208794145988u64)
    put(data, 0u64, 11020319450292874212u64, 196612052468u64)
    put(data, 0u64, 8754634933362354176u64, 244597412714u64)
    put(data, 0u64, 12976319450332528640u64, 106474589710u64)
    put(data, 0u64, 17447331119627239424u64, 14703447686u64)
    put(data, 0u64, 3665184902673858560u64, 134945821715u64)
    put(data, 0u64, 12949678516038795264u64, 19198690071u64)
    put(data, 0u64, 72057594037927936u64, 23702003479u64)
    put(data, 0u64, 0u64, 23003906250u64)
    put(data, 0u64, 0u64, 202000000000u64)
    put(data, 8218347283861607400u64, 4u64, 0u64)
    put(data, 17896200385973633643u64, 4445517498u64, 0u64)
    put(data, 16333242102094352209u64, 4445517498970154966u64, 0u64)
    put(data, 9981905728606788815u64, 9413159735776077452u64, 240991986u64)
    put(data, 15219470018924839012u64, 14279163482889998017u64, 242510288411u64)
    put(data, 17152070168529617370u64, 8693044629541194274u64, 27774075003u64)
    put(data, 17841343440958328027u64, 11863110253260222498u64, 123471250893u64)
    put(data, 17291078023923990493u64, 8319293368489531245u64, 205643100495u64)
    put(data, 16744804581790759223u64, 3376307525676489265u64, 79450989797u64)
    put(data, 5001622214111594905u64, 13205662254759912523u64, 229183029997u64)
    put(data, 9676746897435398146u64, 5276250334231686323u64, 237715880385u64)
    put(data, 8109025833995118532u64, 13790198520922745052u64, 193286026103u64)
    put(data, 5495826424046694744u64, 14195535250150996227u64, 119747568159u64)
    put(data, 7890288164365705852u64, 16425228796427004035u64, 31769541507u64)
    put(data, 8616438349039895217u64, 4295900841296269186u64, 131890413437u64)
    put(data, 15787154801788760618u64, 4533952595483946442u64, 125232881251u64)
    put(data, 12418659311480782502u64, 12885038019373447184u64, 99245786062u64)
    put(data, 4486988874116669987u64, 12140736240487831910u64, 206698499310u64)
    put(data, 4828971301551875409u64, 6927124077155322074u64, 238658150630u64)
    put(data, 14769106422014442226u64, 12477788342407819890u64, 230375520148u64)
    put(data, 7763933466423188156u64, 7980854329409711087u64, 148676422261u64)
    put(data, 10449097116253839963u64, 2062671021810827996u64, 117432642980u64)
    put(data, 12870692502472900571u64, 2739521363598172769u64, 164111817620u64)
    put(data, 11597479481311003817u64, 12897585686593465638u64, 148148509750u64)
    put(data, 8294994869530047486u64, 1127632646629044686u64, 54699179521u64)
    put(data, 16879315829924478241u64, 4833775019274666364u64, 1061129088u64)
    put(data, 11873324837601439670u64, 15867662672939849256u64, 128262039468u64)
    put(data, 3277599055636107318u64, 2092350330982953557u64, 172860187717u64)
    put(data, 15363467897354242201u64, 13330062299842493592u64, 69113426538u64)
    put(data, 10351182204479784367u64, 4479193352178519263u64, 106722624125u64)
    put(data, 12811517584931924466u64, 3149393938889064983u64, 125242817558u64)
    put(data, 16988930699558748726u64, 9736379904070620767u64, 22170728987u64)
    put(data, 11683499918824718325u64, 3816238703055069186u64, 27527810212u64)
    put(data, 13119300691281647499u64, 11598915938798661975u64, 164206878714u64)
    put(data, 10125549106595354099u64, 17821633264606555643u64, 250628778492u64)
    put(data, 17505352699870800544u64, 2514623558764574316u64, 252966112675u64)
    put(data, 6756039242241163264u64, 4976730480406253215u64, 163136318016u64)
    put(data, 3537338758766526464u64, 17276563697191611637u64, 64269789099u64)
    put(data, 6522626374119718912u64, 12524734095940998814u64, 171936564394u64)
    put(data, 4733294203482669056u64, 15331551308930355164u64, 170678967195u64)
    put(data, 16997710893603094528u64, 15417115581125943816u64, 155831125061u64)
    put(data, 16717361816799281152u64, 6010750237807115593u64, 69835763510u64)
    put(data, 0u64, 5624630987553628432u64, 54325843423u64)
    put(data, 0u64, 14881848243837640704u64, 223304911856u64)
    put(data, 0u64, 15281613886881529856u64, 240806746609u64)
    put(data, 0u64, 14057902358273196032u64, 241828417948u64)
    put(data, 0u64, 16075318494433902592u64, 156762080413u64)
    put(data, 0u64, 13891916000577716224u64, 157871444761u64)
    put(data, 0u64, 7205759403792793600u64, 25753082275u64)
    put(data, 0u64, 0u64, 163390625000u64)
    put(data, 0u64, 0u64, 232000000000u64)
    put(data, 3943737498063000362u64, 67833u64, 0u64)
    put(data, 2870731037991212489u64, 67833213790438u64, 0u64)
    put(data, 7389433400402095883u64, 4535831408134330609u64, 3677u64)
    put(data, 5675049236146197433u64, 6204770794376564579u64, 93245887913u64)
    put(data, 9953779846262904264u64, 13869812122751887467u64, 169336361298u64)
    put(data, 12691978937179636241u64, 14253229412394467550u64, 82751884021u64)
    put(data, 15523327331528198029u64, 12776557610216045332u64, 245772669114u64)
    put(data, 15722603279568118520u64, 16493640728678654060u64, 186692618575u64)
    put(data, 11838632364171816147u64, 9434398296825833151u64, 79894122055u64)
    put(data, 7832751832367143680u64, 8773374058285327850u64, 71511439756u64)
    put(data, 12167724027162940862u64, 12932015276748029367u64, 140475605560u64)
    put(data, 4108211144748152962u64, 16293958583527755209u64, 56701045952u64)
    put(data, 7530983398136343676u64, 13511893936143127948u64, 192883297264u64)
    put(data, 1117587133956542355u64, 18409936402005226436u64, 240732481237u64)
    put(data, 17134748625149490872u64, 2189663026458466887u64, 213998004652u64)
    put(data, 4039918359454207848u64, 9497725274248154664u64, 172118701870u64)
    put(data, 1830218764589441242u64, 14766925481127792125u64, 46514872718u64)
    put(data, 637895981480825742u64, 6982373971809635814u64, 142800516634u64)
    put(data, 8246879226348334620u64, 8616702383006884794u64, 26378515251u64)
    put(data, 12389239568142583275u64, 3059473300040871066u64, 51467112372u64)
    put(data, 14041257178803154398u64, 17123843157031495558u64, 180165854379u64)
    put(data, 16312515716494630702u64, 11210627174210626524u64, 171928285397u64)
    put(data, 17088522799596987756u64, 15868067138625928592u64, 213607729316u64)
    put(data, 3588932524637852678u64, 4467869511636937589u64, 164860209643u64)
    put(data, 107218049069817414u64, 10052108125844341766u64, 235242203691u64)
    put(data, 1596707240462008334u64, 7470588003218451534u64, 43544925873u64)
    put(data, 17461913142391587672u64, 2613527085490786280u64, 177404981387u64)
    put(data, 4366474266651610090u64, 3632919450036549616u64, 139141679587u64)
    put(data, 5539304013194805084u64, 179367907231218916u64, 227196940958u64)
    put(data, 4762470619211987849u64, 13553068184555874624u64, 158009723553u64)
    put(data, 10835638458986644717u64, 8798774862365584481u64, 161734713298u64)
    put(data, 16141642290510052058u64, 910911255817064881u64, 210476982541u64)
    put(data, 17390568670756355425u64, 2304331144765093813u64, 13049380598u64)
    put(data, 12536768491333867107u64, 12248937023083640360u64, 246124918041u64)
    put(data, 13145148522871947193u64, 10206039550662130685u64, 25664016206u64)
    put(data, 5665349945233068642u64, 12267881323837852537u64, 78553270512u64)
    put(data, 17074607537751066240u64, 2858642007937891971u64, 240665043179u64)
    put(data, 6241525660962062336u64, 14171330289750320841u64, 235154967293u64)
    put(data, 1142860629783085056u64, 6601103619749017720u64, 253768229354u64)
    put(data, 16287527416870469632u64, 4919573414486739494u64, 234357846544u64)
    put(data, 9028002014738513920u64, 3401998285294974486u64, 16266690609u64)
    put(data, 16217462258161156096u64, 10799436256515532233u64, 49184422696u64)
    put(data, 11529215046068469760u64, 10083786644665753398u64, 40585438612u64)
    put(data, 0u64, 6481194517685688896u64, 148546643169u64)
    put(data, 0u64, 15104161756860547072u64, 225351346258u64)
    put(data, 0u64, 9556039274244079616u64, 82818798249u64)
    put(data, 0u64, 1376343134954323968u64, 169518033927u64)
    put(data, 0u64, 15682488278596976640u64, 7074611710u64)
    put(data, 0u64, 1506454075355430912u64, 254850149393u64)
    put(data, 0u64, 1152921504606846976u64, 17081665039u64)
    put(data, 0u64, 0u64, 15062500000u64)
    put(data, 0u64, 0u64, 160000000000u64)
    put(data, 12170458846894708007u64, 1035052700u64, 0u64)
    put(data, 1797330480103086687u64, 1035052700659761896u64, 0u64)
    put(data, 10332188564497263448u64, 6172559441576707976u64, 56110319u64)
    put(data, 7524259485079594225u64, 15083329738554729992u64, 239334615117u64)
    put(data, 62681109059153749u64, 10013126833549229036u64, 77817668943u64)
    put(data, 13480636451804037081u64, 5817156823499936061u64, 79542812693u64)
    put(data, 6948168233012789004u64, 5282692560913632718u64, 21315348703u64)
    put(data, 12015502974041806055u64, 10252307034225766362u64, 223286375337u64)
    put(data, 7343801660689004040u64, 17981881283247669689u64, 169555778677u64)
    put(data, 13670580858640731144u64, 11689290159733383293u64, 117974799737u64)
    put(data, 5605073897566574851u64, 5530668968487988249u64, 121633677689u64)
    put(data, 15387788940505247559u64, 10083765740821947024u64, 121299818165u64)
    put(data, 17565181499678113030u64, 2798423656816843533u64, 181546642036u64)
    put(data, 1893743623847493029u64, 7614494481582904797u64, 116151702850u64)
    put(data, 10243498996716269784u64, 17811318500083423695u64, 66412782572u64)
    put(data, 5619675836950314139u64, 11641467412200329033u64, 236965553510u64)
    put(data, 10224869737511515088u64, 17733593025296340645u64, 102631085212u64)
    put(data, 2574495974386198538u64, 3689424000190644835u64, 156961340004u64)
    put(data, 7825756347302873178u64, 14966634145516728506u64, 100200004075u64)
    put(data, 12071550103794656887u64, 14171681941562070109u64, 235811342862u64)
    put(data, 7195875213867606691u64, 8130575762882608170u64, 14768248417u64)
    put(data, 18271364438406891044u64, 5234550794400656856u64, 97440759395u64)
    put(data, 16966521933952564706u64, 3020576149360486378u64, 99283765567u64)
    put(data, 289920862029570129u64, 3038675756589057221u64, 63163745761u64)
    put(data, 7804199568098625032u64, 15470260187120878369u64, 225164726942u64)
    put(data, 5758118571242446585u64, 3497929414841828746u64, 158838644485u64)
    put(data, 4030788293606375591u64, 9935840636861015305u64, 5189623133u64)
    put(data, 4387716460037196127u64, 3647355485153741471u64, 93538623000u64)
    put(data, 16807506478881285981u64, 766100215038272793u64, 24197723537u64)
    put(data, 17033060604413529717u64, 16128087474216800751u64, 145041530375u64)
    put(data, 10498418508292170054u64, 16216631732633731297u64, 7874305373u64)
    put(data, 13237752038744465016u64, 13760220872779997335u64, 93879105367u64)
    put(data, 17737618428304633155u64, 3826276262374222087u64, 87745943068u64)
    put(data, 13546183833248825736u64, 14938032745839181005u64, 28207422851u64)
    put(data, 826778452978976229u64, 14479259995009508865u64, 131809792377u64)
    put(data, 13728076626990147292u64, 2372033248156102437u64, 121784922257u64)
    put(data, 2794860281883592225u64, 792005346826701645u64, 145128588180u64)
    put(data, 8680705720425908736u64, 16278924527931792559u64, 148042934695u64)
    put(data, 731520517439488000u64, 17442516423538940144u64, 167882482266u64)
    put(data, 13120812320768917504u64, 13844184233048446u64, 90945560710u64)
    put(data, 2722954908557901824u64, 13486193870480782357u64, 134000750494u64)
    put(data, 6860847004205973504u64, 11931315179184648737u64, 158731088034u64)
    put(data, 6503197861922996224u64, 16492562205587485405u64, 162646797891u64)
    put(data, 9223372036854775808u64, 12128987217680380854u64, 67894063588u64)
    put(data, 0u64, 10568123814189138176u64, 228657513714u64)
    put(data, 0u64, 17007583519117541376u64, 242572899139u64)
    put(data, 0u64, 143791533903052800u64, 67921982950u64)
    put(data, 0u64, 12398714235792654336u64, 230007794954u64)
    put(data, 0u64, 9659957317919047680u64, 10672135645u64)
    put(data, 0u64, 9412523221204336640u64, 221523667335u64)
    put(data, 0u64, 4611686018427387904u64, 135510253906u64)
    put(data, 0u64, 0u64, 82250000000u64)
    put(data, 0u64, 0u64, 128000000000u64)
    put(data, 12005656413127238315u64, 15793u64, 0u64)
    put(data, 4821130826186787462u64, 15793650827938u64, 0u64)
    put(data, 14377899467066168118u64, 3237900842885170729u64, 856u64)
    put(data, 16575613239625444872u64, 7515893506498066595u64, 88175526956u64)
    put(data, 4317827099179284377u64, 7300206309181072546u64, 44407437403u64)
    put(data, 1242354770412171254u64, 5999737279837044u64, 91395744977u64)
    put(data, 994838588328896609u64, 7556839307242450651u64, 209000325246u64)
    put(data, 17283309862013060457u64, 12946035041643640643u64, 126409657079u64)
    put(data, 124242522249856586u64, 15885877642352740665u64, 247701805965u64)
    put(data, 11564608014666985609u64, 10770818348246089568u64, 141861175152u64)
    put(data, 12401028575581654085u64, 11635415503599551744u64, 112583887232u64)
    put(data, 2490725392961465727u64, 6248053924100826098u64, 128630757138u64)
    put(data, 1949482237120640915u64, 16894170802729859998u64, 18338707681u64)
    put(data, 15410502396166200087u64, 6143589029651889899u64, 225915834834u64)
    put(data, 15694919529799920727u64, 11812087701837886160u64, 210333044628u64)
    put(data, 10324869370171768388u64, 7306705080150829180u64, 148640334557u64)
    put(data, 1631866459122189059u64, 1485332570280714274u64, 221396097276u64)
    put(data, 172020494461226230u64, 18042602303295630634u64, 252080520039u64)
    put(data, 12734610307908856767u64, 13397029889257074369u64, 103978091430u64)
    put(data, 1467513250829340930u64, 9948104869613411488u64, 166726254445u64)
    put(data, 13558759428494307997u64, 10836066241170646532u64, 109539287845u64)
    put(data, 7915355143999496434u64, 18330574781234459389u64, 37587424327u64)
    put(data, 2876370200608797469u64, 666297360208433062u64, 71993702450u64)
    put(data, 343685370404989503u64, 5035352224889324309u64, 50036120052u64)
    put(data, 4837266557407634630u64, 1341745796439923765u64, 244272966991u64)
    put(data, 9622591415747161468u64, 6846932182653803785u64, 79072736185u64)
    put(data, 16503783814424220982u64, 6727685027257825533u64, 185371172937u64)
    put(data, 5377083431343591334u64, 2168538874806877737u64, 73364708536u64)
    put(data, 16508482371299291595u64, 17694936100676971444u64, 184117556727u64)
    put(data, 10515883558812249028u64, 2163944241059563294u64, 247959244408u64)
    put(data, 63492062913405476u64, 6727780864524301558u64, 120117307652u64)
    put(data, 11571919759617799697u64, 8599551977795002615u64, 4364713731u64)
    put(data, 2956602334970088581u64, 15428264807806859091u64, 3466182646u64)
    put(data, 13604736747717849839u64, 2126771385339683557u64, 246836367911u64)
    put(data, 16573540719338151362u64, 15094316562082972944u64, 39115292507u64)
    put(data, 12620703004601168151u64, 8111300598225956802u64, 91818264540u64)
    put(data, 14649407809089591941u64, 9481215200564260304u64, 220439714486u64)
    put(data, 11290375247898624432u64, 16836674128623424708u64, 182513977705u64)
    put(data, 11020319450292874212u64, 7087243115299722740u64, 105912717933u64)
    put(data, 8754634933362354176u64, 2343560867338408810u64, 109384200219u64)
    put(data, 12976319450332528640u64, 3431385749090422286u64, 27127044689u64)
    put(data, 17447331119627239424u64, 3504545517469224582u64, 81186015794u64)
    put(data, 3665184902673858560u64, 3333759805712094227u64, 50189981793u64)
    put(data, 12949678516038795264u64, 3595183476205994775u64, 97180723481u64)
    put(data, 72057594037927936u64, 14191566632569921303u64, 25194895286u64)
    put(data, 0u64, 12917427671358095562u64, 182769326368u64)
    put(data, 0u64, 3883793922738316288u64, 32700255157u64)
    put(data, 0u64, 7857281689266421760u64, 181210540890u64)
    put(data, 0u64, 15987081651486195712u64, 90425944093u64)
    put(data, 0u64, 16827562156399525888u64, 29866661432u64)
    put(data, 0u64, 7012737938513461248u64, 56912223972u64)
    put(data, 0u64, 7385903388887613440u64, 228380161285u64)
    put(data, 0u64, 0u64, 5400390625u64)
    put(data, 0u64, 0u64, 225000000000u64)
    put(data, 9413159735776077452u64, 240991986u64, 0u64)
    put(data, 14279163482889998017u64, 240991986510288411u64, 0u64)
    put(data, 8693044629541194274u64, 14135788013842776187u64, 13064201u64)
    put(data, 11863110253260222498u64, 13284322918167594445u64, 9766302603u64)
    put(data, 8319293368489531245u64, 7264587765474046287u64, 139720144588u64)
    put(data, 3376307525676489265u64, 16176482219778368741u64, 204393814091u64)
    put(data, 13205662254759912523u64, 5401983818872095469u64, 75876928858u64)
    put(data, 5276250334231686323u64, 11208857446851049921u64, 90292842129u64)
    put(data, 13790198520922745052u64, 13794690008281035639u64, 145607633379u64)
    put(data, 14195535250150996227u64, 14519782740993303071u64, 227747811643u64)
    put(data, 16425228796427004035u64, 10885858587044789123u64, 59787118999u64)
    put(data, 4295900841296269186u64, 8710500938899914621u64, 151590123576u64)
    put(data, 4533952595483946442u64, 1284182587483102819u64, 56472197202u64)
    put(data, 12885038019373447184u64, 10346074482131502030u64, 82069615677u64)
    put(data, 12140736240487831910u64, 9429804686255246574u64, 61560861821u64)
    put(data, 6927124077155322074u64, 6412022633845121254u64, 125511190736u64)
    put(data, 12477788342407819890u64, 8892351297529018260u64, 208347596443u64)
    put(data, 7980854329409711087u64, 14098160105983060597u64, 155482055329u64)
    put(data, 2062671021810827996u64, 13793833029739474340u64, 161764262790u64)
    put(data, 2739521363598172769u64, 16367653765996977044u64, 134747765186u64)
    put(data, 12897585686593465638u64, 10684788343333772342u64, 194887292288u64)
    put(data, 1127632646629044686u64, 13272681218705145345u64, 128579223536u64)
    put(data, 4833775019274666364u64, 11093568615497829248u64, 240719513490u64)
    put(data, 15867662672939849256u64, 12488220765137758124u64, 146601383559u64)
    put(data, 2092350330982953557u64, 3727114642519696453u64, 135676987804u64)
    put(data, 13330062299842493592u64, 11549865375695057514u64, 156202047289u64)
    put(data, 4479193352178519263u64, 11292809154908783229u64, 57626119456u64)
    put(data, 3149393938889064983u64, 17723904861837310998u64, 32612184410u64)
    put(data, 9736379904070620767u64, 14877674388187150875u64, 90960814807u64)
    put(data, 3816238703055069186u64, 12178961950105734308u64, 215806520344u64)
    put(data, 11598915938798661975u64, 4540604068069253114u64, 24660222850u64)
    put(data, 17821633264606555643u64, 13832478722153359868u64, 130246146639u64)
    put(data, 2514623558764574316u64, 1308046668730371491u64, 79749860174u64)
    put(data, 4976730480406253215u64, 18400531023544756800u64, 78070909351u64)
    put(data, 17276563697191611637u64, 9789823458621466539u64, 167997494785u64)
    put(data, 12524734095940998814u64, 1924870562610267306u64, 1530707393u64)
    put(data, 15331551308930355164u64, 5290016144582400923u64, 193104347442u64)
    put(data, 15417115581125943816u64, 15162883663174059077u64, 50286772349u64)
    put(data, 6010750237807115593u64, 8078086116520046390u64, 125821981570u64)
    put(data, 5624630987553628432u64, 15731407332173190623u64, 130437913925u64)
    put(data, 14881848243837640704u64, 5346389182763011056u64, 69852801300u64)
    put(data, 15281613886881529856u64, 6368422217216252401u64, 20289828338u64)
    put(data, 14057902358273196032u64, 2961453088119116188u64, 242345232860u64)
    put(data, 16075318494433902592u64, 10932141691610170525u64, 220160540693u64)
    put(data, 13891916000577716224u64, 11034016191361782553u64, 21592632588u64)
    put(data, 7205759403792793600u64, 5455325785621453219u64, 12598155216u64)
    put(data, 0u64, 7735615202566149352u64, 208295733803u64)
    put(data, 0u64, 7502396497775759360u64, 43419348540u64)
    put(data, 0u64, 1601286435751591936u64, 60406705729u64)
    put(data, 0u64, 11449383158571597824u64, 65086805911u64)
    put(data, 0u64, 13043944595690356736u64, 151620672304u64)
    put(data, 0u64, 7773494431818186752u64, 48707113653u64)
    put(data, 0u64, 9943947977234055168u64, 181421401977u64)
    put(data, 0u64, 0u64, 121539062500u64)
    put(data, 0u64, 0u64, 228000000000u64)
    put(data, 4535831408134330609u64, 3677u64, 0u64)
    put(data, 6204770794376564579u64, 3677245887913u64, 0u64)
    put(data, 13869812122751887467u64, 6343817245135589714u64, 199u64)
    put(data, 14253229412394467550u64, 17549323075660516085u64, 199343899021u64)
    put(data, 12776557610216045332u64, 3948641822109421754u64, 141951350710u64)
    put(data, 16493640728678654060u64, 1750739713693534543u64, 182214056302u64)
    put(data, 9434398296825833151u64, 962163898128633415u64, 110094907790u64)
    put(data, 8773374058285327850u64, 7967320249386531212u64, 142052159009u64)
    put(data, 12932015276748029367u64, 3018466665533383224u64, 33431909296u64)
    put(data, 16293958583527755209u64, 15076865731854945472u64, 176163631405u64)
    put(data, 13511893936143127948u64, 691187172844604400u64, 45817318529u64)
    put(data, 18409936402005226436u64, 13274492813370992341u64, 129037469331u64)
    put(data, 2189663026458466887u64, 6364168818499152300u64, 147719611697u64)
    put(data, 9497725274248154664u64, 17599380787401914158u64, 49345002282u64)
    put(data, 14766925481127792125u64, 3782323149461692814u64, 42954064344u64)
    put(data, 6982373971809635814u64, 14470163442442237466u64, 216205040148u64)
    put(data, 8616702383006884794u64, 476109872130437939u64, 20784429132u64)
    put(data, 3059473300040871066u64, 16330548844673355700u64, 76025809967u64)
    put(data, 17123843157031495558u64, 14089158961463739563u64, 47885280826u64)
    put(data, 11210627174210626524u64, 13385510793074798805u64, 58763774837u64)
    put(data, 15868067138625928592u64, 1549401308746959012u64, 117725629994u64)
    put(data, 4467869511636937589u64, 4607384943843027435u64, 42083993213u64)
    put(data, 10052108125844341766u64, 5157353797716093483u64, 125249766838u64)
    put(data, 7470588003218451534u64, 10846828782671550129u64, 182279580709u64)
    put(data, 2613527085490786280u64, 9915857350819131531u64, 37588007766u64)
    put(data, 3632919450036549616u64, 1673544973504317923u64, 86537539704u64)
    put(data, 179367907231218916u64, 14780986291622785694u64, 120090723054u64)
    put(data, 13553068184555874624u64, 8168111319515466401u64, 238801278872u64)
    put(data, 8798774862365584481u64, 16345760387859734482u64, 152442794201u64)
    put(data, 910911255817064881u64, 3177475373321281805u64, 217886105446u64)
    put(data, 2304331144765093813u64, 2558676822419554038u64, 102172251285u64)
    put(data, 12248937023083640360u64, 8813474062662382873u64, 149138706148u64)
    put(data, 10206039550662130685u64, 5426294560236228430u64, 228477779386u64)
    put(data, 12267881323837852537u64, 9919177474128333040u64, 186294160017u64)
    put(data, 2858642007937891971u64, 6197383943089627371u64, 145537719688u64)
    put(data, 14171330289750320841u64, 13673239314867423997u64, 136335960856u64)
    put(data, 6601103619749017720u64, 9309584098968723946u64, 24741227788u64)
    put(data, 4919573414486739494u64, 4647101757759615504u64, 12504673565u64)
    put(data, 3401998285294974486u64, 1405809295505096753u64, 29251919891u64)
    put(data, 10799436256515532233u64, 11332704079573859112u64, 19076209074u64)
    put(data, 10083786644665753398u64, 2960072434514044308u64, 178614347119u64)
    put(data, 6481194517685688896u64, 3887266602785432801u64, 111160465848u64)
    put(data, 15104161756860547072u64, 14545546084687849554u64, 184210729144u64)
    put(data, 9556039274244079616u64, 4617763804182385321u64, 184788515633u64)
    put(data, 1376343134954323968u64, 7857823815580249095u64, 49250329477u64)
    put(data, 15682488278596976640u64, 10939326736548364798u64, 133425973482u64)
    put(data, 1506454075355430912u64, 12262012446566951953u64, 234593022090u64)
    put(data, 1152921504606846976u64, 12555024338687723023u64, 138664725026u64)
    put(data, 0u64, 3332969632922829472u64, 34680609233u64)
    put(data, 0u64, 15535060143360327680u64, 209180680645u64)
    put(data, 0u64, 15794322927987458048u64, 197842157297u64)
    put(data, 0u64, 10571474314433921024u64, 241856211961u64)
    put(data, 0u64, 16679514427547975680u64, 249573080770u64)
    put(data, 0u64, 16925653299565166592u64, 194904198288u64)
    put(data, 0u64, 16717361816799281152u64, 144917541503u64)
    put(data, 0u64, 0u64, 127906250000u64)
    put(data, 0u64, 0u64, 16000000000u64)
    put(data, 6172559441576707976u64, 56110319u64, 0u64)
    put(data, 15083329738554729992u64, 56110319334615117u64, 0u64)
    put(data, 10013126833549229036u64, 9335385384027907407u64, 3041746u64)
    put(data, 5817156823499936061u64, 13237828406194798613u64, 210506072255u64)
    put(data, 5282692560913632718u64, 15667486867836528863u64, 191717624115u64)
    put(data, 10252307034225766362u64, 17982325043592934313u64, 51849336164u64)
    put(data, 17981881283247669689u64, 17159117626917379189u64, 100974823793u64)
    put(data, 11689290159733383293u64, 8336208968408929657u64, 113930197630u64)
    put(data, 5530668968487988249u64, 12767090573379150201u64, 126451906793u64)
    put(data, 10083765740821947024u64, 14736070002412246709u64, 233692105366u64)
    put(data, 2798423656816843533u64, 9697296975344560756u64, 150798843955u64)
    put(data, 7614494481582904797u64, 7291706381199103298u64, 51525691522u64)
    put(data, 17811318500083423695u64, 18098546597780825068u64, 130395284194u64)
    put(data, 11641467412200329033u64, 132913902678533478u64, 226981124177u64)
    put(data, 17733593025296340645u64, 1879347741692007580u64, 81007205277u64)
    put(data, 3689424000190644835u64, 4056624629214083684u64, 157101879645u64)
    put(data, 14966634145516728506u64, 14713227692042795499u64, 93219910061u64)
    put(data, 14171681941562070109u64, 7366415124022528526u64, 173797605671u64)
    put(data, 8130575762882608170u64, 825770353378039393u64, 39399334164u64)
    put(data, 5234550794400656856u64, 10244023944395357795u64, 20044765100u64)
    put(data, 3020576149360486378u64, 14302658294713551167u64, 172555329650u64)
    put(data, 3038675756589057221u64, 14246653166206862817u64, 114775348659u64)
    put(data, 15470260187120878369u64, 12404486258134291102u64, 179772312615u64)
    put(data, 3497929414841828746u64, 8887442218637942533u64, 39672448547u64)
    put(data, 9935840636861015305u64, 1186724038081863005u64, 35481789208u64)
    put(data, 3647355485153741471u64, 211331772484951576u64, 24064332439u64)
    put(data, 766100215038272793u64, 6311919513247413649u64, 151011456318u64)
    put(data, 16128087474216800751u64, 8131780018703965703u64, 62342169842u64)
    put(data, 16216631732633731297u64, 2262544347226725725u64, 242440824678u64)
    put(data, 13760220872779997335u64, 15318188749880522583u64, 102122652774u64)
    put(data, 3826276262374222087u64, 1073117094162650652u64, 102830400676u64)
    put(data, 14938032745839181005u64, 4447950380665871747u64, 164058173794u64)
    put(data, 14479259995009508865u64, 5373227185066463609u64, 98241123873u64)
    put(data, 2372033248156102437u64, 6739731406934274193u64, 33291283229u64)
    put(data, 792005346826701645u64, 12328812617001239444u64, 29365361571u64)
    put(data, 16278924527931792559u64, 3246111484407310759u64, 163668346271u64)
    put(data, 17442516423538940144u64, 3250825415176839770u64, 159175972056u64)
    put(data, 13844184233048446u64, 16146270540000862342u64, 216176227598u64)
    put(data, 13486193870480782357u64, 15686773375425916830u64, 14875291079u64)
    put(data, 11931315179184648737u64, 11920791905793880226u64, 199850381688u64)
    put(data, 16492562205587485405u64, 1853290561644080707u64, 120646227424u64)
    put(data, 12128987217680380854u64, 12157689141506159076u64, 224100467082u64)
    put(data, 10568123814189138176u64, 18100318838862562546u64, 138659069648u64)
    put(data, 17007583519117541376u64, 7171257882533475139u64, 208981220250u64)
    put(data, 143791533903052800u64, 14477550873015039462u64, 154388754668u64)
    put(data, 12398714235792654336u64, 8109481182495403274u64, 236784829605u64)
    put(data, 9659957317919047680u64, 14565395719337663965u64, 165439615855u64)
    put(data, 9412523221204336640u64, 1860318978161305991u64, 111789591684u64)
    put(data, 4611686018427387904u64, 16268646275151585618u64, 132100848093u64)
    put(data, 0u64, 13759019338835519104u64, 221881925081u64)
    put(data, 0u64, 17003783176010661888u64, 217745877932u64)
    put(data, 0u64, 18357489540307877888u64, 172921776932u64)
    put(data, 0u64, 905481790074912768u64, 36995161502u64)
    put(data, 0u64, 3638882110636294144u64, 158049086266u64)
    put(data, 0u64, 9011702854368362496u64, 58197264194u64)
    put(data, 0u64, 11529215046068469760u64, 66488525390u64)
    put(data, 0u64, 0u64, 78625000000u64)
    put(data, 0u64, 0u64, 64000000000u64)
    put(data, 3237900842885170729u64, 856u64, 0u64)
    put(data, 7515893506498066595u64, 856175526956u64, 0u64)
    put(data, 7300206309181072546u64, 7625299565768063067u64, 46u64)
    put(data, 5999737279837044u64, 13889021769065194705u64, 46413368317u64)
    put(data, 7556839307242450651u64, 14498170692313014398u64, 253752925378u64)
    put(data, 12946035041643640643u64, 1541631360972245751u64, 194785947408u64)
    put(data, 15885877642352740665u64, 9903958882920799117u64, 16083572003u64)
    put(data, 10770818348246089568u64, 15744148547788062576u64, 35536894686u64)
    put(data, 11635415503599551744u64, 17936061801321712000u64, 222853492002u64)
    put(data, 6248053924100826098u64, 9986394078324430610u64, 34972315858u64)
    put(data, 16894170802729859998u64, 13849561248103430369u64, 210541363507u64)
    put(data, 6143589029651889899u64, 12142378807953854930u64, 51750786219u64)
    put(data, 11812087701837886160u64, 2513847703931031444u64, 171658239674u64)
    put(data, 7306705080150829180u64, 1752183758129038045u64, 186136275957u64)
    put(data, 1485332570280714274u64, 15824833342220556540u64, 245094986071u64)
    put(data, 18042602303295630634u64, 8168747198299470695u64, 87857865934u64)
    put(data, 13397029889257074369u64, 17414799840149357478u64, 206442828672u64)
    put(data, 9948104869613411488u64, 83147520704167789u64, 128944058191u64)
    put(data, 10836066241170646532u64, 2383542703041471269u64, 79004507436u64)
    put(data, 18330574781234459389u64, 15540952725549257799u64, 44129212108u64)
    put(data, 666297360208433062u64, 6949835416232048690u64, 204842476735u64)
    put(data, 5035352224889324309u64, 15398868937585367540u64, 191376751332u64)
    put(data, 1341745796439923765u64, 14710915985268256079u64, 228834774357u64)
    put(data, 6846932182653803785u64, 9665704836873335737u64, 85797480353u64)
    put(data, 6727685027257825533u64, 2528789298740305993u64, 161523978909u64)
    put(data, 2168538874806877737u64, 10562914675687726264u64, 157137085942u64)
    put(data, 17694936100676971444u64, 17671658300096837111u64, 246572616751u64)
    put(data, 2163944241059563294u64, 356471401631698552u64, 47957982516u64)
    put(data, 6727780864524301558u64, 7450677157218003204u64, 52019324353u64)
    put(data, 8599551977795002615u64, 317174560787152643u64, 193403902018u64)
    put(data, 15428264807806859091u64, 7251937674440720374u64, 66017194067u64)
    put(data, 2126771385339683557u64, 1252631516699038247u64, 83393128329u64)
    put(data, 15094316562082972944u64, 10818009768860843867u64, 137067905290u64)
    put(data, 8111300598225956802u64, 12330114194950162396u64, 10586445484u64)
    put(data, 9481215200564260304u64, 15826681638261168822u64, 172668416829u64)
    put(data, 16836674128623424708u64, 14240150078499211625u64, 61857966130u64)
    put(data, 7087243115299722740u64, 10725372116242125421u64, 50771960082u64)
    put(data, 2343560867338408810u64, 8434925524647833627u64, 18581423587u64)
    put(data, 3431385749090422286u64, 17133902668520348241u64, 227457258228u64)
    put(data, 3504545517469224582u64, 15093996047981365810u64, 244928830724u64)
    put(data, 3333759805712094227u64, 6187974166976813153u64, 4818247165u64)
    put(data, 3595183476205994775u64, 13946144707720259865u64, 253335450751u64)
    put(data, 14191566632569921303u64, 9138079832881862582u64, 127756022019u64)
    put(data, 12917427671358095562u64, 6600697628576225568u64, 3495376300u64)
    put(data, 3883793922738316288u64, 8137099536646556597u64, 172357824535u64)
    put(data, 7857281689266421760u64, 14169855543453903706u64, 23441113049u64)
    put(data, 15987081651486195712u64, 3706403268650100765u64, 217768149408u64)
    put(data, 16827562156399525888u64, 14736932266877982264u64, 160200924523u64)
    put(data, 7012737938513461248u64, 18004795125138956004u64, 107798890698u64)
    put(data, 7385903388887613440u64, 9068489270661002501u64, 202976041899u64)
    put(data, 0u64, 7758835715193269217u64, 171491603788u64)
    put(data, 0u64, 16943947811135261184u64, 76420607326u64)
    put(data, 0u64, 6745843108403216384u64, 94918533251u64)
    put(data, 0u64, 12338229654069444608u64, 131365692887u64)
    put(data, 0u64, 14358176069683511296u64, 215668856769u64)
    put(data, 0u64, 7083775185760813056u64, 193778358284u64)
    put(data, 0u64, 5350276357316149248u64, 12384012222u64)
    put(data, 0u64, 9223372036854775808u64, 190290039062u64)
    put(data, 0u64, 0u64, 22500000000u64)
    put(data, 14135788013842776187u64, 13064201u64, 0u64)
    put(data, 13284322918167594445u64, 13064201766302603u64, 0u64)
    put(data, 7264587765474046287u64, 14699116688460625612u64, 708211u64)
    put(data, 16176482219778368741u64, 6684126021499623499u64, 115796840712u64)
    put(data, 5401983818872095469u64, 12614606079692508506u64, 8362347197u64)
    put(data, 11208857446851049921u64, 15358270276683001489u64, 189683839165u64)
    put(data, 13794690008281035639u64, 18077126190953408995u64, 189832573499u64)
    put(data, 14519782740993303071u64, 7864121581925945659u64, 59979962974u64)
    put(data, 10885858587044789123u64, 3518026639210514839u64, 94426314885u64)
    put(data, 8710500938899914621u64, 4698310163811252280u64, 133190712606u64)
    put(data, 1284182587483102819u64, 6101155398200416338u64, 30254695904u64)
    put(data, 10346074482131502030u64, 16049178580360033341u64, 224330744296u64)
    put(data, 9429804686255246574u64, 3167464649127375997u64, 232870027714u64)
    put(data, 6412022633845121254u64, 12778923935480989904u64, 194171708602u64)
    put(data, 8892351297529018260u64, 11875553912612980379u64, 186692746854u64)
    put(data, 14098160105983060597u64, 10628760849351697057u64, 102643775067u64)
    put(data, 13793833029739474340u64, 3408944711673234310u64, 91576186280u64)
    put(data, 16367653765996977044u64, 2102091496050506178u64, 168184799263u64)
    put(data, 10684788343333772342u64, 6254611118630245760u64, 31113954608u64)
    put(data, 13272681218705145345u64, 2647941151989776368u64, 48339063148u64)
    put(data, 11093568615497829248u64, 8855437735410157458u64, 108143545177u64)
    put(data, 12488220765137758124u64, 10184270603132180103u64, 89480054241u64)
    put(data, 3727114642519696453u64, 12079083162535627164u64, 225552090415u64)
    put(data, 11549865375695057514u64, 5952952868716156729u64, 47654808410u64)
    put(data, 11292809154908783229u64, 11958907037815852320u64, 90322710221u64)
    put(data, 17723904861837310998u64, 10101562137321697626u64, 205648293649u64)
    put(data, 14877674388187150875u64, 13633527411279258327u64, 17547606780u64)
    put(data, 12178961950105734308u64, 16555627393501768728u64, 252739075001u64)
    put(data, 4540604068069253114u64, 6359650463500280706u64, 185897482359u64)
    put(data, 13832478722153359868u64, 8093923611102181967u64, 119344757342u64)
    put(data, 1308046668730371491u64, 2848827352928635726u64, 94438772478u64)
    put(data, 18400531023544756800u64, 4686723431961561511u64, 254154435240u64)
    put(data, 9789823458621466539u64, 6245554925867652609u64, 168254067786u64)
    put(data, 1924870562610267306u64, 17527406820792516033u64, 74338572210u64)
    put(data, 5290016144582400923u64, 12119966834653692210u64, 178950162627u64)
    put(data, 15162883663174059077u64, 11606502845877928061u64, 195657024718u64)
    put(data, 8078086116520046390u64, 424311496652297090u64, 206629189780u64)
    put(data, 15731407332173190623u64, 5977664048034127173u64, 148023001972u64)
    put(data, 5346389182763011056u64, 6702712461535947028u64, 116324049817u64)
    put(data, 6368422217216252401u64, 11384349854055020018u64, 153363354770u64)
    put(data, 2961453088119116188u64, 3782955013294836188u64, 146617146842u64)
    put(data, 10932141691610170525u64, 3531805968821207061u64, 218205074402u64)
    put(data, 11034016191361782553u64, 3867566898657193228u64, 226191459585u64)
    put(data, 5455325785621453219u64, 12688734637425072080u64, 1209661221u64)
    put(data, 7735615202566149352u64, 18435982764454619691u64, 37687857682u64)
    put(data, 7502396497775759360u64, 4728836163964677692u64, 18999416628u64)
    put(data, 1601286435751591936u64, 2120012917348838977u64, 52256350722u64)
    put(data, 11449383158571597824u64, 9856965465824679831u64, 2114926130u64)
    put(data, 13043944595690356736u64, 11217197671061248816u64, 50534347168u64)
    put(data, 7773494431818186752u64, 3840562972677739189u64, 160608085504u64)
    put(data, 9943947977234055168u64, 17104366978925258617u64, 208197335u64)
    put(data, 0u64, 16177877219841993444u64, 215927229591u64)
    put(data, 0u64, 7338522384267208704u64, 151877004481u64)
    put(data, 0u64, 10935240458612244480u64, 193397822095u64)
    put(data, 0u64, 1732868046462124032u64, 143592800573u64)
    put(data, 0u64, 557965042578882560u64, 61093938965u64)
    put(data, 0u64, 10454684322475540480u64, 21030247345u64)
    put(data, 0u64, 13907115649320091648u64, 177566749572u64)
    put(data, 0u64, 0u64, 132753906250u64)
    put(data, 0u64, 0u64, 74000000000u64)
    put(data, 6343817245135589714u64, 199u64, 0u64)
    put(data, 17549323075660516085u64, 199343899021u64, 0u64)
    put(data, 3948641822109421754u64, 14876458284855834550u64, 10u64)
    put(data, 1750739713693534543u64, 10450704926982265198u64, 10806454419u64)
    put(data, 962163898128633415u64, 5385653213018257806u64, 147566533849u64)
    put(data, 7967320249386531212u64, 12735569669880147489u64, 217291956845u64)
    put(data, 3018466665533383224u64, 3619762560577729456u64, 109690396615u64)
    put(data, 15076865731854945472u64, 11123448126624084269u64, 199196227721u64)
    put(data, 691187172844604400u64, 4072715118852885633u64, 137603003331u64)
    put(data, 13274492813370992341u64, 18239087231420827283u64, 195220782328u64)
    put(data, 6364168818499152300u64, 423431461216085297u64, 248988742900u64)
    put(data, 17599380787401914158u64, 9360976716520160042u64, 244022954265u64)
    put(data, 3782323149461692814u64, 11655927117263208920u64, 25507459564u64)
    put(data, 14470163442442237466u64, 2646622721938364948u64, 236631869075u64)
    put(data, 476109872130437939u64, 4496462484548171852u64, 147143473705u64)
    put(data, 16330548844673355700u64, 13140258519803350063u64, 41243753719u64)
    put(data, 14089158961463739563u64, 13089764333320627770u64, 247712334841u64)
    put(data, 13385510793074798805u64, 6926286827289840501u64, 249709597546u64)
    put(data, 1549401308746959012u64, 4985580225290866218u64, 106375474761u64)
    put(data, 4607384943843027435u64, 10478790837359789693u64, 73270268845u64)
    put(data, 5157353797716093483u64, 10041191967455692214u64, 173568056389u64)
    put(data, 10846828782671550129u64, 5035461258013813797u64, 69544334107u64)
    put(data, 9915857350819131531u64, 14208759661559249750u64, 27272972901u64)
    put(data, 1673544973504317923u64, 12347272163241758840u64, 101770258404u64)
    put(data, 14780986291622785694u64, 3372534174410277614u64, 228669346965u64)
    put(data, 8168111319515466401u64, 17226704187274712984u64, 149182825443u64)
    put(data, 16345760387859734482u64, 4250480179449852121u64, 227933861505u64)
    put(data, 3177475373321281805u64, 4303723537755414374u64, 129230418992u64)
    put(data, 2558676822419554038u64, 8680503847344854165u64, 48233305320u64)
    put(data, 8813474062662382873u64, 8817608623911079652u64, 232470571056u64)
    put(data, 5426294560236228430u64, 5692030448698539450u64, 48478003521u64)
    put(data, 9919177474128333040u64, 16908836314686769809u64, 65308565588u64)
    put(data, 6197383943089627371u64, 6073762347067727240u64, 84916629853u64)
    put(data, 13673239314867423997u64, 10931066692585106200u64, 93329259316u64)
    put(data, 9309584098968723946u64, 14466591364061539596u64, 52592574312u64)
    put(data, 4647101757759615504u64, 4958077340960173341u64, 104784235489u64)
    put(data, 1405809295505096753u64, 4076890037156765715u64, 225268777911u64)
    put(data, 11332704079573859112u64, 14083973146609179058u64, 183221008651u64)
    put(data, 2960072434514044308u64, 2565183738039805295u64, 11763493714u64)
    put(data, 3887266602785432801u64, 1482420938751351224u64, 82139058889u64)
    put(data, 14545546084687849554u64, 2151089495335413944u64, 201080362200u64)
    put(data, 4617763804182385321u64, 3738604531753220913u64, 216116610795u64)
    put(data, 7857823815580249095u64, 14195686514836005765u64, 235202670157u64)
    put(data, 10939326736548364798u64, 17808833916231796970u64, 77769549707u64)
    put(data, 12262012446566951953u64, 1302384553035657354u64, 139965418821u64)
    put(data, 12555024338687723023u64, 1672033517974833698u64, 69070602408u64)
    put(data, 3332969632922829472u64, 11673925532927662545u64, 168090641118u64)
    put(data, 15535060143360327680u64, 3905334232240480709u64, 222632844771u64)
    put(data, 15794322927987458048u64, 17411087320267472625u64, 227211708592u64)
    put(data, 10571474314433921024u64, 16573305231063706617u64, 176943856934u64)
    put(data, 16679514427547975680u64, 15481103236037148354u64, 38898440676u64)
    put(data, 16925653299565166592u64, 907440704754420880u64, 228839232288u64)
    put(data, 16717361816799281152u64, 3224970785139077759u64, 32049192459u64)
    put(data, 0u64, 10560826509734608144u64, 11174826016u64)
    put(data, 0u64, 4700940027512659968u64, 32572503552u64)
    put(data, 0u64, 9733694683502084096u64, 254838469u64)
    put(data, 0u64, 1995535635724632064u64, 197527664646u64)
    put(data, 0u64, 10629833226245373952u64, 6108178203u64)
    put(data, 0u64, 15729384648544878592u64, 27576244413u64)
    put(data, 0u64, 7205759403792793600u64, 189852691650u64)
    put(data, 0u64, 0u64, 194390625000u64)
    put(data, 0u64, 0u64, 232000000000u64)
    put(data, 9335385384027907407u64, 3041746u64, 0u64)
    put(data, 13237828406194798613u64, 3041746506072255u64, 0u64)
    put(data, 15667486867836528863u64, 7535526066623007027u64, 164893u64)
    put(data, 17982325043592934313u64, 11302146918409311588u64, 29408501686u64)
    put(data, 17159117626917379189u64, 2480833299122194801u64, 182612690612u64)
    put(data, 8336208968408929657u64, 11513226205589330558u64, 180134486242u64)
    put(data, 12767090573379150201u64, 4073957068281936105u64, 226624133243u64)
    put(data, 14736070002412246709u64, 3729887061093812886u64, 123220849655u64)
    put(data, 9697296975344560756u64, 13616911779739451443u64, 247202197582u64)
    put(data, 7291706381199103298u64, 13039053282195777666u64, 78738174266u64)
    put(data, 18098546597780825068u64, 14490756113210417890u64, 58706848494u64)
    put(data, 132913902678533478u64, 17432486112977557585u64, 238785545462u64)
    put(data, 1879347741692007580u64, 14308820825344039837u64, 246945016965u64)
    put(data, 4056624629214083684u64, 4190949538817536349u64, 133775682731u64)
    put(data, 14713227692042795499u64, 13616552502810964397u64, 171227191829u64)
    put(data, 7366415124022528526u64, 4898145803694965031u64, 21738154790u64)
    put(data, 825770353378039393u64, 1399036321001644308u64, 38265529016u64)
    put(data, 10244023944395357795u64, 17170331128243738540u64, 184075841910u64)
    put(data, 14302658294713551167u64, 10641321388205367410u64, 118930805515u64)
    put(data, 14246653166206862817u64, 6648873641312572851u64, 11576867188u64)
    put(data, 12404486258134291102u64, 5988456964560374823u64, 116360436162u64)
    put(data, 8887442218637942533u64, 9972593758348346915u64, 194324634902u64)
    put(data, 1186724038081863005u64, 16709668921872818968u64, 22540615390u64)
    put(data, 211331772484951576u64, 6094829131503407767u64, 222905832967u64)
    put(data, 6311919513247413649u64, 4892016478899926334u64, 7330401349u64)
    put(data, 8131780018703965703u64, 13150857244079031538u64, 69265196744u64)
    put(data, 2262544347226725725u64, 12983943395318785894u64, 200712909399u64)
    put(data, 15318188749880522583u64, 15341644584614757478u64, 87703860981u64)
    put(data, 1073117094162650652u64, 7507635124856644772u64, 245831672219u64)
    put(data, 4447950380665871747u64, 11619655367084544354u64, 155406989715u64)
    put(data, 5373227185066463609u64, 11553116952478783009u64, 147629902779u64)
    put(data, 6739731406934274193u64, 17392150014233193245u64, 187626295724u64)
    put(data, 12328812617001239444u64, 8877887560294980515u64, 172942830341u64)
    put(data, 3246111484407310759u64, 18404180619915609503u64, 5481271248u64)
    put(data, 3250825415176839770u64, 10079413095288181976u64, 208997692630u64)
    put(data, 16146270540000862342u64, 14102802966539105550u64, 214546406078u64)
    put(data, 15686773375425916830u64, 13333966026135891399u64, 190764514480u64)
    put(data, 11920791905793880226u64, 12344968670173516152u64, 176722835746u64)
    put(data, 1853290561644080707u64, 10577007819804726752u64, 34669222092u64)
    put(data, 12157689141506159076u64, 15337041354031088010u64, 204573380742u64)
    put(data, 18100318838862562546u64, 14333607285614673616u64, 134831422677u64)
    put(data, 7171257882533475139u64, 17171597563219696538u64, 213777026407u64)
    put(data, 14477550873015039462u64, 2849642930482147564u64, 103930874169u64)
    put(data, 8109481182495403274u64, 14791248423979435173u64, 57154479452u64)
    put(data, 14565395719337663965u64, 13882371364576310127u64, 92801835183u64)
    put(data, 1860318978161305991u64, 11735995808941329540u64, 175752564859u64)
    put(data, 16268646275151585618u64, 11376996674339273181u64, 123636209607u64)
    put(data, 13759019338835519104u64, 9849638057168043481u64, 199616748225u64)
    put(data, 17003783176010661888u64, 18241520229279361964u64, 193533949948u64)
    put(data, 18357489540307877888u64, 1865852368526961444u64, 252988874793u64)
    put(data, 905481790074912768u64, 10601487369276448158u64, 41101148059u64)
    put(data, 3638882110636294144u64, 15999931310312762170u64, 155574707781u64)
    put(data, 9011702854368362496u64, 5773775867713013570u64, 69867358014u64)
    put(data, 11529215046068469760u64, 17726239863982547534u64, 62312997016u64)
    put(data, 0u64, 9711316695888316992u64, 152960941388u64)
    put(data, 0u64, 17872002620723724288u64, 76526451532u64)
    put(data, 0u64, 7429694208660733952u64, 76968843203u64)
    put(data, 0u64, 1782821038871019520u64, 195402764530u64)
    put(data, 0u64, 3225250234313474048u64, 242096646922u64)
    put(data, 0u64, 10009250171830927360u64, 10174841165u64)
    put(data, 0u64, 1152921504606846976u64, 77542602539u64)
    put(data, 0u64, 0u64, 43062500000u64)
    put(data, 0u64, 0u64, 160000000000u64)
    put(data, 7625299565768063067u64, 46u64, 0u64)
    put(data, 13889021769065194705u64, 46413368317u64, 0u64)
    put(data, 14498170692313014398u64, 9519880170333822146u64, 2u64)
    put(data, 1541631360972245751u64, 2285186318012886800u64, 2516073738u64)
    put(data, 9903958882920799117u64, 9706420951402272035u64, 10123880198u64)
    put(data, 15744148547788062576u64, 2369632031840402142u64, 6526186134u64)
    put(data, 17936061801321712000u64, 15599123897979399458u64, 150128458009u64)
    put(data, 9986394078324430610u64, 17579576584023912658u64, 25845630200u64)
    put(data, 13849561248103430369u64, 3480927339588501811u64, 248952990756u64)
    put(data, 12142378807953854930u64, 3547346616671294635u64, 36188701449u64)
    put(data, 2513847703931031444u64, 7705317123868384954u64, 9192302045u64)
    put(data, 1752183758129038045u64, 4969425237478353909u64, 221417706078u64)
    put(data, 15824833342220556540u64, 17043246700132217175u64, 94269393081u64)
    put(data, 8168747198299470695u64, 17053788362783499470u64, 185923916254u64)
    put(data, 17414799840149357478u64, 11102988228454224768u64, 222924487719u64)
    put(data, 83147520704167789u64, 16944305387801685839u64, 39601894197u64)
    put(data, 2383542703041471269u64, 11725142977459199276u64, 53918552635u64)
    put(data, 15540952725549257799u64, 8175984171998533324u64, 59635621274u64)
    put(data, 6949835416232048690u64, 1372352885142856895u64, 154443220990u64)
    put(data, 15398868937585367540u64, 17975093466502888164u64, 254074395398u64)
    put(data, 14710915985268256079u64, 6467823391459085653u64, 6974431769u64)
    put(data, 9665704836873335737u64, 11319386883146885025u64, 25350621408u64)
    put(data, 2528789298740305993u64, 9141999262922068637u64, 224613625192u64)
    put(data, 10562914675687726264u64, 1587330393383478774u64, 104495588773u64)
    put(data, 17671658300096837111u64, 884187548095712303u64, 165086049353u64)
    put(data, 356471401631698552u64, 488841225726377268u64, 73047931903u64)
    put(data, 7450677157218003204u64, 17462624199405856193u64, 255026500135u64)
    put(data, 317174560787152643u64, 13183677579115583554u64, 39946650754u64)
    put(data, 7251937674440720374u64, 11645015818917277779u64, 130714688593u64)
    put(data, 1252631516699038247u64, 8760523002035971977u64, 81631277572u64)
    put(data, 10818009768860843867u64, 10068817678491468042u64, 4474908903u64)
    put(data, 12330114194950162396u64, 1273658177787418284u64, 231545831700u64)
    put(data, 15826681638261168822u64, 3100019384328057661u64, 20069045148u64)
    put(data, 14240150078499211625u64, 10363063568089458738u64, 156168052387u64)
    put(data, 10725372116242125421u64, 13030756371481403666u64, 163561782801u64)
    put(data, 8434925524647833627u64, 6538878900684195299u64, 17706398718u64)
    put(data, 17133902668520348241u64, 8984884716779098868u64, 254354473335u64)
    put(data, 15093996047981365810u64, 8728727397070363908u64, 119487071576u64)
    put(data, 6187974166976813153u64, 6398650562917867005u64, 88473185260u64)
    put(data, 13946144707720259865u64, 1190873176164938879u64, 236346871542u64)
    put(data, 9138079832881862582u64, 4383628525805121795u64, 246064557364u64)
    put(data, 6600697628576225568u64, 10189374699734119852u64, 52237636978u64)
    put(data, 8137099536646556597u64, 5276291920541626391u64, 114552367109u64)
    put(data, 14169855543453903706u64, 2692252373800386521u64, 5286028358u64)
    put(data, 3706403268650100765u64, 11578684995169173920u64, 70145947293u64)
    put(data, 14736932266877982264u64, 5799408022254132587u64, 157627681771u64)
    put(data, 18004795125138956004u64, 15548569837712345290u64, 235314386538u64)
    put(data, 9068489270661002501u64, 15763030464322902955u64, 106842889659u64)
    put(data, 7758835715193269217u64, 13257749746581255500u64, 187854515593u64)
    put(data, 16943947811135261184u64, 16152470009188707678u64, 137718704053u64)
    put(data, 6745843108403216384u64, 13806790848493904003u64, 181875627153u64)
    put(data, 12338229654069444608u64, 11981226523265951191u64, 145748467631u64)
    put(data, 14358176069683511296u64, 5133628726077003713u64, 175649503591u64)
    put(data, 7083775185760813056u64, 16183955741910833164u64, 103278294570u64)
    put(data, 5350276357316149248u64, 13640425554331371454u64, 42877333998u64)
    put(data, 9223372036854775808u64, 18108120906868035862u64, 238739448950u64)
    put(data, 0u64, 6324011669895037184u64, 118981643201u64)
    put(data, 0u64, 10444437689515769856u64, 193342825359u64)
    put(data, 0u64, 12324712543665782784u64, 143566194101u64)
    put(data, 0u64, 13928941951563857920u64, 181668124005u64)
    put(data, 0u64, 3975288688270639104u64, 101755089456u64)
    put(data, 0u64, 11141905478114607104u64, 48215500831u64)
    put(data, 0u64, 4611686018427387904u64, 31604003906u64)
    put(data, 0u64, 0u64, 66250000000u64)
    put(data, 0u64, 0u64, 128000000000u64)
    put(data, 14699116688460625612u64, 708211u64, 0u64)
    put(data, 6684126021499623499u64, 708211796840712u64, 0u64)
    put(data, 12614606079692508506u64, 4398362855256705725u64, 38392u64)
    put(data, 15358270276683001489u64, 2812083125569302717u64, 248238435728u64)
    put(data, 18077126190953408995u64, 12868509142973100603u64, 144152443331u64)
    put(data, 7864121581925945659u64, 8726243776748165726u64, 195697603278u64)
    put(data, 3518026639210514839u64, 358304413426858117u64, 206473050623u64)
    put(data, 4698310163811252280u64, 3180720351566429470u64, 255019423721u64)
    put(data, 6101155398200416338u64, 14053818240400098784u64, 233172427195u64)
    put(data, 16049178580360033341u64, 7340140541492429288u64, 187761859013u64)
    put(data, 3167464649127375997u64, 1323571167904965058u64, 197397909816u64)
    put(data, 12778923935480989904u64, 14463851737583396026u64, 56071750936u64)
    put(data, 11875553912612980379u64, 15122784818916048486u64, 24784086973u64)
    put(data, 10628760849351697057u64, 13557974621377508955u64, 189819807807u64)
    put(data, 3408944711673234310u64, 17525172074563876264u64, 63734979276u64)
    put(data, 2102091496050506178u64, 15148880683074215967u64, 204950041481u64)
    put(data, 6254611118630245760u64, 6744828147558597936u64, 137821222467u64)
    put(data, 2647941151989776368u64, 9799290779647971692u64, 67365637866u64)
    put(data, 8855437735410157458u64, 11170890203898678105u64, 234531220617u64)
    put(data, 10184270603132180103u64, 7068779781287527905u64, 137605575171u64)
    put(data, 12079083162535627164u64, 14474741922505540911u64, 3383199319u64)
    put(data, 5952952868716156729u64, 17107062680405191514u64, 87784677331u64)
    put(data, 11958907037815852320u64, 2712598571300237005u64, 211927375726u64)
    put(data, 10101562137321697626u64, 3767556054903418641u64, 110147050263u64)
    put(data, 13633527411279258327u64, 18158239681706277628u64, 23204239622u64)
    put(data, 16555627393501768728u64, 10531652712128330681u64, 6984360145u64)
    put(data, 6359650463500280706u64, 9548395326934120567u64, 209570922037u64)
    put(data, 8093923611102181967u64, 15875647850297719390u64, 53517619547u64)
    put(data, 2848827352928635726u64, 8215825295203192574u64, 91860620594u64)
    put(data, 4686723431961561511u64, 12747310908260543144u64, 50445380781u64)
    put(data, 6245554925867652609u64, 77706528053613642u64, 173691033109u64)
    put(data, 17527406820792516033u64, 6024737704056756146u64, 21004212479u64)
    put(data, 12119966834653692210u64, 6819452388570089667u64, 255326601685u64)
    put(data, 11606502845877928061u64, 13695926775373186254u64, 213369683254u64)
    put(data, 424311496652297090u64, 3746531715392682132u64, 54742457678u64)
    put(data, 5977664048034127173u64, 4717376233154528116u64, 78203099891u64)
    put(data, 6702712461535947028u64, 385190957950313369u64, 243255729478u64)
    put(data, 11384349854055020018u64, 12388374310648616082u64, 70020881243u64)
    put(data, 3782955013294836188u64, 1078067332084407770u64, 91671575117u64)
    put(data, 3531805968821207061u64, 3257295319358714850u64, 77058442147u64)
    put(data, 3867566898657193228u64, 1545453099660723457u64, 163176578333u64)
    put(data, 12688734637425072080u64, 7495477664653506341u64, 29083779180u64)
    put(data, 18435982764454619691u64, 7225503732673614354u64, 108406330658u64)
    put(data, 4728836163964677692u64, 3935478326103643956u64, 34391695342u64)
    put(data, 2120012917348838977u64, 10082240682742686210u64, 238213342707u64)
    put(data, 9856965465824679831u64, 10838712705567897138u64, 243546559362u64)
    put(data, 11217197671061248816u64, 2142546572501643680u64, 130587567793u64)
    put(data, 3840562972677739189u64, 7893042119150331392u64, 177116147682u64)
    put(data, 17104366978925258617u64, 12084811642251302615u64, 226427882670u64)
    put(data, 16177877219841993444u64, 15317234482572954775u64, 174655118951u64)
    put(data, 7338522384267208704u64, 2283226355108359361u64, 103830348945u64)
    put(data, 10935240458612244480u64, 13359725152575722127u64, 145123773948u64)
    put(data, 1732868046462124032u64, 13126551011491594557u64, 252724232151u64)
    put(data, 557965042578882560u64, 3598021288691861269u64, 215711591756u64)
    put(data, 10454684322475540480u64, 16462621795896662961u64, 76195049124u64)
    put(data, 13907115649320091648u64, 14682112756964627332u64, 164892440515u64)
    put(data, 0u64, 7174112100896070218u64, 195795918927u64)
    put(data, 0u64, 5023109019590616064u64, 79388909396u64)
    put(data, 0u64, 10765223023086141440u64, 84272303285u64)
    put(data, 0u64, 8228137177297453056u64, 181583583909u64)
    put(data, 0u64, 2891199497780592640u64, 165446048210u64)
    put(data, 0u64, 15294857653247803392u64, 210156732238u64)
    put(data, 0u64, 14303432416528695296u64, 78829135894u64)
    put(data, 0u64, 0u64, 22775390625u64)
    put(data, 0u64, 0u64, 161000000000u64)
    put(data, 14876458284855834550u64, 10u64, 0u64)
    put(data, 10450704926982265198u64, 10806454419u64, 0u64)
    put(data, 5385653213018257806u64, 10806454419566533849u64, 0u64)
    put(data, 12735569669880147489u64, 17118225092618494573u64, 585819067u64)
    put(data, 3619762560577729456u64, 13385738875341807559u64, 187927980841u64)
    put(data, 11123448126624084269u64, 8272682717439277193u64, 41725642358u64)
    put(data, 4072715118852885633u64, 13402436483369350083u64, 118448463028u64)
    put(data, 18239087231420827283u64, 10946328903241612536u64, 180726547537u64)
    put(data, 423431461216085297u64, 16265808923426731252u64, 81593401678u64)
    put(data, 9360976716520160042u64, 11080374459871185177u64, 78881771268u64)
    put(data, 11655927117263208920u64, 1240761893433831916u64, 4600668303u64)
    put(data, 2646622721938364948u64, 367264070493390483u64, 143067261837u64)
    put(data, 4496462484548171852u64, 2863675693461092905u64, 141019909425u64)
    put(data, 13140258519803350063u64, 7511929581752138999u64, 49155240170u64)
    put(data, 13089764333320627770u64, 11154557789993845753u64, 234407222518u64)
    put(data, 6926286827289840501u64, 8325416539745948522u64, 246604689789u64)
    put(data, 4985580225290866218u64, 17745129874679852617u64, 125451321734u64)
    put(data, 10478790837359789693u64, 1074820986392253357u64, 134961965418u64)
    put(data, 10041191967455692214u64, 7820952682162838597u64, 106058266162u64)
    put(data, 5035461258013813797u64, 8215518006273528603u64, 50423974694u64)
    put(data, 14208759661559249750u64, 9680426791089900133u64, 38445364123u64)
    put(data, 12347272163241758840u64, 16128495723604797412u64, 155524776987u64)
    put(data, 3372534174410277614u64, 2264789053583348885u64, 27874327505u64)
    put(data, 17226704187274712984u64, 11175458488686298083u64, 209122774460u64)
    put(data, 4250480179449852121u64, 11026777810412287617u64, 188605822818u64)
    put(data, 4303723537755414374u64, 16199890034895598640u64, 98597762822u64)
    put(data, 8680503847344854165u64, 9094320719494763752u64, 6878197798u64)
    put(data, 8817608623911079652u64, 1250835564687222832u64, 38493004114u64)
    put(data, 5692030448698539450u64, 15362466642459337025u64, 82067807931u64)
    put(data, 16908836314686769809u64, 7831109835595423828u64, 187832800985u64)
    put(data, 6073762347067727240u64, 15426237284335022429u64, 217424525314u64)
    put(data, 10931066692585106200u64, 15636308361455434548u64, 2836257998u64)
    put(data, 14466591364061539596u64, 13967173875944980328u64, 206847645974u64)
    put(data, 4958077340960173341u64, 18245979923595824097u64, 22757162012u64)
    put(data, 4076890037156765715u64, 11335054479675278263u64, 28989116553u64)
    put(data, 14083973146609179058u64, 11165339882630461707u64, 137614474534u64)
    put(data, 2565183738039805295u64, 15944437408299395922u64, 38605274287u64)
    put(data, 1482420938751351224u64, 15806416348777321161u64, 175864349683u64)
    put(data, 2151089495335413944u64, 4201030477408556248u64, 243856867547u64)
    put(data, 3738604531753220913u64, 9485474942554588907u64, 219227738318u64)
    put(data, 14195686514836005765u64, 18238757647663230541u64, 206514208626u64)
    put(data, 17808833916231796970u64, 4642199687824746379u64, 114988725033u64)
    put(data, 1302384553035657354u64, 6134575894869364037u64, 41251654149u64)
    put(data, 1672033517974833698u64, 11524208547121316008u64, 5332556025u64)
    put(data, 11673925532927662545u64, 2734683241527878366u64, 249624728597u64)
    put(data, 3905334232240480709u64, 10629223456178675171u64, 21148247475u64)
    put(data, 17411087320267472625u64, 2788042336985254064u64, 179576211358u64)
    put(data, 16573305231063706617u64, 17285498758066142502u64, 158151140077u64)
    put(data, 15481103236037148354u64, 5525538192421886436u64, 237937048765u64)
    put(data, 907440704754420880u64, 11414325503043801888u64, 189299540025u64)
    put(data, 3224970785139077759u64, 7246608114685173259u64, 57618771825u64)
    put(data, 10560826509734608144u64, 1007884269852184608u64, 113392839413u64)
    put(data, 4700940027512659968u64, 13823717876510029312u64, 245054637515u64)
    put(data, 9733694683502084096u64, 12487410768239429317u64, 203749385247u64)
    put(data, 1995535635724632064u64, 3361062421598631942u64, 31676943894u64)
    put(data, 10629833226245373952u64, 17853337379088328475u64, 22182203558u64)
    put(data, 15729384648544878592u64, 11551561037491869885u64, 166967831358u64)
    put(data, 7205759403792793600u64, 11480877996635204802u64, 62626211378u64)
    put(data, 0u64, 5527488381934471912u64, 50622379643u64)
    put(data, 0u64, 11143438404407726080u64, 123299645745u64)
    put(data, 0u64, 6472279730688098304u64, 49604087006u64)
    put(data, 0u64, 4561816853579563008u64, 222350862987u64)
    put(data, 0u64, 2888714464062865408u64, 139247296587u64)
    put(data, 0u64, 16258276129784201216u64, 75156597524u64)
    put(data, 0u64, 720575940379279360u64, 20881362915u64)
    put(data, 0u64, 0u64, 227039062500u64)
    put(data, 0u64, 0u64, 228000000000u64)
    put(data, 7535526066623007027u64, 164893u64, 0u64)
    put(data, 11302146918409311588u64, 164893408501686u64, 0u64)
    put(data, 2480833299122194801u64, 16409970870640346804u64, 8938u64)
    put(data, 11513226205589330558u64, 7721907286269370594u64, 234889586303u64)
    put(data, 4073957068281936105u64, 14300743897882155131u64, 127418605432u64)
    put(data, 3729887061093812886u64, 2068482633821123575u64, 120775244880u64)
    put(data, 13616911779739451443u64, 4922882895416406094u64, 80112132668u64)
    put(data, 13039053282195777666u64, 9317632875623428410u64, 60266870016u64)
    put(data, 14490756113210417890u64, 5693844901999766254u64, 505109890u64)
    put(data, 17432486112977557585u64, 11569484900262102262u64, 130308663950u64)
    put(data, 14308820825344039837u64, 3138170119352085637u64, 142627183033u64)
    put(data, 4190949538817536349u64, 950584692575235243u64, 185170120543u64)
    put(data, 13616552502810964397u64, 8136430299747162645u64, 95051531299u64)
    put(data, 4898145803694965031u64, 6698711700804594470u64, 35441076770u64)
    put(data, 1399036321001644308u64, 17401191571004302008u64, 34363137888u64)
    put(data, 17170331128243738540u64, 4721732028538188150u64, 96943320485u64)
    put(data, 10641321388205367410u64, 2984214103553086219u64, 165255965606u64)
    put(data, 6648873641312572851u64, 13128675202005662068u64, 166161774570u64)
    put(data, 5988456964560374823u64, 14638512997670672834u64, 234711706908u64)
    put(data, 9972593758348346915u64, 12942085665769692438u64, 28793555379u64)
    put(data, 16709668921872818968u64, 14131134357119205086u64, 179701591869u64)
    put(data, 6094829131503407767u64, 8921946894736102919u64, 61766050328u64)
    put(data, 4892016478899926334u64, 5601522560505809989u64, 24483659710u64)
    put(data, 13150857244079031538u64, 8602606493507716808u64, 190303659146u64)
    put(data, 12983943395318785894u64, 8576789731078566487u64, 138466348232u64)
    put(data, 15341644584614757478u64, 17881118138842658549u64, 200464948702u64)
    put(data, 7507635124856644772u64, 11624372674432704923u64, 222969337356u64)
    put(data, 11619655367084544354u64, 6826284072848095635u64, 12630158505u64)
    put(data, 11553116952478783009u64, 1646466632033733563u64, 169370053601u64)
    put(data, 17392150014233193245u64, 17871081657060299180u64, 225089255134u64)
    put(data, 8877887560294980515u64, 15910893124677544709u64, 222968793277u64)
    put(data, 18404180619915609503u64, 11031217459450580944u64, 189862531244u64)
    put(data, 10079413095288181976u64, 13554987390037243094u64, 172598003496u64)
    put(data, 14102802966539105550u64, 15026714590903687870u64, 40734817338u64)
    put(data, 13333966026135891399u64, 4406379654994689200u64, 58814599830u64)
    put(data, 12344968670173516152u64, 13596329092861950242u64, 150238870319u64)
    put(data, 10577007819804726752u64, 284812388227373260u64, 47737058477u64)
    put(data, 15337041354031088010u64, 9285079159392309382u64, 173015439710u64)
    put(data, 14333607285614673616u64, 15046108141952711893u64, 94503345149u64)
    put(data, 17171597563219696538u64, 13795366909944958311u64, 253815651156u64)
    put(data, 2849642930482147564u64, 12909920641180059961u64, 84747848338u64)
    put(data, 14791248423979435173u64, 5333762939889788252u64, 146699848200u64)
    put(data, 13882371364576310127u64, 6411331390005944495u64, 8289143868u64)
    put(data, 11735995808941329540u64, 1447104583224217723u64, 60347558971u64)
    put(data, 11376996674339273181u64, 11940049226167932871u64, 59078447696u64)
    put(data, 9849638057168043481u64, 9772290783590472385u64, 80647271365u64)
    put(data, 18241520229279361964u64, 16351989577831528444u64, 197529756944u64)
    put(data, 1865852368526961444u64, 4376738725895725097u64, 16886443131u64)
    put(data, 10601487369276448158u64, 13851276297739812763u64, 123237263481u64)
    put(data, 15999931310312762170u64, 12641996203470333509u64, 121750879192u64)
    put(data, 5773775867713013570u64, 7707081716407945022u64, 216685323987u64)
    put(data, 17726239863982547534u64, 417638323657040024u64, 211417801737u64)
    put(data, 9711316695888316992u64, 16438047707692449100u64, 9022640218u64)
    put(data, 17872002620723724288u64, 14850108107043306316u64, 90891108351u64)
    put(data, 7429694208660733952u64, 10423290807904720835u64, 255805025973u64)
    put(data, 1782821038871019520u64, 16951162310302339314u64, 181565047726u64)
    put(data, 3225250234313474048u64, 2752437506572397322u64, 174918924350u64)
    put(data, 10009250171830927360u64, 3925815842962784589u64, 62149209936u64)
    put(data, 1152921504606846976u64, 5274166674003605291u64, 80212818903u64)
    put(data, 0u64, 5538963350863452832u64, 215285913148u64)
    put(data, 0u64, 16900671634439028736u64, 60300267804u64)
    put(data, 0u64, 2326997710751662080u64, 28916187245u64)
    put(data, 0u64, 12327726161625874432u64, 109126146798u64)
    put(data, 0u64, 5756455743825903616u64, 238668287374u64)
    put(data, 0u64, 3018537650245074944u64, 142312058091u64)
    put(data, 0u64, 16717361816799281152u64, 235163635253u64)
    put(data, 0u64, 0u64, 53906250000u64)
    put(data, 0u64, 0u64, 16000000000u64)
    put(data, 2285186318012886800u64, 2516073738u64, 0u64)
    put(data, 9706420951402272035u64, 2516073738123880198u64, 0u64)
    put(data, 2369632031840402142u64, 11997425759292732054u64, 136396630u64)
    put(data, 15599123897979399458u64, 11491152661270395161u64, 86650381753u64)
    put(data, 17579576584023912658u64, 18181063258234881272u64, 185622936633u64)
    put(data, 3480927339588501811u64, 2466921813123869732u64, 57985597414u64)
    put(data, 3547346616671294635u64, 8430880678232179465u64, 230133732099u64)
    put(data, 7705317123868384954u64, 6738034873677997533u64, 3457038957u64)
    put(data, 4969425237478353909u64, 7678250951042929246u64, 109365269602u64)
    put(data, 17043246700132217175u64, 1853560606315563193u64, 98416238818u64)
    put(data, 17053788362783499470u64, 14942676593409905118u64, 226100481721u64)
    put(data, 11102988228454224768u64, 4909892170837638183u64, 185810044121u64)
    put(data, 16944305387801685839u64, 16871149368312132405u64, 217266165787u64)
    put(data, 11725142977459199276u64, 16096130589333770811u64, 27914586839u64)
    put(data, 8175984171998533324u64, 12512479187631824282u64, 215872572987u64)
    put(data, 1372352885142856895u64, 16980304980540557310u64, 59678302855u64)
    put(data, 17975093466502888164u64, 8640919162749295366u64, 135920504177u64)
    put(data, 6467823391459085653u64, 7862382415464063513u64, 113468425166u64)
    put(data, 11319386883146885025u64, 14534157903009925344u64, 206426220604u64)
    put(data, 9141999262922068637u64, 12627464554215107944u64, 60787898278u64)
    put(data, 1587330393383478774u64, 2456849734836299173u64, 166684536225u64)
    put(data, 884187548095712303u64, 18428252197697827913u64, 161133186090u64)
    put(data, 488841225726377268u64, 7244734215936736255u64, 42998997553u64)
    put(data, 17462624199405856193u64, 14756175050504770087u64, 49392737828u64)
    put(data, 13183677579115583554u64, 6764116534566945922u64, 36799933852u64)
    put(data, 11645015818917277779u64, 1588822142405565521u64, 156366683492u64)
    put(data, 8760523002035971977u64, 17053265624843842052u64, 100086130220u64)
    put(data, 10068817678491468042u64, 16996891591759999207u64, 44924459381u64)
    put(data, 1273658177787418284u64, 8565556232370585876u64, 117921403339u64)
    put(data, 3100019384328057661u64, 14464960359145886620u64, 203464339733u64)
    put(data, 10363063568089458738u64, 5813189542048784035u64, 21784147072u64)
    put(data, 13030756371481403666u64, 9739241026882027025u64, 128315133636u64)
    put(data, 6538878900684195299u64, 18175068535675302910u64, 196527965313u64)
    put(data, 8984884716779098868u64, 10562697212061761911u64, 129985272439u64)
    put(data, 8728727397070363908u64, 4264834835660801368u64, 119572604963u64)
    put(data, 6398650562917867005u64, 13019066443690126316u64, 35231197159u64)
    put(data, 1190873176164938879u64, 1828040177823321846u64, 231705765006u64)
    put(data, 4383628525805121795u64, 11240369830376975668u64, 142099098256u64)
    put(data, 10189374699734119852u64, 8886938465302549874u64, 144609341669u64)
    put(data, 5276291920541626391u64, 9985240313589688325u64, 229481761899u64)
    put(data, 2692252373800386521u64, 722909126956573766u64, 107541300962u64)
    put(data, 11578684995169173920u64, 5493363474638452381u64, 226039188982u64)
    put(data, 5799408022254132587u64, 12410535279213120491u64, 246297795830u64)
    put(data, 15548569837712345290u64, 10543108918366869098u64, 246672776465u64)
    put(data, 15763030464322902955u64, 12953909016524823995u64, 17571543079u64)
    put(data, 13257749746581255500u64, 16505942145872588169u64, 39702232814u64)
    put(data, 16152470009188707678u64, 12428594380392015797u64, 238894788916u64)
    put(data, 13806790848493904003u64, 7528259605829768337u64, 52673755451u64)
    put(data, 11981226523265951191u64, 18147447600042811311u64, 59408107770u64)
    put(data, 5133628726077003713u64, 12021069431116183911u64, 250983775105u64)
    put(data, 16183955741910833164u64, 11819985069665662506u64, 129651663479u64)
    put(data, 13640425554331371454u64, 10401877114068152814u64, 119640762674u64)
    put(data, 18108120906868035862u64, 4611631138117837942u64, 50563886888u64)
    put(data, 6324011669895037184u64, 17200813398607252417u64, 40249997024u64)
    put(data, 10444437689515769856u64, 14100466137553658767u64, 224932457962u64)
    put(data, 12324712543665782784u64, 17887776768825509301u64, 234764387800u64)
    put(data, 13928941951563857920u64, 12632656857970087269u64, 216969698321u64)
    put(data, 3975288688270639104u64, 8923681664054686256u64, 17684817700u64)
    put(data, 11141905478114607104u64, 6213926103737837599u64, 36483753752u64)
    put(data, 4611686018427387904u64, 1233118281776157762u64, 24336857609u64)
    put(data, 0u64, 30716279628678784u64, 9066847476u64)
    put(data, 0u64, 15775734650898546688u64, 244001665132u64)
    put(data, 0u64, 976806005729918976u64, 108855204289u64)
    put(data, 0u64, 12460098853279891456u64, 193052952759u64)
    put(data, 0u64, 5635665595421687808u64, 183675463312u64)
    put(data, 0u64, 1805943450575568896u64, 144305510044u64)
    put(data, 0u64, 11529215046068469760u64, 156097900390u64)
    put(data, 0u64, 0u64, 102625000000u64)
    put(data, 0u64, 0u64, 64000000000u64)
    put(data, 4398362855256705725u64, 38392u64, 0u64)
    put(data, 2812083125569302717u64, 38392238435728u64, 0u64)
    put(data, 12868509142973100603u64, 4564018338575530435u64, 2081u64)
    put(data, 8726243776748165726u64, 16553437246451512014u64, 33247415929u64)
    put(data, 358304413426858117u64, 4339777136957372927u64, 121897363631u64)
    put(data, 3180720351566429470u64, 18439463366554654697u64, 175235259789u64)
    put(data, 14053818240400098784u64, 1370067356680643003u64, 141999605312u64)
    put(data, 7340140541492429288u64, 4210124040914115013u64, 64074271500u64)
    put(data, 1323571167904965058u64, 10692225626142609720u64, 12228231281u64)
    put(data, 14463851737583396026u64, 11592856673895384344u64, 113579626712u64)
    put(data, 15122784818916048486u64, 10284479231227406269u64, 216628450019u64)
    put(data, 13557974621377508955u64, 4961071383534266431u64, 227557522736u64)
    put(data, 17525172074563876264u64, 10960611551445686988u64, 48268940218u64)
    put(data, 15148880683074215967u64, 14616396723115619209u64, 186594175942u64)
    put(data, 6744828147558597936u64, 1025604265437492803u64, 198792356454u64)
    put(data, 9799290779647971692u64, 11711588454892179178u64, 102055598118u64)
    put(data, 11170890203898678105u64, 5580373263251565705u64, 38634886482u64)
    put(data, 7068779781287527905u64, 14109334653033148931u64, 82302512640u64)
    put(data, 14474741922505540911u64, 2899414033769399895u64, 764868564u64)
    put(data, 17107062680405191514u64, 13233457234892808147u64, 212157177549u64)
    put(data, 2712598571300237005u64, 3287946691509034862u64, 205717387154u64)
    put(data, 3767556054903418641u64, 5488480288717445911u64, 146178239947u64)
    put(data, 18158239681706277628u64, 11687233053874362630u64, 203297531112u64)
    put(data, 10531652712128330681u64, 6783772100089274577u64, 232633566173u64)
    put(data, 9548395326934120567u64, 7898291058728402485u64, 221367749022u64)
    put(data, 15875647850297719390u64, 4423684977486598491u64, 158428167216u64)
    put(data, 8215825295203192574u64, 2750833684599526706u64, 48239808443u64)
    put(data, 12747310908260543144u64, 15669689830489025709u64, 187149122992u64)
    put(data, 77706528053613642u64, 15117307274214954517u64, 176849455587u64)
    put(data, 6024737704056756146u64, 8148639818575698175u64, 227819510869u64)
    put(data, 6819452388570089667u64, 13006484426078994901u64, 85441738649u64)
    put(data, 13695926775373186254u64, 10287496057845513526u64, 153705082933u64)
    put(data, 3746531715392682132u64, 14159876032966532430u64, 53557686278u64)
    put(data, 4717376233154528116u64, 15742212196465548019u64, 6767608417u64)
    put(data, 385190957950313369u64, 2892220461917134150u64, 97853387033u64)
    put(data, 12388374310648616082u64, 7487151560715393883u64, 25156787585u64)
    put(data, 1078067332084407770u64, 7245756744165177933u64, 129405879299u64)
    put(data, 3257295319358714850u64, 3067122860671533987u64, 3392793260u64)
    put(data, 1545453099660723457u64, 8135043905834122525u64, 172166269063u64)
    put(data, 7495477664653506341u64, 14730019368921022572u64, 135441001613u64)
    put(data, 7225503732673614354u64, 495969939682055458u64, 141798515950u64)
    put(data, 3935478326103643956u64, 5617761407265775598u64, 238026886584u64)
    put(data, 10082240682742686210u64, 2087044847072781811u64, 184304539456u64)
    put(data, 10838712705567897138u64, 15929674232061203330u64, 64113138927u64)
    put(data, 2142546572501643680u64, 8658086469608285873u64, 239863549370u64)
    put(data, 7893042119150331392u64, 18369871790780313570u64, 186469355807u64)
    put(data, 12084811642251302615u64, 3545648451947416750u64, 31995832745u64)
    put(data, 15317234482572954775u64, 13347376792767929959u64, 169192209987u64)
    put(data, 2283226355108359361u64, 14482164459838203025u64, 67723562745u64)
    put(data, 13359725152575722127u64, 8899577765623565820u64, 249785079708u64)
    put(data, 13126551011491594557u64, 7095320096604405719u64, 156482447077u64)
    put(data, 3598021288691861269u64, 2968593824439315788u64, 229384638073u64)
    put(data, 16462621795896662961u64, 12621408323612585636u64, 121160927793u64)
    put(data, 14682112756964627332u64, 3954422936414648259u64, 49684207916u64)
    put(data, 7174112100896070218u64, 17143730087577690191u64, 44214369696u64)
    put(data, 5023109019590616064u64, 5033045529399041876u64, 160929363470u64)
    put(data, 10765223023086141440u64, 15857648521994521781u64, 14272841944u64)
    put(data, 8228137177297453056u64, 16655573486499109541u64, 216859644848u64)
    put(data, 2891199497780592640u64, 16652154439190075858u64, 176902900447u64)
    put(data, 15294857653247803392u64, 18016950600164130638u64, 223902715100u64)
    put(data, 14303432416528695296u64, 2086292996072613910u64, 220976700849u64)
    put(data, 0u64, 17324462585194799521u64, 177113098169u64)
    put(data, 0u64, 11079151463184927232u64, 185939160998u64)
    put(data, 0u64, 5239846817488961536u64, 166600602004u64)
    put(data, 0u64, 2778806963520143360u64, 148284052665u64)
    put(data, 0u64, 6240890740138835968u64, 185150639427u64)
    put(data, 0u64, 17250651344549707776u64, 67338319364u64)
    put(data, 0u64, 4197354852709302272u64, 4935159683u64)
    put(data, 0u64, 9223372036854775808u64, 131227539062u64)
    put(data, 0u64, 0u64, 118500000000u64)
    put(data, 17118225092618494573u64, 585819067u64, 0u64)
    put(data, 13385738875341807559u64, 585819067927980841u64, 0u64)
    put(data, 8272682717439277193u64, 5654803392547571318u64, 31757315u64)
    put(data, 13402436483369350083u64, 2931628102185393332u64, 3306547506u64)
    put(data, 10946328903241612536u64, 15964697617980212305u64, 50158923877u64)
    put(data, 16265808923426731252u64, 450380868305846606u64, 101865447992u64)
    put(data, 11080374459871185177u64, 14631133530814566148u64, 56024415195u64)
    put(data, 1240761893433831916u64, 31969822783742095u64, 219793155338u64)
    put(data, 367264070493390483u64, 10437269029385743245u64, 10001733087u64)
    put(data, 2863675693461092905u64, 15196146496377392433u64, 223565805487u64)
    put(data, 7511929581752138999u64, 4409099735137480938u64, 175823784752u64)
    put(data, 11154557789993845753u64, 10644987914903248118u64, 48239017775u64)
    put(data, 8325416539745948522u64, 3154431617534062973u64, 47577065951u64)
    put(data, 17745129874679852617u64, 11702056331247960454u64, 223171002080u64)
    put(data, 1074820986392253357u64, 15575315065965259114u64, 224634369744u64)
    put(data, 7820952682162838597u64, 10759747609480050226u64, 208844339521u64)
    put(data, 8215518006273528603u64, 12538236653960743718u64, 65583287086u64)
    put(data, 9680426791089900133u64, 17857942663978005403u64, 46679699170u64)
    put(data, 16128495723604797412u64, 11443004154750813211u64, 226968081011u64)
    put(data, 2264789053583348885u64, 4004313188770806737u64, 115620326498u64)
    put(data, 11175458488686298083u64, 17134872954824183228u64, 98217074252u64)
    put(data, 11026777810412287617u64, 2659553912986171234u64, 76928883324u64)
    put(data, 16199890034895598640u64, 9501854300969137926u64, 124144174706u64)
    put(data, 9094320719494763752u64, 14528169966301018150u64, 114515096553u64)
    put(data, 1250835564687222832u64, 18172091996515901778u64, 233787573671u64)
    put(data, 15362466642459337025u64, 1133541705604751035u64, 167985111081u64)
    put(data, 7831109835595423828u64, 18280349987988641497u64, 41061449418u64)
    put(data, 15426237284335022429u64, 9936015874712336386u64, 202990979758u64)
    put(data, 15636308361455434548u64, 15876720399740689614u64, 174538632499u64)
    put(data, 13967173875944980328u64, 8618117825152456982u64, 51860678737u64)
    put(data, 18245979923595824097u64, 8085525680745921564u64, 81467189103u64)
    put(data, 11335054479675278263u64, 8072355444669730953u64, 111438317225u64)
    put(data, 11165339882630461707u64, 9395030504766848294u64, 169437603265u64)
    put(data, 15944437408299395922u64, 3537903114058185903u64, 193509305624u64)
    put(data, 15806416348777321161u64, 2126094743961928691u64, 24191790112u64)
    put(data, 4201030477408556248u64, 289185362555601115u64, 32115255827u64)
    put(data, 9485474942554588907u64, 16909937501450129614u64, 19015676769u64)
    put(data, 18238757647663230541u64, 14449642060360499058u64, 97916689548u64)
    put(data, 4642199687824746379u64, 12433818908498244393u64, 140783316665u64)
    put(data, 6134575894869364037u64, 11884444034578008581u64, 185674038673u64)
    put(data, 11524208547121316008u64, 988625838444140793u64, 145644257002u64)
    put(data, 2734683241527878366u64, 1675370907158909973u64, 234053593514u64)
    put(data, 10629223456178675171u64, 15920186275316934067u64, 170090822038u64)
    put(data, 2788042336985254064u64, 5600921198503757726u64, 150863035027u64)
    put(data, 17285498758066142502u64, 10457357161776341741u64, 147303626546u64)
    put(data, 5525538192421886436u64, 12225356765775740093u64, 50566894467u64)
    put(data, 11414325503043801888u64, 4486633318598164537u64, 131662737918u64)
    put(data, 7246608114685173259u64, 10302486602879381361u64, 254243220879u64)
    put(data, 1007884269852184608u64, 15536428611301239541u64, 143558498917u64)
    put(data, 13823717876510029312u64, 12026126645955462603u64, 101842231482u64)
    put(data, 12487410768239429317u64, 14877968141142123551u64, 186651937631u64)
    put(data, 3361062421598631942u64, 734560801645383190u64, 95806536269u64)
    put(data, 17853337379088328475u64, 15648943144911081638u64, 77039820620u64)
    put(data, 11551561037491869885u64, 13664182862003235646u64, 76848330907u64)
    put(data, 11480877996635204802u64, 3895127525902132786u64, 155740736837u64)
    put(data, 5527488381934471912u64, 5249187334214137467u64, 69211155286u64)
    put(data, 11143438404407726080u64, 10642260063359027505u64, 86284559015u64)
    put(data, 6472279730688098304u64, 783598951897779422u64, 167576918074u64)
    put(data, 4561816853579563008u64, 5538576558607624843u64, 58042478984u64)
    put(data, 2888714464062865408u64, 15974581187564609611u64, 136300246836u64)
    put(data, 16258276129784201216u64, 7474269406918257428u64, 52865983781u64)
    put(data, 720575940379279360u64, 8045286838779138019u64, 37405180956u64)
    put(data, 0u64, 8184246376556341732u64, 28436135873u64)
    put(data, 0u64, 1493267152679331840u64, 193443668885u64)
    put(data, 0u64, 10179074811222818816u64, 149080950174u64)
    put(data, 0u64, 3892499202005008384u64, 158551808751u64)
    put(data, 0u64, 10341173215925108736u64, 239211012804u64)
    put(data, 0u64, 6230307872002015232u64, 196560596123u64)
    put(data, 0u64, 9295429630892703744u64, 155337745666u64)
    put(data, 0u64, 0u64, 2503906250u64)
    put(data, 0u64, 0u64, 202000000000u64)
    put(data, 16409970870640346804u64, 8938u64, 0u64)
    put(data, 7721907286269370594u64, 8938889586303u64, 0u64)
    put(data, 14300743897882155131u64, 10665454627995623288u64, 484u64)
    put(data, 2068482633821123575u64, 16803537892767562832u64, 228578175453u64)
    put(data, 4922882895416406094u64, 8099123106849104444u64, 221910921614u64)
    put(data, 9317632875623428410u64, 7077413686679401728u64, 142439054343u64)
    put(data, 5693844901999766254u64, 13536636358372449666u64, 7383667364u64)
    put(data, 11569484900262102262u64, 7280632235418610318u64, 164733822527u64)
    put(data, 3138170119352085637u64, 6187823673116858809u64, 63394683864u64)
    put(data, 950584692575235243u64, 8624343686231740255u64, 216335442593u64)
    put(data, 8136430299747162645u64, 806211610822132771u64, 161467526608u64)
    put(data, 6698711700804594470u64, 18388078233202190882u64, 208043704818u64)
    put(data, 17401191571004302008u64, 7628864426595573600u64, 242996819718u64)
    put(data, 4721732028538188150u64, 4530799784343874981u64, 6413561569u64)
    put(data, 2984214103553086219u64, 8561580552078486438u64, 225245615148u64)
    put(data, 13128675202005662068u64, 13349114951221999594u64, 44464124211u64)
    put(data, 14638512997670672834u64, 10029144738508991772u64, 51723656971u64)
    put(data, 12942085665769692438u64, 12601907197916268979u64, 11543681025u64)
    put(data, 14131134357119205086u64, 1329580921391066941u64, 1683150758u64)
    put(data, 8921946894736102919u64, 3198179786356761112u64, 166072076726u64)
    put(data, 5601522560505809989u64, 11406753413634654142u64, 182173373673u64)
    put(data, 8602606493507716808u64, 11131812960525182090u64, 233618361341u64)
    put(data, 8576789731078566487u64, 14299636753645227208u64, 253603456789u64)
    put(data, 17881118138842658549u64, 12964114684643663326u64, 21775184861u64)
    put(data, 11624372674432704923u64, 5019257593846306316u64, 221702786065u64)
    put(data, 6826284072848095635u64, 6929086798159998121u64, 17272094499u64)
    put(data, 1646466632033733563u64, 18359765766933703649u64, 35375626547u64)
    put(data, 17871081657060299180u64, 9993076234752063198u64, 51995284896u64)
    put(data, 15910893124677544709u64, 3257189215046584509u64, 160541725748u64)
    put(data, 11031217459450580944u64, 2905234736672690348u64, 52176572581u64)
    put(data, 13554987390037243094u64, 12064985302079670056u64, 165157493090u64)
    put(data, 15026714590903687870u64, 14315096064942799930u64, 98654044163u64)
    put(data, 4406379654994689200u64, 11943971043551974038u64, 3776022912u64)
    put(data, 13596329092861950242u64, 12472773152119929647u64, 128647483967u64)
    put(data, 284812388227373260u64, 7791259796982183085u64, 63676150387u64)
    put(data, 9285079159392309382u64, 16866829442051086686u64, 115422365039u64)
    put(data, 15046108141952711893u64, 3702498393844653053u64, 111914352656u64)
    put(data, 13795366909944958311u64, 2057239613841701716u64, 16200712840u64)
    put(data, 12909920641180059961u64, 17201969976738286226u64, 136111523182u64)
    put(data, 5333762939889788252u64, 18271566505443461640u64, 110932520660u64)
    put(data, 6411331390005944495u64, 18368509115417119804u64, 212990503604u64)
    put(data, 1447104583224217723u64, 7613923684154518587u64, 180995758874u64)
    put(data, 11940049226167932871u64, 17984805084714865232u64, 26412751629u64)
    put(data, 9772290783590472385u64, 4220802739051410373u64, 13974958237u64)
    put(data, 16351989577831528444u64, 17812459042810815760u64, 157228810174u64)
    put(data, 4376738725895725097u64, 10629526089664605307u64, 190965615339u64)
    put(data, 13851276297739812763u64, 17437443267816548473u64, 235576227763u64)
    put(data, 12641996203470333509u64, 12506371893701049304u64, 179945285693u64)
    put(data, 7707081716407945022u64, 15737221540003030739u64, 61677971778u64)
    put(data, 417638323657040024u64, 2358380859011605513u64, 66853116489u64)
    put(data, 16438047707692449100u64, 10042972713837039706u64, 73127848082u64)
    put(data, 14850108107043306316u64, 13424397272769642495u64, 146544430641u64)
    put(data, 10423290807904720835u64, 6867102315755663029u64, 49727738034u64)
    put(data, 16951162310302339314u64, 8690748404825506734u64, 178372266362u64)
    put(data, 2752437506572397322u64, 956229930815387710u64, 122471126415u64)
    put(data, 3925815842962784589u64, 7734449506297687888u64, 143051837328u64)
    put(data, 5274166674003605291u64, 16332184961683848151u64, 144419285347u64)
    put(data, 5538963350863452832u64, 15580777817612768828u64, 99885369520u64)
    put(data, 16900671634439028736u64, 17404245271944696092u64, 176844635657u64)
    put(data, 2326997710751662080u64, 13201420160494469229u64, 9943486026u64)
    put(data, 12327726161625874432u64, 16511717657124068078u64, 74715650420u64)
    put(data, 5756455743825903616u64, 14131292492116594062u64, 116895102007u64)
    put(data, 3018537650245074944u64, 18429136031865875691u64, 55766058900u64)
    put(data, 16717361816799281152u64, 2563978348305862197u64, 148999045466u64)
    put(data, 0u64, 14239974392147482896u64, 90138993544u64)
    put(data, 0u64, 11164201396098998272u64, 136771950558u64)
    put(data, 0u64, 7116971104932986880u64, 222605212570u64)
    put(data, 0u64, 12437629862867369984u64, 154385811776u64)
    put(data, 0u64, 16501893821638901760u64, 64674245265u64)
    put(data, 0u64, 10649324268870959104u64, 145894569456u64)
    put(data, 0u64, 7205759403792793600u64, 240577301025u64)
    put(data, 0u64, 0u64, 33390625000u64)
    put(data, 0u64, 0u64, 232000000000u64)
    put(data, 11997425759292732054u64, 136396630u64, 0u64)
    put(data, 11491152661270395161u64, 136396630650381753u64, 0u64)
    put(data, 18181063258234881272u64, 3016823727048309817u64, 7394076u64)
    put(data, 2466921813123869732u64, 17405973192644624358u64, 28163542341u64)
    put(data, 8430880678232179465u64, 8937219978302591747u64, 69943579697u64)
    put(data, 6738034873677997533u64, 15178463196824222317u64, 49484487665u64)
    put(data, 7678250951042929246u64, 11979404627460330594u64, 241822826138u64)
    put(data, 1853560606315563193u64, 2006448052689740002u64, 154649404826u64)
    put(data, 14942676593409905118u64, 16330465320863239865u64, 154108769766u64)
    put(data, 4909892170837638183u64, 17136208883957646553u64, 230885276298u64)
    put(data, 16871149368312132405u64, 140455118208931867u64, 138928955745u64)
    put(data, 16096130589333770811u64, 3964972929179372247u64, 97007614087u64)
    put(data, 12512479187631824282u64, 3378050330022776379u64, 135214941613u64)
    put(data, 16980304980540557310u64, 6065353437512901255u64, 173183124475u64)
    put(data, 8640919162749295366u64, 12768753059854699889u64, 251328803468u64)
    put(data, 7862382415464063513u64, 6848720690951013326u64, 140692195490u64)
    put(data, 14534157903009925344u64, 10953228058585475132u64, 162371269892u64)
    put(data, 12627464554215107944u64, 15539127852083296166u64, 4593775682u64)
    put(data, 2456849734836299173u64, 14534853647735598497u64, 66842377808u64)
    put(data, 18428252197697827913u64, 1506909603576368170u64, 80787935995u64)
    put(data, 7244734215936736255u64, 5475702579938239025u64, 251081689733u64)
    put(data, 14756175050504770087u64, 12039747373985783332u64, 133296838431u64)
    put(data, 6764116534566945922u64, 17572399137760898460u64, 31652676012u64)
    put(data, 1588822142405565521u64, 869552790852091236u64, 172952601666u64)
    put(data, 17053265624843842052u64, 4549585778048181804u64, 66047138551u64)
    put(data, 16996891591759999207u64, 4121918231767210357u64, 247246633539u64)
    put(data, 8565556232370585876u64, 1558397953312543179u64, 67223449635u64)
    put(data, 14464960359145886620u64, 6067524298738069781u64, 35084480922u64)
    put(data, 5813189542048784035u64, 5811095224555517056u64, 154328921151u64)
    put(data, 9739241026882027025u64, 6440894514158997188u64, 63315020103u64)
    put(data, 18175068535675302910u64, 4612748874388784257u64, 71349161591u64)
    put(data, 10562697212061761911u64, 9908101430749813367u64, 119250057617u64)
    put(data, 4264834835660801368u64, 15150017990912190499u64, 145537119254u64)
    put(data, 13019066443690126316u64, 17470426264690059239u64, 22821284120u64)
    put(data, 1828040177823321846u64, 9615161096851907726u64, 24947073705u64)
    put(data, 11240369830376975668u64, 9227932132124142224u64, 169521238927u64)
    put(data, 8886938465302549874u64, 4794113194321211621u64, 143500247203u64)
    put(data, 9985240313589688325u64, 391512698859146347u64, 163259889397u64)
    put(data, 722909126956573766u64, 17209658878068655842u64, 245021223945u64)
    put(data, 5493363474638452381u64, 3077364726606876150u64, 9932937477u64)
    put(data, 12410535279213120491u64, 1952989567673965814u64, 5166824276u64)
    put(data, 10543108918366869098u64, 11172860676923186449u64, 84105871776u64)
    put(data, 12953909016524823995u64, 17338078544784947239u64, 160605681990u64)
    put(data, 16505942145872588169u64, 4593380466519703278u64, 70939899121u64)
    put(data, 12428594380392015797u64, 786884753602720052u64, 241249007654u64)
    put(data, 7528259605829768337u64, 17848875822468020539u64, 38042657107u64)
    put(data, 18147447600042811311u64, 2899664567187130618u64, 83967589497u64)
    put(data, 12021069431116183911u64, 2973178834961857409u64, 121157191131u64)
    put(data, 11819985069665662506u64, 11117453141176836727u64, 219161176347u64)
    put(data, 10401877114068152814u64, 7535238370146462002u64, 27602678342u64)
    put(data, 4611631138117837942u64, 10246175467290865448u64, 70408486090u64)
    put(data, 17200813398607252417u64, 1203128834127050464u64, 202555446285u64)
    put(data, 14100466137553658767u64, 14518048959078919658u64, 13065221744u64)
    put(data, 17887776768825509301u64, 1553474987376920024u64, 112787025011u64)
    put(data, 12632656857970087269u64, 14956572380830948369u64, 115084214047u64)
    put(data, 8923681664054686256u64, 7594162606042048292u64, 31810797413u64)
    put(data, 6213926103737837599u64, 14461296147288811288u64, 101411680379u64)
    put(data, 1233118281776157762u64, 18305427728131488265u64, 123783948434u64)
    put(data, 30716279628678784u64, 10253208939347909876u64, 146992339225u64)
    put(data, 15775734650898546688u64, 6446028915490812012u64, 25555827570u64)
    put(data, 976806005729918976u64, 12986063676957432257u64, 114349439927u64)
    put(data, 12460098853279891456u64, 9769714697972762807u64, 183703975922u64)
    put(data, 5635665595421687808u64, 97429465146664592u64, 242529617295u64)
    put(data, 1805943450575568896u64, 16395571728207795868u64, 143005281661u64)
    put(data, 11529215046068469760u64, 6331668478323650406u64, 125888805724u64)
    put(data, 0u64, 18129911846294207040u64, 92343240435u64)
    put(data, 0u64, 9890094564876124160u64, 243982824490u64)
    put(data, 0u64, 12290856656987750400u64, 42536143100u64)
    put(data, 0u64, 8498454992640802816u64, 252666288674u64)
    put(data, 0u64, 5341660584200896512u64, 34460702168u64)
    put(data, 0u64, 9288674231451648000u64, 216289572000u64)
    put(data, 0u64, 1152921504606846976u64, 160503540039u64)
    put(data, 0u64, 0u64, 71062500000u64)
    put(data, 0u64, 0u64, 160000000000u64)
    put(data, 4564018338575530435u64, 2081u64, 0u64)
    put(data, 16553437246451512014u64, 2081247415929u64, 0u64)
    put(data, 4339777136957372927u64, 15212079674427582639u64, 112u64)
    put(data, 18439463366554654697u64, 10179808126814248333u64, 112824648491u64)
    put(data, 1370067356680643003u64, 6066766544199222848u64, 43551848504u64)
    put(data, 4210124040914115013u64, 6625308131806923532u64, 56328880073u64)
    put(data, 10692225626142609720u64, 9122786786400665713u64, 201359158673u64)
    put(data, 11592856673895384344u64, 11932880778639151320u64, 145494547262u64)
    put(data, 10284479231227406269u64, 3884040911779255011u64, 62646882763u64)
    put(data, 4961071383534266431u64, 13441817515637357872u64, 203210554279u64)
    put(data, 10960611551445686988u64, 11628577856022352826u64, 167728682387u64)
    put(data, 14616396723115619209u64, 13296656925520243654u64, 147630386468u64)
    put(data, 1025604265437492803u64, 5020720704545399398u64, 36720813216u64)
    put(data, 11711588454892179178u64, 14121973606499014694u64, 160272173814u64)
    put(data, 5580373263251565705u64, 3642481034345420114u64, 246765553723u64)
    put(data, 14109334653033148931u64, 9845536238569696768u64, 59197459292u64)
    put(data, 2899414033769399895u64, 17655403572195686356u64, 92533727588u64)
    put(data, 13233457234892808147u64, 8377495365136654029u64, 100957101345u64)
    put(data, 3287946691509034862u64, 13713682649609025426u64, 33454144933u64)
    put(data, 5488480288717445911u64, 1367709905452854731u64, 165743420226u64)
    put(data, 11687233053874362630u64, 9981467701727208680u64, 66074143702u64)
    put(data, 6783772100089274577u64, 6277920117543306205u64, 214541096448u64)
    put(data, 7898291058728402485u64, 9344111460418701726u64, 340326731u64)
    put(data, 4423684977486598491u64, 4918507011364617264u64, 75506545297u64)
    put(data, 2750833684599526706u64, 6554777203830755259u64, 145266632799u64)
    put(data, 15669689830489025709u64, 4198262173120265648u64, 95355335184u64)
    put(data, 15117307274214954517u64, 8080325935698446819u64, 16227588248u64)
    put(data, 8148639818575698175u64, 12797633874200091733u64, 152438035346u64)
    put(data, 13006484426078994901u64, 8376502502208665497u64, 146693761122u64)
    put(data, 10287496057845513526u64, 9891973386793349173u64, 98454091110u64)
    put(data, 14159876032966532430u64, 14877430279003795462u64, 102536244951u64)
    put(data, 15742212196465548019u64, 8759933935842067041u64, 215806507111u64)
    put(data, 2892220461917134150u64, 3753418510388703513u64, 103474876970u64)
    put(data, 7487151560715393883u64, 2961383332545305985u64, 42203473225u64)
    put(data, 7245756744165177933u64, 2497674184068629507u64, 73160536912u64)
    put(data, 3067122860671533987u64, 15244544070742305452u64, 80135399188u64)
    put(data, 8135043905834122525u64, 45953573565810823u64, 20826408390u64)
    put(data, 14730019368921022572u64, 3960077421351906445u64, 198002491148u64)
    put(data, 495969939682055458u64, 3173330011013883118u64, 12214676227u64)
    put(data, 5617761407265775598u64, 11026266219545759160u64, 3172026564u64)
    put(data, 2087044847072781811u64, 8886757764964685632u64, 196597735089u64)
    put(data, 15929674232061203330u64, 13952322129918090479u64, 177481752103u64)
    put(data, 8658086469608285873u64, 4127250666614902202u64, 39756356898u64)
    put(data, 18369871790780313570u64, 17649958504065306911u64, 34223738706u64)
    put(data, 3545648451947416750u64, 13269305359002216873u64, 82956806167u64)
    put(data, 13347376792767929959u64, 16236593433831947843u64, 23719330484u64)
    put(data, 14482164459838203025u64, 13580930396682424057u64, 180880187493u64)
    put(data, 8899577765623565820u64, 421976357197961116u64, 101736223712u64)
    put(data, 7095320096604405719u64, 2962130818798626533u64, 224022875384u64)
    put(data, 2968593824439315788u64, 8234383947306356345u64, 248160577433u64)
    put(data, 12621408323612585636u64, 4380469931801381425u64, 153446386848u64)
    put(data, 3954422936414648259u64, 15279887469027055916u64, 160237465750u64)
    put(data, 17143730087577690191u64, 8534542821713755552u64, 150828324359u64)
    put(data, 5033045529399041876u64, 7814613482565088782u64, 7462658493u64)
    put(data, 15857648521994521781u64, 13771954404705323224u64, 189423631045u64)
    put(data, 16655573486499109541u64, 4568173274762548144u64, 197746579144u64)
    put(data, 16652154439190075858u64, 8105292616250821343u64, 200247641169u64)
    put(data, 18016950600164130638u64, 2923678426777275612u64, 81439388793u64)
    put(data, 2086292996072613910u64, 1808633176918384049u64, 121158492925u64)
    put(data, 17324462585194799521u64, 18118642609460438969u64, 253098046200u64)
    put(data, 11079151463184927232u64, 18138164175864360870u64, 248982213583u64)
    put(data, 5239846817488961536u64, 4031433690465792404u64, 207983271850u64)
    put(data, 2778806963520143360u64, 5012226396942308537u64, 170218544458u64)
    put(data, 6240890740138835968u64, 7889712298793536835u64, 74271713337u64)
    put(data, 17250651344549707776u64, 13500762396543628804u64, 57427702160u64)
    put(data, 4197354852709302272u64, 501020624068841347u64, 144731877796u64)
    put(data, 9223372036854775808u64, 8370653768288261750u64, 164027160382u64)
    put(data, 0u64, 647579990023635200u64, 62453774050u64)
    put(data, 0u64, 11106569307181154304u64, 226035105381u64)
    put(data, 0u64, 10797461613892861952u64, 101602088328u64)
    put(data, 0u64, 17627230675448889344u64, 136585331566u64)
    put(data, 0u64, 12197735707942322176u64, 110955574089u64)
    put(data, 0u64, 12871287735024877568u64, 73661240577u64)
    put(data, 0u64, 4611686018427387904u64, 1697753906u64)
    put(data, 0u64, 0u64, 50250000000u64)
    put(data, 0u64, 0u64, 128000000000u64)
    put(data, 5654803392547571318u64, 31757315u64, 0u64)
    put(data, 2931628102185393332u64, 31757315306547506u64, 0u64)
    put(data, 15964697617980212305u64, 9451803574512021605u64, 1721567u64)
    put(data, 450380868305846606u64, 8662766454758138424u64, 223512383298u64)
    put(data, 14631133530814566148u64, 9207992007314947035u64, 66469609510u64)
    put(data, 31969822783742095u64, 17118602861291201802u64, 38499166246u64)
    put(data, 10437269029385743245u64, 11186560605745599967u64, 38928001320u64)
    put(data, 15196146496377392433u64, 10505549821532796847u64, 40606424665u64)
    put(data, 4409099735137480938u64, 18133667530488679216u64, 89569506996u64)
    put(data, 10644987914903248118u64, 10778135771244330799u64, 180983028086u64)
    put(data, 3154431617534062973u64, 17087985777033767391u64, 118584283910u64)
    put(data, 11702056331247960454u64, 2639185991757283040u64, 6926341565u64)
    put(data, 15575315065965259114u64, 5401720287293896400u64, 189143070559u64)
    put(data, 10759747609480050226u64, 9816495392633895233u64, 95292827843u64)
    put(data, 12538236653960743718u64, 10042051500090034990u64, 195532153281u64)
    put(data, 17857942663978005403u64, 11629689537856384738u64, 193544380702u64)
    put(data, 11443004154750813211u64, 2099086731766010483u64, 30630446733u64)
    put(data, 4004313188770806737u64, 13665537898516458594u64, 141113791719u64)
    put(data, 17134872954824183228u64, 16375672064669490764u64, 231740810293u64)
    put(data, 2659553912986171234u64, 7770550512184564348u64, 53887726961u64)
    put(data, 9501854300969137926u64, 6197048880720627314u64, 113421242387u64)
    put(data, 14528169966301018150u64, 17963594118523106281u64, 19335942692u64)
    put(data, 18172091996515901778u64, 8255454642407818663u64, 36973808388u64)
    put(data, 1133541705604751035u64, 16744201957549498409u64, 4447529092u64)
    put(data, 18280349987988641497u64, 17442505417202859722u64, 132907705006u64)
    put(data, 9936015874712336386u64, 6383975767786687150u64, 174945560113u64)
    put(data, 15876720399740689614u64, 15245442964998335795u64, 49346076019u64)
    put(data, 8618117825152456982u64, 2910016124519524433u64, 115826457119u64)
    put(data, 8085525680745921564u64, 3847913871169988463u64, 31157752290u64)
    put(data, 8072355444669730953u64, 17210451512590059177u64, 226208595828u64)
    put(data, 9395030504766848294u64, 17899408909991454145u64, 116932980445u64)
    put(data, 3537903114058185903u64, 5920601932753251608u64, 221970328901u64)
    put(data, 2126094743961928691u64, 16521781895108979744u64, 69320956473u64)
    put(data, 289185362555601115u64, 3697493405554698771u64, 57895647591u64)
    put(data, 16909937501450129614u64, 2816108280295732065u64, 103200441519u64)
    put(data, 14449642060360499058u64, 14251078772056398988u64, 175152661535u64)
    put(data, 12433818908498244393u64, 4543066550096031417u64, 31772552528u64)
    put(data, 11884444034578008581u64, 3099369389734296977u64, 80246280131u64)
    put(data, 988625838444140793u64, 5243484113636490986u64, 195168017151u64)
    put(data, 1675370907158909973u64, 6823370511605197226u64, 255284249843u64)
    put(data, 15920186275316934067u64, 11396290277624641942u64, 243369895656u64)
    put(data, 5600921198503757726u64, 15934361408437566099u64, 232617794133u64)
    put(data, 10457357161776341741u64, 14939272230935131954u64, 85863803462u64)
    put(data, 12225356765775740093u64, 7500666177940329347u64, 70809859570u64)
    put(data, 4486633318598164537u64, 4806714453065462270u64, 242406611928u64)
    put(data, 10302486602879381361u64, 11557851247268441487u64, 216260572512u64)
    put(data, 15536428611301239541u64, 10655523157206817381u64, 96626552371u64)
    put(data, 12026126645955462603u64, 14769600176490881210u64, 51577637067u64)
    put(data, 14877968141142123551u64, 16688495540925795167u64, 203800661629u64)
    put(data, 734560801645383190u64, 909793965395524173u64, 125904685156u64)
    put(data, 15648943144911081638u64, 12724590949761703756u64, 100049320029u64)
    put(data, 13664182862003235646u64, 10810739657314826395u64, 93689801457u64)
    put(data, 3895127525902132786u64, 2431218615388671301u64, 241586051371u64)
    put(data, 5249187334214137467u64, 4235001167959059286u64, 43131796625u64)
    put(data, 10642260063359027505u64, 6253317787396334247u64, 145229579873u64)
    put(data, 783598951897779422u64, 9534525563070371898u64, 97338993036u64)
    put(data, 5538576558607624843u64, 8392783992374030728u64, 140516867666u64)
    put(data, 15974581187564609611u64, 16356257019231647540u64, 82454973731u64)
    put(data, 7474269406918257428u64, 12896334001521091877u64, 35886674469u64)
    put(data, 8045286838779138019u64, 1427636373320877084u64, 37699111667u64)
    put(data, 8184246376556341732u64, 16116755731295043521u64, 243077392322u64)
    put(data, 1493267152679331840u64, 15945633911163986837u64, 194873691078u64)
    put(data, 10179074811222818816u64, 7510154241072743838u64, 198864414546u64)
    put(data, 3892499202005008384u64, 3571560509790395119u64, 82407126277u64)
    put(data, 10341173215925108736u64, 3576991649007035076u64, 5193614683u64)
    put(data, 6230307872002015232u64, 15509961892750732443u64, 91193909105u64)
    put(data, 9295429630892703744u64, 17789791359353349378u64, 113840796718u64)
    put(data, 0u64, 18331227331079738314u64, 46964386521u64)
    put(data, 0u64, 15386712883100476416u64, 217993737824u64)
    put(data, 0u64, 14082462055028752384u64, 96834115376u64)
    put(data, 0u64, 12919043128765186048u64, 48763411797u64)
    put(data, 0u64, 6125373368465096704u64, 85700342731u64)
    put(data, 0u64, 12335992698065387520u64, 203332057155u64)
    put(data, 0u64, 2774217370460225536u64, 67668735504u64)
    put(data, 0u64, 0u64, 16150390625u64)
    put(data, 0u64, 0u64, 97000000000u64)
    put(data, 10665454627995623288u64, 484u64, 0u64)
    put(data, 16803537892767562832u64, 484578175453u64, 0u64)
    put(data, 8099123106849104444u64, 4962829537462579598u64, 26u64)
    put(data, 7077413686679401728u64, 5711259460785241095u64, 26269035528u64)
    put(data, 13536636358372449666u64, 13845894607204897444u64, 8309607995u64)
    put(data, 7280632235418610318u64, 12116633056637003327u64, 59750587450u64)
    put(data, 6187823673116858809u64, 2965791047992089560u64, 58656843994u64)
    put(data, 8624343686231740255u64, 16021997451315962529u64, 218160775854u64)
    put(data, 806211610822132771u64, 3942052271663803856u64, 174868554222u64)
    put(data, 18388078233202190882u64, 15669876414782439922u64, 238213699081u64)
    put(data, 7628864426595573600u64, 10594415915406145286u64, 9849465702u64)
    put(data, 4530799784343874981u64, 10789820553031921377u64, 102574324437u64)
    put(data, 8561580552078486438u64, 3989990218583987244u64, 213584917344u64)
    put(data, 13349114951221999594u64, 2937341169808224563u64, 96216297803u64)
    put(data, 10029144738508991772u64, 16267436558584536843u64, 75159233583u64)
    put(data, 12601907197916268979u64, 16221580362814625793u64, 47881859502u64)
    put(data, 1329580921391066941u64, 9695437602320209830u64, 174879373633u64)
    put(data, 3198179786356761112u64, 10729753156793715126u64, 65525590725u64)
    put(data, 11406753413634654142u64, 2609241432056861929u64, 197581661084u64)
    put(data, 11131812960525182090u64, 8462663743997037565u64, 156141447261u64)
    put(data, 14299636753645227208u64, 14993422143908194069u64, 93458761920u64)
    put(data, 12964114684643663326u64, 1307443894537745373u64, 192812795043u64)
    put(data, 5019257593846306316u64, 10017257439419829265u64, 163070876675u64)
    put(data, 6929086798159998121u64, 16754772009970777891u64, 3543036613u64)
    put(data, 18359765766933703649u64, 11722573031602862387u64, 197908278010u64)
    put(data, 9993076234752063198u64, 7363764277467092384u64, 250635481957u64)
    put(data, 3257189215046584509u64, 6733958494847390772u64, 101399190461u64)
    put(data, 2905234736672690348u64, 8799796600227451045u64, 189365048621u64)
    put(data, 12064985302079670056u64, 10512023194742249826u64, 45477037929u64)
    put(data, 14315096064942799930u64, 4572542132337197059u64, 105569857919u64)
    put(data, 11943971043551974038u64, 12600500455757416832u64, 127247878005u64)
    put(data, 12472773152119929647u64, 7873789864743195199u64, 117683074498u64)
    put(data, 7791259796982183085u64, 15724851676325671539u64, 194426839003u64)
    put(data, 16866829442051086686u64, 8748017220462413167u64, 219852445917u64)
    put(data, 3702498393844653053u64, 14172589522760466448u64, 221474230963u64)
    put(data, 2057239613841701716u64, 9520545591489413768u64, 179768297617u64)
    put(data, 17201969976738286226u64, 12488551088392570222u64, 145516109810u64)
    put(data, 18271566505443461640u64, 1135798823651241684u64, 242677005711u64)
    put(data, 18368509115417119804u64, 11168725610120161972u64, 143061571777u64)
    put(data, 7613923684154518587u64, 9580104948718508826u64, 193605457828u64)
    put(data, 17984805084714865232u64, 16638722716909738765u64, 164519338529u64)
    put(data, 4220802739051410373u64, 15732724012348272797u64, 33901986965u64)
    put(data, 17812459042810815760u64, 12269722190021214142u64, 149852872677u64)
    put(data, 10629526089664605307u64, 13110655916311972587u64, 229665142972u64)
    put(data, 17437443267816548473u64, 6618112997062866867u64, 188710730081u64)
    put(data, 12506371893701049304u64, 8457936459015989309u64, 97358768624u64)
    put(data, 15737221540003030739u64, 3329167139937134914u64, 240458505654u64)
    put(data, 2358380859011605513u64, 5245511557216705097u64, 182180474512u64)
    put(data, 10042972713837039706u64, 5655931353280440466u64, 144284359751u64)
    put(data, 13424397272769642495u64, 604622132328697393u64, 71306608653u64)
    put(data, 6867102315755663029u64, 8673282619234652338u64, 13032776631u64)
    put(data, 8690748404825506734u64, 16929477433058445690u64, 183470179592u64)
    put(data, 956229930815387710u64, 11036952409253549455u64, 8917748810u64)
    put(data, 7734449506297687888u64, 18199392190170386320u64, 74598314388u64)
    put(data, 16332184961683848151u64, 9683116091880335715u64, 148986591027u64)
    put(data, 15580777817612768828u64, 2993913337608915120u64, 51524922775u64)
    put(data, 17404245271944696092u64, 4490779842162392585u64, 151162300367u64)
    put(data, 13201420160494469229u64, 946849923353644618u64, 207243445663u64)
    put(data, 16511717657124068078u64, 3613491058474899828u64, 159051328837u64)
    put(data, 14131292492116594062u64, 14624054199004410935u64, 69195887742u64)
    put(data, 18429136031865875691u64, 12088470271991908244u64, 126792771566u64)
    put(data, 2563978348305862197u64, 10071980927725011290u64, 238655317286u64)
    put(data, 14239974392147482896u64, 2833441711428854664u64, 38546003180u64)
    put(data, 11164201396098998272u64, 17655572411864340446u64, 236153601182u64)
    put(data, 7116971104932986880u64, 4997642792058747802u64, 158957110498u64)
    put(data, 12437629862867369984u64, 11489200787635734848u64, 226270922758u64)
    put(data, 16501893821638901760u64, 12983586226429536913u64, 6622830822u64)
    put(data, 10649324268870959104u64, 12311150768725063152u64, 230703841619u64)
    put(data, 7205759403792793600u64, 8530052476845967905u64, 83667388820u64)
    put(data, 0u64, 6282736361499820264u64, 148462415071u64)
    put(data, 0u64, 11337164765929082880u64, 223340587820u64)
    put(data, 0u64, 8343856200414134272u64, 44614588933u64)
    put(data, 0u64, 17889330377156198400u64, 5452321350u64)
    put(data, 0u64, 17730714064155312128u64, 70969782542u64)
    put(data, 0u64, 7449235258647511040u64, 14961183935u64)
    put(data, 0u64, 9943947977234055168u64, 191403823852u64)
    put(data, 0u64, 0u64, 236539062500u64)
    put(data, 0u64, 0u64, 228000000000u64)
    put(data, 3016823727048309817u64, 7394076u64, 0u64)
    put(data, 17405973192644624358u64, 7394076163542341u64, 0u64)
    put(data, 8937219978302591747u64, 12396245121240683569u64, 400833u64)
    put(data, 15178463196824222317u64, 10248996648596888561u64, 193672001794u64)
    put(data, 11979404627460330594u64, 11257495103713935002u64, 2555599221u64)
    put(data, 2006448052689740002u64, 7555396579247433114u64, 117610270032u64)
    put(data, 16330465320863239865u64, 4805022328730367462u64, 80409578869u64)
    put(data, 17136208883957646553u64, 7056637817080232586u64, 117260480782u64)
    put(data, 140455118208931867u64, 10811411483818434913u64, 14382541102u64)
    put(data, 3964972929179372247u64, 16962406704495245447u64, 46586087790u64)
    put(data, 3378050330022776379u64, 18074517319117194669u64, 110919533909u64)
    put(data, 6065353437512901255u64, 3702019776117654523u64, 85979821547u64)
    put(data, 12768753059854699889u64, 3551977551381082764u64, 235200686894u64)
    put(data, 6848720690951013326u64, 16442608985936005282u64, 46192553088u64)
    put(data, 10953228058585475132u64, 3580046275479139588u64, 128891355619u64)
    put(data, 15539127852083296166u64, 8737412692712715330u64, 227194074697u64)
    put(data, 14534853647735598497u64, 3082033243045084752u64, 73473656091u64)
    put(data, 1506909603576368170u64, 16401023756841128699u64, 27167077356u64)
    put(data, 5475702579938239025u64, 7520296082779572869u64, 236889101279u64)
    put(data, 12039747373985783332u64, 9854104766152464159u64, 223407676067u64)
    put(data, 17572399137760898460u64, 14169188802648310188u64, 163534192089u64)
    put(data, 869552790852091236u64, 2018609909210367042u64, 217768113264u64)
    put(data, 4549585778048181804u64, 8270271948267674359u64, 112109429062u64)
    put(data, 4121918231767210357u64, 12320338602894572099u64, 70448332340u64)
    put(data, 1558397953312543179u64, 17538536685990080547u64, 52667886893u64)
    put(data, 6067524298738069781u64, 15833914616956760474u64, 45950765978u64)
    put(data, 5811095224555517056u64, 6137696141415969855u64, 154858358231u64)
    put(data, 6440894514158997188u64, 9757490468419438919u64, 215332725174u64)
    put(data, 4612748874388784257u64, 3566639201356598903u64, 182528954618u64)
    put(data, 9908101430749813367u64, 9760900035773954449u64, 250193347898u64)
    put(data, 15150017990912190499u64, 3873778773990716438u64, 58529139451u64)
    put(data, 17470426264690059239u64, 2295668377270167832u64, 251209997968u64)
    put(data, 9615161096851907726u64, 1791721710912807593u64, 144124448432u64)
    put(data, 9227932132124142224u64, 10571009006922683279u64, 176097129428u64)
    put(data, 4794113194321211621u64, 9840791932778184867u64, 212573055546u64)
    put(data, 391512698859146347u64, 11525464956561274613u64, 58533470399u64)
    put(data, 17209658878068655842u64, 4435781488897895433u64, 191624796707u64)
    put(data, 3077364726606876150u64, 6395563367070996741u64, 35240464196u64)
    put(data, 1952989567673965814u64, 15538690795135662932u64, 68346704184u64)
    put(data, 11172860676923186449u64, 16294558813563371936u64, 56842354115u64)
    put(data, 17338078544784947239u64, 4942096228426070342u64, 195883329803u64)
    put(data, 4593380466519703278u64, 6910116424372647153u64, 11267911573u64)
    put(data, 786884753602720052u64, 17923400669760829478u64, 149374598161u64)
    put(data, 17848875822468020539u64, 4134686917293039955u64, 17971629497u64)
    put(data, 2899664567187130618u64, 16857102463116098681u64, 185224141826u64)
    put(data, 2973178834961857409u64, 11364321508775167451u64, 2913825355u64)
    put(data, 11117453141176836727u64, 7966947780972783899u64, 75616061103u64)
    put(data, 7535238370146462002u64, 11261055695926686278u64, 175431889104u64)
    put(data, 10246175467290865448u64, 9227040437353594058u64, 208610463052u64)
    put(data, 1203128834127050464u64, 7185344074282882061u64, 76500198864u64)
    put(data, 14518048959078919658u64, 14197856148610578032u64, 208389518282u64)
    put(data, 1553474987376920024u64, 885688687260429427u64, 202769667324u64)
    put(data, 14956572380830948369u64, 17407816160380305183u64, 252048013279u64)
    put(data, 7594162606042048292u64, 17812728703806357349u64, 223943679604u64)
    put(data, 14461296147288811288u64, 17120198191964319867u64, 116965629957u64)
    put(data, 18305427728131488265u64, 12091952048375408786u64, 5928087803u64)
    put(data, 10253208939347909876u64, 405056939269888281u64, 251655506034u64)
    put(data, 6446028915490812012u64, 12485440679452408690u64, 114021958180u64)
    put(data, 12986063676957432257u64, 8394369900823444407u64, 36676837095u64)
    put(data, 9769714697972762807u64, 2877421667354294258u64, 231455059704u64)
    put(data, 97429465146664592u64, 2676980714750756239u64, 248155985341u64)
    put(data, 16395571728207795868u64, 6119309228579057021u64, 189145119415u64)
    put(data, 6331668478323650406u64, 18203256146533333852u64, 183331728417u64)
    put(data, 18129911846294207040u64, 351919978865493747u64, 33986800493u64)
    put(data, 9890094564876124160u64, 5190010931882390570u64, 109019077620u64)
    put(data, 12290856656987750400u64, 6982466386088036604u64, 244281351056u64)
    put(data, 8498454992640802816u64, 4707293888784996898u64, 144378520261u64)
    put(data, 5341660584200896512u64, 690306801165964760u64, 197255182913u64)
    put(data, 9288674231451648000u64, 12456770961278956704u64, 65037421606u64)
    put(data, 1152921504606846976u64, 16946092489294063943u64, 38675282906u64)
    put(data, 0u64, 11098404173866185376u64, 218918649514u64)
    put(data, 0u64, 15152070965853306880u64, 170601645695u64)
    put(data, 0u64, 17370091362040414208u64, 127821395412u64)
    put(data, 0u64, 10141938552171134976u64, 212941634539u64)
    put(data, 0u64, 10586988556645826560u64, 235549795590u64)
    put(data, 0u64, 12169852093061922816u64, 6573921799u64)
    put(data, 0u64, 16717361816799281152u64, 7659729003u64)
    put(data, 0u64, 0u64, 107906250000u64)
    put(data, 0u64, 0u64, 16000000000u64)
    put(data, 15212079674427582639u64, 112u64, 0u64)
    put(data, 10179808126814248333u64, 112824648491u64, 0u64)
    put(data, 6066766544199222848u64, 2144184049294538808u64, 6u64)
    put(data, 6625308131806923532u64, 4108002197393276873u64, 6116236450u64)
    put(data, 9122786786400665713u64, 6446230217393892753u64, 162222695245u64)
    put(data, 11932880778639151320u64, 5571068025259989822u64, 77349450840u64)
    put(data, 3884040911779255011u64, 14804812668872528331u64, 88302008202u64)
    put(data, 13441817515637357872u64, 17369928488562523047u64, 138802570502u64)
    put(data, 11628577856022352826u64, 2967474173531035027u64, 6941625710u64)
    put(data, 13296656925520243654u64, 5291425437992807716u64, 110160867097u64)
    put(data, 5020720704545399398u64, 14219547193739388064u64, 25286848747u64)
    put(data, 14121973606499014694u64, 17720313647158217462u64, 235770843197u64)
    put(data, 3642481034345420114u64, 12334850628290578491u64, 61960620127u64)
    put(data, 9845536238569696768u64, 7818499847417334620u64, 95668673592u64)
    put(data, 17655403572195686356u64, 136007040922198372u64, 56423841726u64)
    put(data, 8377495365136654029u64, 8523477092112604449u64, 190007372956u64)
    put(data, 13713682649609025426u64, 367934822655966629u64, 156462058619u64)
    put(data, 1367709905452854731u64, 12964987687054730050u64, 123019945786u64)
    put(data, 9981467701727208680u64, 15267036012420885462u64, 58702833390u64)
    put(data, 6277920117543306205u64, 11142900264750765568u64, 238827627680u64)
    put(data, 9344111460418701726u64, 13680181547777718603u64, 160604057833u64)
    put(data, 4918507011364617264u64, 13001922925761426065u64, 233741604127u64)
    put(data, 6554777203830755259u64, 2397730045956515935u64, 31704835654u64)
    put(data, 4198262173120265648u64, 4482395522588406288u64, 70129981206u64)
    put(data, 8080325935698446819u64, 3255525722490493080u64, 22242991148u64)
    put(data, 12797633874200091733u64, 836222287193822098u64, 44176482403u64)
    put(data, 8376502502208665497u64, 420898743993182306u64, 99045331701u64)
    put(data, 9891973386793349173u64, 11652649973356574054u64, 245022816966u64)
    put(data, 14877430279003795462u64, 15058402726661910231u64, 198631691420u64)
    put(data, 8759933935842067041u64, 9600134495208339559u64, 156816317647u64)
    put(data, 3753418510388703513u64, 14626343323989004842u64, 207520424333u64)
    put(data, 2961383332545305985u64, 6813981265331086665u64, 141792895660u64)
    put(data, 2497674184068629507u64, 10281745288790487888u64, 172369386664u64)
    put(data, 15244544070742305452u64, 17569829347075761940u64, 168557374528u64)
    put(data, 45953573565810823u64, 7654580675237889478u64, 64952462357u64)
    put(data, 3960077421351906445u64, 16194838649686212364u64, 21414955649u64)
    put(data, 3173330011013883118u64, 6495102772252453635u64, 129877923962u64)
    put(data, 11026266219545759160u64, 14935159852819761348u64, 122352100226u64)
    put(data, 8886757764964685632u64, 17381879863441579697u64, 130809636637u64)
    put(data, 13952322129918090479u64, 9062335510435372583u64, 29942273595u64)
    put(data, 4127250666614902202u64, 7569219009130126626u64, 59491270192u64)
    put(data, 17649958504065306911u64, 12652124168176193362u64, 48410328184u64)
    put(data, 13269305359002216873u64, 8940200224697247767u64, 120685873025u64)
    put(data, 16236593433831947843u64, 5600570701927432884u64, 129484649225u64)
    put(data, 13580930396682424057u64, 2018432801986093157u64, 9303607546u64)
    put(data, 421976357197961116u64, 8235849749361824736u64, 250109419461u64)
    put(data, 2962130818798626533u64, 9705097287982370040u64, 197446466309u64)
    put(data, 8234383947306356345u64, 3517483139049842585u64, 5526114378u64)
    put(data, 4380469931801381425u64, 958281614186777760u64, 74190683143u64)
    put(data, 15279887469027055916u64, 7336473432636108950u64, 7051948550u64)
    put(data, 8534542821713755552u64, 12955383920176764423u64, 6397711021u64)
    put(data, 7814613482565088782u64, 10735469126281273789u64, 173702312769u64)
    put(data, 13771954404705323224u64, 8637888232514730693u64, 65581970947u64)
    put(data, 4568173274762548144u64, 6806336737533581000u64, 3468260859u64)
    put(data, 8105292616250821343u64, 16142569672872330321u64, 251368972253u64)
    put(data, 2923678426777275612u64, 8141285259947963513u64, 221875090455u64)
    put(data, 1808633176918384049u64, 5220241098754220797u64, 23441339958u64)
    put(data, 18118642609460438969u64, 154438799943119608u64, 54282989837u64)
    put(data, 18138164175864360870u64, 2226876628677628879u64, 13008372144u64)
    put(data, 4031433690465792404u64, 17219557081221357482u64, 176120719223u64)
    put(data, 5012226396942308537u64, 15401507148161015114u64, 119933474059u64)
    put(data, 7889712298793536835u64, 8842629766613985337u64, 11834917375u64)
    put(data, 13500762396543628804u64, 3180100571546071440u64, 255479359920u64)
    put(data, 501020624068841347u64, 7740848704392475044u64, 176172393597u64)
    put(data, 8370653768288261750u64, 2014314126623495998u64, 125419632249u64)
    put(data, 647579990023635200u64, 11209566016506885858u64, 121109196187u64)
    put(data, 11106569307181154304u64, 7117166613733441125u64, 155607671791u64)
    put(data, 10797461613892861952u64, 4197646860931880328u64, 239385822375u64)
    put(data, 17627230675448889344u64, 5487263271238026094u64, 167227554892u64)
    put(data, 12197735707942322176u64, 18148076225293562697u64, 76297465137u64)
    put(data, 12871287735024877568u64, 9127276943027950849u64, 49983809183u64)
    put(data, 4611686018427387904u64, 9691696125379324722u64, 159494790674u64)
    put(data, 0u64, 13102362262487705216u64, 18525387899u64)
    put(data, 0u64, 8929385439893192704u64, 123710280481u64)
    put(data, 0u64, 11891353410743566336u64, 33484062954u64)
    put(data, 0u64, 1587423090877399040u64, 234644631560u64)
    put(data, 0u64, 3489137423026225152u64, 8086054378u64)
    put(data, 0u64, 13046928120492326912u64, 234189146518u64)
    put(data, 0u64, 11529215046068469760u64, 150707275390u64)
    put(data, 0u64, 0u64, 126625000000u64)
    put(data, 0u64, 0u64, 64000000000u64)
    put(data, 9451803574512021605u64, 1721567u64, 0u64)
    put(data, 8662766454758138424u64, 1721567512383298u64, 0u64)
    put(data, 9207992007314947035u64, 6674960280855494694u64, 93326u64)
    put(data, 17118602861291201802u64, 16378845781483497510u64, 142361850321u64)
    put(data, 11186560605745599967u64, 17606907750956804392u64, 209887899008u64)
    put(data, 10505549821532796847u64, 13225609159240506969u64, 128954472381u64)
    put(data, 18133667530488679216u64, 2668084873338435252u64, 189716961709u64)
    put(data, 10778135771244330799u64, 14802814305275861366u64, 173144637170u64)
    put(data, 17087985777033767391u64, 8005510553372365574u64, 242802462171u64)
    put(data, 2639185991757283040u64, 12748500143273514429u64, 219433979596u64)
    put(data, 5401720287293896400u64, 10393733905569036127u64, 204691097577u64)
    put(data, 9816495392633895233u64, 603389089974790339u64, 233563445444u64)
    put(data, 10042051500090034990u64, 2033494532597735873u64, 196032709788u64)
    put(data, 11629689537856384738u64, 9204796763694620958u64, 156110235959u64)
    put(data, 2099086731766010483u64, 7826260310402107021u64, 55498993032u64)
    put(data, 13665537898516458594u64, 10122690201685169383u64, 136424262421u64)
    put(data, 16375672064669490764u64, 7438455564568110133u64, 21548752135u64)
    put(data, 7770550512184564348u64, 2805412574380520817u64, 7403239484u64)
    put(data, 6197048880720627314u64, 7250965427231182867u64, 60152081720u64)
    put(data, 17963594118523106281u64, 8136242944826085924u64, 56393075623u64)
    put(data, 8255454642407818663u64, 15357191647956011780u64, 167441066613u64)
    put(data, 16744201957549498409u64, 7369614426695395460u64, 117832515027u64)
    put(data, 17442505417202859722u64, 10886957545142526638u64, 211399507598u64)
    put(data, 6383975767786687150u64, 2030047207417538097u64, 142590183151u64)
    put(data, 15245442964998335795u64, 11557093828502314355u64, 239110049079u64)
    put(data, 2910016124519524433u64, 15201062539664128543u64, 55626511311u64)
    put(data, 3847913871169988463u64, 8846936323343880674u64, 207824051251u64)
    put(data, 17210451512590059177u64, 1485291750116245364u64, 51479593379u64)
    put(data, 17899408909991454145u64, 2076024439668322013u64, 163080517827u64)
    put(data, 5920601932753251608u64, 7029497773682748741u64, 195112541510u64)
    put(data, 16521781895108979744u64, 16333533921668749881u64, 70381069837u64)
    put(data, 3697493405554698771u64, 2065057316131928423u64, 13885442648u64)
    put(data, 2816108280295732065u64, 7800502648925570223u64, 88111946981u64)
    put(data, 14251078772056398988u64, 17011619967093802015u64, 229422866095u64)
    put(data, 4543066550096031417u64, 5368819344429198672u64, 175922201766u64)
    put(data, 3099369389734296977u64, 15598879366754275267u64, 166291044279u64)
    put(data, 5243484113636490986u64, 16393893486035835647u64, 183845616944u64)
    put(data, 6823370511605197226u64, 12042046205096920307u64, 48888714746u64)
    put(data, 11396290277624641942u64, 15437070428008474344u64, 250652800632u64)
    put(data, 15934361408437566099u64, 13704569163204647509u64, 120836845264u64)
    put(data, 14939272230935131954u64, 18192483750856993350u64, 208742926182u64)
    put(data, 7500666177940329347u64, 5152535865317963250u64, 102986216520u64)
    put(data, 4806714453065462270u64, 17512614083933854680u64, 72279319528u64)
    put(data, 11557851247268441487u64, 14481918350603613536u64, 232949360711u64)
    put(data, 10655523157206817381u64, 16124419709964004915u64, 71785066366u64)
    put(data, 14769600176490881210u64, 18088011566435813579u64, 126874106543u64)
    put(data, 16688495540925795167u64, 15008862380698848893u64, 175980553071u64)
    put(data, 909793965395524173u64, 18160498644611827812u64, 111813632059u64)
    put(data, 12724590949761703756u64, 3604680497457231965u64, 59984482604u64)
    put(data, 10810739657314826395u64, 5957615565551495921u64, 44195410121u64)
    put(data, 2431218615388671301u64, 17528455034961565995u64, 201322962986u64)
    put(data, 4235001167959059286u64, 8503772325120113809u64, 42950219451u64)
    put(data, 6253317787396334247u64, 8501492578048509537u64, 187460990421u64)
    put(data, 9534525563070371898u64, 2296237701094386060u64, 213460866836u64)
    put(data, 8392783992374030728u64, 3753593040591076946u64, 20124479295u64)
    put(data, 16356257019231647540u64, 8518075399775653155u64, 63203482686u64)
    put(data, 12896334001521091877u64, 12757855675959554597u64, 62461765792u64)
    put(data, 1427636373320877084u64, 121631169379748595u64, 160691604742u64)
    put(data, 16116755731295043521u64, 16679062494579173314u64, 6006593638u64)
    put(data, 15945633911163986837u64, 10739912744743898054u64, 102904173789u64)
    put(data, 7510154241072743838u64, 9367340677776287570u64, 221582211836u64)
    put(data, 3571560509790395119u64, 12227321512794715397u64, 252507804555u64)
    put(data, 3576991649007035076u64, 7241061891859170651u64, 139662844427u64)
    put(data, 15509961892750732443u64, 13148571323079237489u64, 11392538751u64)
    put(data, 17789791359353349378u64, 12509763434355012654u64, 127712785479u64)
    put(data, 18331227331079738314u64, 11812768946960181977u64, 71678155634u64)
    put(data, 15386712883100476416u64, 14170358803552564832u64, 114640371487u64)
    put(data, 14082462055028752384u64, 18179989524780635952u64, 31768176689u64)
    put(data, 12919043128765186048u64, 17091718978514754901u64, 49985539206u64)
    put(data, 6125373368465096704u64, 7394768384359232459u64, 134926543942u64)
    put(data, 12335992698065387520u64, 6778628272692852803u64, 70400871197u64)
    put(data, 2774217370460225536u64, 18193335045875234320u64, 29367470174u64)
    put(data, 0u64, 1378519212560967521u64, 94986262669u64)
    put(data, 0u64, 4677732610631043584u64, 141074729676u64)
    put(data, 0u64, 17296098591070486528u64, 204253580392u64)
    put(data, 0u64, 7343735382392963072u64, 104937623383u64)
    put(data, 0u64, 14525996728454217728u64, 87398104692u64)
    put(data, 0u64, 9691359370008330240u64, 116787455860u64)
    put(data, 0u64, 3044433348102455296u64, 116525369644u64)
    put(data, 0u64, 9223372036854775808u64, 44165039062u64)
    put(data, 0u64, 0u64, 214500000000u64)
    put(data, 4962829537462579598u64, 26u64, 0u64)
    put(data, 5711259460785241095u64, 26269035528u64, 0u64)
    put(data, 13845894607204897444u64, 7822291454600056379u64, 1u64)
    put(data, 12116633056637003327u64, 8201586317771250746u64, 1424047269u64)
    put(data, 2965791047992089560u64, 3278889188817135834u64, 165444608885u64)
    put(data, 16021997451315962529u64, 1710725240251040430u64, 117177748939u64)
    put(data, 3942052271663803856u64, 1850175733663425006u64, 203092738601u64)
    put(data, 15669876414782439922u64, 9147599666163914249u64, 41100298227u64)
    put(data, 10594415915406145286u64, 10221885933644344166u64, 243495892371u64)
    put(data, 10789820553031921377u64, 14901479793736678101u64, 147554129546u64)
    put(data, 3989990218583987244u64, 5181831442059703136u64, 138807810838u64)
    put(data, 2937341169808224563u64, 6396246577759793483u64, 22280907645u64)
    put(data, 16267436558584536843u64, 14167229556464870447u64, 125346741221u64)
    put(data, 16221580362814625793u64, 2969982933326311854u64, 229768007053u64)
    put(data, 9695437602320209830u64, 7892677766222018881u64, 141161003097u64)
    put(data, 10729753156793715126u64, 798698968922663621u64, 89427862919u64)
    put(data, 2609241432056861929u64, 15926812109043458972u64, 135043297557u64)
    put(data, 8462663743997037565u64, 8663842590352697437u64, 21863394214u64)
    put(data, 14993422143908194069u64, 17093523026636671168u64, 166469667847u64)
    put(data, 1307443894537745373u64, 839764004742743203u64, 7926641740u64)
    put(data, 10017257439419829265u64, 16894643909298232323u64, 76045523697u64)
    put(data, 16754772009970777891u64, 9066702926218949317u64, 241915860481u64)
    put(data, 11722573031602862387u64, 9119392417260546810u64, 1491506950u64)
    put(data, 7363764277467092384u64, 9723021096578315109u64, 6494363253u64)
    put(data, 6733958494847390772u64, 14787464248751217597u64, 117527086029u64)
    put(data, 8799796600227451045u64, 3733434565920249133u64, 205801630043u64)
    put(data, 10512023194742249826u64, 6643788868836820841u64, 91202389893u64)
    put(data, 4572542132337197059u64, 4729646697422664063u64, 133360160516u64)
    put(data, 12600500455757416832u64, 4090144564201555829u64, 4256394661u64)
    put(data, 7873789864743195199u64, 2109480737093400002u64, 165221727181u64)
    put(data, 15724851676325671539u64, 16577155033369419739u64, 205114355179u64)
    put(data, 8748017220462413167u64, 745377248603805917u64, 235898649375u64)
    put(data, 14172589522760466448u64, 11305561465807999667u64, 31040406981u64)
    put(data, 9520545591489413768u64, 2211245518782892177u64, 197612875715u64)
    put(data, 12488551088392570222u64, 14170095199249735666u64, 195119871859u64)
    put(data, 1135798823651241684u64, 17849973668116118927u64, 115768162399u64)
    put(data, 11168725610120161972u64, 9020960204585720001u64, 95967649011u64)
    put(data, 9580104948718508826u64, 10807134002871850916u64, 243489027232u64)
    put(data, 16638722716909738765u64, 3925122626254791201u64, 160585855908u64)
    put(data, 15732724012348272797u64, 17208463291312718997u64, 164212781323u64)
    put(data, 12269722190021214142u64, 5145077219589447653u64, 11932872664u64)
    put(data, 13110655916311972587u64, 17602397765035489468u64, 216278915194u64)
    put(data, 6618112997062866867u64, 16422643262490753377u64, 122954227894u64)
    put(data, 8457936459015989309u64, 2902509461400906224u64, 182890273275u64)
    put(data, 3329167139937134914u64, 3422418805967265206u64, 251157345353u64)
    put(data, 5245511557216705097u64, 4228874576277237392u64, 73185529695u64)
    put(data, 5655931353280440466u64, 2553488530807495751u64, 95229247750u64)
    put(data, 604622132328697393u64, 11546099176912486413u64, 6138424890u64)
    put(data, 8673282619234652338u64, 10460791037534167991u64, 58625915290u64)
    put(data, 16929477433058445690u64, 8127117908566000904u64, 154567080618u64)
    put(data, 11036952409253549455u64, 11541304458088287306u64, 170440571944u64)
    put(data, 18199392190170386320u64, 6249718665174839700u64, 40625655368u64)
    put(data, 9683116091880335715u64, 13102508413386290995u64, 72338797927u64)
    put(data, 2993913337608915120u64, 6274675218640661911u64, 103710288404u64)
    put(data, 4490779842162392585u64, 3404497118599817167u64, 20340150825u64)
    put(data, 946849923353644618u64, 11258566093988562335u64, 41184558158u64)
    put(data, 3613491058474899828u64, 16762592482501635397u64, 78610328090u64)
    put(data, 14624054199004410935u64, 5550125446725071998u64, 26908701959u64)
    put(data, 12088470271991908244u64, 6370033225258510318u64, 7300872903u64)
    put(data, 10071980927725011290u64, 1503521728674735398u64, 199345320193u64)
    put(data, 2833441711428854664u64, 4250415082606384364u64, 1081506076u64)
    put(data, 17655572411864340446u64, 6020091901030562974u64, 28230415463u64)
    put(data, 4997642792058747802u64, 16288222967151527138u64, 103326349835u64)
    put(data, 11489200787635734848u64, 6377016228656203782u64, 11882986336u64)
    put(data, 12983586226429536913u64, 8378856515587563750u64, 96345698742u64)
    put(data, 12311150768725063152u64, 15812881490200838483u64, 182454218721u64)
    put(data, 8530052476845967905u64, 4548570371183413652u64, 225857218023u64)
    put(data, 6282736361499820264u64, 16731431495283420383u64, 231246578493u64)
    put(data, 11337164765929082880u64, 14737727629551135532u64, 61907012718u64)
    put(data, 8343856200414134272u64, 12413722258104293893u64, 110798933815u64)
    put(data, 17889330377156198400u64, 800899742400762438u64, 55672949232u64)
    put(data, 17730714064155312128u64, 603197008376033550u64, 240043416862u64)
    put(data, 7449235258647511040u64, 6380777281587743935u64, 30032699375u64)
    put(data, 9943947977234055168u64, 10001440249018225388u64, 239345902629u64)
    put(data, 0u64, 5505914461980436708u64, 37542179162u64)
    put(data, 0u64, 1105464290051876864u64, 90298476221u64)
    put(data, 0u64, 4500443576769970176u64, 189059927339u64)
    put(data, 0u64, 2843045143185981440u64, 43243969535u64)
    put(data, 0u64, 660949699682893824u64, 255154121786u64)
    put(data, 0u64, 276549164618219520u64, 58035830155u64)
    put(data, 0u64, 4683743612465315840u64, 139014991760u64)
    put(data, 0u64, 0u64, 144253906250u64)
    put(data, 0u64, 0u64, 74000000000u64)
    put(data, 12396245121240683569u64, 400833u64, 0u64)
    put(data, 10248996648596888561u64, 400833672001794u64, 0u64)
    put(data, 11257495103713935002u64, 4370024159708535157u64, 21729u64)
    put(data, 7555396579247433114u64, 7166684413908503888u64, 225236899484u64)
    put(data, 4805022328730367462u64, 10217286283215687029u64, 156388506740u64)
    put(data, 7056637817080232586u64, 4767369911989629198u64, 116553880199u64)
    put(data, 10811411483818434913u64, 14407999214182082862u64, 135258439640u64)
    put(data, 16962406704495245447u64, 8472271297615317358u64, 216781059202u64)
    put(data, 18074517319117194669u64, 6236024012584764757u64, 130459282747u64)
    put(data, 3702019776117654523u64, 1951826556984620523u64, 59338055539u64)
    put(data, 3551977551381082764u64, 12357130551551830830u64, 115105808729u64)
    put(data, 16442608985936005282u64, 8927758011099278464u64, 89669881389u64)
    put(data, 3580046275479139588u64, 10199854049407140323u64, 45483974731u64)
    put(data, 8737412692712715330u64, 17895455027038549577u64, 75552935195u64)
    put(data, 3082033243045084752u64, 16539200343720527131u64, 27970114560u64)
    put(data, 16401023756841128699u64, 3536976106235802604u64, 896591847u64)
    put(data, 7520296082779572869u64, 16980391644793590751u64, 231191739858u64)
    put(data, 9854104766152464159u64, 10090294316609084067u64, 210920508875u64)
    put(data, 14169188802648310188u64, 17603457857266236889u64, 203546995950u64)
    put(data, 2018609909210367042u64, 11164962743035868272u64, 238954285362u64)
    put(data, 8270271948267674359u64, 1585686890718568774u64, 50605253843u64)
    put(data, 12320338602894572099u64, 10882524700472655412u64, 211085960258u64)
    put(data, 17538536685990080547u64, 2194808754940947757u64, 66589942846u64)
    put(data, 15833914616956760474u64, 274100791137209242u64, 62118980821u64)
    put(data, 6137696141415969855u64, 12203404582981010903u64, 213014859033u64)
    put(data, 9757490468419438919u64, 541940706340938166u64, 25661547888u64)
    put(data, 3566639201356598903u64, 10305434016011833594u64, 112029378664u64)
    put(data, 9760900035773954449u64, 7900783531944543546u64, 104558658697u64)
    put(data, 3873778773990716438u64, 8920818625012419323u64, 137428302333u64)
    put(data, 2295668377270167832u64, 12532363335400447632u64, 253483598546u64)
    put(data, 1791721710912807593u64, 13483507182924762800u64, 210679380777u64)
    put(data, 10571009006922683279u64, 415911049779278804u64, 41730942389u64)
    put(data, 9840791932778184867u64, 3441628281170127418u64, 181022546583u64)
    put(data, 11525464956561274613u64, 17830811568183566527u64, 151186571042u64)
    put(data, 4435781488897895433u64, 17897295813176613411u64, 34966610231u64)
    put(data, 6395563367070996741u64, 2086148701331574596u64, 55970214350u64)
    put(data, 15538690795135662932u64, 13015567826878853432u64, 206113090347u64)
    put(data, 16294558813563371936u64, 12944531121587846595u64, 43705575345u64)
    put(data, 4942096228426070342u64, 3534180912913737995u64, 177701724438u64)
    put(data, 6910116424372647153u64, 3447584022400118677u64, 22191588331u64)
    put(data, 17923400669760829478u64, 6375676813770849297u64, 235186893904u64)
    put(data, 4134686917293039955u64, 11580694081479200185u64, 80345626132u64)
    put(data, 16857102463116098681u64, 1872134358882196482u64, 20627790684u64)
    put(data, 11364321508775167451u64, 17602652840520938059u64, 92101488606u64)
    put(data, 7966947780972783899u64, 10331040597716338351u64, 222954241722u64)
    put(data, 11261055695926686278u64, 73785407041056976u64, 186560046833u64)
    put(data, 9227040437353594058u64, 17166209109167902028u64, 241003999914u64)
    put(data, 7185344074282882061u64, 8762475644006589904u64, 170930582060u64)
    put(data, 14197856148610578032u64, 8839001228645872586u64, 44475014756u64)
    put(data, 885688687260429427u64, 13558262784529110268u64, 100479163216u64)
    put(data, 17407816160380305183u64, 5640853896420358111u64, 80734994898u64)
    put(data, 17812728703806357349u64, 8459930353450835572u64, 210305791302u64)
    put(data, 17120198191964319867u64, 7643830211500171269u64, 70458613743u64)
    put(data, 12091952048375408786u64, 1308629115231236347u64, 239414372866u64)
    put(data, 405056939269888281u64, 8957268500971669618u64, 2070940926u64)
    put(data, 12485440679452408690u64, 7645679094277669412u64, 254485574498u64)
    put(data, 8394369900823444407u64, 3821107497040617191u64, 98414473094u64)
    put(data, 2877421667354294258u64, 8847137191985934072u64, 134207142652u64)
    put(data, 2676980714750756239u64, 3531126524756088253u64, 252479604268u64)
    put(data, 6119309228579057021u64, 8726915034124352183u64, 44191422752u64)
    put(data, 18203256146533333852u64, 17611136727168068641u64, 32473087011u64)
    put(data, 351919978865493747u64, 18017743272784259949u64, 35954701634u64)
    put(data, 5190010931882390570u64, 18113575006829616116u64, 66976743819u64)
    put(data, 6982466386088036604u64, 12805550441678740368u64, 139981938868u64)
    put(data, 4707293888784996898u64, 8061966093393027781u64, 180694190280u64)
    put(data, 690306801165964760u64, 11954593141554100801u64, 200437040057u64)
    put(data, 12456770961278956704u64, 14068656112359197734u64, 185648059792u64)
    put(data, 16946092489294063943u64, 895878255770467290u64, 144762663376u64)
    put(data, 11098404173866185376u64, 10319906489512197802u64, 208048565657u64)
    put(data, 15152070965853306880u64, 14551142616794302079u64, 153559443251u64)
    put(data, 17370091362040414208u64, 15933181735739307476u64, 51788819021u64)
    put(data, 10141938552171134976u64, 11524527334398983147u64, 77863739512u64)
    put(data, 10586988556645826560u64, 11828012606225556742u64, 120624745878u64)
    put(data, 12169852093061922816u64, 3556238869349799431u64, 150641197848u64)
    put(data, 16717361816799281152u64, 7403090230513381483u64, 24192784095u64)
    put(data, 0u64, 10172292854665622800u64, 223401322325u64)
    put(data, 0u64, 11240746576366182400u64, 85551441100u64)
    put(data, 0u64, 17021927826892259328u64, 204609362092u64)
    put(data, 0u64, 9046328496309141504u64, 172922760556u64)
    put(data, 0u64, 8038996803112140800u64, 108490402450u64)
    put(data, 0u64, 17098478935265509376u64, 146435794889u64)
    put(data, 0u64, 7205759403792793600u64, 201926910400u64)
    put(data, 0u64, 0u64, 192390625000u64)
    put(data, 0u64, 0u64, 232000000000u64)
    put(data, 2144184049294538808u64, 6u64, 0u64)
    put(data, 4108002197393276873u64, 6116236450u64, 0u64)
    put(data, 6446230217393892753u64, 6116236450222695245u64, 0u64)
    put(data, 5571068025259989822u64, 6240972538554414168u64, 331561842u64)
    put(data, 14804812668872528331u64, 4356262642990299018u64, 114338323799u64)
    put(data, 17369928488562523047u64, 1335108558830511366u64, 87236153471u64)
    put(data, 2967474173531035027u64, 18435704923261947246u64, 127072376379u64)
    put(data, 5291425437992807716u64, 8395401931972636441u64, 59999401566u64)
    put(data, 14219547193739388064u64, 12482665946362458347u64, 94455115650u64)
    put(data, 17720313647158217462u64, 16101242875289374781u64, 130676686676u64)
    put(data, 12334850628290578491u64, 4708983440241068127u64, 84872850125u64)
    put(data, 7818499847417334620u64, 14856666972541426744u64, 205255274503u64)
    put(data, 136007040922198372u64, 6938795288315789246u64, 7805381530u64)
    put(data, 8523477092112604449u64, 5556307628265073820u64, 154376152846u64)
    put(data, 367934822655966629u64, 1441404248927865979u64, 14301208040u64)
    put(data, 12964987687054730050u64, 16710378912353838906u64, 232078138680u64)
    put(data, 15267036012420885462u64, 18289940136919312110u64, 56905871455u64)
    put(data, 11142900264750765568u64, 10217414145292657824u64, 95991499641u64)
    put(data, 13680181547777718603u64, 12461165826430955753u64, 121553887130u64)
    put(data, 13001922925761426065u64, 662762458988270879u64, 154675521153u64)
    put(data, 2397730045956515935u64, 16488546856395302470u64, 129035928424u64)
    put(data, 4482395522588406288u64, 2612816787977180950u64, 104893845916u64)
    put(data, 3255525722490493080u64, 16446616379327454252u64, 156141641081u64)
    put(data, 836222287193822098u64, 7842178508581740643u64, 121891572860u64)
    put(data, 420898743993182306u64, 14779029861369369333u64, 124425125348u64)
    put(data, 11652649973356574054u64, 2697664446153849542u64, 228801172814u64)
    put(data, 15058402726661910231u64, 12135106444393649308u64, 78146240682u64)
    put(data, 9600134495208339559u64, 9550285041205189839u64, 170657845438u64)
    put(data, 14626343323989004842u64, 8790318168586740109u64, 190517721989u64)
    put(data, 6813981265331086665u64, 14038474217155846828u64, 133476524102u64)
    put(data, 10281745288790487888u64, 4263144264274812072u64, 70761027212u64)
    put(data, 17569829347075761940u64, 11940456333341715520u64, 140231105513u64)
    put(data, 7654580675237889478u64, 15751110736831573013u64, 233647293434u64)
    put(data, 16194838649686212364u64, 18384528705472318081u64, 250853869423u64)
    put(data, 6495102772252453635u64, 2393654818032310394u64, 111996627298u64)
    put(data, 14935159852819761348u64, 12812209822018626434u64, 98129760287u64)
    put(data, 17381879863441579697u64, 3110778569433458461u64, 31694551286u64)
    put(data, 9062335510435372583u64, 2860264756226872891u64, 246168635644u64)
    put(data, 7569219009130126626u64, 2384146980060315184u64, 252155055263u64)
    put(data, 12652124168176193362u64, 14117430062880324728u64, 159129244866u64)
    put(data, 8940200224697247767u64, 3769610173216737153u64, 194765307417u64)
    put(data, 5600570701927432884u64, 17731974340232672009u64, 25204350976u64)
    put(data, 2018432801986093157u64, 1971479303384713466u64, 961252255u64)
    put(data, 8235849749361824736u64, 3449462959779012549u64, 159106874107u64)
    put(data, 9705097287982370040u64, 13743454852043766533u64, 251186995761u64)
    put(data, 3517483139049842585u64, 7417711187131879498u64, 49745034180u64)
    put(data, 958281614186777760u64, 3650992383501007879u64, 196402114929u64)
    put(data, 7336473432636108950u64, 12838770342493958662u64, 113197920693u64)
    put(data, 12955383920176764423u64, 16025068246546338477u64, 181695991134u64)
    put(data, 10735469126281273789u64, 6579965938260177729u64, 94868720690u64)
    put(data, 8637888232514730693u64, 4742939430174291459u64, 50356700668u64)
    put(data, 6806336737533581000u64, 13062256857527449083u64, 252257115261u64)
    put(data, 16142569672872330321u64, 2301174570202439645u64, 125708106363u64)
    put(data, 8141285259947963513u64, 7638687886069412887u64, 123124746923u64)
    put(data, 5220241098754220797u64, 936322449610274358u64, 171414094100u64)
    put(data, 154438799943119608u64, 12926010544311283981u64, 20050758141u64)
    put(data, 2226876628677628879u64, 12647854908989899184u64, 253700720435u64)
    put(data, 17219557081221357482u64, 8862093163358513015u64, 51685641588u64)
    put(data, 15401507148161015114u64, 444784343917630731u64, 116480415033u64)
    put(data, 8842629766613985337u64, 11033952249213387263u64, 57024111807u64)
    put(data, 3180100571546071440u64, 18168634046363183536u64, 191598151749u64)
    put(data, 7740848704392475044u64, 3837904761417065597u64, 69984923625u64)
    put(data, 2014314126623495998u64, 111459007020906105u64, 233208053234u64)
    put(data, 11209566016506885858u64, 16191761957496794523u64, 242006042204u64)
    put(data, 7117166613733441125u64, 9856250800340378607u64, 92877757174u64)
    put(data, 4197646860931880328u64, 9491800102275105959u64, 246534308426u64)
    put(data, 5487263271238026094u64, 10777328578953608268u64, 74514551514u64)
    put(data, 18148076225293562697u64, 17424440628313779505u64, 218584240152u64)
    put(data, 9127276943027950849u64, 3285814872419755679u64, 24944580819u64)
    put(data, 9691696125379324722u64, 2824823424107240978u64, 211178124381u64)
    put(data, 13102362262487705216u64, 12271707680713669755u64, 93153133984u64)
    put(data, 8929385439893192704u64, 6951481875178001185u64, 160665250606u64)
    put(data, 11891353410743566336u64, 10202522487003824362u64, 46376840587u64)
    put(data, 1587423090877399040u64, 4834668463880990728u64, 139553079852u64)
    put(data, 3489137423026225152u64, 10871520987687904746u64, 44262087902u64)
    put(data, 13046928120492326912u64, 12057698794225322390u64, 222589346333u64)
    put(data, 11529215046068469760u64, 7263351819222681214u64, 29653649161u64)
    put(data, 0u64, 1778055686910650944u64, 9393747091u64)
    put(data, 0u64, 17108187120491986944u64, 147096388591u64)
    put(data, 0u64, 3067636961549221888u64, 239927436682u64)
    put(data, 0u64, 16702141595163557888u64, 138166296932u64)
    put(data, 0u64, 2432053749942845440u64, 100905424910u64)
    put(data, 0u64, 17791470327927144448u64, 14131841897u64)
    put(data, 0u64, 1152921504606846976u64, 105964477539u64)
    put(data, 0u64, 0u64, 99062500000u64)
    put(data, 0u64, 0u64, 160000000000u64)
    put(data, 6674960280855494694u64, 93326u64, 0u64)
    put(data, 16378845781483497510u64, 93326361850321u64, 0u64)
    put(data, 17606907750956804392u64, 4283581425266273664u64, 5059u64)
    put(data, 13225609159240506969u64, 6725911039793895357u64, 195232213414u64)
    put(data, 2668084873338435252u64, 1188689198788975021u64, 166364612368u64)
    put(data, 14802814305275861366u64, 10825527435847761650u64, 16064438970u64)
    put(data, 8005510553372365574u64, 3917696829526085083u64, 186586853018u64)
    put(data, 12748500143273514429u64, 12646861173976387276u64, 154212378770u64)
    put(data, 10393733905569036127u64, 18398576063183996905u64, 146685587717u64)
    put(data, 603389089974790339u64, 16919251228485834948u64, 5997388806u64)
    put(data, 2033494532597735873u64, 17296019588687185052u64, 6917194446u64)
    put(data, 9204796763694620958u64, 12365301604512770359u64, 206937619100u64)
    put(data, 7826260310402107021u64, 2814271599679204744u64, 156670324343u64)
    put(data, 10122690201685169383u64, 2154994415780170517u64, 119152561969u64)
    put(data, 7438455564568110133u64, 6717373824370072839u64, 49116822481u64)
    put(data, 2805412574380520817u64, 12709155755801344060u64, 209364149564u64)
    put(data, 7250965427231182867u64, 826847911966403896u64, 60688964714u64)
    put(data, 8136242944826085924u64, 2277322703890025383u64, 106044823515u64)
    put(data, 15357191647956011780u64, 2774508958389496437u64, 219123453911u64)
    put(data, 7369614426695395460u64, 245697774950120915u64, 215150406432u64)
    put(data, 10886957545142526638u64, 1268929063431863950u64, 32013319303u64)
    put(data, 2030047207417538097u64, 6735665673159411439u64, 135068788782u64)
    put(data, 11557093828502314355u64, 14734771742997073207u64, 46365141167u64)
    put(data, 15201062539664128543u64, 13683287077957612495u64, 175798773576u64)
    put(data, 8846936323343880674u64, 15370263741354826803u64, 72741772478u64)
    put(data, 1485291750116245364u64, 48035913070297507u64, 190833223667u64)
    put(data, 2076024439668322013u64, 1206547475966802115u64, 243002604032u64)
    put(data, 7029497773682748741u64, 13512340386605768006u64, 65407069u64)
    put(data, 16333533921668749881u64, 2325760467700278797u64, 93732505440u64)
    put(data, 2065057316131928423u64, 10848110652847753816u64, 96126079727u64)
    put(data, 7800502648925570223u64, 15846378960784301285u64, 239588077256u64)
    put(data, 17011619967093802015u64, 14121839924449844911u64, 200859033924u64)
    put(data, 5368819344429198672u64, 5147613424753296550u64, 68765546476u64)
    put(data, 15598879366754275267u64, 16817040482828810167u64, 236279052682u64)
    put(data, 16393893486035835647u64, 5773528746119363888u64, 138911653591u64)
    put(data, 12042046205096920307u64, 8716201595536184826u64, 215312983620u64)
    put(data, 15437070428008474344u64, 5259122109038474872u64, 68472506235u64)
    put(data, 13704569163204647509u64, 14744540084230155984u64, 123285097580u64)
    put(data, 18192483750856993350u64, 10719345477982635878u64, 108799303119u64)
    put(data, 5152535865317963250u64, 13698037261310555208u64, 207581096882u64)
    put(data, 17512614083933854680u64, 16141171632951976936u64, 178742572087u64)
    put(data, 14481918350603613536u64, 10060790174955808839u64, 55875014667u64)
    put(data, 16124419709964004915u64, 4250043307981877118u64, 11545396528u64)
    put(data, 18088011566435813579u64, 7075646198054337199u64, 48230395309u64)
    put(data, 15008862380698848893u64, 18141738384245531503u64, 173383571548u64)
    put(data, 18160498644611827812u64, 8174370508376809531u64, 92983465608u64)
    put(data, 3604680497457231965u64, 3581964982731575596u64, 136443133513u64)
    put(data, 5957615565551495921u64, 14798509948722114761u64, 73194178710u64)
    put(data, 17528455034961565995u64, 14713923334885122090u64, 150802228831u64)
    put(data, 8503772325120113809u64, 5042978054260414139u64, 95797643382u64)
    put(data, 8501492578048509537u64, 2052996319372883413u64, 118273380388u64)
    put(data, 2296237701094386060u64, 8825683007899981588u64, 36111293153u64)
    put(data, 3753593040591076946u64, 9992196755378745151u64, 225478441234u64)
    put(data, 8518075399775653155u64, 9301073417573669950u64, 18541678071u64)
    put(data, 12757855675959554597u64, 5331614769144850592u64, 247504212200u64)
    put(data, 121631169379748595u64, 14354009428310052102u64, 232289027415u64)
    put(data, 16679062494579173314u64, 5581221063029119078u64, 87778132410u64)
    put(data, 10739912744743898054u64, 1529260335339476189u64, 186302558600u64)
    put(data, 9367340677776287570u64, 16483061525949201148u64, 136082901368u64)
    put(data, 12227321512794715397u64, 14431217812333089675u64, 120893548555u64)
    put(data, 7241061891859170651u64, 3452349151135392267u64, 11782317885u64)
    put(data, 13148571323079237489u64, 9075317899834447999u64, 61187152222u64)
    put(data, 12509763434355012654u64, 2764331337978901575u64, 94491973969u64)
    put(data, 11812768946960181977u64, 1942890683708857202u64, 81149854702u64)
    put(data, 14170358803552564832u64, 165089169728028447u64, 238105324315u64)
    put(data, 18179989524780635952u64, 15193620741871233073u64, 27008949501u64)
    put(data, 17091718978514754901u64, 14995000835194145926u64, 253823647830u64)
    put(data, 7394768384359232459u64, 1788823614552255558u64, 86812880624u64)
    put(data, 6778628272692852803u64, 8384901184618498845u64, 240096972322u64)
    put(data, 18193335045875234320u64, 405511217862281310u64, 34454546404u64)
    put(data, 1378519212560967521u64, 3111530463755196557u64, 228021982807u64)
    put(data, 4677732610631043584u64, 7893558450035460812u64, 87168676404u64)
    put(data, 17296098591070486528u64, 156573858237402216u64, 52427910661u64)
    put(data, 7343735382392963072u64, 15915324019419451223u64, 5008487885u64)
    put(data, 14525996728454217728u64, 16293363012778802804u64, 205862771443u64)
    put(data, 9691359370008330240u64, 14342105318291351412u64, 243883264978u64)
    put(data, 3044433348102455296u64, 3788398842525387052u64, 210777487087u64)
    put(data, 9223372036854775808u64, 14118764407048307670u64, 239205369512u64)
    put(data, 0u64, 2705021334614720768u64, 168765379752u64)
    put(data, 0u64, 7017988973805568000u64, 168146639500u64)
    put(data, 0u64, 10956732053634154496u64, 140380445944u64)
    put(data, 0u64, 14657517938546835456u64, 248593965634u64)
    put(data, 0u64, 11268868284797157376u64, 66794585639u64)
    put(data, 0u64, 14600669991935148032u64, 39610886573u64)
    put(data, 0u64, 4611686018427387904u64, 173791503906u64)
    put(data, 0u64, 0u64, 34250000000u64)
    put(data, 0u64, 0u64, 128000000000u64)
    put(data, 8201586317771250746u64, 1424047269u64, 0u64)
    put(data, 3278889188817135834u64, 1424047269444608885u64, 0u64)
    put(data, 1710725240251040430u64, 3001188830946823627u64, 77197757u64)
    put(data, 1850175733663425006u64, 9732296932705387049u64, 189162694772u64)
    put(data, 9147599666163914249u64, 16337535782679529459u64, 116527588873u64)
    put(data, 10221885933644344166u64, 7969742269895046547u64, 9885659589u64)
    put(data, 14901479793736678101u64, 2923592083903829642u64, 197432040594u64)
    put(data, 5181831442059703136u64, 8144196241160608534u64, 146158488244u64)
    put(data, 6396246577759793483u64, 16431078457793424253u64, 180441497762u64)
    put(data, 14167229556464870447u64, 202362949592775653u64, 162890730548u64)
    put(data, 2969982933326311854u64, 8835125248522947981u64, 52010970117u64)
    put(data, 7892677766222018881u64, 7959873808777345113u64, 5478953099u64)
    put(data, 798698968922663621u64, 14929747122315126151u64, 139431505623u64)
    put(data, 15926812109043458972u64, 4310328817360515349u64, 215809343213u64)
    put(data, 8663842590352697437u64, 7294899422760201126u64, 237233663393u64)
    put(data, 17093523026636671168u64, 2047461597291187207u64, 161395457290u64)
    put(data, 839764004742743203u64, 10942374468813517900u64, 10110993115u64)
    put(data, 16894643909298232323u64, 10364795403063433969u64, 219593187308u64)
    put(data, 9066702926218949317u64, 12330859528790939137u64, 236561876684u64)
    put(data, 9119392417260546810u64, 8973160144879916806u64, 204668457234u64)
    put(data, 9723021096578315109u64, 2895354388547509877u64, 18486435986u64)
    put(data, 14787464248751217597u64, 16766844772497556429u64, 146156957475u64)
    put(data, 3733434565920249133u64, 7442407174620948827u64, 35908932476u64)
    put(data, 6643788868836820841u64, 6683013428676659077u64, 124403453701u64)
    put(data, 4729646697422664063u64, 16713703375071907588u64, 5362286883u64)
    put(data, 4090144564201555829u64, 8791044883080637861u64, 35906051675u64)
    put(data, 2109480737093400002u64, 602844107089214413u64, 91476563498u64)
    put(data, 16577155033369419739u64, 9754832281172880875u64, 42032680244u64)
    put(data, 745377248603805917u64, 10587846778003503903u64, 52528810517u64)
    put(data, 11305561465807999667u64, 17206244172922947013u64, 21573968323u64)
    put(data, 2211245518782892177u64, 11620628420699303875u64, 195932752365u64)
    put(data, 14170095199249735666u64, 17864732368219338611u64, 237629955528u64)
    put(data, 17849973668116118927u64, 4146383014621345887u64, 200968449082u64)
    put(data, 9020960204585720001u64, 11445705075042688243u64, 58224775873u64)
    put(data, 10807134002871850916u64, 7369147888966546592u64, 193620472915u64)
    put(data, 3925122626254791201u64, 9762476865090597796u64, 83399482307u64)
    put(data, 17208463291312718997u64, 5507001428194242827u64, 195529224931u64)
    put(data, 5145077219589447653u64, 11371471148365328344u64, 227298535145u64)
    put(data, 17602397765035489468u64, 3148788104946538618u64, 233616448686u64)
    put(data, 16422643262490753377u64, 3762722308424507574u64, 174170696145u64)
    put(data, 2902509461400906224u64, 1156171244825745915u64, 209203977585u64)
    put(data, 3422418805967265206u64, 14208921674868257865u64, 113062676168u64)
    put(data, 4228874576277237392u64, 7903080886897905503u64, 200770267187u64)
    put(data, 2553488530807495751u64, 6367240794154270982u64, 51428426873u64)
    put(data, 11546099176912486413u64, 1623672396662369850u64, 121345168815u64)
    put(data, 10460791037534167991u64, 18323231215381674394u64, 175088019456u64)
    put(data, 8127117908566000904u64, 9842279843006544554u64, 993304354u64)
    put(data, 11541304458088287306u64, 7376839231308610600u64, 34533551059u64)
    put(data, 6249718665174839700u64, 609751749293657672u64, 211399899256u64)
    put(data, 13102508413386290995u64, 10386457966860989799u64, 120033054708u64)
    put(data, 6274675218640661911u64, 11160336020836149780u64, 244563051014u64)
    put(data, 3404497118599817167u64, 17947559933847409193u64, 6605003027u64)
    put(data, 11258566093988562335u64, 10229787001712704590u64, 19972939173u64)
    put(data, 16762592482501635397u64, 10441677090043619866u64, 165554557864u64)
    put(data, 5550125446725071998u64, 4996681336392922375u64, 168566044449u64)
    put(data, 6370033225258510318u64, 124497102381021895u64, 33270870638u64)
    put(data, 1503521728674735398u64, 8180812057779384577u64, 110006749001u64)
    put(data, 4250415082606384364u64, 5294232873532946716u64, 73443482710u64)
    put(data, 6020091901030562974u64, 2885620189169448039u64, 86287000939u64)
    put(data, 16288222967151527138u64, 16662526875008170507u64, 107156429783u64)
    put(data, 6377016228656203782u64, 15663095032402672480u64, 215903277391u64)
    put(data, 8378856515587563750u64, 1824281504410546614u64, 79849098083u64)
    put(data, 15812881490200838483u64, 9506565509584809953u64, 99098894498u64)
    put(data, 4548570371183413652u64, 16941136942345070055u64, 162515351948u64)
    put(data, 16731431495283420383u64, 15924115693705937725u64, 140918380873u64)
    put(data, 14737727629551135532u64, 9247807690406628462u64, 73863248041u64)
    put(data, 12413722258104293893u64, 7993916633864834871u64, 169501324659u64)
    put(data, 800899742400762438u64, 1018504409177639408u64, 115433351089u64)
    put(data, 603197008376033550u64, 12097800686634130718u64, 177055213234u64)
    put(data, 6380777281587743935u64, 6221488888422637551u64, 178655823089u64)
    put(data, 10001440249018225388u64, 8229322865256080421u64, 241337267588u64)
    put(data, 5505914461980436708u64, 7927745108183101786u64, 132446112486u64)
    put(data, 1105464290051876864u64, 8488683721235326653u64, 230429763923u64)
    put(data, 4500443576769970176u64, 11165516518170922283u64, 83460172466u64)
    put(data, 2843045143185981440u64, 5463648141113596927u64, 178605283863u64)
    put(data, 660949699682893824u64, 3958440403860778042u64, 23296184959u64)
    put(data, 276549164618219520u64, 5091534813990256011u64, 127214587484u64)
    put(data, 4683743612465315840u64, 6100166970623291280u64, 92276012655u64)
    put(data, 0u64, 1913011027739012426u64, 111330690714u64)
    put(data, 0u64, 11310957650604221440u64, 154103704535u64)
    put(data, 0u64, 16303817257009020928u64, 215613168242u64)
    put(data, 0u64, 9090406322154766336u64, 114883831704u64)
    put(data, 0u64, 3003279315069566976u64, 152492791914u64)
    put(data, 0u64, 16582887146675765248u64, 106162808097u64)
    put(data, 0u64, 9691746398101307392u64, 33898960113u64)
    put(data, 0u64, 0u64, 241525390625u64)
    put(data, 0u64, 0u64, 33000000000u64)
    data
  end
end
