# LICENSES

## CODE LICENSE / BINARY

While Cardinal itself is licensed under GPLv3+, some modules/plugins used by it are not.  
And since Cardinal builds the entire Rack and modules as a static library,
the more restrictive of the **code licenses** will apply to the final binary.

Below follows a list of all code licenses used in Cardinal and linked submodules.

| Name                    | License(s)               | Additional notes |
|-------------------------|--------------------------|------------------|
| Carla                   | GPL-2.0-or-later         | Used as plugin host within Cardinal |
| DPF                     | ISC                      | Used as the plugin framework |
| Rack                    | GPL-3.0-or-later         | The actual Rack code, internal dependencies are compatible with GPLv3+ |
| 21kHz                   | MIT                      | |
| 8Mode                   | BSD-3-Clause             | |
| Aaron Static            | MIT                      | |
| admiral                 | MIT                      | |
| alef's bits             | GPL-3.0-or-later         | |
| AlgoritmArte            | GPL-3.0-or-later         | |
| Amalgamated Harmonics   | BSD-3-Clause             | |
| Animated Circuits       | GPL-3.0-or-later         | |
| Arable Instruments      | GPL-3.0-or-later         | |
| Aria Salvatrice         | GPL-3.0-or-later         | |
| AS                      | MIT                      | |
| Audible Instruments     | GPL-3.0-or-later         | |
| Autinn                  | GPL-3.0-or-later         | |
| Axioma                  | GPL-3.0-or-later         | |
| Bacon Music             | GPL-3.0-or-later         | |
| Befaco                  | GPL-3.0-or-later         | |
| Bidoo                   | GPL-3.0-or-later         | |
| Biset                   | MIT                      | |
| Bogaudio                | GPL-3.0-or-later         | |
| Catro/Modulo            | BSD-3-Clause             | |
| cf                      | BSD-3-Clause             | |
| ChowDSP                 | GPL-3.0-or-later         | |
| Computerscare           | BSD-3-Clause             | |
| CVfunk                  | MIT                      | |
| dBiz                    | GPL-3.0-or-later         | |
| DHE-Modules             | MIT                      | |
| eightfold               | GPL-3.0-or-later         | |
| EnigmaCurry             | GPL-3.0-or-later         | |
| E-Series                | GPL-3.0-or-later         | |
| ExpertSleepers Encoders | MIT                      | |
| Extratone               | GPL-3.0-or-later         | |
| Fehler Fabrik           | GPL-3.0-or-later         | |
| forsitan modulare       | GPL-3.0-or-later         | |
| Fundamental             | GPL-3.0-or-later         | |
| Glue the Giant          | GPL-3.0-or-later         | |
| GoodSheperd             | GPL-3.0-or-later         | |
| Grande                  | GPL-3.0-or-later         | |
| H4N4 Modules            | GPL-3.0-or-later         | |
| Hampton Harmonics       | MIT                      | |
| HetrickCV               | CC0-1.0                  | |
| ihtsyn                  | GPL-3.0-or-later         | |
| Impromptu               | GPL-3.0-or-later         | |
| JW-Modules              | BSD-3-Clause             | |
| kocmoc                  | GPL-3.0-or-later         | |
| LifeFormModular         | MIT                      | |
| Lilac Loop              | GPL-3.0-or-later         | |
| Little Utils            | EUPL-1.2                 | |
| Lomas Modules           | GPL-3.0-or-later         | |
| Lyrae Modules           | GPL-3.0-or-later         | |
| Meander                 | GPL-3.0-or-later         | |
| MindMeld                | GPL-3.0-or-later         | |
| ML Modules              | BSD-3-Clause             | |
| Mockba Modular          | MIT                      | |
| Mog                     | CC0-1.0                  | |
| mscHack                 | BSD-3-Clause             | |
| MSM                     | MIT                      | Repo's [LICENSE-dist.md](https://github.com/netboy3/MSM-vcvrack-plugin/issues/10) includes wrong information |
| MUS-X                   | GPL-3.0-or-later         | |
| Myth                    | GPL-3.0-or-later         | |
| Nonlinear Circuits      | CC0-1.0                  | |
| Orbits                  | GPL-3.0-or-later         | |
| Parable Instruments     | GPL-3.0-or-later         | |
| Path Set                | GPL-3.0-or-later         | |
| PdArray                 | EUPL-1.2                 | |
| PinkTrombone            | GPL-3.0-or-later         | |
| Prism                   | BSD-3-Clause             | |
| Rackwindows             | MIT                      | |
| RCM                     | GPL-2.0-or-later         | |
| repelzen                | GPL-3.0-or-later         | |
| RebelTech               | GPL-2.0-or-later         | |
| Sapphire                | GPL-3.0-or-later         | |
| Sonus Modular           | GPL-3.0-or-later         | |
| Starling Via            | MIT                      | |
| stocaudio               | GPL-3.0-or-later         | |
| Stoermelder Pack-One    | GPL-3.0-or-later         | |
| Surge XT                | GPL-3.0-or-later         | |
| unless_modules          | GPL-3.0-or-later         | |
| Valley                  | GPL-3.0-or-later         | |
| Voxglitch               | GPL-3.0-or-later         | |
| WSTD-Drums              | CC0-1.0                  | |
| WhatTheRack             | WTFPL                    | |
| ZetaCarinae             | GPL-3.0-or-later         | |
| ZZC                     | GPL-3.0-or-later         | |

## ARTWORK / PANEL LICENSES

Bellow follows a list of all licenses related to **artwork and module panels**, sorted by file name.  
Licenses were retrieved from the official project's LICENSE, README or related files.  
When * is used, it is meant as wildcard of all files, with potential exceptions mentioned afterwards.  
When a license is uncertain, ??? is used.

Note: The "final" version of Cardinal MUST NOT be released with unclear licenses!  
So all uncertainties need to be resolved ASAP.

### Plugins

Below is a list of artwork licenses from plugins

| Name                                    | License(s)       | Additional notes |
|-----------------------------------------|------------------|------------------|
| 21kHz                                   | MIT              | No artwork specific license provided |
| 8Mode                                   | BSD-3-Clause     | No artwork specific license provided |
| AaronStatic/*                           | MIT              | No artwork specific license provided |
| AaronStatic/fonts/PixelOperator.ttf     | CC0-1.0          | |
| alefsbits/*                             | GPL-3.0-or-later | No artwork specific license provided |
| Algoritmarte/*                          | GPL-3.0-or-later | No artwork specific license provided |
| Algoritmarte/LEDSliderGreenHandle.svg   | CC-BY-NC-4.0     | |
| AmalgamatedHarmonics/*                  | BSD-3-Clause     | No artwork specific license provided |
| AmalgamatedHarmonics/DSEG*.ttf          | OFL-1.1-RFN      | |
| AmalgamatedHarmonics/Roboto*.ttf        | Apache-2.0       | |
| AnimatedCircuits/*                      | CC-BY-NC-SA-4.0  | |
| ArableInstruments/*                     | Custom           | Copyright © Alex Brandt, [used and distributed with permission](https://github.com/adbrant/ArableInstruments/issues/21) |
| AriaModules/*                           | CC-BY-SA-4.0     | |
| AriaModules/Arcane/*                    | CC-BY-NC-SA-3.0  | Unused in Cardinal |
| AriaModules/components/*                | WTFPL            | |
| AriaModules/dseg/*                      | OFL-1.1-RFN      | |
| AriaModules/lcd/Fixed_v01/*             | Custom           | See [LICENSE.txt](../plugins/AriaModules/res/lcd/Fixed_v01/LICENSE.txt) |
| AriaModules/lcd/piano/*                 | WTFPL            | |
| AriaModules/signature/*                 | Custom           | Removal required if modifying other files without author's permission |
| AS/*                                    | CC-BY-NC-ND-4.0  | The AS Logo/Monogram is Copyright (c) 2017 Alfredo Santamaria and cannot be used in derivative works; Cardinal has [explicit permission](https://github.com/AScustomWorks/AS/issues/60#issuecomment-1133488586) for its use. |
| AS/saxmono.ttf                          | Custom           | You may download this font, circulate it und use it freely. You may not alter, rename, change copyrights or modify this font in any way. |
| AS/Segment7Standard.ttf                 | OFL-1.1-RFN      | |
| AudibleInstruments/*                    | Custom           | Copyright © Emilie Gillet, [used and distributed with permission](LICENSE-PERMISSIONS.md#audible-instruments-émilie-gillet--mutable-instruments) |
| Autinn/*                                | GPL-3.0-or-later | No artwork specific license provided |
| Axioma/*                                | GPL-3.0-or-later | No artwork specific license provided |
| BaconPlugs/*                            | GPL-3.0-or-later | No artwork specific license provided |
| BaconPlugs/midi/*                       | CC-BY-SA-3.0-DE  | |
| BaconPlugs/midi/beeth/*                 | ???              | Unused in Cardinal, taken from http://www.jsbach.net/ |
| BaconPlugs/FiraMono-Regular.ttf         | OFL-1.1-RFN      | |
| BaconPlugs/Monitorica-Bd.ttf            | CC-BY-SA-4.0     | |
| BaconPlugs/Keypunch029.json             | OFL-1.1          | |
| BaconPlugs/1f953.svg                    | CC-BY-4.0        | |
| BaconPlugs/1f60d.svg                    | CC-BY-4.0        | |
| BaconPlugs/HelpActive.svg               | CC0-1.0          | |
| BaconPlugs/HelpActiveSmall.svg          | CC0-1.0          | |
| BaconPlugs/SABROG-*.svg                 | CC0-1.0          | |
| BaconPlugs/sabrog-*.svg                 | CC0-1.0          | |
| Bidoo/*                                 | CC-BY-NC-ND-4.0  | [Special permission granted for runtime dark mode](https://github.com/sebastien-bouffier/Bidoo/issues/191) |
| Befaco/components/*                     | CC-BY-NC-4.0     | |
| Befaco/fonts/Segment7Standard.otf       | OFL-1.1-RFN      | |
| Befaco/panels/*                         | Custom           | Copyright © [Befaco](https://www.befaco.org/), [used and distributed with permission](LICENSE-PERMISSIONS.md#befaco-manu-retamero--befaco) |
| Biset/*                                 | MIT              | No artwork specific license provided |
| Biset/FT88-Regular.ttf                  | OFL              | |
| Biset/Recursive_VF_1.085.ttf            | OFL-1.1-no-RFN   | |
| BogaudioModules/*                       | CC-BY-SA-4.0     | |
| BogaudioModules/fonts/audiowide.ttf     | OFL-1.1-RFN      | |
| BogaudioModules/fonts/inconsolata*.ttf  | OFL-1.1-no-RFN   | |
| Cardinal/*                              | CC0-1.0          | |
| Cardinal/Miku/Miku.png                  | CC-BY-NC-3.0     | https://piapro.net/intl/en_for_creators.html |
| CatroModulo/*                           | BSD-3-Clause     | No artwork specific license provided |
| CatroModulo/Segment7Standard.ttf        | OFL-1.1-RFN      | |
| cf/*                                    | BSD-3-Clause     | No artwork specific license provided |
| cf/DejaVuSansMono.ttf                   | Bitstream-Vera   | |
| cf/Segment7Standard.ttf                 | OFL-1.1-RFN      | |
| cf/VT323-Regular.ttf                    | OFL-1.1-no-RFN   | |
| ChowDSP/*                               | GPL-3.0-or-later | Same license as source code |
| ChowDSP/fonts/RobotoCondensed-*.ttf     | Apache-2.0       | |
| Computerscare/*                         | BSD-3-Clause     | No artwork specific license provided |
| Computerscare/Oswald-Regular.ttf        | OFL-1.1          | |
| Computerscare/Segment7Standard.ttf      | OFL-1.1-RFN      | |
| CVfunk/*                                | MIT              | Same license as source code |
| dBiz/*                                  | CC-BY-NC-ND-4.0  | |
| dBiz/DejaVuSansMono.ttf                 | Bitstream-Vera   | |
| dBiz/ShareTechMono-Regular.ttf          | OFL-1.1          | |
| DHE-Modules/*                           | MIT              | Same license as source code |
| DrumKit/*                               | CC0-1.0          | |
| DrumKit/component/NovaMono.ttf          | OFL-1.1-RFN      | |
| eightfold/*                             | GPL-3.0-or-later | No artwork specific license provided |
| EnigmaCurry/res/fonts/dseg/*            | OFL-1.1-RFN      | |
| EnigmaCurry/res/fonts/Fantasque/*       | OFL-1.1          | |
| EnigmaCurry/res/fonts/manrope/*         | OFL-1.1          | |
| EnigmaCurry/res/*.svg                   | CC0-1.0          | |
| E-Series/*                              | Custom           | Copyright © Synthesis Technology, [used and distributed with permission](LICENSE-PERMISSIONS.md#eseries-paul-schreiber--synthtech) |
| ExpertSleepers-Encoders/*               | MIT              | [Same license as source code](https://github.com/expertsleepersltd/vcvrack-encoders/issues/3) |
| Extratone/*                             | GPL-3.0-or-later | [Same license as source code](https://github.com/EaterOfSheep/Extratone/issues/7) |
| FehlerFabrik/*                          | GPL-3.0-or-later | No artwork specific license provided, see [FehlerFabrik#17](https://github.com/RCameron93/FehlerFabrik/issues/17) |
| forsitan-modulare/*                     | GPL-3.0-or-later | No artwork specific license provided |
| Fundamental/*                           | GPL-3.0-or-later | Same license as source code |
| GlueTheGiant/*                          | GPL-3.0-or-later | Same license as source code |
| GlueTheGiant/fonts/DSEG7-*              | OFL-1.1-RFN      | |
| GoodSheperd/*                           | GPL-3.0-or-later | No artwork specific license provided |
| GrandeModular/*                         | CC-BY-NC-ND-4.0  | |
| h4n4-modules/*                          | GPL-3.0-or-later | No artwork specific license provided |
| HamptonHarmonics/*                      | MIT              | No artwork specific license provided |
| HamptonHarmonics/PixelOperator.ttf      | CC0-1.0          | |
| HetrickCV/*                             | CC0-1.0          | |
| ihtsyn/*                                | GPL-3.0-or-later | [Same license as source code](https://github.com/nysthi/nysthi/issues/379#issuecomment-1027873902) |
| ImpromptuModular/*                      | CC-BY-NC-ND-4.0  | |
| ImpromptuModular/res/comp/complib/*     | CC-BY-NC-4.0     | |
| JW-Modules/*                            | BSD-3-Clause     | No artwork specific license provided |
| JW-Modules/DejaVuSansMono.ttf           | Bitstream-Vera   | Unused in Cardinal |
| JW-Modules/res/fonts/ShareTechMono-Regular.ttf | OFL-1.1 | |
| kocmoc/*                                | GPL-3.0-or-later | No artwork specific license provided |
| LifeFormModular/*                       | MIT              | No artwork specific license provided |
| LilacLoop/*                             | GPL-3.0-or-later | No artwork specific license provided |
| LittleUtils/*                           | EUPL-1.2         | Same license as source code |
| LittleUtils/fonts/CooperHewitt-*.ttf    | OFL-1.1-RFN      | |
| LittleUtils/fonts/Overpass-*.ttf        | OFL-1.1-RFN      | |
| LittleUtils/fonts/RobotoMono-*.ttf      | Apache-2.0       | |
| LomasModules/*                          | GPL-3.0-or-later | [Same license as source code](https://github.com/LomasModules/LomasModules/issues/26) |
| LomasModules/Fonts/FiraMono-Bold.ttf    | OFL-1.1-RFN      | |
| LyraeModules/*                          | CC-BY-NC-SA-4.0  | |
| Meander/*                               | GPL-3.0-or-later | No artwork specific license provided |
| Meander/Bravura.otf                     | OFL-1.1-RFN      | |
| Meander/DejaVuSansMono.ttf              | Bitstream-Vera   | |
| Meander/Ubuntu Condensed 400.ttf        | UFL-1.0          | Ubuntu Font License, based on OFL-1.1 |
| MindMeld/*                              | CC-BY-NC-ND-4.0  | |
| MindMeld/fonts/RobotoCondensed-*.ttf    | Apache-2.0       | |
| ML_modules/*                            | BSD-3-Clause     | No artwork specific license provided |
| ML_modules/DejaVuSansMono.ttf           | Bitstream-Vera   | |
| ML_modules/Segment7Standard.ttf         | OFL-1.1-RFN      | |
| MockbaModular/*                         | MIT              | No artwork specific license provided |
| Mog/*                                   | CC0-1.0          | |
| Mog/components/*                        | CC-BY-NC-4.0     | |
| Mog/Exo2-BoldItalic.ttf                 | OFL-1.1-RFN      | |
| mscHack/*                               | BSD-3-Clause     | No artwork specific license provided, see [mschack#108](https://github.com/mschack/VCV-Rack-Plugins/issues/108) |
| MSM/*                                   | MIT              | No artwork specific license provided |
| MSM/Fonts/DejaVuSansMono.ttf            | Bitstream-Vera   | |
| MSM/Fonts/Segment7Standard.ttf          | OFL-1.1-RFN      | |
| MSM/Fonts/Sudo.ttf                      | OFL-1.1-no-RFN   | |
| MUS-X/*                                 | GPL-3.0-or-later | No artwork specific license provided |
| Myth/*                                  | GPL-3.0-or-later | No artwork specific license provided |
| nonlinearcircuits/*                     | CC0-1.0          | No artwork specific license provided |
| nonlinearcircuits/Audiowide-Regular.ttf | OFL-1.1-RFN      | |
| Orbits/*                                | CC-BY-NC-ND-4.0  | |
| Orbits/fonts/ShareTechMono-Regular.ttf  | OFL-1.1-RFN      | |
| ParableInstruments/*                    | Custom           | Copyright © Alex Brandt, [used and distributed with permission](https://github.com/adbrant/ArableInstruments/issues/21) |
| PathSet/*                               | GPL-3.0-or-later | No artwork specific license provided |
| PdArray/res/*svg                        | EUPL-1.2         | No artwork specific license provided |
| PdArray/res/fonts/Overpass-*.ttf        | OFL-1.1-RFN      | |
| PdArray/res/fonts/Roboto-*.ttf          | Apache-2.0       | |
| PinkTrombone/*                          | GPL-3.0-or-later | No artwork specific license provided |
| Prism/*                                 | CC-BY-SA-4.0     | |
| Prism/RobotoCondensed-Regular.ttf       | Apache-2.0       | |
| Rackwindows/*                           | MIT              | [Same license as source code](https://github.com/n0jo/rackwindows/issues/15) |
| RCM/*                                   | GPL-2.0-or-later | No artwork specific license provided |
| repelzen/*                              | CC-BY-SA-4.0     | |
| RebelTech/*                             | CC-BY-NC-4.0     | |
| Sapphire/*                              | GPL-3.0-or-later | No artwork specific license provided |
| sonusmodular/*                          | GPL-3.0-or-later | [Same license as source code](https://gitlab.com/sonusdept/sonusmodular/-/issues/14) |
| StarlingVia/*                           | MIT              | No artwork specific license provided |
| stocaudio/*                             | GPL-3.0-or-later | No artwork specific license provided |
| stoermelder-packone/*                   | GPL-3.0-or-later | No artwork specific license provided |
| stoermelder-packone/fonts/RedkostComic.otf | OFL-1.1-RFN   | |
| surgext/*                               | GPL-3.0-or-later | |
| surgext/xt/*                            | CC-BY-NC-SA-4.0  | |
| surgext/xt/fonts/quicksand/*            | OFL-1.1-RFN      | |
| unless_modules/*                        | CC-BY-NC-ND-4.0  | |
| unless_modules/font/CuteFont-Regular.ttf| OFL-1.1          | |
| unless_modules/font/Terminus.ttf        | GPL-2.0-or-later | [Starting from v4.32, font license is OFL-1.1](https://files.ax86.net/terminus-ttf/#license) |
| ValleyAudio/*                           | GPL-3.0-or-later | [Same license as source code](https://github.com/ValleyAudio/ValleyRackFree/issues/73) |
| ValleyAudio/din1451alt.ttf              | CC-BY-3.0-DE     | |
| ValleyAudio/DSEG14Classic-*.ttf         | OFL-1.1-RFN      | |
| ValleyAudio/ShareTechMono-*.ttf         | OFL-1.1-RFN      | |
| voxglitch/*                             | GPL-3.0-or-later | No artwork specific license provided |
| voxglitch/ShareTechMono-Regular.ttf     | OFL-1.1-RFN      | |
| WhatTheRack/*                           | WTFPL            | |
| WhatTheRack/BoomButton/*                | CC-BY-3.0        | |
| ZetaCarinaeModules/*                    | GPL-3.0-or-later | [Same license as source code](https://github.com/mhampton/ZetaCarinaeModules/issues/8) |
| ZZC/*                                   | CC-BY-NC-SA-4.0  | |
| ZZC/panels/*                            | CC-BY-NC-SA-4.0  | The ZZC Logo is Copyright (c) 2019 Sergey Ukolov and cannot be used in derivative works; Cardinal's use does not officially constitute derivative work. |
| ZZC/fonts/DSEG/*                        | OFL-1.1-RFN      | |
| ZZC/fonts/Nunito/*                      | OFL-1.1-RFN      | |

### Rack

Below is a list of artwork licenses from Rack

| Name                            | License(s)       |
|---------------------------------|------------------|
| ComponentLibrary/*              | CC-BY-NC-4.0     |
| fonts/DejaVuSans.ttf            | Bitstream-Vera   |
| fonts/DSEG*.ttf                 | OFL-1.1-RFN      |
| fonts/Nunito-Bold.ttf           | OFL-1.1-RFN      |
| fonts/ShareTechMono-Regular.ttf | OFL-1.1-RFN      |
