/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI.Application;

import com.zeroc.IceGridGUI.Application.Editor;
import com.zeroc.IceGridGUI.Utils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;

public class ParameterValuesField
extends JTable {
    private JComboBox _useDefaultCombo = new JComboBox<String>(new String[]{"Use default"});
    private JComboBox _notSetCombo = new JComboBox<String>(new String[]{"Not set"});
    private TableCellEditor _useDefaultEditor = new DefaultCellEditor(this._useDefaultCombo);
    private TableCellEditor _notSetEditor = new DefaultCellEditor(this._notSetCombo);
    private DefaultTableModel _model;
    private Vector<String> _columnNames;
    private Editor _editor;
    private boolean[] _hasDefault;

    public ParameterValuesField(Editor editor) {
        this._editor = editor;
        this._columnNames = new Vector(2);
        this._columnNames.add("Name");
        this._columnNames.add("Value");
        this._useDefaultCombo.setEditable(true);
        this._notSetCombo.setEditable(true);
        int fontSize = this.getFont().getSize();
        int minRowHeight = fontSize + fontSize / 3;
        if (this.rowHeight < minRowHeight) {
            this.setRowHeight(minRowHeight);
        }
    }

    public void set(List<String> names, Map<String, String> values, Map<String, String> defaultValues, final Utils.Resolver resolver) {
        Vector vector = new Vector(names.size());
        this._hasDefault = new boolean[names.size()];
        int i = 0;
        for (String name : names) {
            Vector<String> row = new Vector<String>(2);
            row.add(name);
            this._hasDefault[i] = defaultValues.get(name) != null;
            String val = values.get(name);
            if (val == null) {
                row.add(this._hasDefault[i] ? "Use default" : "Not set");
            } else {
                row.add(Utils.substitute(val, resolver));
            }
            vector.add(row);
            ++i;
        }
        this._model = new DefaultTableModel(vector, this._columnNames){

            @Override
            public boolean isCellEditable(int row, int column) {
                if (resolver == null) {
                    return column > 0;
                }
                return false;
            }
        };
        this._model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                ParameterValuesField.this._editor.updated();
            }
        });
        this.setModel(this._model);
        this.setCellSelectionEnabled(resolver == null);
        this.setOpaque(resolver == null);
        this.setPreferredScrollableViewportSize(this.getPreferredSize());
        DefaultTableCellRenderer cr = (DefaultTableCellRenderer)this.getDefaultRenderer(String.class);
        cr.setOpaque(resolver == null);
    }

    public Map<String, String> getValues() {
        HashMap<String, String> values = new HashMap<String, String>();
        if (this.isEditing()) {
            this.getCellEditor().stopCellEditing();
        }
        Vector<Vector> vector = this._model.getDataVector();
        for (Vector row : vector) {
            String name = row.elementAt(0).toString();
            assert (name != null);
            String val = row.elementAt(1).toString();
            if (val == "Use default" || val == "Not set") continue;
            assert (val != null);
            values.put(name, val);
        }
        return values;
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        if (column == 1) {
            return this._hasDefault[row] ? this._useDefaultEditor : this._notSetEditor;
        }
        return super.getCellEditor(row, column);
    }
}

