/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.httppanel.view.text;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.zaproxy.zap.extension.httppanel.Message;
import org.zaproxy.zap.extension.search.SearchMatch;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.utils.ZapTextArea;
import org.zaproxy.zap.view.HighlightSearchEntry;
import org.zaproxy.zap.view.HighlighterManager;

public abstract class HttpPanelTextArea
extends ZapTextArea {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LogManager.getLogger(HttpPanelTextArea.class);
    private Message message = null;

    public HttpPanelTextArea() {
        this.initHighlighter();
    }

    private void initHighlighter() {
        HighlighterManager highlighter = HighlighterManager.getInstance();
        highlighter.addHighlighterManagerListener(e -> {
            switch (e.getType()) {
                case HIGHLIGHTS_SET: 
                case HIGHLIGHT_REMOVED: {
                    this.removeAllHighlights();
                    this.highlightAll();
                    break;
                }
                case HIGHLIGHT_ADDED: {
                    this.highlightEntryParser(e.getHighlight());
                }
            }
            this.invalidate();
        });
        if (this.message != null) {
            this.highlightAll();
        }
    }

    private void highlightAll() {
        HighlighterManager highlighter = HighlighterManager.getInstance();
        LinkedList<HighlightSearchEntry> highlights = highlighter.getHighlights();
        for (HighlightSearchEntry entry : highlights) {
            this.highlightEntryParser(entry);
        }
    }

    private void highlightEntryParser(HighlightSearchEntry entry) {
        int lastPos = 0;
        String text = this.getText();
        Highlighter hilite = this.getHighlighter();
        DefaultHighlighter.DefaultHighlightPainter painter = new DefaultHighlighter.DefaultHighlightPainter(entry.getColor());
        while ((lastPos = text.indexOf(entry.getToken(), lastPos)) > -1) {
            try {
                hilite.addHighlight(lastPos, lastPos + entry.getToken().length(), painter);
                lastPos += entry.getToken().length();
            }
            catch (BadLocationException e) {
                LOGGER.warn("Could not highlight entry", (Throwable)e);
            }
        }
    }

    @Override
    public void setText(String s) {
        super.setText(s);
        this.highlightAll();
    }

    protected void highlight(int start, int end) {
        Highlighter hilite = this.getHighlighter();
        DefaultHighlighter.DefaultHighlightPainter painter = new DefaultHighlighter.DefaultHighlightPainter(DisplayUtils.getHighlightColor());
        try {
            this.removeAllHighlights();
            hilite.addHighlight(start, end, painter);
            this.setCaretPosition(start);
        }
        catch (BadLocationException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private void removeAllHighlights() {
        Highlighter hilite = this.getHighlighter();
        hilite.removeAllHighlights();
    }

    public abstract void search(Pattern var1, List<SearchMatch> var2);

    public abstract void highlight(SearchMatch var1);

    public void setMessage(Message aMessage) {
        this.message = aMessage;
    }

    public Message getMessage() {
        return this.message;
    }
}

