/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.autoupdate;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.control.AddOnCollection;
import org.zaproxy.zap.extension.autoupdate.AddOnWrapper;
import org.zaproxy.zap.extension.autoupdate.AddOnsTableModel;
import org.zaproxy.zap.view.StatusUI;

public class UninstalledAddOnsTableModel
extends AddOnsTableModel {
    private static final long serialVersionUID = 1L;
    private static final String[] COLUMN_NAMES = new String[]{Constant.messages.getString("cfu.table.header.note"), Constant.messages.getString("cfu.table.header.status"), Constant.messages.getString("cfu.table.header.name"), Constant.messages.getString("cfu.table.header.desc"), Constant.messages.getString("cfu.table.header.update"), Constant.messages.getString("cfu.table.header.selected")};
    private static final int COLUMN_COUNT = COLUMN_NAMES.length;

    public UninstalledAddOnsTableModel(AddOnCollection installedAddOns) {
        super(installedAddOns, 4);
    }

    @Override
    public int getColumnCount() {
        return COLUMN_COUNT;
    }

    @Override
    public String getColumnName(int col) {
        return COLUMN_NAMES[col];
    }

    @Override
    public int getRowCount() {
        return this.getAddOnWrappers().size();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Icon.class;
        }
        if (columnIndex == 1) {
            return StatusUI.class;
        }
        if (columnIndex == 5) {
            return Boolean.class;
        }
        return String.class;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case -1: {
                return this.getAddOnWrapper(rowIndex);
            }
            case 0: {
                return this.getAddOnWrapper(rowIndex).hasRunningIssues();
            }
            case 1: {
                return View.getSingleton().getStatusUI(this.getAddOnWrapper(rowIndex).getAddOn().getStatus());
            }
            case 2: {
                return this.getAddOnWrapper(rowIndex).getAddOn().getName();
            }
            case 3: {
                return this.getAddOnWrapper(rowIndex).getAddOn().getDescription();
            }
            case 4: {
                int progress = this.getAddOnWrapper(rowIndex).getProgress();
                if (this.getAddOnWrapper(rowIndex).isFailed()) {
                    return Constant.messages.getString("cfu.download.failed");
                }
                if (progress > 0) {
                    return progress + "%";
                }
                if (AddOnWrapper.Status.newAddon == this.getAddOnWrapper(rowIndex).getStatus()) {
                    return Constant.messages.getString("cfu.table.label.new");
                }
                return this.getAddOnWrapper(rowIndex).getAddOn().getVersion();
            }
            case 5: {
                return this.getAddOnWrapper(rowIndex).isEnabled();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 5 && this.getAddOnWrapper(rowIndex).getInstallationStatus() != AddOn.InstallationStatus.DOWNLOADING && aValue instanceof Boolean) {
            this.getAddOnWrapper(rowIndex).setEnabled((Boolean)aValue);
            this.fireTableCellUpdated(rowIndex, columnIndex);
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 5 && this.getAddOnWrapper(rowIndex).getInstallationStatus() != AddOn.InstallationStatus.DOWNLOADING;
    }

    public boolean canIinstallSelected() {
        boolean enable = false;
        for (AddOnWrapper addon : this.getAddOnWrappers()) {
            if (!addon.isEnabled()) continue;
            return true;
        }
        return enable;
    }

    public Set<AddOn> getAvailableAddOns() {
        HashSet<AddOn> addOns = new HashSet<AddOn>();
        for (AddOnWrapper aow : this.getAddOnWrappers()) {
            if (aow.getInstallationStatus() != AddOn.InstallationStatus.AVAILABLE) continue;
            addOns.add(aow.getAddOn());
        }
        return addOns;
    }

    public boolean hasAvailableAddOns() {
        for (AddOnWrapper aow : this.getAddOnWrappers()) {
            if (aow.getInstallationStatus() != AddOn.InstallationStatus.AVAILABLE) continue;
            return true;
        }
        return false;
    }

    public void addAddOn(AddOn addOn) {
        this.addAddOnWrapper(addOn, null);
    }

    public void setAddOns(List<AddOn> addOnsNotInstalled, AddOnCollection olderAddOns) {
        if (!this.getAddOnWrappers().isEmpty()) {
            int rows = this.getAddOnWrappers().size();
            this.getAddOnWrappers().clear();
            this.fireTableRowsDeleted(0, rows - 1);
        }
        for (AddOn addOn : addOnsNotInstalled) {
            AddOnWrapper.Status status = null;
            if (olderAddOns != null && olderAddOns.getAddOn(addOn.getId()) == null) {
                status = AddOnWrapper.Status.newAddon;
            }
            this.addAddOnWrapper(addOn, status);
        }
    }

    @Override
    protected void restoreInstallationStatusFailedDownload(AddOnWrapper aow) {
        aow.setInstallationStatus(AddOn.InstallationStatus.AVAILABLE);
    }
}

