/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.coyote.ActionCode;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.descriptor.web.ErrorPage;
import org.apache.tomcat.util.res.StringManager;

final class StandardHostValve
extends ValveBase {
    private static final Log log = LogFactory.getLog(StandardHostValve.class);
    private static final StringManager sm = StringManager.getManager(StandardHostValve.class);
    private static final ClassLoader MY_CLASSLOADER = StandardHostValve.class.getClassLoader();
    static final boolean STRICT_SERVLET_COMPLIANCE = Globals.STRICT_SERVLET_COMPLIANCE;
    static final boolean ACCESS_SESSION;

    StandardHostValve() {
        super(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        Context context = request.getContext();
        if (context == null) {
            if (!response.isError()) {
                response.sendError(404);
            }
            return;
        }
        if (request.isAsyncSupported()) {
            request.setAsyncSupported(context.getPipeline().isAsyncSupported());
        }
        boolean bl = request.isAsync();
        try {
            block19: {
                context.bind(Globals.IS_SECURITY_ENABLED, MY_CLASSLOADER);
                if (!bl && !context.fireRequestInitEvent((ServletRequest)request.getRequest())) {
                    return;
                }
                try {
                    if (!response.isErrorReportRequired()) {
                        context.getPipeline().getFirst().invoke(request, response);
                    }
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                    this.container.getLogger().error((Object)sm.getString("standardHostValve.exception", new Object[]{request.getRequestURI()}), throwable);
                    if (response.isErrorReportRequired()) break block19;
                    request.setAttribute("javax.servlet.error.exception", throwable);
                    this.throwable(request, response, throwable);
                }
            }
            response.setSuspended(false);
            Throwable throwable = (Throwable)request.getAttribute("javax.servlet.error.exception");
            if (!context.getState().isAvailable()) {
                return;
            }
            if (response.isErrorReportRequired()) {
                AtomicBoolean atomicBoolean = new AtomicBoolean(false);
                response.getCoyoteResponse().action(ActionCode.IS_IO_ALLOWED, (Object)atomicBoolean);
                if (atomicBoolean.get()) {
                    if (throwable != null) {
                        this.throwable(request, response, throwable);
                    } else {
                        this.status(request, response);
                    }
                }
            }
            if (!request.isAsync() && !bl) {
                context.fireRequestDestroyEvent((ServletRequest)request.getRequest());
            }
        }
        finally {
            if (ACCESS_SESSION) {
                request.getSession(false);
            }
            context.unbind(Globals.IS_SECURITY_ENABLED, MY_CLASSLOADER);
        }
    }

    private void status(Request request, Response response) {
        int n = response.getStatus();
        Context context = request.getContext();
        if (context == null) {
            return;
        }
        if (!response.isError()) {
            return;
        }
        ErrorPage errorPage = context.findErrorPage(n);
        if (errorPage == null) {
            errorPage = context.findErrorPage(0);
        }
        if (errorPage != null && response.isErrorReportRequired()) {
            response.setAppCommitted(false);
            request.setAttribute("javax.servlet.error.status_code", n);
            String string = response.getMessage();
            if (string == null) {
                string = "";
            }
            request.setAttribute("javax.servlet.error.message", string);
            request.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", errorPage.getLocation());
            request.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", DispatcherType.ERROR);
            Wrapper wrapper = request.getWrapper();
            if (wrapper != null) {
                request.setAttribute("javax.servlet.error.servlet_name", wrapper.getName());
            }
            request.setAttribute("javax.servlet.error.request_uri", request.getRequestURI());
            if (this.custom(request, response, errorPage)) {
                response.setErrorReported();
                try {
                    response.finishResponse();
                }
                catch (ClientAbortException clientAbortException) {
                }
                catch (IOException iOException) {
                    this.container.getLogger().warn((Object)sm.getString("standardHostValve.exception", new Object[]{errorPage}), (Throwable)iOException);
                }
            }
        }
    }

    protected void throwable(Request request, Response response, Throwable throwable) {
        Context context = request.getContext();
        if (context == null) {
            return;
        }
        Throwable throwable2 = throwable;
        if (throwable2 instanceof ServletException && (throwable2 = ((ServletException)throwable2).getRootCause()) == null) {
            throwable2 = throwable;
        }
        if (throwable2 instanceof ClientAbortException) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("standardHost.clientAbort", new Object[]{throwable2.getCause().getMessage()}));
            }
            return;
        }
        ErrorPage errorPage = context.findErrorPage(throwable);
        if (errorPage == null && throwable2 != throwable) {
            errorPage = context.findErrorPage(throwable2);
        }
        if (errorPage != null) {
            if (response.setErrorReported()) {
                response.setAppCommitted(false);
                request.setAttribute("org.apache.catalina.core.DISPATCHER_REQUEST_PATH", errorPage.getLocation());
                request.setAttribute("org.apache.catalina.core.DISPATCHER_TYPE", DispatcherType.ERROR);
                request.setAttribute("javax.servlet.error.status_code", 500);
                request.setAttribute("javax.servlet.error.message", throwable.getMessage());
                request.setAttribute("javax.servlet.error.exception", throwable2);
                Wrapper wrapper = request.getWrapper();
                if (wrapper != null) {
                    request.setAttribute("javax.servlet.error.servlet_name", wrapper.getName());
                }
                request.setAttribute("javax.servlet.error.request_uri", request.getRequestURI());
                request.setAttribute("javax.servlet.error.exception_type", throwable2.getClass());
                if (this.custom(request, response, errorPage)) {
                    try {
                        response.finishResponse();
                    }
                    catch (IOException iOException) {
                        this.container.getLogger().warn((Object)sm.getString("standardHostValve.exception", new Object[]{errorPage}), (Throwable)iOException);
                    }
                }
            }
        } else {
            if (response.getStatus() < 400) {
                response.setStatus(500);
            }
            response.setError();
            this.status(request, response);
        }
    }

    private boolean custom(Request request, Response response, ErrorPage errorPage) {
        if (this.container.getLogger().isTraceEnabled()) {
            this.container.getLogger().trace((Object)("Processing " + errorPage));
        }
        try {
            ServletContext servletContext = request.getContext().getServletContext();
            RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(errorPage.getLocation());
            if (requestDispatcher == null) {
                this.container.getLogger().error((Object)sm.getString("standardHostValve.customStatusFailed", new Object[]{errorPage.getLocation()}));
                return false;
            }
            if (response.isCommitted()) {
                requestDispatcher.include((ServletRequest)request.getRequest(), (ServletResponse)response.getResponse());
                try {
                    response.flushBuffer();
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable((Throwable)throwable);
                }
                response.getCoyoteResponse().action(ActionCode.CLOSE_NOW, request.getAttribute("javax.servlet.error.exception"));
            } else {
                response.resetBuffer(true);
                response.setContentLength(-1);
                requestDispatcher.forward((ServletRequest)request.getRequest(), (ServletResponse)response.getResponse());
                response.setSuspended(false);
            }
            return true;
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            this.container.getLogger().error((Object)sm.getString("standardHostValve.exception", new Object[]{errorPage}), throwable);
            return false;
        }
    }

    static {
        String string = System.getProperty("org.apache.catalina.core.StandardHostValve.ACCESS_SESSION");
        ACCESS_SESSION = string == null ? STRICT_SERVLET_COMPLIANCE : Boolean.parseBoolean(string);
    }
}

