/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.engine.value.svg;

import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.CSSStylableElement;
import org.apache.batik.css.engine.StyleMap;
import org.apache.batik.css.engine.value.ListValue;
import org.apache.batik.css.engine.value.URIValue;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.css.engine.value.ValueConstants;
import org.apache.batik.css.engine.value.svg.SVGColorManager;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class SVGPaintManager
extends SVGColorManager {
    public SVGPaintManager(String string) {
        super(string);
    }

    public SVGPaintManager(String string, Value value) {
        super(string, value);
    }

    public boolean isInheritedProperty() {
        return true;
    }

    public boolean isAnimatableProperty() {
        return true;
    }

    public boolean isAdditiveProperty() {
        return true;
    }

    public int getPropertyType() {
        return 7;
    }

    public Value createValue(LexicalUnit lexicalUnit, CSSEngine cSSEngine) throws DOMException {
        switch (lexicalUnit.getLexicalUnitType()) {
            case 35: {
                if (lexicalUnit.getStringValue().equalsIgnoreCase("none")) {
                    return ValueConstants.NONE_VALUE;
                }
            }
            default: {
                return super.createValue(lexicalUnit, cSSEngine);
            }
            case 24: 
        }
        String string = lexicalUnit.getStringValue();
        String string2 = SVGPaintManager.resolveURI(cSSEngine.getCSSBaseURI(), string);
        lexicalUnit = lexicalUnit.getNextLexicalUnit();
        if (lexicalUnit == null) {
            return new URIValue(string, string2);
        }
        ListValue listValue = new ListValue(' ');
        listValue.append(new URIValue(string, string2));
        if (lexicalUnit.getLexicalUnitType() == 35 && lexicalUnit.getStringValue().equalsIgnoreCase("none")) {
            listValue.append(ValueConstants.NONE_VALUE);
            return listValue;
        }
        Value value = super.createValue(lexicalUnit, cSSEngine);
        if (value.getCssValueType() == 3) {
            ListValue listValue2 = (ListValue)value;
            for (int i = 0; i < listValue2.getLength(); ++i) {
                listValue.append(listValue2.item(i));
            }
        } else {
            listValue.append(value);
        }
        return listValue;
    }

    public Value computeValue(CSSStylableElement cSSStylableElement, String string, CSSEngine cSSEngine, int n, StyleMap styleMap, Value value) {
        ListValue listValue;
        Value value2;
        if (value == ValueConstants.NONE_VALUE) {
            return value;
        }
        if (value.getCssValueType() == 2 && (value2 = (listValue = (ListValue)value).item(0)).getPrimitiveType() == 20) {
            value2 = listValue.item(1);
            if (value2 == ValueConstants.NONE_VALUE) {
                return value;
            }
            Value value3 = super.computeValue(cSSStylableElement, string, cSSEngine, n, styleMap, value2);
            if (value3 != value2) {
                ListValue listValue2 = new ListValue(' ');
                listValue2.append(listValue.item(0));
                listValue2.append(value3);
                if (listValue.getLength() == 3) {
                    listValue2.append(listValue.item(1));
                }
                return listValue2;
            }
            return value;
        }
        return super.computeValue(cSSStylableElement, string, cSSEngine, n, styleMap, value);
    }
}

