/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.processor.aggregate.OptimisticLockRetryPolicy;
import org.apache.camel.spi.Metadata;

@Metadata(label="configuration")
@XmlRootElement(name="optimisticLockRetryPolicy")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class OptimisticLockRetryPolicyDefinition {
    @XmlAttribute
    private Integer maximumRetries;
    @XmlAttribute
    @Metadata(defaultValue="50")
    private Long retryDelay;
    @XmlAttribute
    @Metadata(defaultValue="1000")
    private Long maximumRetryDelay;
    @XmlAttribute
    @Metadata(defaultValue="true")
    private Boolean exponentialBackOff;
    @XmlAttribute
    private Boolean randomBackOff;

    public OptimisticLockRetryPolicy createOptimisticLockRetryPolicy() {
        OptimisticLockRetryPolicy policy = new OptimisticLockRetryPolicy();
        if (this.maximumRetries != null) {
            policy.setMaximumRetries(this.maximumRetries);
        }
        if (this.retryDelay != null) {
            policy.setRetryDelay(this.retryDelay);
        }
        if (this.maximumRetryDelay != null) {
            policy.setMaximumRetryDelay(this.maximumRetryDelay);
        }
        if (this.exponentialBackOff != null) {
            policy.setExponentialBackOff(this.exponentialBackOff);
        }
        if (this.randomBackOff != null) {
            policy.setRandomBackOff(this.randomBackOff);
        }
        return policy;
    }

    public OptimisticLockRetryPolicyDefinition maximumRetries(int maximumRetries) {
        this.setMaximumRetries(maximumRetries);
        return this;
    }

    public Integer getMaximumRetries() {
        return this.maximumRetries;
    }

    public void setMaximumRetries(Integer maximumRetries) {
        this.maximumRetries = maximumRetries;
    }

    public OptimisticLockRetryPolicyDefinition retryDelay(long retryDelay) {
        this.setRetryDelay(retryDelay);
        return this;
    }

    public Long getRetryDelay() {
        return this.retryDelay;
    }

    public void setRetryDelay(Long retryDelay) {
        this.retryDelay = retryDelay;
    }

    public OptimisticLockRetryPolicyDefinition maximumRetryDelay(long maximumRetryDelay) {
        this.setMaximumRetryDelay(maximumRetryDelay);
        return this;
    }

    public Long getMaximumRetryDelay() {
        return this.maximumRetryDelay;
    }

    public void setMaximumRetryDelay(Long maximumRetryDelay) {
        this.maximumRetryDelay = maximumRetryDelay;
    }

    public OptimisticLockRetryPolicyDefinition exponentialBackOff() {
        return this.exponentialBackOff(true);
    }

    public OptimisticLockRetryPolicyDefinition exponentialBackOff(boolean exponentialBackOff) {
        this.setExponentialBackOff(exponentialBackOff);
        return this;
    }

    public Boolean getExponentialBackOff() {
        return this.exponentialBackOff;
    }

    public void setExponentialBackOff(Boolean exponentialBackOff) {
        this.exponentialBackOff = exponentialBackOff;
    }

    public OptimisticLockRetryPolicyDefinition randomBackOff() {
        return this.randomBackOff(true);
    }

    public OptimisticLockRetryPolicyDefinition randomBackOff(boolean randomBackOff) {
        this.setRandomBackOff(randomBackOff);
        return this;
    }

    public Boolean getRandomBackOff() {
        return this.randomBackOff;
    }

    public void setRandomBackOff(Boolean randomBackOff) {
        this.randomBackOff = randomBackOff;
    }
}

