/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.plugin.jpms;

import aQute.bnd.build.model.EE;
import aQute.bnd.classfile.builder.ModuleInfoBuilder;
import aQute.bnd.header.Attrs;
import aQute.bnd.header.OSGiHeader;
import aQute.bnd.header.Parameters;
import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.Descriptors;
import aQute.bnd.osgi.EmbeddedResource;
import aQute.bnd.osgi.Instructions;
import aQute.bnd.osgi.Jar;
import aQute.bnd.osgi.Packages;
import aQute.bnd.osgi.Processor;
import aQute.bnd.service.verifier.VerifierPlugin;
import aQute.bnd.stream.MapStream;
import aQute.lib.io.ByteBufferDataOutput;
import aQute.lib.strings.Strings;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPMSModuleInfoPlugin
implements VerifierPlugin {
    private static final Logger logger = LoggerFactory.getLogger(JPMSModuleInfoPlugin.class);
    private static final Pattern mangledModuleName = Pattern.compile("(.*)-\\d.*");
    private static final EE DEFAULT_MODULE_EE = EE.JavaSE_11_0;
    private static final String INTERNAL_MODULE_DIRECTIVE = "-internal-module:";
    private static final String WEB_INF = "WEB-INF";

    @Override
    public void verify(Analyzer analyzer) throws Exception {
        Parameters moduleParameters;
        String moduleProperty = analyzer.getProperty("-jpms-module-info");
        if (moduleProperty == null) {
            return;
        }
        Parameters provideCapabilities = new Parameters(analyzer.getJar().getManifest().getMainAttributes().getValue("Provide-Capability"));
        Parameters requireCapabilities = new Parameters(analyzer.getJar().getManifest().getMainAttributes().getValue("Require-Capability"));
        if (moduleProperty.isEmpty()) {
            String name = this.name(analyzer);
            int access = this.access(requireCapabilities);
            String version = analyzer.getVersion();
            moduleProperty = String.format("%s;access=%s;version=%s", name, access, version);
        }
        if ((moduleParameters = OSGiHeader.parseHeader(moduleProperty)).isEmpty()) {
            return;
        }
        if (moduleParameters.size() > 1) {
            throw new IllegalArgumentException("Only one -module instruction is allowed:" + moduleParameters);
        }
        Map.Entry<String, Attrs> moduleInstructions = moduleParameters.stream().findFirst().get();
        Parameters moduleInfoOptions = OSGiHeader.parseHeader(analyzer.getProperty("-jpms-module-info-options"));
        Packages index = new Packages();
        for (Jar jar : analyzer.getClasspath()) {
            String moduleName = this.getModuleName(analyzer, jar, moduleInfoOptions);
            String moduleVersion = jar.getModuleVersion();
            Attrs attrs = new Attrs();
            if (moduleName != null) {
                attrs.put(INTERNAL_MODULE_DIRECTIVE, moduleName);
            }
            if (moduleVersion != null) {
                attrs.put("-internal-module-version:", moduleVersion);
            }
            MapStream.of(jar.getDirectories()).filter((k, v) -> v != null && !v.isEmpty() && !k.isEmpty()).keys().map(analyzer::getPackageRef).filter(ref -> !ref.isMetaData() && !ref.getPath().startsWith(WEB_INF)).forEach(ref -> index.put((Descriptors.PackageRef)ref, new Attrs(attrs)));
        }
        ModuleInfoBuilder builder = this.nameAccessAndVersion(moduleInstructions, requireCapabilities, analyzer);
        this.requires(moduleInstructions, analyzer, index, moduleInfoOptions, builder);
        this.exportPackages(analyzer, builder);
        this.openPackages(analyzer, builder);
        this.serviceLoaderProviders(provideCapabilities, analyzer, builder);
        this.serviceLoaderUses(requireCapabilities, analyzer, builder);
        this.mainClass(analyzer, builder);
        ByteBufferDataOutput bbout = new ByteBufferDataOutput();
        builder.build().write(bbout);
        analyzer.getJar().putResource("module-info.class", new EmbeddedResource(bbout.toByteBuffer(), analyzer.lastModified()));
    }

    private String getModuleName(Analyzer analyzer, Jar jar, Parameters moduleInfoOptions) throws Exception {
        String moduleName = jar.getModuleName();
        if (moduleName == null) {
            if (jar.getSource() != null && jar.getSource().isDirectory()) {
                return null;
            }
            moduleName = jar.getName();
            Matcher matcher = mangledModuleName.matcher(moduleName);
            if (matcher.matches()) {
                moduleName = matcher.group(1);
            }
            String name = moduleName;
            moduleName = moduleInfoOptions.stream().filterValue(attrs -> name.equals(attrs.get("substitute"))).keys().findFirst().orElse(moduleName);
            if (logger.isWarnEnabled()) {
                logger.warn("Using module name '{}' for: {}", (Object)moduleName, (Object)jar);
            }
        }
        return moduleName;
    }

    private int access(Parameters requireCapabilities) {
        return requireCapabilities.stream().filterKey(key -> Processor.removeDuplicateMarker(key).equals("osgi.extender")).mapToInt((k, v) -> 32).findAny().orElse(0);
    }

    private String name(Analyzer analyzer) {
        return analyzer.getProperty("Automatic-Module-Name", analyzer.getBsn());
    }

    private void exportPackages(Analyzer analyzer, ModuleInfoBuilder builder) {
        Packages contained = analyzer.getContained();
        analyzer.getExports().forEach((packageRef, attrs) -> {
            Set targets = Collections.emptySet();
            Attrs containedAttrs = contained.get((Descriptors.PackageRef)packageRef);
            if (containedAttrs != null && containedAttrs.containsKey("-internal-export-to-modules:")) {
                targets = Strings.splitAsStream(containedAttrs.get("-internal-export-to-modules:")).collect(Collectors.toCollection(LinkedHashSet::new));
            }
            builder.exports(packageRef.getBinary(), 0, targets);
        });
    }

    private void mainClass(Analyzer analyzer, ModuleInfoBuilder builder) {
        String mainClass = analyzer.getProperty("Main-Class");
        if (mainClass != null) {
            Descriptors.TypeRef typeRef = analyzer.getTypeRefFromFQN(mainClass);
            builder.mainClass(typeRef.getBinary());
        }
    }

    private ModuleInfoBuilder nameAccessAndVersion(Map.Entry<String, Attrs> instruction, Parameters requireCapability, Analyzer analyzer) {
        Attrs attrs = instruction.getValue();
        String name = instruction.getKey();
        String access = attrs.computeIfAbsent("access", k -> String.valueOf(this.access(requireCapability)));
        String version = attrs.computeIfAbsent("version", k -> analyzer.getVersion());
        ModuleInfoBuilder builder = new ModuleInfoBuilder().module_name(name).module_version(version).module_flags(Access.parse(access).getValue());
        return builder;
    }

    private void openPackages(Analyzer analyzer, ModuleInfoBuilder builder) {
        analyzer.getContained().stream().filterValue(attrs -> attrs.containsKey("-internal-open-to-modules:")).forEach((packageRef, attrs) -> {
            Set targets = Strings.splitAsStream(attrs.get("-internal-open-to-modules:")).collect(Collectors.toCollection(LinkedHashSet::new));
            builder.opens(packageRef.getBinary(), 0, targets);
        });
    }

    private void requires(Map.Entry<String, Attrs> instruction, Analyzer analyzer, Packages index, Parameters moduleInfoOptions, ModuleInfoBuilder builder) throws Exception {
        String eeAttribute = instruction.getValue().get("ee");
        EE moduleEE = eeAttribute != null ? Optional.of(eeAttribute).map(EE::parse).orElseThrow(() -> new IllegalArgumentException("unrecognize ee name: " + eeAttribute)) : DEFAULT_MODULE_EE;
        Packages exports = analyzer.getExports();
        Packages imports = analyzer.getImports();
        Packages referred = analyzer.getReferred();
        Instructions dynamicImportPackages = new Instructions(new Parameters(analyzer.getJar().getManifest().getMainAttributes().getValue("DynamicImport-Package")));
        Packages externallyReferred = new Packages(referred);
        exports.keySet().forEach(externallyReferred::remove);
        Map<String, List<Map.Entry>> requiresMap = externallyReferred.stream().filterKey(packageRef -> {
            Attrs attrs = index.get((Descriptors.PackageRef)packageRef);
            Attrs importAttrs = imports.get((Descriptors.PackageRef)packageRef);
            if (attrs == null || !attrs.containsKey(INTERNAL_MODULE_DIRECTIVE)) {
                String eeModuleName = moduleEE.getModules().stream().filterValue(a -> a.getTyped(Attrs.LIST_STRING, "exports").contains(packageRef.getFQN())).keys().findAny().orElse(null);
                if (eeModuleName == null) {
                    if (logger.isWarnEnabled()) {
                        logger.warn("Can't find a module name for imported package: {}", (Object)packageRef.getFQN());
                    }
                    return false;
                }
                attrs = Attrs.create(INTERNAL_MODULE_DIRECTIVE, eeModuleName);
                index.put((Descriptors.PackageRef)packageRef, attrs);
            }
            if (importAttrs != null) {
                attrs.mergeWith(importAttrs, false);
            }
            return true;
        }).collect(Collectors.groupingBy(entry -> index.get((Descriptors.PackageRef)entry.getKey()).get(INTERNAL_MODULE_DIRECTIVE)));
        String manuallyRequiredModules = instruction.getValue().get("modules");
        if (manuallyRequiredModules != null) {
            Strings.splitAsStream(manuallyRequiredModules).forEach(moduleToAdd -> requiresMap.computeIfAbsent((String)moduleToAdd, key -> Collections.emptyList()));
        }
        MapStream.of(requiresMap).sortedByKey().mapValue(referencedPackages -> MapStream.of(referencedPackages).keys().collect(Collectors.toList())).forEach((moduleName, referencedModulePackages) -> {
            Attrs moduleMappingAttrs = Optional.ofNullable(moduleInfoOptions.get((String)moduleName)).orElseGet(Attrs::new);
            if (Processor.isTrue(moduleMappingAttrs.get("ignore"))) {
                return;
            }
            boolean isTransitive = Optional.ofNullable(moduleMappingAttrs.get("transitive")).map(Processor::isTrue).orElseGet(() -> exports.values().stream().map(a -> a.get("uses:")).flatMap(Strings::splitAsStream).map(analyzer::getPackageRef).anyMatch(referencedModulePackages::contains));
            boolean isStatic = Optional.ofNullable(moduleMappingAttrs.get("static")).map(Processor::isTrue).orElseGet(() -> referencedModulePackages.isEmpty() || referencedModulePackages.stream().allMatch(p -> {
                Attrs attrs = index.get((Descriptors.PackageRef)p);
                if ("optional".equals(attrs.get("resolution:"))) {
                    return true;
                }
                return !dynamicImportPackages.isEmpty() && dynamicImportPackages.matches(p.getFQN());
            }));
            int access = (isTransitive ? 32 : 0) | (isStatic ? 64 : 0);
            builder.requires((String)moduleName, access, null);
        });
    }

    private void serviceLoaderProviders(Parameters provideCapabilities, Analyzer analyzer, ModuleInfoBuilder builder) {
        provideCapabilities.stream().filterKey(namespace -> Processor.removeDuplicateMarker(namespace).equals("osgi.serviceloader")).filterValue(attrs -> attrs.containsKey("register:")).values().collect(Collectors.groupingBy(attrs -> analyzer.getTypeRefFromFQN(attrs.get("osgi.serviceloader")))).entrySet().forEach(entry -> {
            Descriptors.TypeRef typeRef = (Descriptors.TypeRef)entry.getKey();
            Set impls = ((List)entry.getValue()).stream().map(attrs -> attrs.get("register:")).map(impl -> analyzer.getTypeRefFromFQN((String)impl).getBinary()).collect(Collectors.toCollection(LinkedHashSet::new));
            builder.provides(typeRef.getBinary(), impls);
        });
    }

    private void serviceLoaderUses(Parameters requireCapabilities, Analyzer analyzer, ModuleInfoBuilder builder) {
        requireCapabilities.stream().filterKey(key -> Processor.removeDuplicateMarker(key).equals("osgi.serviceloader")).values().forEach(attrs -> {
            Descriptors.TypeRef typeRef = analyzer.getTypeRefFromFQN(attrs.get("osgi.serviceloader"));
            builder.uses(typeRef.getBinary());
        });
    }

    static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }

    static enum Access {
        CLOSED(0),
        OPEN(32),
        SYNTHETIC(4096),
        MANDATED(32768);

        private final int value;

        public static Access parse(String input) {
            switch (input) {
                case "OPEN": 
                case "open": 
                case "0x0020": 
                case "32": {
                    return OPEN;
                }
                case "SYNTHETIC": 
                case "synthetic": 
                case "0x1000": 
                case "4096": {
                    return SYNTHETIC;
                }
                case "MANDATED": 
                case "mandated": 
                case "0x8000": 
                case "32768": {
                    return MANDATED;
                }
            }
            int parsedValue = Integer.decode(input);
            return Arrays.stream(Access.values()).filter(a -> a.getValue() == parsedValue).findFirst().orElseThrow(() -> new IllegalArgumentException(input));
        }

        private Access(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

