/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.soap;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.AccessController;
import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.soap.SOAPException;
import org.apache.karaf.specs.locator.OsgiLocator;

class $FactoryFinder {
    private static final Logger LOGGER = Logger.getLogger("javax.xml.soap");

    $FactoryFinder() {
    }

    static <T> T find(Class<T> factoryClass, String defaultClassName, boolean tryFallback, String deprecatedFactoryId) throws SOAPException {
        ClassLoader tccl = $FactoryFinder.contextClassLoader();
        String factoryId = factoryClass.getName();
        String className = $FactoryFinder.fromSystemProperty(factoryId, deprecatedFactoryId);
        if (className != null) {
            Object result = $FactoryFinder.newInstance(className, defaultClassName, tccl);
            return (T)result;
        }
        className = $FactoryFinder.fromJDKProperties(factoryId, deprecatedFactoryId);
        if (className != null) {
            Object result = $FactoryFinder.newInstance(className, defaultClassName, tccl);
            return (T)result;
        }
        try {
            Class spiClass = OsgiLocator.locate(factoryClass);
            if (spiClass != null) {
                return spiClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Throwable spiClass) {
            // empty catch block
        }
        T factory = $FactoryFinder.firstByServiceLoader(factoryClass);
        if (factory != null) {
            return factory;
        }
        className = $FactoryFinder.fromMetaInfServices(deprecatedFactoryId, tccl);
        if (className != null) {
            LOGGER.log(Level.WARNING, "Using deprecated META-INF/services mechanism with non-standard property: {0}. Property {1} should be used instead.", new Object[]{deprecatedFactoryId, factoryId});
            Object result = $FactoryFinder.newInstance(className, defaultClassName, tccl);
            return (T)result;
        }
        if (!tryFallback) {
            return null;
        }
        if (defaultClassName == null) {
            throw new SOAPException("Provider for " + factoryId + " cannot be found", null);
        }
        return (T)$FactoryFinder.newInstance(defaultClassName, defaultClassName, tccl);
    }

    static <T> T find(Class<T> factoryClass, String defaultClassName, boolean tryFallback) throws SOAPException {
        return $FactoryFinder.find(factoryClass, defaultClassName, tryFallback, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String fromMetaInfServices(String deprecatedFactoryId, ClassLoader tccl) {
        String serviceId = "META-INF/services/" + deprecatedFactoryId;
        LOGGER.log(Level.FINE, "Checking deprecated {0} resource", serviceId);
        try (InputStream is = tccl == null ? ClassLoader.getSystemResourceAsStream(serviceId) : tccl.getResourceAsStream(serviceId);){
            String factoryClassName;
            if (is == null) return null;
            try (InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
                 BufferedReader rd = new BufferedReader(isr);){
                factoryClassName = rd.readLine();
            }
            $FactoryFinder.logFound(factoryClassName);
            if (factoryClassName == null) return null;
            if ("".equals(factoryClassName)) return null;
            String string = factoryClassName;
            return string;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static String fromJDKProperties(String factoryId, String deprecatedFactoryId) {
        block18: {
            Path path = null;
            try {
                String JAVA_HOME = $FactoryFinder.getSystemProperty("java.home");
                path = Paths.get(JAVA_HOME, "conf", "jaxm.properties");
                LOGGER.log(Level.FINE, "Checking configuration in {0}", path);
                if (!Files.exists(path, new LinkOption[0])) {
                    path = Paths.get(JAVA_HOME, "lib", "jaxm.properties");
                }
                LOGGER.log(Level.FINE, "Checking configuration in {0}", path);
                if (!Files.exists(path, new LinkOption[0])) break block18;
                Properties props = new Properties();
                try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
                    props.load(inputStream);
                }
                LOGGER.log(Level.FINE, "Checking property {0}", factoryId);
                String factoryClassName = props.getProperty(factoryId);
                $FactoryFinder.logFound(factoryClassName);
                if (factoryClassName != null) {
                    return factoryClassName;
                }
                if (deprecatedFactoryId != null) {
                    LOGGER.log(Level.FINE, "Checking deprecated property {0}", deprecatedFactoryId);
                    factoryClassName = props.getProperty(deprecatedFactoryId);
                    $FactoryFinder.logFound(factoryClassName);
                    if (factoryClassName != null) {
                        LOGGER.log(Level.WARNING, "Using non-standard property: {0}. Property {1} should be used instead.", new Object[]{deprecatedFactoryId, factoryId});
                        return factoryClassName;
                    }
                }
            }
            catch (Exception ignored) {
                LOGGER.log(Level.SEVERE, "Error reading SAAJ configuration from [" + path + "] file. Check it is accessible and has correct format.", ignored);
            }
        }
        return null;
    }

    private static String fromSystemProperty(String factoryId, String deprecatedFactoryId) {
        String systemProp = $FactoryFinder.getSystemProperty(factoryId);
        if (systemProp != null) {
            return systemProp;
        }
        if (deprecatedFactoryId != null && (systemProp = $FactoryFinder.getSystemProperty(deprecatedFactoryId)) != null) {
            LOGGER.log(Level.WARNING, "Using non-standard property: {0}. Property {1} should be used instead.", new Object[]{deprecatedFactoryId, factoryId});
            return systemProp;
        }
        return null;
    }

    private static String getSystemProperty(String property) {
        LOGGER.log(Level.FINE, "Checking system property {0}", property);
        String value = AccessController.doPrivileged(() -> System.getProperty(property));
        $FactoryFinder.logFound(value);
        return value;
    }

    private static void logFound(String value) {
        if (value != null) {
            LOGGER.log(Level.FINE, "  found {0}", value);
        } else {
            LOGGER.log(Level.FINE, "  not found");
        }
    }

    private static <T> T firstByServiceLoader(Class<T> spiClass) throws SOAPException {
        LOGGER.log(Level.FINE, "Using java.util.ServiceLoader to find {0}", spiClass.getName());
        try {
            ServiceLoader<T> serviceLoader = ServiceLoader.load(spiClass);
            Iterator<T> iterator = serviceLoader.iterator();
            if (iterator.hasNext()) {
                T impl = iterator.next();
                LOGGER.fine("ServiceProvider loading Facility used; returning object [" + impl.getClass().getName() + "]");
                return impl;
            }
        }
        catch (Throwable t) {
            throw new SOAPException("Error while searching for service [" + spiClass.getName() + "]", t);
        }
        return null;
    }

    private static void checkPackageAccess(String className) {
        int i;
        SecurityManager s = System.getSecurityManager();
        if (s != null && (i = className.lastIndexOf(46)) != -1) {
            s.checkPackageAccess(className.substring(0, i));
        }
    }

    private static Class nullSafeLoadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        if (classLoader == null) {
            return Class.forName(className);
        }
        return classLoader.loadClass(className);
    }

    static Object newInstance(String className, String defaultImplClassName, ClassLoader classLoader) throws SOAPException {
        try {
            return $FactoryFinder.safeLoadClass(className, defaultImplClassName, classLoader).getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException x) {
            throw new SOAPException("Provider " + className + " not found", (Throwable)x);
        }
        catch (Exception x) {
            throw new SOAPException("Provider " + className + " could not be instantiated: " + x, (Throwable)x);
        }
    }

    private static Class<?> safeLoadClass(String className, String defaultImplClassName, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            $FactoryFinder.checkPackageAccess(className);
        }
        catch (SecurityException se) {
            if (defaultImplClassName != null && defaultImplClassName.equals(className)) {
                return Class.forName(className);
            }
            throw se;
        }
        return $FactoryFinder.nullSafeLoadClass(className, classLoader);
    }

    private static ClassLoader contextClassLoader() throws SOAPException {
        try {
            return Thread.currentThread().getContextClassLoader();
        }
        catch (Exception x) {
            throw new SOAPException(x.toString(), (Throwable)x);
        }
    }
}

