/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.core.event;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.karaf.cellar.core.event.Event;
import org.apache.karaf.cellar.core.event.EventDispatchTask;
import org.apache.karaf.cellar.core.event.EventDispatcher;
import org.apache.karaf.cellar.core.event.EventHandlerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventHandlerRegistryDispatcher<E extends Event>
implements EventDispatcher<E> {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(EventHandlerRegistryDispatcher.class);
    private ExecutorService threadPool;
    private EventHandlerRegistry handlerRegistry;

    public void init() {
        if (this.threadPool == null) {
            if (Boolean.getBoolean(this.getClass().getName() + ".threadPool.singleThreadExecutor")) {
                LOGGER.info("Will use an Executor that uses a single worker thread");
                this.threadPool = Executors.newSingleThreadExecutor();
            } else {
                LOGGER.info("Will use an Executor with a pool of threads");
                this.threadPool = Executors.newCachedThreadPool();
            }
        }
    }

    @Override
    public void dispatch(E event) {
        EventDispatchTask<E> task = new EventDispatchTask<E>(event, this.handlerRegistry);
        this.threadPool.execute(task);
    }

    public EventHandlerRegistry getHandlerRegistry() {
        return this.handlerRegistry;
    }

    public void setHandlerRegistry(EventHandlerRegistry handlerRegistry) {
        this.handlerRegistry = handlerRegistry;
    }

    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(ExecutorService threadPool) {
        this.threadPool = threadPool;
    }

    public void destroy() {
        if (this.threadPool != null) {
            this.threadPool.shutdown();
        }
    }
}

