/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.network.InetAddresses;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.common.util.LocaleUtils;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.plain.DocValuesIndexFieldData;
import org.elasticsearch.index.mapper.CustomDocValuesField;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.RangeType;
import org.elasticsearch.index.mapper.TypeParsers;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.search.DocValueFormat;

public class RangeFieldMapper
extends FieldMapper {
    public static final boolean DEFAULT_INCLUDE_UPPER = true;
    public static final boolean DEFAULT_INCLUDE_LOWER = true;
    static final Setting<Boolean> COERCE_SETTING = Setting.boolSetting("index.mapping.coerce", true, Setting.Property.IndexScope);
    private Explicit<Boolean> coerce;

    private RangeFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Explicit<Boolean> coerce, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, indexSettings, multiFields, copyTo);
        this.coerce = coerce;
    }

    @Override
    public RangeFieldType fieldType() {
        return (RangeFieldType)super.fieldType();
    }

    @Override
    protected String contentType() {
        return this.fieldType.typeName();
    }

    @Override
    protected RangeFieldMapper clone() {
        return (RangeFieldMapper)super.clone();
    }

    @Override
    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        Range range;
        if (context.externalValueSet()) {
            range = context.parseExternalValue(Range.class);
        } else {
            XContentParser parser = context.parser();
            XContentParser.Token start = parser.currentToken();
            if (start == XContentParser.Token.VALUE_NULL) {
                return;
            }
            if (start == XContentParser.Token.START_OBJECT) {
                XContentParser.Token token;
                RangeFieldType fieldType = this.fieldType();
                RangeType rangeType = fieldType.rangeType;
                String fieldName = null;
                Object from = rangeType.minValue();
                Object to = rangeType.maxValue();
                boolean includeFrom = true;
                boolean includeTo = true;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        fieldName = parser.currentName();
                        continue;
                    }
                    if (fieldName.equals(RangeQueryBuilder.GT_FIELD.getPreferredName())) {
                        includeFrom = false;
                        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) continue;
                        from = rangeType.parseFrom(fieldType, parser, this.coerce.value(), includeFrom);
                        continue;
                    }
                    if (fieldName.equals(RangeQueryBuilder.GTE_FIELD.getPreferredName())) {
                        includeFrom = true;
                        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) continue;
                        from = rangeType.parseFrom(fieldType, parser, this.coerce.value(), includeFrom);
                        continue;
                    }
                    if (fieldName.equals(RangeQueryBuilder.LT_FIELD.getPreferredName())) {
                        includeTo = false;
                        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) continue;
                        to = rangeType.parseTo(fieldType, parser, this.coerce.value(), includeTo);
                        continue;
                    }
                    if (fieldName.equals(RangeQueryBuilder.LTE_FIELD.getPreferredName())) {
                        includeTo = true;
                        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) continue;
                        to = rangeType.parseTo(fieldType, parser, this.coerce.value(), includeTo);
                        continue;
                    }
                    throw new MapperParsingException("error parsing field [" + this.name() + "], with unknown parameter [" + fieldName + "]");
                }
                range = new Range(rangeType, from, to, includeFrom, includeTo);
            } else if (this.fieldType().rangeType == RangeType.IP && start == XContentParser.Token.VALUE_STRING) {
                range = RangeFieldMapper.parseIpRangeFromCidr(parser);
            } else {
                throw new MapperParsingException("error parsing field [" + this.name() + "], expected an object but got " + parser.currentName());
            }
        }
        boolean indexed = this.fieldType.indexOptions() != IndexOptions.NONE;
        boolean docValued = this.fieldType.hasDocValues();
        boolean stored = this.fieldType.stored();
        fields.addAll(this.fieldType().rangeType.createFields(context, this.name(), range, indexed, docValued, stored));
        if (!docValued && (indexed || stored)) {
            this.createFieldNamesField(context, fields);
        }
    }

    @Override
    protected void doMerge(Mapper mergeWith) {
        super.doMerge(mergeWith);
        RangeFieldMapper other = (RangeFieldMapper)mergeWith;
        if (other.coerce.explicit()) {
            this.coerce = other.coerce;
        }
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (this.fieldType().rangeType == RangeType.DATE && (includeDefaults || this.fieldType().dateTimeFormatter() != null && !this.fieldType().dateTimeFormatter().pattern().equals(DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER.pattern()))) {
            builder.field("format", this.fieldType().dateTimeFormatter().pattern());
        }
        if (this.fieldType().rangeType == RangeType.DATE && (includeDefaults || this.fieldType().dateTimeFormatter() != null && this.fieldType().dateTimeFormatter().locale() != Locale.ROOT)) {
            builder.field("locale", this.fieldType().dateTimeFormatter().locale());
        }
        if (includeDefaults || this.coerce.explicit()) {
            builder.field("coerce", this.coerce.value());
        }
    }

    private static Range parseIpRangeFromCidr(XContentParser parser) throws IOException {
        Tuple<InetAddress, Integer> cidr = InetAddresses.parseCidr(parser.text());
        byte[] lower = cidr.v1().getAddress();
        byte[] upper = (byte[])lower.clone();
        for (int i = cidr.v2().intValue(); i < 8 * lower.length; ++i) {
            int m = 1 << 7 - (i & 7);
            int n = i >> 3;
            lower[n] = (byte)(lower[n] & ~m);
            int n2 = i >> 3;
            upper[n2] = (byte)(upper[n2] | m);
        }
        try {
            return new Range(RangeType.IP, InetAddress.getByAddress(lower), InetAddress.getByAddress(upper), true, true);
        }
        catch (UnknownHostException bogus) {
            throw new AssertionError((Object)bogus);
        }
    }

    static class BinaryRangesDocValuesField
    extends CustomDocValuesField {
        private final Set<Range> ranges;
        private final RangeType rangeType;

        BinaryRangesDocValuesField(String name, Range range, RangeType rangeType) {
            super(name);
            this.rangeType = rangeType;
            this.ranges = new HashSet<Range>();
            this.add(range);
        }

        void add(Range range) {
            this.ranges.add(range);
        }

        public BytesRef binaryValue() {
            try {
                return this.rangeType.encodeRanges(this.ranges);
            }
            catch (IOException e) {
                throw new ElasticsearchException("failed to encode ranges", (Throwable)e, new Object[0]);
            }
        }
    }

    public static class Range {
        RangeType type;
        Object from;
        Object to;
        private boolean includeFrom;
        private boolean includeTo;

        public Range(RangeType type, Object from, Object to, boolean includeFrom, boolean includeTo) {
            this.type = type;
            this.from = from;
            this.to = to;
            this.includeFrom = includeFrom;
            this.includeTo = includeTo;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Range range = (Range)o;
            return this.includeFrom == range.includeFrom && this.includeTo == range.includeTo && this.type == range.type && this.from.equals(range.from) && this.to.equals(range.to);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.from, this.to, this.includeFrom, this.includeTo});
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.includeFrom ? (char)'[' : '(');
            Object f = this.includeFrom || this.from.equals(this.type.minValue()) ? this.from : this.type.nextDown(this.from);
            Object t = this.includeTo || this.to.equals(this.type.maxValue()) ? this.to : this.type.nextUp(this.to);
            sb.append(this.type == RangeType.IP ? InetAddresses.toAddrString((InetAddress)f) : f.toString());
            sb.append(" : ");
            sb.append(this.type == RangeType.IP ? InetAddresses.toAddrString((InetAddress)t) : t.toString());
            sb.append(this.includeTo ? (char)']' : ')');
            return sb.toString();
        }

        public Object getFrom() {
            return this.from;
        }

        public Object getTo() {
            return this.to;
        }
    }

    public static final class RangeFieldType
    extends MappedFieldType {
        protected RangeType rangeType;
        protected DateFormatter dateTimeFormatter;
        protected DateMathParser dateMathParser;

        RangeFieldType(RangeType type) {
            this.rangeType = Objects.requireNonNull(type);
            this.setTokenized(false);
            this.setHasDocValues(true);
            this.setOmitNorms(true);
            if (this.rangeType == RangeType.DATE) {
                this.setDateTimeFormatter(DateFieldMapper.DEFAULT_DATE_TIME_FORMATTER);
            }
        }

        RangeFieldType(RangeFieldType other) {
            super(other);
            this.rangeType = other.rangeType;
            if (other.rangeType == RangeType.DATE && other.dateTimeFormatter() != null) {
                this.setDateTimeFormatter(other.dateTimeFormatter());
            }
        }

        public RangeType rangeType() {
            return this.rangeType;
        }

        @Override
        public MappedFieldType clone() {
            return new RangeFieldType(this);
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            RangeFieldType that = (RangeFieldType)((Object)o);
            return Objects.equals((Object)this.rangeType, (Object)that.rangeType) && this.rangeType == RangeType.DATE ? Objects.equals(this.dateTimeFormatter, that.dateTimeFormatter) : this.dateTimeFormatter == null && that.dateTimeFormatter == null;
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{super.hashCode(), this.rangeType, this.dateTimeFormatter});
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName) {
            this.failIfNoDocValues();
            return new DocValuesIndexFieldData.Builder().setRangeType(this.rangeType);
        }

        @Override
        public String typeName() {
            return this.rangeType.name;
        }

        public DateFormatter dateTimeFormatter() {
            return this.dateTimeFormatter;
        }

        public void setDateTimeFormatter(DateFormatter dateTimeFormatter) {
            this.checkIfFrozen();
            this.dateTimeFormatter = dateTimeFormatter;
            this.dateMathParser = dateTimeFormatter.toDateMathParser();
        }

        protected DateMathParser dateMathParser() {
            return this.dateMathParser;
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            if (this.hasDocValues()) {
                return new DocValuesFieldExistsQuery(this.name());
            }
            return new TermQuery(new Term("_field_names", this.name()));
        }

        @Override
        public DocValueFormat docValueFormat(String format, ZoneId timeZone) {
            if (this.rangeType == RangeType.DATE) {
                DateFormatter dateTimeFormatter = this.dateTimeFormatter;
                if (format != null) {
                    dateTimeFormatter = DateFormatter.forPattern(format).withLocale(dateTimeFormatter.locale());
                }
                if (timeZone == null) {
                    timeZone = ZoneOffset.UTC;
                }
                return new DocValueFormat.DateTime(dateTimeFormatter, timeZone, DateFieldMapper.Resolution.MILLISECONDS);
            }
            return super.docValueFormat(format, timeZone);
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            Query query = this.rangeQuery(value, value, true, true, ShapeRelation.INTERSECTS, null, null, context);
            if (this.boost() != 1.0f) {
                query = new BoostQuery(query, this.boost());
            }
            return query;
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, ShapeRelation relation, ZoneId timeZone, DateMathParser parser, QueryShardContext context) {
            this.failIfNotIndexed();
            if (parser == null) {
                parser = this.dateMathParser();
            }
            return this.rangeType.rangeQuery(this.name(), this.hasDocValues(), lowerTerm, upperTerm, includeLower, includeUpper, relation, timeZone, parser, context);
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        final RangeType type;

        public TypeParser(RangeType type) {
            this.type = type;
        }

        @Override
        public Mapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name, this.type);
            TypeParsers.parseField(builder, name, node, parserContext);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = entry.getKey();
                Object propNode = entry.getValue();
                if (propName.equals("null_value")) {
                    throw new MapperParsingException("Property [null_value] is not supported for [" + this.type.name + "] field types.");
                }
                if (propName.equals("coerce")) {
                    builder.coerce(XContentMapValues.nodeBooleanValue(propNode, name + ".coerce"));
                    iterator.remove();
                    continue;
                }
                if (propName.equals("locale")) {
                    builder.locale(LocaleUtils.parse(propNode.toString()));
                    iterator.remove();
                    continue;
                }
                if (propName.equals("format")) {
                    builder.format(propNode.toString());
                    iterator.remove();
                    continue;
                }
                if (!TypeParsers.parseMultiField(builder, name, parserContext, propName, propNode)) continue;
                iterator.remove();
            }
            return builder;
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder, RangeFieldMapper> {
        private Boolean coerce;
        private Locale locale = Locale.ROOT;
        private String pattern;

        public Builder(String name, RangeType type) {
            super(name, new RangeFieldType(type), new RangeFieldType(type));
            this.builder = this;
        }

        @Override
        public RangeFieldType fieldType() {
            return (RangeFieldType)this.fieldType;
        }

        @Override
        public Builder docValues(boolean docValues) {
            if (docValues) {
                throw new IllegalArgumentException("field [" + this.name + "] does not currently support " + "doc_values");
            }
            return (Builder)super.docValues(docValues);
        }

        public Builder coerce(boolean coerce) {
            this.coerce = coerce;
            return (Builder)this.builder;
        }

        protected Explicit<Boolean> coerce(Mapper.BuilderContext context) {
            if (this.coerce != null) {
                return new Explicit<Boolean>(this.coerce, true);
            }
            if (context.indexSettings() != null) {
                return new Explicit<Boolean>(COERCE_SETTING.get(context.indexSettings()), false);
            }
            return Defaults.COERCE;
        }

        public Builder format(String format) {
            this.pattern = format;
            return this;
        }

        @Override
        public Builder nullValue(Object nullValue) {
            throw new IllegalArgumentException("Field [" + this.name() + "] does not support null value.");
        }

        public void locale(Locale locale) {
            this.locale = locale;
        }

        @Override
        protected void setupFieldType(Mapper.BuilderContext context) {
            super.setupFieldType(context);
            DateFormatter formatter = this.fieldType().dateTimeFormatter;
            if (this.fieldType().rangeType == RangeType.DATE) {
                boolean hasPatternChanged;
                boolean bl = hasPatternChanged = Strings.hasLength(((Builder)this.builder).pattern) && !Objects.equals(((Builder)this.builder).pattern, formatter.pattern());
                if (hasPatternChanged || !Objects.equals(((Builder)this.builder).locale, formatter.locale())) {
                    this.fieldType().setDateTimeFormatter(DateFormatter.forPattern(this.pattern).withLocale(this.locale));
                }
            } else if (this.pattern != null) {
                throw new IllegalArgumentException("field [" + this.name() + "] of type [" + (Object)((Object)this.fieldType().rangeType) + "] should not define a dateTimeFormatter unless it is a " + (Object)((Object)RangeType.DATE) + " type");
            }
        }

        @Override
        public RangeFieldMapper build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            return new RangeFieldMapper(this.name, this.fieldType, this.defaultFieldType, this.coerce(context), context.indexSettings(), this.multiFieldsBuilder.build(this, context), this.copyTo);
        }
    }

    public static class Defaults {
        public static final Explicit<Boolean> COERCE = new Explicit<Boolean>(true, false);
    }
}

