/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.core.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.DateSchema;
import io.swagger.v3.oas.models.media.DateTimeSchema;
import io.swagger.v3.oas.models.media.EmailSchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.PasswordSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.media.UUIDSchema;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

public class ModelDeserializer
extends JsonDeserializer<Schema> {
    public Schema deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        String format;
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        JsonNode allOf = node.get("allOf");
        JsonNode anyOf = node.get("anyOf");
        JsonNode oneOf = node.get("oneOf");
        Schema schema = null;
        if (allOf != null || anyOf != null || oneOf != null) {
            ComposedSchema composedSchema = (ComposedSchema)Json.mapper().convertValue((Object)node, ComposedSchema.class);
            return composedSchema;
        }
        JsonNode type = node.get("type");
        String string = format = node.get("format") == null ? "" : node.get("format").textValue();
        if (type != null && "array".equals(((TextNode)type).textValue())) {
            schema = (Schema)Json.mapper().convertValue((Object)node, ArraySchema.class);
        } else if (type != null) {
            if (type.textValue().equals("integer")) {
                schema = (Schema)Json.mapper().convertValue((Object)node, IntegerSchema.class);
                if (StringUtils.isBlank((CharSequence)format)) {
                    schema.setFormat(null);
                }
            } else if (type.textValue().equals("number")) {
                schema = (Schema)Json.mapper().convertValue((Object)node, NumberSchema.class);
            } else if (type.textValue().equals("boolean")) {
                schema = (Schema)Json.mapper().convertValue((Object)node, BooleanSchema.class);
            } else if (type.textValue().equals("string")) {
                schema = "date".equals(format) ? (Schema)Json.mapper().convertValue((Object)node, DateSchema.class) : ("date-time".equals(format) ? (Schema)Json.mapper().convertValue((Object)node, DateTimeSchema.class) : ("email".equals(format) ? (Schema)Json.mapper().convertValue((Object)node, EmailSchema.class) : ("password".equals(format) ? (Schema)Json.mapper().convertValue((Object)node, PasswordSchema.class) : ("uuid".equals(format) ? (Schema)Json.mapper().convertValue((Object)node, UUIDSchema.class) : (Schema)Json.mapper().convertValue((Object)node, StringSchema.class)))));
            } else if (type.textValue().equals("object")) {
                schema = this.deserializeObjectSchema(node);
            }
        } else {
            schema = node.get("$ref") != null ? new Schema().$ref(node.get("$ref").asText()) : this.deserializeObjectSchema(node);
        }
        return schema;
    }

    private Schema deserializeObjectSchema(JsonNode node) {
        JsonNode additionalProperties = node.get("additionalProperties");
        Schema schema = null;
        if (additionalProperties != null) {
            try {
                Schema innerSchema = (Schema)Json.mapper().convertValue((Object)additionalProperties, Schema.class);
                ((ObjectNode)node).remove("additionalProperties");
                MapSchema ms = (MapSchema)Json.mapper().convertValue((Object)node, MapSchema.class);
                ms.setAdditionalProperties((Object)innerSchema);
                schema = ms;
            }
            catch (Exception e) {
                Boolean additionalPropsBoolean = (Boolean)Json.mapper().convertValue((Object)additionalProperties, Boolean.class);
                schema = additionalPropsBoolean != false ? (Schema)Json.mapper().convertValue((Object)node, MapSchema.class) : (Schema)Json.mapper().convertValue((Object)node, ObjectSchema.class);
                schema.setAdditionalProperties((Object)additionalPropsBoolean);
            }
        } else {
            schema = (Schema)Json.mapper().convertValue((Object)node, ObjectSchema.class);
        }
        return schema;
    }
}

