/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.runtimecatalog;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class UnsafeUriCharactersEncoder {
    private static BitSet unsafeCharactersRfc1738;
    private static BitSet unsafeCharactersHttp;
    private static final char[] HEX_DIGITS;
    private static final Pattern RAW_PATTERN;

    private UnsafeUriCharactersEncoder() {
    }

    public static String encode(String s) {
        return UnsafeUriCharactersEncoder.encode(s, unsafeCharactersRfc1738);
    }

    public static String encodeHttpURI(String s) {
        return UnsafeUriCharactersEncoder.encode(s, unsafeCharactersHttp);
    }

    public static String encode(String s, BitSet unsafeCharacters) {
        return UnsafeUriCharactersEncoder.encode(s, unsafeCharacters, false);
    }

    public static String encode(String s, boolean checkRaw) {
        return UnsafeUriCharactersEncoder.encode(s, unsafeCharactersRfc1738, checkRaw);
    }

    public static String encodeHttpURI(String s, boolean checkRaw) {
        return UnsafeUriCharactersEncoder.encode(s, unsafeCharactersHttp, checkRaw);
    }

    private static List<Pair> checkRAW(String s) {
        Matcher matcher = RAW_PATTERN.matcher(s);
        ArrayList<Pair> answer = new ArrayList<Pair>();
        while (matcher.find()) {
            answer.add(new Pair(matcher.start(), matcher.end()));
        }
        return answer;
    }

    private static boolean isRaw(int index, List<Pair> pairs) {
        for (Pair pair : pairs) {
            if (index < pair.left) {
                return false;
            }
            if (index < pair.left || index > pair.right) continue;
            return true;
        }
        return false;
    }

    public static String encode(String s, BitSet unsafeCharacters, boolean checkRaw) {
        int n;
        List<Pair> rawPairs = checkRaw ? UnsafeUriCharactersEncoder.checkRAW(s) : new ArrayList<Pair>();
        int n2 = n = s == null ? 0 : s.length();
        if (n == 0) {
            return s;
        }
        char[] chars = s.toCharArray();
        int i = 0;
        while (chars[i] <= '\u0000' || chars[i] >= '\u0080' || !unsafeCharacters.get(chars[i])) {
            if (++i < chars.length) continue;
            return s;
        }
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < chars.length; ++i2) {
            char ch = chars[i2];
            if (ch > '\u0000' && ch < '\u0080' && unsafeCharacters.get(ch)) {
                if (ch == '%') {
                    char next2;
                    char next = i2 + 1 < chars.length ? chars[i2 + 1] : (char)' ';
                    char c = next2 = i2 + 2 < chars.length ? chars[i2 + 2] : (char)' ';
                    if (UnsafeUriCharactersEncoder.isHexDigit(next) && UnsafeUriCharactersEncoder.isHexDigit(next2) && !UnsafeUriCharactersEncoder.isRaw(i2, rawPairs)) {
                        sb.append(ch);
                        continue;
                    }
                    UnsafeUriCharactersEncoder.appendEscape(sb, (byte)ch);
                    continue;
                }
                UnsafeUriCharactersEncoder.appendEscape(sb, (byte)ch);
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    private static void appendEscape(StringBuilder sb, byte b) {
        sb.append('%');
        sb.append(HEX_DIGITS[b >> 4 & 0xF]);
        sb.append(HEX_DIGITS[b >> 0 & 0xF]);
    }

    private static boolean isHexDigit(char ch) {
        for (char hex : HEX_DIGITS) {
            if (hex != ch) continue;
            return true;
        }
        return false;
    }

    static {
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'a', 'b', 'c', 'd', 'e', 'f'};
        RAW_PATTERN = Pattern.compile("RAW\\([^\\)]+\\)");
        unsafeCharactersRfc1738 = new BitSet(256);
        unsafeCharactersRfc1738.set(32);
        unsafeCharactersRfc1738.set(34);
        unsafeCharactersRfc1738.set(60);
        unsafeCharactersRfc1738.set(62);
        unsafeCharactersRfc1738.set(35);
        unsafeCharactersRfc1738.set(37);
        unsafeCharactersRfc1738.set(123);
        unsafeCharactersRfc1738.set(125);
        unsafeCharactersRfc1738.set(124);
        unsafeCharactersRfc1738.set(92);
        unsafeCharactersRfc1738.set(94);
        unsafeCharactersRfc1738.set(126);
        unsafeCharactersRfc1738.set(91);
        unsafeCharactersRfc1738.set(93);
        unsafeCharactersRfc1738.set(96);
        unsafeCharactersHttp = new BitSet(256);
        unsafeCharactersHttp.set(32);
        unsafeCharactersHttp.set(34);
        unsafeCharactersHttp.set(60);
        unsafeCharactersHttp.set(62);
        unsafeCharactersHttp.set(35);
        unsafeCharactersHttp.set(37);
        unsafeCharactersHttp.set(123);
        unsafeCharactersHttp.set(125);
        unsafeCharactersHttp.set(124);
        unsafeCharactersHttp.set(92);
        unsafeCharactersHttp.set(94);
        unsafeCharactersHttp.set(126);
        unsafeCharactersHttp.set(96);
    }

    private static class Pair {
        int left;
        int right;

        Pair(int left, int right) {
            this.left = left;
            this.right = right;
        }
    }
}

