/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy.txn.xa;

import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.XATransactionCommitCodec;
import com.hazelcast.client.impl.protocol.codec.XATransactionCreateCodec;
import com.hazelcast.client.impl.protocol.codec.XATransactionPrepareCodec;
import com.hazelcast.client.impl.protocol.codec.XATransactionRollbackCodec;
import com.hazelcast.client.proxy.txn.ClientTransactionUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionNotActiveException;
import com.hazelcast.transaction.impl.Transaction;
import com.hazelcast.transaction.impl.xa.SerializableXID;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import java.util.concurrent.TimeUnit;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class XATransactionProxy {
    private final HazelcastClientInstanceImpl client;
    private final ClientConnection connection;
    private final SerializableXID xid;
    private final int timeout;
    private final ILogger logger;
    private Transaction.State state = Transaction.State.NO_TXN;
    private volatile String txnId;
    private long startTime;

    public XATransactionProxy(HazelcastClientInstanceImpl client, ClientConnection connection, Xid xid, int timeout) {
        this.client = client;
        this.connection = connection;
        this.timeout = timeout;
        this.xid = new SerializableXID(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier());
        this.logger = client.getLoggingService().getLogger(XATransactionProxy.class);
    }

    void begin() {
        try {
            this.startTime = Clock.currentTimeMillis();
            ClientMessage request = XATransactionCreateCodec.encodeRequest(this.xid, this.timeout);
            ClientMessage response = ClientTransactionUtil.invoke(request, this.txnId, this.client, this.connection);
            this.txnId = XATransactionCreateCodec.decodeResponse((ClientMessage)response).response;
            this.state = Transaction.State.ACTIVE;
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    void prepare() {
        this.checkTimeout();
        try {
            if (this.state != Transaction.State.ACTIVE) {
                throw new TransactionNotActiveException("Transaction is not active");
            }
            ClientMessage request = XATransactionPrepareCodec.encodeRequest(this.txnId);
            ClientTransactionUtil.invoke(request, this.txnId, this.client, this.connection);
            this.state = Transaction.State.PREPARED;
        }
        catch (Exception e) {
            this.state = Transaction.State.ROLLING_BACK;
            throw ExceptionUtil.rethrow(e);
        }
    }

    void commit(boolean onePhase) {
        this.checkTimeout();
        try {
            if (onePhase && this.state != Transaction.State.ACTIVE) {
                throw new TransactionException("Transaction is not active");
            }
            if (!onePhase && this.state != Transaction.State.PREPARED) {
                throw new TransactionException("Transaction is not prepared");
            }
            this.state = Transaction.State.COMMITTING;
            ClientMessage request = XATransactionCommitCodec.encodeRequest(this.txnId, onePhase);
            ClientTransactionUtil.invoke(request, this.txnId, this.client, this.connection);
            this.state = Transaction.State.COMMITTED;
        }
        catch (Exception e) {
            this.state = Transaction.State.COMMIT_FAILED;
            throw ExceptionUtil.rethrow(e);
        }
    }

    void rollback() {
        this.state = Transaction.State.ROLLING_BACK;
        try {
            ClientMessage request = XATransactionRollbackCodec.encodeRequest(this.txnId);
            ClientTransactionUtil.invoke(request, this.txnId, this.client, this.connection);
        }
        catch (Exception exception) {
            this.logger.warning("Exception while rolling back the transaction", exception);
        }
        this.state = Transaction.State.ROLLED_BACK;
    }

    public String getTxnId() {
        return this.txnId;
    }

    public Transaction.State getState() {
        return this.state;
    }

    private void checkTimeout() {
        long timeoutMillis = TimeUnit.SECONDS.toMillis(this.timeout);
        if (this.startTime + timeoutMillis < Clock.currentTimeMillis()) {
            ExceptionUtil.sneakyThrow(new XAException(106));
        }
    }
}

