/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.adapter.vinci.util;

import org.apache.vinci.transport.Attributes;
import org.apache.vinci.transport.FrameComponent;
import org.apache.vinci.transport.FrameLeaf;
import org.apache.vinci.transport.KeyValuePair;
import org.apache.vinci.transport.VinciFrame;
import org.apache.vinci.transport.document.AFrame;
import org.apache.vinci.transport.document.AFrameLeaf;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class VinciSaxParser {
    private ContentHandler mHandler;

    public void setContentHandler(ContentHandler aHandler) {
        this.mHandler = aHandler;
    }

    public void parse(VinciFrame aFrame) throws SAXException {
        this.parse(aFrame, true);
    }

    public void parse(VinciFrame aFrame, boolean aSendStartAndEndDocEvents) throws SAXException {
        if (aSendStartAndEndDocEvents) {
            this.mHandler.startDocument();
        }
        this._parse(aFrame);
        if (aSendStartAndEndDocEvents) {
            this.mHandler.endDocument();
        }
    }

    protected void _parse(VinciFrame aFrame) throws SAXException {
        int count = aFrame.getKeyValuePairCount();
        for (int i = 0; i < count; ++i) {
            KeyValuePair kvp = aFrame.getKeyValuePair(i);
            boolean isIndexed = false;
            FrameComponent val = kvp.getValue();
            AttributesImpl attrs = new AttributesImpl();
            Attributes vinciAttrs = null;
            if (val instanceof AFrame) {
                vinciAttrs = ((AFrame)val).getAttributes();
            } else if (val instanceof AFrameLeaf) {
                vinciAttrs = ((AFrameLeaf)val).getAttributes();
            }
            if (vinciAttrs != null) {
                for (int j = 0; j < vinciAttrs.getKeyValuePairCount(); ++j) {
                    KeyValuePair attr = vinciAttrs.getKeyValuePair(j);
                    String attrName = attr.getKey();
                    String attrVal = attr.getValueAsString();
                    attrs.addAttribute("", attrName, attrName, "CDATA", attrVal);
                    if (!attrName.equals("_indexed")) continue;
                    isIndexed = true;
                }
            }
            if (!isIndexed && !kvp.getKey().equals("i")) {
                attrs.addAttribute("", "_indexed", "_indexed", "CDATA", "true");
            }
            this.mHandler.startElement("", kvp.getKey(), kvp.getKey(), attrs);
            if (val instanceof FrameLeaf) {
                String leafString = ((FrameLeaf)val).toString();
                this.mHandler.characters(leafString.toCharArray(), 0, leafString.length());
            } else if (val instanceof VinciFrame) {
                this._parse((VinciFrame)val);
            } else {
                throw new SAXException("Expected FrameLeaf or VinciFrame, found " + val.getClass());
            }
            this.mHandler.endElement("", kvp.getKey(), kvp.getKey());
        }
    }
}

