/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.utilities;

import com.strobel.core.Pair;
import com.strobel.functions.Function;
import com.strobel.util.ContractUtils;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Stack;

public final class TreeTraversal {
    public static <T> Iterable<T> preOrder(T root, Function<T, Iterable<T>> recursion) {
        return TreeTraversal.preOrder(Collections.singletonList(root), recursion);
    }

    public static <T> Iterable<T> preOrder(final Iterable<T> input, final Function<T, Iterable<T>> recursion) {
        return new Iterable<T>(){

            @Override
            public final Iterator<T> iterator() {
                return new Iterator<T>(){
                    final Stack<Iterator<T>> stack = new Stack();
                    boolean returnedCurrent;
                    T next;
                    {
                        this.stack.push(input.iterator());
                    }

                    private T selectNext() {
                        if (this.next != null) {
                            return this.next;
                        }
                        while (!this.stack.isEmpty()) {
                            if (this.stack.peek().hasNext()) {
                                Iterable children;
                                this.next = this.stack.peek().next();
                                if (this.next != null && (children = (Iterable)recursion.apply(this.next)) != null) {
                                    this.stack.push(children.iterator());
                                }
                                return this.next;
                            }
                            this.stack.pop();
                        }
                        return null;
                    }

                    @Override
                    public final boolean hasNext() {
                        return this.selectNext() != null;
                    }

                    @Override
                    public final T next() {
                        Object next = this.selectNext();
                        if (next == null) {
                            throw new NoSuchElementException();
                        }
                        this.next = null;
                        return next;
                    }

                    @Override
                    public final void remove() {
                        throw ContractUtils.unsupported();
                    }
                };
            }
        };
    }

    public static <T> Iterable<T> postOrder(T root, Function<T, Iterable<T>> recursion) {
        return TreeTraversal.postOrder(Collections.singletonList(root), recursion);
    }

    public static <T> Iterable<T> postOrder(final Iterable<T> input, final Function<T, Iterable<T>> recursion) {
        return new Iterable<T>(){

            @Override
            public final Iterator<T> iterator() {
                return new Iterator<T>(){
                    final Stack<Pair<Iterator<T>, T>> stack = new Stack();
                    boolean returnedCurrent;
                    T next;
                    {
                        this.stack.push(Pair.create(input.iterator(), (Object)null));
                    }

                    private T selectNext() {
                        if (this.next != null) {
                            return this.next;
                        }
                        while (!this.stack.isEmpty()) {
                            while (((Iterator)this.stack.peek().getFirst()).hasNext()) {
                                Iterable children;
                                this.next = ((Iterator)this.stack.peek().getFirst()).next();
                                if (this.next != null && (children = (Iterable)recursion.apply(this.next)) != null) {
                                    this.stack.push(Pair.create(children.iterator(), this.next));
                                    continue;
                                }
                                return this.next;
                            }
                            this.next = this.stack.pop().getSecond();
                            if (this.next == null) continue;
                            return this.next;
                        }
                        return null;
                    }

                    @Override
                    public final boolean hasNext() {
                        return this.selectNext() != null;
                    }

                    @Override
                    public final T next() {
                        Object next = this.selectNext();
                        if (next == null) {
                            throw new NoSuchElementException();
                        }
                        this.next = null;
                        return next;
                    }

                    @Override
                    public final void remove() {
                        throw ContractUtils.unsupported();
                    }
                };
            }
        };
    }
}

