/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.ComposedType;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.InvocationExpression;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.MemberReferenceExpression;
import com.strobel.decompiler.languages.java.ast.NodeType;
import com.strobel.decompiler.languages.java.ast.TypeReferenceExpression;
import com.strobel.decompiler.patterns.BacktrackingInfo;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.Pattern;
import com.strobel.decompiler.patterns.Role;
import com.strobel.util.ContractUtils;

public abstract class AstType
extends AstNode {
    public static final AstType[] EMPTY_TYPES = new AstType[0];
    public static final AstType NULL = new NullAstType();

    @Override
    public NodeType getNodeType() {
        return NodeType.TYPE_REFERENCE;
    }

    public TypeReference toTypeReference() {
        return this.getUserData(Keys.TYPE_REFERENCE);
    }

    public Role<? extends AstType> getRole() {
        return super.getRole();
    }

    public static AstType forPattern(Pattern pattern) {
        return new PatternPlaceholder((Pattern)VerifyArgument.notNull((Object)pattern, (String)"pattern"));
    }

    @Override
    public AstType clone() {
        return (AstType)super.clone();
    }

    public AstType makeArrayType() {
        ComposedType composedType = new ComposedType();
        composedType.setBaseType(this);
        TypeReference typeReference = this.getUserData(Keys.TYPE_REFERENCE);
        if (typeReference != null) {
            composedType.putUserData(Keys.TYPE_REFERENCE, typeReference);
        }
        composedType.makeArrayType();
        return composedType;
    }

    public InvocationExpression invoke(String methodName, Expression ... arguments) {
        return new TypeReferenceExpression(-34, this).invoke(methodName, arguments);
    }

    public InvocationExpression invoke(String methodName, Iterable<Expression> arguments) {
        return new TypeReferenceExpression(-34, this).invoke(methodName, arguments);
    }

    public InvocationExpression invoke(String methodName, Iterable<AstType> typeArguments, Expression ... arguments) {
        return new TypeReferenceExpression(-34, this).invoke(methodName, typeArguments, arguments);
    }

    public InvocationExpression invoke(String methodName, Iterable<AstType> typeArguments, Iterable<Expression> arguments) {
        return new TypeReferenceExpression(-34, this).invoke(methodName, typeArguments, arguments);
    }

    public MemberReferenceExpression member(String memberName) {
        return new TypeReferenceExpression(-34, this).member(memberName);
    }

    private static final class PatternPlaceholder
    extends AstType {
        private final Pattern _child;

        PatternPlaceholder(Pattern child) {
            this._child = child;
        }

        @Override
        public NodeType getNodeType() {
            return NodeType.PATTERN;
        }

        @Override
        public TypeReference toTypeReference() {
            throw ContractUtils.unsupported();
        }

        @Override
        public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
            return visitor.visitPatternPlaceholder(this, this._child, data);
        }

        @Override
        public boolean matches(INode other, Match match) {
            return this._child.matches(other, match);
        }

        @Override
        public boolean matchesCollection(Role role, INode position, Match match, BacktrackingInfo backtrackingInfo) {
            return this._child.matchesCollection(role, position, match, backtrackingInfo);
        }
    }

    private static final class NullAstType
    extends AstType {
        private NullAstType() {
        }

        @Override
        public boolean isNull() {
            return true;
        }

        @Override
        public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
            return null;
        }

        @Override
        public boolean matches(INode other, Match match) {
            return other == null || other.isNull();
        }

        @Override
        public TypeReference toTypeReference() {
            throw ContractUtils.unreachable();
        }
    }
}

