/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.ast;

import com.strobel.core.VerifyArgument;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Range
implements Comparable<Range> {
    private int _start;
    private int _end;

    public Range() {
    }

    public Range(int start, int end) {
        this._start = start;
        this._end = end;
    }

    public final int getStart() {
        return this._start;
    }

    public final void setStart(int start) {
        this._start = start;
    }

    public final int getEnd() {
        return this._end;
    }

    public final void setEnd(int end) {
        this._end = end;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Range) {
            Range range = (Range)o;
            return range._end == this._end && range._start == this._start;
        }
        return false;
    }

    public final boolean contains(int location) {
        return location >= this._start && location <= this._end;
    }

    public final boolean contains(int start, int end) {
        return start >= this._start && end <= this._end;
    }

    public final boolean contains(Range range) {
        return range != null && range._start >= this._start && range._end <= this._end;
    }

    public final boolean intersects(Range range) {
        return range != null && range._start <= this._end && range._end >= this._start;
    }

    public final int hashCode() {
        int result = this._start;
        result = 31 * result + this._end;
        return result;
    }

    @Override
    public final int compareTo(Range o) {
        if (o == null) {
            return 1;
        }
        int compareResult = Integer.compare(this._start, o._start);
        return compareResult != 0 ? compareResult : Integer.compare(this._end, o._end);
    }

    public final String toString() {
        return String.format("Range(%d, %d)", this._start, this._end);
    }

    public static List<Range> orderAndJoint(Iterable<Range> input) {
        VerifyArgument.notNull(input, (String)"input");
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (Range range : input) {
            if (range == null) continue;
            ranges.add(range);
        }
        Collections.sort(ranges);
        int i = 0;
        while (i < ranges.size() - 1) {
            Range current = ranges.get(i);
            Range next = ranges.get(i + 1);
            if (current.getStart() <= next.getStart() && next.getStart() <= current.getEnd()) {
                current.setEnd(Math.max(current.getEnd(), next.getEnd()));
                ranges.remove(i + 1);
                continue;
            }
            ++i;
        }
        return ranges;
    }

    public static List<Range> invert(Iterable<Range> input, int codeSize) {
        VerifyArgument.notNull(input, (String)"input");
        VerifyArgument.isPositive((int)codeSize, (String)"codeSize");
        List<Range> ordered = Range.orderAndJoint(input);
        if (ordered.isEmpty()) {
            return Collections.singletonList(new Range(0, codeSize));
        }
        ArrayList<Range> inverted = new ArrayList<Range>();
        if (ordered.get(0).getStart() != 0) {
            inverted.add(new Range(0, ordered.get(0).getStart()));
        }
        for (int i = 0; i < ordered.size() - 1; ++i) {
            inverted.add(new Range(ordered.get(i).getEnd(), ordered.get(i + 1).getStart()));
        }
        assert (ordered.get(ordered.size() - 1).getEnd() <= codeSize);
        if (ordered.get(ordered.size() - 1).getEnd() != codeSize) {
            inverted.add(new Range(ordered.get(ordered.size() - 1).getEnd(), codeSize));
        }
        return inverted;
    }
}

