/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.jcas.cas;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.uima.cas.BooleanArrayFS;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.JCasRegistry;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.cas.TOP_Type;

public final class BooleanArray
extends TOP
implements BooleanArrayFS,
Iterable<Boolean> {
    public static final int typeIndexID;
    public static final int type;

    @Override
    public int getTypeIndexID() {
        return typeIndexID;
    }

    private BooleanArray() {
    }

    public BooleanArray(int addr, TOP_Type type) {
        super(addr, type);
    }

    public BooleanArray(JCas jcas, int length) {
        this(jcas.getLowLevelCas().ll_createBooleanArray(length), jcas.getType(typeIndexID));
    }

    @Override
    public boolean get(int i) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, i);
        return this.jcasType.ll_cas.ll_getBooleanArrayValue(this.addr, i);
    }

    @Override
    public void set(int i, boolean v) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, i);
        this.jcasType.ll_cas.ll_setBooleanArrayValue(this.addr, i, v);
    }

    @Override
    public void copyFromArray(boolean[] src, int srcOffset, int destOffset, int length) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, destOffset, length);
        for (int i = 0; i < length; ++i) {
            this.jcasType.ll_cas.ll_setBooleanArrayValue(this.addr, i + destOffset, src[i + srcOffset]);
        }
    }

    @Override
    public void copyToArray(int srcOffset, boolean[] dest, int destOffset, int length) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, srcOffset, length);
        for (int i = 0; i < length; ++i) {
            dest[i + destOffset] = this.jcasType.ll_cas.ll_getBooleanArrayValue(this.addr, i + srcOffset);
        }
    }

    @Override
    public boolean[] toArray() {
        int size = this.size();
        boolean[] outArray = new boolean[size];
        this.copyToArray(0, outArray, 0, size);
        return outArray;
    }

    @Override
    public int size() {
        return this.jcasType.casImpl.ll_getArraySize(this.addr);
    }

    @Override
    public void copyToArray(int srcOffset, String[] dest, int destOffset, int length) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, srcOffset, length);
        for (int i = 0; i < length; ++i) {
            dest[i + destOffset] = Boolean.toString(this.jcasType.ll_cas.ll_getBooleanArrayValue(this.addr, i + srcOffset));
        }
    }

    @Override
    public void copyFromArray(String[] src, int srcOffset, int destOffset, int length) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, destOffset, length);
        for (int i = 0; i < length; ++i) {
            this.jcasType.ll_cas.ll_setBooleanArrayValue(this.addr, i + destOffset, "true".equalsIgnoreCase(src[i + srcOffset]));
        }
    }

    @Override
    public String[] toStringArray() {
        int size = this.size();
        String[] strArray = new String[size];
        this.copyToArray(0, strArray, 0, size);
        return strArray;
    }

    @Override
    public Iterator<Boolean> iterator() {
        return new Iterator<Boolean>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < BooleanArray.this.size();
            }

            @Override
            public Boolean next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return BooleanArray.this.get(this.i++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    static {
        type = typeIndexID = JCasRegistry.register(BooleanArray.class);
    }
}

