/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.expression.bool;

import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.expression.bool.AbstractBooleanExpression;
import org.apache.uima.ruta.expression.string.IStringExpression;
import org.apache.uima.ruta.rule.MatchContext;

public class BooleanStringExpression
extends AbstractBooleanExpression {
    private final IStringExpression e1;
    private final String op;
    private final IStringExpression e2;

    public BooleanStringExpression(IStringExpression e1, String op, IStringExpression e2) {
        this.e1 = e1;
        this.op = op;
        this.e2 = e2;
    }

    @Override
    public boolean getBooleanValue(MatchContext context, RutaStream stream) {
        String first = this.getFristExpression().getStringValue(context, stream);
        String second = this.getSecondExpression().getStringValue(context, stream);
        return this.eval(first, this.getOperator(), second);
    }

    private boolean eval(String t1, String op, String t2) {
        if ("==".equals(op)) {
            if (t1 == null) {
                return t2 == null;
            }
            return t1.equals(t2);
        }
        if ("!=".equals(op)) {
            if (t1 == null) {
                return t2 != null;
            }
            return !t1.equals(t2);
        }
        return false;
    }

    public IStringExpression getFristExpression() {
        return this.e1;
    }

    public String getOperator() {
        return this.op;
    }

    public IStringExpression getSecondExpression() {
        return this.e2;
    }

    @Override
    public String getStringValue(MatchContext context, RutaStream stream) {
        return this.e1.getStringValue(context, stream) + " " + this.op + " " + this.e2.getStringValue(context, stream);
    }
}

