/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cpe.model;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.TaeDescription;
import org.apache.uima.application.metadata.UimaApplication;
import org.apache.uima.collection.CasConsumerDescription;
import org.apache.uima.collection.CollectionReaderDescription;
import org.apache.uima.collection.metadata.CasProcessorConfigurationParameterSettings;
import org.apache.uima.collection.metadata.CpeCasProcessor;
import org.apache.uima.collection.metadata.CpeCollectionReader;
import org.apache.uima.collection.metadata.CpeCollectionReaderCasInitializer;
import org.apache.uima.collection.metadata.CpeDescription;
import org.apache.uima.collection.metadata.CpeDescriptorException;
import org.apache.uima.collection.metadata.NameValuePair;
import org.apache.uima.cpe.model.CpeCasProcessorModel;
import org.apache.uima.cpe.model.UimaCollectionReader;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.URISpecifier;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.tools.debug.util.Trace;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;
import org.xml.sax.SAXException;

public class CpeDescriptorModel {
    protected UimaApplication mUimaApplication = null;
    protected List collectionReaderModelList = null;
    protected List cpeCasProcessorModelList = null;
    protected CpeDescription cpeDesc;
    protected CpeCollectionReader[] collRdrs;
    protected CpeCasProcessor[] casProcs;
    protected List resourceSpecifierList = null;
    protected List analysisEngineList = null;
    protected List casConsumerList = null;
    protected List typeSystemList = null;
    protected TypeSystemDescription mergedTypeSystemDescription = null;

    protected CpeDescriptorModel() {
    }

    public static CpeDescriptorModel createInstance(String cpeXmlDescriptorFile) {
        try {
            CpeDescription cpeDescription = UIMAFramework.getXMLParser().parseCpeDescription(new XMLInputSource(new File(cpeXmlDescriptorFile)));
            return CpeDescriptorModel.createInstance(cpeXmlDescriptorFile, cpeDescription);
        }
        catch (InvalidXMLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static CpeDescriptorModel createInstance(String cpeXmlDescriptorFile, CpeDescription cpeDescription) {
        CpeDescriptorModel cpeModel = new CpeDescriptorModel();
        try {
            cpeModel.cpeDesc = cpeDescription;
            cpeModel.collRdrs = cpeModel.cpeDesc.getAllCollectionCollectionReaders();
            cpeModel.collectionReaderModelList = new ArrayList();
            if (cpeModel.collRdrs != null && cpeModel.collRdrs.length > 0) {
                for (int i = 0; i < cpeModel.collRdrs.length; ++i) {
                    cpeModel.collectionReaderModelList.add(new UimaCollectionReader(cpeModel, cpeModel.collRdrs[i], null));
                }
            }
            cpeModel.casProcs = cpeModel.cpeDesc.getCpeCasProcessors().getAllCpeCasProcessors();
            if (cpeModel.casProcs == null) {
                return cpeModel;
            }
            cpeModel.cpeCasProcessorModelList = new ArrayList();
            ArrayList<ResourceSpecifier> specifierList = new ArrayList<ResourceSpecifier>();
            ArrayList<ResourceSpecifier> aeList = new ArrayList<ResourceSpecifier>();
            ArrayList<ResourceSpecifier> consumerList = new ArrayList<ResourceSpecifier>();
            cpeModel.typeSystemList = new ArrayList();
            for (int i = 0; i < cpeModel.casProcs.length; ++i) {
                CpeDescriptorModel.printCpeCasProcessor(cpeModel.casProcs[i]);
                String specifierFile = cpeModel.casProcs[i].getDescriptor();
                ResourceSpecifier specifier = UIMAFramework.getXMLParser().parseResourceSpecifier(new XMLInputSource(specifierFile));
                specifierList.add(specifier);
                cpeModel.cpeCasProcessorModelList.add(new CpeCasProcessorModel(cpeModel, cpeModel.casProcs[i], specifier));
                if (cpeModel.isCasConsumerSpecifier(specifier)) {
                    consumerList.add(specifier);
                } else {
                    aeList.add(specifier);
                }
                cpeModel.typeSystemList.add(CpeDescriptorModel.getTypeSystemDescription(specifier));
            }
            if (specifierList.size() > 0) {
                cpeModel.resourceSpecifierList = specifierList;
            }
            if (aeList.size() > 0) {
                cpeModel.analysisEngineList = aeList;
            }
            if (consumerList.size() > 0) {
                cpeModel.casConsumerList = consumerList;
            }
            cpeModel.mergedTypeSystemDescription = CasCreationUtils.mergeTypeSystems((Collection)cpeModel.typeSystemList);
            cpeModel.mergedTypeSystemDescription.setName("Merged Type System for ???");
            String descr = "Merge TSs of: ";
            for (int i = 0; i < cpeModel.casProcs.length; ++i) {
                if (i > 0) {
                    descr = descr + ", ";
                }
                descr = descr + cpeModel.casProcs[i].getName();
            }
            cpeModel.mergedTypeSystemDescription.setDescription(descr);
            StringWriter sw = new StringWriter();
            cpeModel.mergedTypeSystemDescription.toXML((Writer)sw);
            sw.close();
        }
        catch (InvalidXMLException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (CpeDescriptorException e) {
            e.printStackTrace();
            return null;
        }
        catch (ResourceInitializationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        return cpeModel;
    }

    public static void printCpeCasProcessor(CpeCasProcessor cpeCasProc) {
        CasProcessorConfigurationParameterSettings settings = cpeCasProc.getConfigurationParameterSettings();
        if (settings != null) {
            CpeDescriptorModel.printNameValuePairs(settings.getParameterSettings());
        }
    }

    public static void printNameValuePairs(NameValuePair[] nvs) {
        for (int i = 0; i < nvs.length; ++i) {
            String name = nvs[i].getName();
            Trace.trace("Param name:" + nvs[i].getName());
            Object aValue = nvs[i].getValue();
            if (aValue == null) {
                System.out.println("    no value");
            }
            if (aValue instanceof String) continue;
            if (aValue instanceof Integer) {
                System.out.println("    Integer" + (Integer)aValue);
                continue;
            }
            if (aValue instanceof Float || aValue instanceof Boolean || !(aValue instanceof Object[])) continue;
            Object[] obj = (Object[])aValue;
            System.out.println("    Object[]:" + obj.length);
            for (int k = 0; k < obj.length; ++k) {
                if (obj[k] instanceof String) {
                    System.out.println("    [" + k + "]:" + obj[k].toString());
                    continue;
                }
                if (obj[k] instanceof Integer) {
                    System.out.println("    [" + k + "]:" + (Integer)obj[k]);
                    continue;
                }
                if (obj[k] instanceof Float) {
                    System.out.println("    [" + k + "]:" + ((Float)obj[k]).floatValue());
                    continue;
                }
                if (!(obj[k] instanceof Boolean)) continue;
                System.out.println("    [" + k + "]:" + (Boolean)obj[k]);
            }
        }
    }

    public static CpeDescriptorModel printCpeXmlDescriptor(String cpeXmlDescriptorFile) {
        CpeDescriptorModel cpeModel = new CpeDescriptorModel();
        try {
            cpeModel.cpeDesc = UIMAFramework.getXMLParser().parseCpeDescription(new XMLInputSource(new File(cpeXmlDescriptorFile)));
            cpeModel.collRdrs = cpeModel.cpeDesc.getAllCollectionCollectionReaders();
            cpeModel.collectionReaderModelList = new ArrayList();
            if (cpeModel.collRdrs != null && cpeModel.collRdrs.length > 0) {
                for (int i = 0; i < cpeModel.collRdrs.length; ++i) {
                    cpeModel.collectionReaderModelList.add(new UimaCollectionReader(cpeModel, cpeModel.collRdrs[i], null));
                }
            }
            cpeModel.casProcs = cpeModel.cpeDesc.getCpeCasProcessors().getAllCpeCasProcessors();
            if (cpeModel.casProcs == null) {
                return cpeModel;
            }
            cpeModel.cpeCasProcessorModelList = new ArrayList();
            ArrayList<ResourceSpecifier> specifierList = new ArrayList<ResourceSpecifier>();
            ArrayList<ResourceSpecifier> aeList = new ArrayList<ResourceSpecifier>();
            ArrayList<ResourceSpecifier> consumerList = new ArrayList<ResourceSpecifier>();
            cpeModel.typeSystemList = new ArrayList();
            for (int i = 0; i < cpeModel.casProcs.length; ++i) {
                String specifierFile = cpeModel.casProcs[i].getDescriptor();
                ResourceSpecifier specifier = UIMAFramework.getXMLParser().parseResourceSpecifier(new XMLInputSource(specifierFile));
                specifierList.add(specifier);
                cpeModel.cpeCasProcessorModelList.add(new CpeCasProcessorModel(cpeModel, cpeModel.casProcs[i], specifier));
                if (cpeModel.isCasConsumerSpecifier(specifier)) {
                    consumerList.add(specifier);
                } else {
                    aeList.add(specifier);
                }
                cpeModel.typeSystemList.add(CpeDescriptorModel.getTypeSystemDescription(specifier));
            }
            if (specifierList.size() > 0) {
                cpeModel.resourceSpecifierList = specifierList;
            }
            if (aeList.size() > 0) {
                cpeModel.analysisEngineList = aeList;
            }
            if (consumerList.size() > 0) {
                cpeModel.casConsumerList = consumerList;
            }
            cpeModel.mergedTypeSystemDescription = CasCreationUtils.mergeTypeSystems((Collection)cpeModel.typeSystemList);
            cpeModel.mergedTypeSystemDescription.setName("Merged Type System for ???");
            String descr = "Merge TSs of: ";
            for (int i = 0; i < cpeModel.casProcs.length; ++i) {
                if (i > 0) {
                    descr = descr + ", ";
                }
                descr = descr + cpeModel.casProcs[i].getName();
            }
            cpeModel.mergedTypeSystemDescription.setDescription(descr);
            StringWriter sw = new StringWriter();
            cpeModel.mergedTypeSystemDescription.toXML((Writer)sw);
            sw.close();
        }
        catch (InvalidXMLException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (CpeDescriptorException e) {
            e.printStackTrace();
            return null;
        }
        catch (ResourceInitializationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        return cpeModel;
    }

    public static TypeSystemDescription getTypeSystemDescription(ResourceSpecifier specifier) {
        TypeSystemDescription tsDescription = null;
        try {
            if (specifier instanceof TaeDescription) {
                TaeDescription tae = (TaeDescription)specifier;
                tsDescription = tae.isPrimitive() ? tae.getAnalysisEngineMetaData().getTypeSystem() : CasCreationUtils.mergeDelegateAnalysisEngineTypeSystems((AnalysisEngineDescription)tae);
            } else if (specifier instanceof CasConsumerDescription) {
                CasConsumerDescription ccDescr = (CasConsumerDescription)specifier;
                tsDescription = ccDescr.getCasConsumerMetaData().getTypeSystem();
            } else if (specifier instanceof CollectionReaderDescription) {
                CollectionReaderDescription crDescr = (CollectionReaderDescription)specifier;
                tsDescription = crDescr.getCollectionReaderMetaData().getTypeSystem();
            }
        }
        catch (ResourceInitializationException e) {
            e.printStackTrace();
        }
        return tsDescription;
    }

    private boolean isCasConsumerSpecifier(ResourceSpecifier specifier) {
        if (specifier instanceof CasConsumerDescription) {
            return true;
        }
        if (specifier instanceof URISpecifier) {
            URISpecifier uriSpec = (URISpecifier)specifier;
            return "CasConsumer".equals(uriSpec.getResourceType());
        }
        return false;
    }

    private void openCpeDescriptor(File aFile) throws InvalidXMLException, IOException, CpeDescriptorException {
        this.cpeDesc = UIMAFramework.getXMLParser().parseCpeDescription(new XMLInputSource(aFile));
        this.collRdrs = this.cpeDesc.getAllCollectionCollectionReaders();
        CpeCollectionReader collRdr = null;
        if (this.collRdrs != null && this.collRdrs.length > 0) {
            collRdr = this.collRdrs[0];
        }
        CpeCollectionReaderCasInitializer casIni = null;
        if (collRdr != null) {
            casIni = collRdr.getCasInitializer();
        }
        if (casIni != null) {
            String casIniDescFile = casIni.getDescriptor().getInclude().get();
        }
        this.casProcs = this.cpeDesc.getCpeCasProcessors().getAllCpeCasProcessors();
        for (int i = 0; i < this.casProcs.length; ++i) {
            CpeCasProcessor casProc = this.casProcs[i];
            String specifierFile = this.casProcs[i].getDescriptor();
            ResourceSpecifier specifier = UIMAFramework.getXMLParser().parseResourceSpecifier(new XMLInputSource(specifierFile));
        }
    }

    public void setUimaApplication(UimaApplication model) {
        this.mUimaApplication = model;
    }

    public CpeCasProcessor[] getCasProcs() {
        return this.casProcs;
    }

    public void setCasProcs(CpeCasProcessor[] casProcs) {
        this.casProcs = casProcs;
    }

    public CpeCollectionReader[] getCollRdrs() {
        return this.collRdrs;
    }

    public void setCollRdrs(CpeCollectionReader[] collRdrs) {
        this.collRdrs = collRdrs;
    }

    public CpeDescription getCpeDesc() {
        return this.cpeDesc;
    }

    public void setCpeDesc(CpeDescription cpeDesc) {
        this.cpeDesc = cpeDesc;
    }

    public List getAnalysisEngineList() {
        return this.analysisEngineList;
    }

    public void setAnalysisEngineList(List analysisEngineList) {
        this.analysisEngineList = analysisEngineList;
    }

    public List getCasConsumerList() {
        return this.casConsumerList;
    }

    public void setCasConsumerList(List casConsumerList) {
        this.casConsumerList = casConsumerList;
    }

    public TypeSystemDescription getMergedTypeSystemDescription() {
        return this.mergedTypeSystemDescription;
    }

    public List getResourceSpecifierList() {
        return this.resourceSpecifierList;
    }

    public List getCpeCasProcessorModelList() {
        return this.cpeCasProcessorModelList;
    }

    public void setCpeCasProcessorModelList(List cpeCasProcessorModelList) {
        this.cpeCasProcessorModelList = cpeCasProcessorModelList;
    }

    public CpeCasProcessorModel getCpeCasProcessorModel(String name) {
        for (int i = 0; i < this.cpeCasProcessorModelList.size(); ++i) {
            if (!name.equals(((CpeCasProcessorModel)this.cpeCasProcessorModelList.get(i)).getName())) continue;
            return (CpeCasProcessorModel)this.cpeCasProcessorModelList.get(i);
        }
        Trace.trace(" *** Cannot find CpeCasProcessorModel: " + name + " ***");
        return null;
    }

    public List getCollectionReaderModelList() {
        return this.collectionReaderModelList;
    }

    public void setCollectionReaderModelList(List collectionReaderModelList) {
        this.collectionReaderModelList = collectionReaderModelList;
    }
}

