/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.testing.ui.views.evalDataTable;

import org.apache.uima.ruta.testing.ui.views.evalDataTable.TypeEvalData;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class TypeTableSorter
extends ViewerSorter {
    private static final int ASCENDING = 0;
    private static final int DESCENDING = 1;
    private int column;
    private int direction;

    public void doSort(int column) {
        if (column == this.column) {
            this.direction = 1 - this.direction;
        } else {
            this.column = column;
            this.direction = 0;
        }
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int rc = 0;
        TypeEvalData td1 = (TypeEvalData)e1;
        TypeEvalData td2 = (TypeEvalData)e2;
        switch (this.column) {
            case 0: {
                rc = td1.getTypeName().compareTo(td2.getTypeName());
                break;
            }
            case 1: {
                rc = td1.getTruePositives() - td2.getTruePositives();
                break;
            }
            case 2: {
                rc = td1.getFalsePositives() - td2.getFalsePositives();
                break;
            }
            case 3: {
                rc = td1.getFalseNegatives() - td2.getFalseNegatives();
                break;
            }
            case 4: {
                rc = Double.compare(td1.getPrecision(), td2.getPrecision());
                break;
            }
            case 5: {
                rc = Double.compare(td1.getRecall(), td2.getRecall());
                break;
            }
            case 6: {
                rc = Double.compare(td1.getFOne(), td2.getFOne());
            }
        }
        if (this.direction == 1) {
            rc = -rc;
        }
        return rc;
    }
}

