/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.caseditor.view.tree;

import org.apache.uima.ruta.caseditor.view.tree.AnnotationTreeNode;
import org.apache.uima.ruta.caseditor.view.tree.AnnotationTreeViewPage;
import org.apache.uima.ruta.caseditor.view.tree.FSTreeNode;
import org.apache.uima.ruta.caseditor.view.tree.ITreeNode;
import org.apache.uima.ruta.caseditor.view.tree.TextUtils;
import org.apache.uima.ruta.caseditor.view.tree.TypeTreeNode;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class AnnotationTreeLableProvider
extends LabelProvider
implements ILabelProvider {
    private AnnotationTreeViewPage page;

    public AnnotationTreeLableProvider(AnnotationTreeViewPage page) {
        this.page = page;
    }

    public Image getImage(Object element) {
        if (element instanceof TypeTreeNode) {
            return this.page.getIcon(((TypeTreeNode)element).getType());
        }
        if (element instanceof FSTreeNode) {
            return this.page.getIcon(((FSTreeNode)element).getType());
        }
        return null;
    }

    public String getText(Object element) {
        String text = "";
        if (element instanceof ITreeNode) {
            String name = ((ITreeNode)element).getName();
            if (name != null) {
                name = name.replaceAll("[\\n]", "").replaceAll("[\\r]", "");
            }
            if (element instanceof TypeTreeNode) {
                text = text + TextUtils.shrinkNamespace(name);
            } else if (name != null) {
                text = text + name;
            }
            if (element instanceof AnnotationTreeNode) {
                ITreeNode parent = ((AnnotationTreeNode)element).getParent();
                if (parent instanceof TypeTreeNode) {
                    text = name;
                } else if (parent instanceof AnnotationTreeNode) {
                    text = ((AnnotationTreeNode)element).getType().getShortName() + ": " + name;
                }
            } else if (element instanceof TypeTreeNode) {
                text = text + " [" + ((TypeTreeNode)element).getChildren().length + "]";
            }
        }
        return text;
    }
}

