/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.cache;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;

public class CachedObject<T>
implements Serializable {
    private static final long serialVersionUID = -9107764093769042092L;
    public static final int DEFAULT = 0;
    public static final int FOREVER = -1;
    private T contents = null;
    private static final long DEFAULT_AGE = 1800000L;
    protected long created;
    private long expires;
    private final AtomicBoolean stale = new AtomicBoolean();

    public CachedObject(T object) {
        this(object, 0L);
    }

    public CachedObject(T object, long expires) {
        this.expires = expires == 0L ? 1800000L : expires;
        this.contents = object;
        this.created = System.currentTimeMillis();
    }

    public T getContents() {
        return this.contents;
    }

    public long getCreated() {
        return this.created;
    }

    public long getExpires() {
        return this.expires;
    }

    public void setExpires(long expires) {
        this.expires = expires == 0L ? 1800000L : expires;
        if (expires == -1L) {
            this.setStale(false);
        } else {
            this.setStale(System.currentTimeMillis() - this.created > expires);
        }
    }

    public void setStale(boolean stale) {
        this.stale.set(stale);
    }

    public boolean isStale() {
        boolean currentState = false;
        if (this.expires != -1L) {
            this.setStale(System.currentTimeMillis() - this.created > this.expires);
            currentState = this.stale.get();
        }
        return currentState;
    }
}

