/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.model;

import org.apache.fulcrum.intake.IntakeException;
import org.apache.fulcrum.intake.model.Field;
import org.apache.fulcrum.intake.model.Group;
import org.apache.fulcrum.intake.model.XmlField;
import org.apache.fulcrum.intake.validator.IntegerValidator;

public class IntegerField
extends Field<Integer> {
    private static final long serialVersionUID = -4186153269451228653L;

    public IntegerField(XmlField field, Group group) throws IntakeException {
        super(field, group);
    }

    @Override
    public void setDefaultValue(String prop) {
        this.defaultValue = null;
        if (prop == null) {
            return;
        }
        this.defaultValue = Integer.valueOf(prop);
    }

    @Override
    public void setEmptyValue(String prop) {
        this.emptyValue = null;
        if (prop == null) {
            return;
        }
        this.emptyValue = Integer.valueOf(prop);
    }

    @Override
    protected Object getSafeEmptyValue() {
        if (this.isMultiValued()) {
            return new int[0];
        }
        return null == this.getEmptyValue() ? Integer.valueOf(0) : this.getEmptyValue();
    }

    @Override
    protected String getDefaultValidator() {
        return IntegerValidator.class.getName();
    }

    @Override
    protected void doSetValue() {
        if (this.isMultiValued()) {
            Integer[] inputs = this.parser.getIntObjects(this.getKey());
            int[] values = new int[inputs.length];
            for (int i = 0; i < inputs.length; ++i) {
                values[i] = inputs[i] == null ? ((Integer)this.getEmptyValue()).intValue() : inputs[i].intValue();
            }
            this.setTestValue(values);
        } else {
            this.setTestValue(this.parser.getIntObject(this.getKey(), (Integer)this.getEmptyValue()));
        }
    }
}

