/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.messenger;

import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.ServerSessionPool;
import javax.jms.Session;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.messenger.DefaultServerSessionPool;

public class SessionFactory {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$commons$messenger$SessionFactory == null ? (class$org$apache$commons$messenger$SessionFactory = SessionFactory.class$("org.apache.commons.messenger.SessionFactory")) : class$org$apache$commons$messenger$SessionFactory));
    private Connection connection;
    private ConnectionFactory connectionFactory;
    private int acknowlegeMode = 1;
    private boolean transacted;
    private String username;
    private String password;
    protected Properties properties;
    private boolean topic = true;
    private String clientID;
    static /* synthetic */ Class class$org$apache$commons$messenger$SessionFactory;

    public Session createSession(Connection connection) throws JMSException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating a JMS session in transacted mode: " + this.isTransacted() + " with ack mode: " + this.getAcknowledgeMode()));
        }
        if (this.topic) {
            TopicConnection topicConnection = (TopicConnection)connection;
            return topicConnection.createTopicSession(this.isTransacted(), this.getAcknowledgeMode());
        }
        QueueConnection queueConnection = (QueueConnection)connection;
        return queueConnection.createQueueSession(this.isTransacted(), this.getAcknowledgeMode());
    }

    public Session createSession() throws JMSException {
        Connection connection = this.getConnection();
        if (this.topic) {
            TopicConnection topicConnection = (TopicConnection)connection;
            return topicConnection.createTopicSession(this.isTransacted(), this.getAcknowledgeMode());
        }
        QueueConnection queueConnection = (QueueConnection)connection;
        return queueConnection.createQueueSession(this.isTransacted(), this.getAcknowledgeMode());
    }

    public ServerSessionPool createServerSessionPool(MessageListener messageListener, int maxThreads) throws JMSException {
        return new DefaultServerSessionPool(this, messageListener, maxThreads);
    }

    public Connection createConnection() throws JMSException {
        ConnectionFactory factory = this.getConnectionFactory();
        if (factory == null) {
            throw new JMSException("No ConnectionFactory configured. Cannot create a JMS Session");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("About to create a connection from: " + factory));
        }
        if (this.topic) {
            return this.createTopicConnection((TopicConnectionFactory)factory);
        }
        return this.createQueueConnection((QueueConnectionFactory)factory);
    }

    public synchronized void close() throws JMSException {
        if (this.connection != null) {
            Connection tmp = this.connection;
            this.connection = null;
            tmp.close();
        }
    }

    public Connection getConnection() throws JMSException {
        if (this.connection == null) {
            this.setConnection(this.createConnection());
            this.connection.start();
        }
        return this.connection;
    }

    public void setConnection(Connection connection) throws JMSException {
        this.connection = connection;
        if (this.topic) {
            if (!(connection instanceof TopicConnection)) {
                this.setTopic(false);
            }
        } else if (!(connection instanceof QueueConnection)) {
            this.setTopic(true);
        }
        if (this.clientID != null) {
            connection.setClientID(this.clientID);
        }
    }

    public ConnectionFactory getConnectionFactory() throws JMSException {
        if (this.connectionFactory == null) {
            this.setConnectionFactory(this.createConnectionFactory());
        }
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
        if (this.topic) {
            if (!(connectionFactory instanceof TopicConnectionFactory)) {
                this.setTopic(false);
            }
        } else if (!(connectionFactory instanceof QueueConnectionFactory)) {
            this.setTopic(true);
        }
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public void setTransacted(boolean transacted) {
        this.transacted = transacted;
    }

    public int getAcknowledgeMode() {
        return this.acknowlegeMode;
    }

    public void setAcknowledgeMode(int acknowlegeMode) {
        this.acknowlegeMode = acknowlegeMode;
    }

    public void setAcknowledge(String value) {
        if (value != null) {
            if (value.equalsIgnoreCase("auto")) {
                this.setAcknowledgeMode(1);
            } else if (value.equalsIgnoreCase("client")) {
                this.setAcknowledgeMode(2);
            } else if (value.equalsIgnoreCase("dups_ok")) {
                this.setAcknowledgeMode(3);
            } else {
                throw new IllegalArgumentException("Value: " + value + " is invalid. Must be 'auto', 'client' or 'dups_ok'");
            }
        }
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = this.createProperties();
        }
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void addProperty(String name, String value) {
        this.getProperties().setProperty(name, value);
    }

    public boolean isTopic() {
        return this.topic;
    }

    public void setTopic(boolean topic) {
        this.topic = topic;
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    protected QueueConnection createQueueConnection(QueueConnectionFactory queueConnectionFactory) throws JMSException {
        if (this.username != null || this.password != null) {
            return queueConnectionFactory.createQueueConnection(this.username, this.password);
        }
        return queueConnectionFactory.createQueueConnection();
    }

    protected TopicConnection createTopicConnection(TopicConnectionFactory topicConnectionFactory) throws JMSException {
        if (this.username != null || this.password != null) {
            return topicConnectionFactory.createTopicConnection(this.username, this.password);
        }
        return topicConnectionFactory.createTopicConnection();
    }

    protected ConnectionFactory createConnectionFactory() throws JMSException {
        return null;
    }

    protected Properties createProperties() {
        try {
            return new Properties(System.getProperties());
        }
        catch (Throwable e) {
            return new Properties();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

