/*
 * Decompiled with CFR 0.152.
 */
package test.ojb.broker;

import java.io.IOException;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import ojb.broker.Identity;
import ojb.broker.PersistenceBroker;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.PersistenceBrokerFactory;
import ojb.broker.cache.ObjectCacheFactory;
import org.xml.sax.SAXException;
import test.ojb.broker.Tree;
import test.ojb.broker.TreeGroup;

public class TreeTest
extends TestCase {
    PersistenceBroker broker;
    private static Class CLASS = class$test$ojb$broker$TreeTest == null ? (class$test$ojb$broker$TreeTest = TreeTest.class$("test.ojb.broker.TreeTest")) : class$test$ojb$broker$TreeTest;
    static /* synthetic */ Class class$test$ojb$broker$TreeTest;
    static /* synthetic */ Class class$test$ojb$broker$Tree;

    public static void main(String[] args) {
        String[] arr = new String[]{CLASS.getName()};
        TestRunner.main((String[])arr);
    }

    public TreeTest(String name) {
        super(name);
    }

    public TreeGroup createTreeGroup() {
        TreeGroup result = new TreeGroup();
        try {
            result.setId(this.broker.getUniqueId(class$test$ojb$broker$Tree == null ? (class$test$ojb$broker$Tree = TreeTest.class$("test.ojb.broker.Tree")) : class$test$ojb$broker$Tree, "id"));
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            // empty catch block
        }
        result.setData("" + result.getId());
        result.setChilds(new Vector());
        result.setMembers(new Vector());
        return result;
    }

    public Tree createTreeNodeWithParent(Tree parent) {
        Tree result = new Tree();
        try {
            result.setId(this.broker.getUniqueId(class$test$ojb$broker$Tree == null ? (class$test$ojb$broker$Tree = TreeTest.class$("test.ojb.broker.Tree")) : class$test$ojb$broker$Tree, "id"));
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            // empty catch block
        }
        result.setData(parent.getId() + "-" + result.getId());
        result.setParentId(parent.getId());
        result.setChilds(new Vector());
        return result;
    }

    public void setUp() {
        try {
            this.broker = PersistenceBrokerFactory.createPersistenceBroker("repository.xml");
        }
        catch (IOException e) {
        }
        catch (ParserConfigurationException e) {
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    public void tearDown() {
        ObjectCacheFactory.getObjectCache().clear();
    }

    public void testCreate() {
        try {
            Tree root = new Tree();
            try {
                root.setId(this.broker.getUniqueId(class$test$ojb$broker$Tree == null ? (class$test$ojb$broker$Tree = TreeTest.class$("test.ojb.broker.Tree")) : class$test$ojb$broker$Tree, "id"));
            }
            catch (PersistenceBrokerException e) {
                // empty catch block
            }
            root.setData("a brand new root: " + root.getId());
            root.addChild(this.createTreeNodeWithParent(root));
            root.addChild(this.createTreeNodeWithParent(root));
            root.addChild(this.createTreeNodeWithParent(root));
            root.addChild(this.createTreeNodeWithParent(root));
            root.addChild(this.createTreeNodeWithParent(root));
            Tree child = root.getChild(0);
            child.addChild(this.createTreeNodeWithParent(child));
            child.addChild(this.createTreeNodeWithParent(child));
            child.addChild(this.createTreeNodeWithParent(child));
            child = child.getChild(1);
            child.addChild(this.createTreeNodeWithParent(child));
            child.addChild(this.createTreeNodeWithParent(child));
            System.out.println("original tree:");
            System.out.println(root);
            this.broker.store(root);
            Identity oid = new Identity(root);
            Tree retrieved = (Tree)this.broker.getObjectByIdentity(oid);
            System.out.println("tree after reading from db:");
            System.out.println(retrieved);
            Assert.assertEquals((String)"tree should have same size after retrival", (int)root.size(), (int)retrieved.size());
        }
        catch (Throwable t) {
            Assert.fail((String)t.getMessage());
        }
    }

    public void testTreeGroup() {
        try {
            TreeGroup child;
            TreeGroup root = this.createTreeGroup();
            root.setData("The Tree Group root: " + root.getId());
            TreeGroup green = this.createTreeGroup();
            green.setData("the GREEN group" + green.getId());
            TreeGroup red = this.createTreeGroup();
            red.setData("the RED group" + red.getId());
            int i = 0;
            while (i < 3) {
                child = this.createTreeGroup();
                root.addChild(child);
                green.addMember(child);
                child = this.createTreeGroup();
                root.addChild(child);
                red.addMember(child);
                ++i;
            }
            int i2 = 0;
            while (i2 < 6) {
                child = root.getChild(i2);
                child.addChild(this.createTreeGroup());
                ++i2;
            }
            System.out.println("original TreeGroup:");
            System.out.println(root);
            System.out.println("GREEN TreeGroup:");
            System.out.println(green);
            System.out.println("RED TreeGroup:");
            System.out.println(red);
            this.broker.store(root);
            this.broker.store(green);
            this.broker.store(red);
            Identity oid = new Identity(root);
            TreeGroup root_r = (TreeGroup)this.broker.getObjectByIdentity(oid);
            System.out.println("tree after reading from db:");
            System.out.println(root_r);
            Assert.assertEquals((String)"tree should have same size after retrival", (int)root.size(), (int)root_r.size());
            oid = new Identity(green);
            TreeGroup green_r = (TreeGroup)this.broker.getObjectByIdentity(oid);
            System.out.println("tree after reading from db:");
            System.out.println(green_r);
            Assert.assertEquals((String)"tree should have same size after retrival", (int)green.size(), (int)green_r.size());
            oid = new Identity(red);
            TreeGroup red_r = (TreeGroup)this.broker.getObjectByIdentity(oid);
            System.out.println("tree after reading from db:");
            System.out.println(red_r);
            Assert.assertEquals((String)"tree should have same size after retrival", (int)red.size(), (int)red_r.size());
        }
        catch (Throwable t) {
            System.out.println(t.getMessage());
            Assert.fail((String)t.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

