/*
 * Decompiled with CFR 0.152.
 */
package ojb.broker.accesslayer;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.accesslayer.ConnectionManager;
import ojb.broker.accesslayer.SqlGenerator;
import ojb.broker.metadata.ClassDescriptor;
import ojb.broker.singlevm.PersistenceBrokerImpl;

class StatementsForClass {
    private Class clazz;
    private ClassDescriptor cld;
    private ConnectionManager manager;
    private PreparedStatement selectByPKkStmt;
    private PreparedStatement insertStmt;
    private PreparedStatement updateStmt;
    private PreparedStatement deleteStmt;
    private SqlGenerator sqlGenerator;
    public static int TYPE = 1004;
    public static int CONCUR = 1007;
    public static boolean ESCAPEPROCESSING = false;

    private StatementsForClass() {
    }

    public StatementsForClass(ClassDescriptor mif, PersistenceBrokerImpl broker) throws PersistenceBrokerException {
        this.cld = mif;
        this.clazz = mif.getClassOfObject();
        this.manager = broker.getConnectionManager();
        this.sqlGenerator = SqlGenerator.getInstance();
    }

    private Connection getConnection() throws SQLException {
        try {
            return this.manager.getConnectionForClassDescriptor(this.cld);
        }
        catch (PersistenceBrokerException e) {
            throw new SQLException("OJB Error: could not obtain a Connection");
        }
    }

    private PreparedStatement prepareStatement(String sql) throws SQLException {
        Connection connection = this.getConnection();
        PreparedStatement result = null;
        try {
            result = connection.prepareStatement(connection.nativeSQL(sql), TYPE, CONCUR);
        }
        catch (AbstractMethodError err) {
            result = connection.prepareStatement(connection.nativeSQL(sql));
        }
        result.setEscapeProcessing(ESCAPEPROCESSING);
        return result;
    }

    private Statement createStatement() throws SQLException {
        Connection connection = this.getConnection();
        Statement result = null;
        try {
            result = connection.createStatement(TYPE, CONCUR);
        }
        catch (AbstractMethodError err) {
            result = connection.createStatement();
        }
        result.setEscapeProcessing(ESCAPEPROCESSING);
        return result;
    }

    public PreparedStatement getDeleteStmt() {
        if (this.deleteStmt == null) {
            StatementsForClass statementsForClass = this;
            synchronized (statementsForClass) {
                String sql = this.sqlGenerator.getPreparedDeleteStatement(this.cld);
                try {
                    this.deleteStmt = this.prepareStatement(sql);
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
        return this.deleteStmt;
    }

    public Statement getGenericStmt() {
        Statement stmt = null;
        try {
            stmt = this.createStatement();
        }
        catch (SQLException ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        return stmt;
    }

    public PreparedStatement getInsertStmt() {
        if (this.insertStmt == null) {
            StatementsForClass statementsForClass = this;
            synchronized (statementsForClass) {
                String sql = this.sqlGenerator.getPreparedInsertStatement(this.cld);
                try {
                    this.insertStmt = this.prepareStatement(sql);
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
        return this.insertStmt;
    }

    public PreparedStatement getPreparedStmt(String sql) {
        PreparedStatement stmt = null;
        try {
            stmt = this.prepareStatement(sql);
        }
        catch (SQLException ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        return stmt;
    }

    public PreparedStatement getSelectByPKkStmt() {
        if (this.selectByPKkStmt == null) {
            StatementsForClass statementsForClass = this;
            synchronized (statementsForClass) {
                String sql = this.sqlGenerator.getPreparedSelectByPkStatement(this.cld);
                try {
                    this.selectByPKkStmt = this.prepareStatement(sql);
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
        return this.selectByPKkStmt;
    }

    public PreparedStatement getUpdateStmt() {
        if (this.updateStmt == null) {
            StatementsForClass statementsForClass = this;
            synchronized (statementsForClass) {
                String sql = this.sqlGenerator.getPreparedUpdateStatement(this.cld);
                try {
                    this.updateStmt = this.prepareStatement(sql);
                }
                catch (SQLException ex) {
                    ex.printStackTrace();
                }
            }
        }
        return this.updateStmt;
    }
}

