/*
 * Decompiled with CFR 0.152.
 */
package ojb.odmg.collections;

import java.util.Map;
import ojb.broker.Identity;
import ojb.broker.PersistenceBroker;
import ojb.broker.PersistenceBrokerException;
import ojb.odmg.DatabaseImpl;
import ojb.odmg.OJB;
import ojb.odmg.TransactionImpl;
import ojb.odmg.collections.DMapImpl;

public class DMapEntry
implements Map.Entry {
    private int id;
    private int dMapId;
    private byte[] keySerializedOID;
    private Identity keyOID;
    private Object keyRealSubject;
    private byte[] valueSerializedOID;
    private Identity valueOID;
    private Object valueRealSubject;

    public DMapEntry() {
    }

    public DMapEntry(int id, int mapId, byte[] keySerOID, byte[] valueSerOID) {
        this.id = id;
        this.dMapId = mapId;
        this.keySerializedOID = keySerOID;
        this.keyOID = Identity.fromByteArray(keySerOID);
        this.valueSerializedOID = valueSerOID;
        this.valueOID = Identity.fromByteArray(valueSerOID);
    }

    public DMapEntry(DMapImpl map, Object key, Object value) {
        this.id = this.generateNewId();
        this.dMapId = map.getId();
        this.keyRealSubject = key;
        this.keyOID = new Identity(key);
        this.keySerializedOID = this.keyOID.serialize();
        this.valueRealSubject = value;
        this.valueOID = new Identity(value);
        this.valueSerializedOID = this.valueOID.serialize();
    }

    protected int generateNewId() {
        PersistenceBroker broker = ((DatabaseImpl)OJB.getInstance().getDatabase(null)).getBroker();
        try {
            return broker.getUniqueId(this.getClass(), "id");
        }
        catch (PersistenceBrokerException e) {
            return -1;
        }
    }

    public Object getKey() {
        try {
            if (this.keyRealSubject == null) {
                this.keyRealSubject = ((DatabaseImpl)OJB.getInstance().getDatabase(null)).getBroker().getObjectByIdentity(this.keyOID);
            }
        }
        catch (Throwable ignored) {
            System.out.println(ignored.getMessage());
            ignored.printStackTrace();
        }
        return this.keyRealSubject;
    }

    public Object getValue() {
        try {
            if (this.valueRealSubject == null) {
                this.valueRealSubject = ((DatabaseImpl)OJB.getInstance().getDatabase(null)).getBroker().getObjectByIdentity(this.valueOID);
            }
        }
        catch (Throwable ignored) {
            System.out.println(ignored.getMessage());
            ignored.printStackTrace();
        }
        return this.valueRealSubject;
    }

    public Object setValue(Object obj) {
        TransactionImpl tx = (TransactionImpl)OJB.getInstance().currentTransaction();
        if (tx != null) {
            tx.lock(this, 4);
        }
        this.valueRealSubject = obj;
        this.valueOID = new Identity(obj);
        this.valueSerializedOID = this.valueOID.serialize();
        return obj;
    }
}

