/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.jce.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.fulcrum.jce.crypto.CryptoParameters;
import org.apache.fulcrum.jce.crypto.CryptoStreamFactory;
import org.apache.fulcrum.jce.crypto.CryptoStreamFactoryTemplate;
import org.apache.fulcrum.jce.crypto.SmartDecryptingInputStream;

public class CryptoStreamFactoryImpl
extends CryptoStreamFactoryTemplate
implements CryptoStreamFactory {
    protected final byte[] salt;
    protected int count;
    protected String providerName;
    protected String algorithm;
    private static CryptoStreamFactory instance;
    protected static final String PROVIDERNAME;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CryptoStreamFactory getInstance() {
        Class<CryptoStreamFactoryImpl> clazz = CryptoStreamFactoryImpl.class;
        synchronized (CryptoStreamFactoryImpl.class) {
            if (instance == null) {
                instance = new CryptoStreamFactoryImpl();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static void setInstance(CryptoStreamFactory instance) {
        CryptoStreamFactoryImpl.instance = instance;
    }

    public CryptoStreamFactoryImpl() {
        this.salt = CryptoParameters.Salt();
        this.count = 20;
        this.providerName = PROVIDERNAME;
        this.algorithm = "PBEWithMD5AndDES";
    }

    public CryptoStreamFactoryImpl(byte[] salt, int count) {
        this.salt = (byte[])salt.clone();
        this.count = count;
        this.providerName = PROVIDERNAME;
        this.algorithm = "PBEWithMD5AndDES";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CryptoStreamFactory getInstance(byte[] salt, int count) {
        Class<CryptoStreamFactoryImpl> clazz = CryptoStreamFactoryImpl.class;
        synchronized (CryptoStreamFactoryImpl.class) {
            if (instance == null) {
                instance = new CryptoStreamFactoryImpl(salt, count);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public InputStream getSmartInputStream(InputStream is, char[] password) throws GeneralSecurityException, IOException {
        SmartDecryptingInputStream result = new SmartDecryptingInputStream(CryptoStreamFactoryImpl.getInstance(), is, password);
        return result;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    protected int getCount() {
        return this.count;
    }

    protected String getProviderName() {
        return this.providerName;
    }

    protected byte[] getSalt() {
        return this.salt;
    }

    protected Key createKey(char[] password) throws GeneralSecurityException {
        String algorithm = this.getAlgorithm();
        PBEKeySpec keySpec = new PBEKeySpec(password);
        SecretKeyFactory keyFactory = this.getProviderName() == null ? SecretKeyFactory.getInstance(algorithm) : SecretKeyFactory.getInstance(algorithm, this.getProviderName());
        return keyFactory.generateSecret(keySpec);
    }

    @Override
    protected Cipher createCipher(int mode, char[] password) throws GeneralSecurityException, IOException {
        PBEParameterSpec paramSpec = new PBEParameterSpec(this.getSalt(), this.getCount());
        Key key = this.createKey(password);
        Cipher cipher = this.getProviderName() == null ? Cipher.getInstance(this.getAlgorithm()) : Cipher.getInstance(this.getAlgorithm(), this.getProviderName());
        cipher.init(mode, key, paramSpec);
        return cipher;
    }

    static {
        PROVIDERNAME = null;
    }
}

