/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mail.james.mime4j.util;

import org.apache.geronimo.mail.james.mime4j.util.ByteSequence;

public final class ByteArrayBuffer
implements ByteSequence {
    private byte[] buffer;
    private int len;

    public ByteArrayBuffer(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Buffer capacity may not be negative");
        }
        this.buffer = new byte[capacity];
    }

    public ByteArrayBuffer(byte[] bytes, boolean dontCopy) {
        this(bytes, bytes.length, dontCopy);
    }

    public ByteArrayBuffer(byte[] bytes, int len, boolean dontCopy) {
        if (bytes == null) {
            throw new IllegalArgumentException();
        }
        if (len < 0 || len > bytes.length) {
            throw new IllegalArgumentException();
        }
        if (dontCopy) {
            this.buffer = bytes;
        } else {
            this.buffer = new byte[len];
            System.arraycopy(bytes, 0, this.buffer, 0, len);
        }
        this.len = len;
    }

    private void expand(int newlen) {
        byte[] newbuffer = new byte[Math.max(this.buffer.length << 1, newlen)];
        System.arraycopy(this.buffer, 0, newbuffer, 0, this.len);
        this.buffer = newbuffer;
    }

    public void append(byte[] b, int off, int len) {
        if (b == null) {
            return;
        }
        if (off < 0 || off > b.length || len < 0 || off + len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int newlen = this.len + len;
        if (newlen > this.buffer.length) {
            this.expand(newlen);
        }
        System.arraycopy(b, off, this.buffer, this.len, len);
        this.len = newlen;
    }

    public void append(int b) {
        int newlen = this.len + 1;
        if (newlen > this.buffer.length) {
            this.expand(newlen);
        }
        this.buffer[this.len] = (byte)b;
        this.len = newlen;
    }

    public void clear() {
        this.len = 0;
    }

    @Override
    public byte[] toByteArray() {
        byte[] b = new byte[this.len];
        if (this.len > 0) {
            System.arraycopy(this.buffer, 0, b, 0, this.len);
        }
        return b;
    }

    @Override
    public byte byteAt(int i) {
        if (i < 0 || i >= this.len) {
            throw new IndexOutOfBoundsException();
        }
        return this.buffer[i];
    }

    public int capacity() {
        return this.buffer.length;
    }

    @Override
    public int length() {
        return this.len;
    }

    public byte[] buffer() {
        return this.buffer;
    }

    public int indexOf(byte b) {
        return this.indexOf(b, 0, this.len);
    }

    public int indexOf(byte b, int beginIndex, int endIndex) {
        if (beginIndex < 0) {
            beginIndex = 0;
        }
        if (endIndex > this.len) {
            endIndex = this.len;
        }
        if (beginIndex > endIndex) {
            return -1;
        }
        for (int i = beginIndex; i < endIndex; ++i) {
            if (this.buffer[i] != b) continue;
            return i;
        }
        return -1;
    }

    public void setLength(int len) {
        if (len < 0 || len > this.buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        this.len = len;
    }

    public void remove(int off, int len) {
        if (off < 0 || off > this.len || len < 0 || off + len < 0 || off + len > this.len) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int remaining = this.len - off - len;
        if (remaining > 0) {
            System.arraycopy(this.buffer, off + len, this.buffer, off, remaining);
        }
        this.len -= len;
    }

    public boolean isEmpty() {
        return this.len == 0;
    }

    public boolean isFull() {
        return this.len == this.buffer.length;
    }

    public String toString() {
        return new String(this.toByteArray());
    }
}

