/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics;

import io.micrometer.core.instrument.Tags;
import io.smallrye.metrics.OriginAndMetadata;
import io.smallrye.metrics.SharedMetricRegistries;
import io.smallrye.metrics.legacyapi.LegacyMetricRegistryAdapter;
import io.smallrye.metrics.legacyapi.LegacyMetricsExtension;
import io.smallrye.metrics.legacyapi.TagsUtils;
import io.smallrye.metrics.legacyapi.interceptors.MetricName;
import io.smallrye.metrics.legacyapi.interceptors.SeMetricName;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.SortedMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.Timer;
import org.eclipse.microprofile.metrics.annotation.Metric;

@ApplicationScoped
public class MetricProducer {
    private static final String CLASS_NAME = MetricProducer.class.getName();
    private static final Logger LOGGER = Logger.getLogger(CLASS_NAME);
    MetricRegistry registry;
    MetricName metricName = new SeMetricName(Collections.emptySet());
    @Inject
    LegacyMetricsExtension metricExtension;

    public MetricProducer() {
    }

    public MetricProducer(LegacyMetricsExtension metricExtension) {
        this.metricExtension = metricExtension;
    }

    @Produces
    public <T extends Number> Gauge<T> getGauge(InjectionPoint ip) {
        String METHOD_NAME = "getGauge";
        return () -> {
            Tag[] tags;
            Tag[] mpTagArray;
            String name;
            MetricID metricID;
            this.registry = SharedMetricRegistries.getOrCreate(this.getScope(ip));
            SortedMap gauges = this.registry.getGauges();
            Gauge gauge = (Gauge)gauges.get(metricID = new MetricID(name = this.metricName.of(ip), mpTagArray = this.resolveAppNameTag(tags = this.getTags(ip))));
            if (gauge == null) {
                LOGGER.logp(Level.WARNING, CLASS_NAME, "getGauge", "Could not retrieve gauge with MetricID [id: {0}]", metricID);
                return null;
            }
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.logp(Level.FINER, CLASS_NAME, "getGauge", "Produced Gauge with MetricID [id: {0}]", metricID);
            }
            return gauge.getValue();
        };
    }

    @Produces
    public Counter getCounter(InjectionPoint ip) {
        String METHOD_NAME = "getCounter";
        this.registry = SharedMetricRegistries.getOrCreate(this.getScope(ip));
        Metadata metadata = this.getMetadata(ip);
        Tag[] tags = this.getTags(ip);
        Counter counter = this.registry.counter(metadata, tags);
        Tag[] mpTagArray = this.resolveAppNameTag(tags);
        MetricID metricID = new MetricID(metadata.getName(), mpTagArray);
        this.metricExtension.addMetricId(metricID);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.logp(Level.FINER, CLASS_NAME, "getCounter", "Produced Counter with MetricID [id: {0}]", metricID);
        }
        return counter;
    }

    @Produces
    public Timer getTimer(InjectionPoint ip) {
        String METHOD_NAME = "getTimer";
        this.registry = SharedMetricRegistries.getOrCreate(this.getScope(ip));
        Metadata metadata = this.getMetadata(ip);
        Tag[] tags = this.getTags(ip);
        Timer timer = this.registry.timer(metadata, tags);
        Tag[] mpTagArray = this.resolveAppNameTag(tags);
        MetricID metricID = new MetricID(metadata.getName(), mpTagArray);
        this.metricExtension.addMetricId(metricID);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.logp(Level.FINER, CLASS_NAME, "getTimer", "Produced Timer with MetricID [id: {0}]", metricID);
        }
        return timer;
    }

    @Produces
    public Histogram getHistogram(InjectionPoint ip) {
        String METHOD_NAME = "getHistogram";
        this.registry = SharedMetricRegistries.getOrCreate(this.getScope(ip));
        Metadata metadata = this.getMetadata(ip);
        Tag[] tags = this.getTags(ip);
        Histogram histogram = this.registry.histogram(metadata, tags);
        Tag[] mpTagArray = this.resolveAppNameTag(tags);
        MetricID metricID = new MetricID(metadata.getName(), mpTagArray);
        this.metricExtension.addMetricId(metricID);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.logp(Level.FINEST, CLASS_NAME, "getHistogram", "Produced histogram with MetricID [id: {0}]", "");
        }
        return histogram;
    }

    private Metadata getMetadata(InjectionPoint ip) {
        OriginAndMetadata metadata;
        Metric metric = (Metric)ip.getAnnotated().getAnnotation(Metric.class);
        if (metric != null) {
            Metadata actualMetadata = Metadata.builder().withName(this.metricName.of(ip)).withUnit(metric.unit()).withDescription(metric.description()).build();
            metadata = new OriginAndMetadata(ip, actualMetadata);
        } else {
            Metadata actualMetadata = Metadata.builder().withName(this.metricName.of(ip)).withUnit("none").withDescription("").build();
            metadata = new OriginAndMetadata(ip, actualMetadata);
        }
        return metadata;
    }

    private String getScope(InjectionPoint ip) {
        Metric metric = (Metric)ip.getAnnotated().getAnnotation(Metric.class);
        if (metric != null) {
            return metric.scope();
        }
        return "application";
    }

    private Tag[] getTags(InjectionPoint ip) {
        Metric metric = (Metric)ip.getAnnotated().getAnnotation(Metric.class);
        if (metric != null && metric.tags().length > 0) {
            return TagsUtils.parseTagsAsArray(metric.tags());
        }
        return new Tag[0];
    }

    private Tag[] resolveAppNameTag(Tag ... tags) {
        Tags mmTags = ((LegacyMetricRegistryAdapter)this.registry).withAppTags(tags);
        ArrayList mpListTags = new ArrayList();
        mmTags.forEach(tag -> {
            Tag mpTag = new Tag(tag.getKey(), tag.getValue());
            mpListTags.add(mpTag);
        });
        return mpListTags.toArray(new Tag[0]);
    }
}

