/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.core.metrics;

import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.InvocationContext;
import io.smallrye.faulttolerance.core.metrics.GeneralMetricsEvents;
import io.smallrye.faulttolerance.core.metrics.MeteredOperation;
import io.smallrye.faulttolerance.core.metrics.MetricsCollector;
import io.smallrye.faulttolerance.core.metrics.MetricsLogger;
import io.smallrye.faulttolerance.core.metrics.MetricsRecorder;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class CompletionStageMetricsCollector<V>
extends MetricsCollector<CompletionStage<V>> {
    public CompletionStageMetricsCollector(FaultToleranceStrategy<CompletionStage<V>> delegate, MetricsRecorder metrics, MeteredOperation operation) {
        super(delegate, metrics, operation);
    }

    @Override
    public CompletionStage<V> apply(InvocationContext<CompletionStage<V>> ctx) {
        MetricsLogger.LOG.trace("CompletionStageMetricsCollector started");
        try {
            CompletionStage<V> completionStage = this.doApply(ctx);
            return completionStage;
        }
        finally {
            MetricsLogger.LOG.trace("CompletionStageMetricsCollector finished");
        }
    }

    private CompletionStage<V> doApply(InvocationContext<CompletionStage<V>> ctx) {
        CompletionStage<Object> originalResult;
        this.registerMetrics(ctx);
        CompletableFuture result = new CompletableFuture();
        try {
            originalResult = this.delegate.apply(ctx);
        }
        catch (Exception e) {
            originalResult = CompletableFuture.failedFuture(e);
        }
        originalResult.whenComplete((value, exception) -> {
            if (exception == null) {
                ctx.fireEvent(GeneralMetricsEvents.ExecutionFinished.VALUE_RETURNED);
                result.complete(value);
            } else {
                ctx.fireEvent(GeneralMetricsEvents.ExecutionFinished.EXCEPTION_THROWN);
                result.completeExceptionally((Throwable)exception);
            }
        });
        return result;
    }
}

